# -*- coding: utf-8 -*-

use_cache = True

# Pour tracer le calcul du profil, il faut mettre la variable ecsDebug a True
ecsDebug=False

def is_ts(user_infos):
    vecteur=user_infos.get('FrEduVecteur')
    return vecteur != None and vecteur != []

def getENTPersonProfils(user_infos):
    ENTProfil=user_infos.get("ENTPersonProfils")
    if ENTProfil != None  and ENTProfil != ['']:
        return ENTProfil[0].strip().lower()
    return None

# Récupération du title
def getTitle(user_infos):
    title=user_infos.get("title")
    if title != None  and title != ['']:
        return title[0].strip().upper()
    return None

# Calcul du FrEduRne
def getRneAcad(user_infos):
    # FrEduRne: Attrbut normalisé de l'annuaire AGENT
    FrEduRne = user_infos.get('FrEduRne')
    if FrEduRne!= None:
        return FrEduRne

    # TODO: A normaliser
    # Si on arrive par FIM
    rne_fim = user_infos.get('rne_fim') # Si on arrive par fédération via FIM (Orleans)
    if rne_fim!= None:
        return rne_fim

    return None

def ecs_profil_log(message):
    if ecsDebug:
        print "|o|===> ecs_profil: %s" % (message)

# =========================================================
# fonction permettant de tester si c'est un enseignant
def isEnseignant(user_infos):
    ecs_profil_log("isEnseignant %s" % str(user_infos))

    # Le profil est renseigné, on l'utilise
    ENTProfil=getENTPersonProfils(user_infos)
    if ENTProfil != None:
        ecs_profil_log("Utilisation de ENTProfil=%s" % ENTProfil)
        return ENTProfil == "enseignant" or ENTProfil == "national_3"

    # Il existe un title, on l'utilise
    # Note: le title DOC est considéré comme enseignant
    title=getTitle(user_infos)
    if title != None:
        ecs_profil_log("Utilisation de title=%s" % title)
        return title == "ENS" or title == "DOC"

    # Rien de tout ça utilisation des infos user_groups
    groups = user_infos.get('user_groups', [])
    typeadmin = user_infos.get('typeadmin', [''])[0]
    if typeadmin == '2' or 'professeurs' in groups:
        ecs_profil_log("Utilisation du groups/typeadmin=%s/%s" % (typeadmin,str(groups)) )
        return True

    # ou objectClass du ldap
    objects = user_infos.get('objectClass', [])
    if 'ENTAuxEnseignant' in objects:
        ecs_profil_log("Utilisation du objects=%s" % (str(objects)))
        return True

    return False
# =========================================================

# =========================================================
# fonction permettant de tester si c'est un administratif
def isAdministratif(user_infos):
    # Le profil est renseigné, on l'utilise
    ENTProfil=getENTPersonProfils(user_infos)
    if ENTProfil != None:
        return ENTProfil == "administratif"  or ENTProfil == "national_6"

    # Il existe un title, on l'utilise
    title=getTitle(user_infos)
    if title != None:
        return title == "ADF" or isVieScolaire(user_infos) or isDir(user_infos)

    return False
# =========================================================

# =========================================================
# fonction permettant de tester si c'est un eleve
def isEleve(user_infos):
    # Le profil est renseigné, on l'utilise
    ENTProfil=getENTPersonProfils(user_infos)
    if ENTProfil != None:
        return ENTProfil == "eleve"  or ENTProfil == "national_1"

    # LDAP-TS: profil|Nom|Prenom|eleveid|RneEtab
    # is_ts ( FrEduVecteur != None et != [] )
    if is_ts(user_infos):
        FrEduVecteur = user_infos.get('FrEduVecteur')
        arr=FrEduVecteur[0].split("|")
        return arr[0]=="3" or arr[0]=="4"

    # Rien de tout ça utilisation des infos user_groups
    groups = user_infos.get('user_groups', [])
    if 'eleves' in groups:
        return True

    # ou objectClass du ldap
    objects = user_infos.get('objectClass', [])
    if 'Eleves' in objects or 'ENTEleve' in objects:
        return True

    return False
# =========================================================

# =========================================================
# fonction permettant de tester si c'est un parent
def isParent(user_infos):
    # Le profil est renseigné, on l'utilise
    ENTProfil=getENTPersonProfils(user_infos)
    if ENTProfil != None:
        return ENTProfil == "responsable"   or ENTProfil == "national_2"

    if is_ts(user_infos):
        FrEduVecteur = user_infos.get('FrEduVecteur')
        arr=FrEduVecteur[0].split("|")
        return arr[0]=="1" or arr[0]=="2"

    return False
# =========================================================


#===========================================================
# Personnel de direction
def isDir(user_infos):
    title=getTitle(user_infos)
    if title != None:
        return title == "DIR"
    return False

#===========================================================
# Personnel de vie scolaire
# Assitant d'education
# Ref: #5724
def isAED(user_infos):
    title=getTitle(user_infos)
    if title != None:
        return title == "AED"
    return False

#===========================================================
# Personnel de vie scolaire
# Assitant Education ou Personnel Education
def isVieScolaire(user_infos):
    title=getTitle(user_infos)
    if title != None:
        return title == "EDU" or title == "AED"
    return False

#===========================================================
# Personnel Inspecteur
def isInspecteur(user_infos):
    title=getTitle(user_infos)
    if title != None:
        return title == "INS"
    return False

# Est-ce un personel academique ?
# => Dispose t'il d'un Rne Academique ?
def isAcademique(user_infos):
    return getRneAcad(user_infos) != None

# =========================================================
# fonction permettant de tester si c'est un administrateur
def isAdmin(user_infos):

    # On considère que le chef d'éablissement est admin
    if isDir(user_infos):
        return True

    typeadmin = user_infos.get('typeadmin', [''])[0]
    uid = user_infos.get('uid', [''])[0]
    if uid == 'admin' or typeadmin == '1':
        return True

    return False
# =========================================================

def calc_info(user_infos):
    """
        calcule le profil d'un utilisateur
    """
    # Nomenclature nationale des profils utilisateurs
    # National_1 : Élève
    # National_2 : Responsable d'un élève (parent, tuteur légal)
    # National_3 : Enseignant
    # National_4 : Personnel de direction de l'établissement
    # National_5 : Personnel de vie scolaire travaillant dans l'établissement
    # National_6 : Personnel administratif, technique ou d'encadrement
    #              travaillant dans l'établissement
    # National_7 : Personnel de rectorat, de DRAF, de collectivité locale,
    #              d'inspection académique

    if isEleve(user_infos):
        return ["National_1"]

    if isParent(user_infos):
        return ["National_2"]

    if isEnseignant(user_infos):
        return ["National_3"]

    if isDir(user_infos):
        return ["National_4"]

    if isVieScolaire(user_infos):
        return ["National_5"]

    if isAdministratif(user_infos):
        return ["National_6"]

    if isInspecteur(user_infos):
        return ["National_7"]

    # Cas ou c'est un personnel avec une entrée Académique
    # Et qui ne match aucun des cas précédents
    # On le considère "National_6" : Personel Etablissement
    if isAcademique(user_infos):
        return ["National_6"]

    return ["National_0"]
