from creole.client import CreoleClient
from scribe.eolegroup import Group
from pyeole.process import system_out


# Creer des listes sympa avec les outils EOLE
# pour verifie que les aliases soient bien reconnus par exim


level_name = "levtest"
class_name = "clatest"
group_name = "grtest"

c = CreoleClient()
domaine_messagerie_etab = c.get_creole('domaine_messagerie_etab')


def has_list(name, restricted=True, exists=True, prefix=''):
    domain = {True: 'i-{}'.format(domaine_messagerie_etab), False: domaine_messagerie_etab}.get(restricted)
    code, out, err = system_out(['exim', '-bt', '{}{}@{}'.format(prefix, name, domain)])
    assert code == {True: 0, False: 2}.get(exists)


g = Group()
try:
    g.delete(class_name)
except:
    pass
try:
    g.delete(level_name)
except:
    pass
try:
    g.delete(group_name)
except:
    pass


def test_alias_group_no_list():
    has_list(group_name, True, False)
    has_list(group_name, False, False)
    g.add_groupe(group_name)
    has_list(group_name, True, False)
    has_list(group_name, False, False)
    g.delete(group_name)
    has_list(group_name, True, False)
    has_list(group_name, False, False)


def test_alias_group_restreint():
    g.add_groupe(group_name, 'restreint')
    has_list(group_name, True, True)
    has_list(group_name, False, False)
    g.delete(group_name)
    has_list(group_name, True, False)
    has_list(group_name, False, False)


def test_alias_group_internet():
    g.add_groupe(group_name, 'internet')
    has_list(group_name, True, False)
    has_list(group_name, False, True)
    g.delete(group_name)
    has_list(group_name, True, False)
    has_list(group_name, False, False)


def test_alias_level_restreint():
    has_list(level_name, True, False)
    has_list(level_name, False, False)
    g.add_niveau(level_name)
    #niveau ajouter en tant que "restreint"
    has_list(level_name, True, True)
    has_list(level_name, False, False)
    g.delete(level_name)
    has_list(level_name, True, False)
    has_list(level_name, False, False)


def test_alias_level_internet():
    g.add_niveau(level_name, 'internet')
    has_list(level_name, True, False)
    has_list(level_name, False, True)
    g.delete(level_name)
    has_list(level_name, True, False)
    has_list(level_name, False, False)


def test_alias_class_restreint():
    has_list(class_name, True, False)
    has_list(class_name, False, False)
    has_list(class_name, True, False, prefix='profs-')
    has_list(class_name, False, False, prefix='profs-')
    has_list(class_name, True, False, prefix='resp-')
    has_list(class_name, False, False, prefix='resp-')
    g.add_niveau(level_name)
    g.add_classe(class_name, level_name)
    has_list(class_name, True, True)
    has_list(class_name, False, False)
    has_list(class_name, True, True, prefix='profs-')
    has_list(class_name, False, False, prefix='profs-')
    has_list(class_name, True, True, prefix='resp-')
    has_list(class_name, False, False, prefix='resp-')
    g.delete(class_name)
    g.delete(level_name)
    has_list(class_name, True, False)
    has_list(class_name, False, False)
    has_list(class_name, True, False, prefix='profs-')
    has_list(class_name, False, False, prefix='profs-')
    has_list(class_name, True, False, prefix='resp-')
    has_list(class_name, False, False, prefix='resp-')


def test_alias_class_internet():
    g.add_niveau(level_name)
    g.add_classe(class_name, level_name, 'internet')
    has_list(class_name, True, False)
    has_list(class_name, False, True)
    #les listes profs toujours en restreint
    has_list(class_name, True, True, prefix='profs-')
    has_list(class_name, False, False, prefix='profs-')
    has_list(class_name, True, False, prefix='resp-')
    has_list(class_name, False, True, prefix='resp-')
    g.delete(class_name)
    g.delete(level_name)
    has_list(class_name, True, False)
    has_list(class_name, False, False)
    has_list(class_name, True, False, prefix='profs-')
    has_list(class_name, False, False, prefix='profs-')
    has_list(class_name, True, False, prefix='resp-')
    has_list(class_name, False, False, prefix='resp-')
