# -*- mode: salt; coding: utf-8 -*-
# vim: ft=sls

{#- Get the `tplroot` from `tpldir` #}
{%- set tplroot = tpldir.split('/')[0] %}
{%- from tplroot ~ "/map.jinja" import mapdata as ews with context %}
{%- from tplroot ~ "/libtofs.jinja" import files_switch with context %}
{%- from tplroot ~ "/libkwargs.jinja" import format_kwargs with context %}

eole-workstation/salt/repo/install/pkgrepo.managed:
  pkgrepo.managed:
    {{- format_kwargs(ews.salt.pkg.repo) }}
    - onlyif: {{ ews.salt.pkg and ews.salt.pkg.use_upstream_repo }}

eole-workstation/salt/repo/install/apt/preferences/file.managed:
  file.managed:
    - name: /etc/apt/preferences.d/saltstack
    - source: {{ files_switch(['saltstack.pref'],
                              use_subpath=True,
                              lookup='eole-workstation/salt/repo/install/apt/preferences/file.managed'
                 )
              }}
    - context:
        version: {{ ews.salt.pkg.version }}
    - template: jinja
    - onlyif: {{ ews.salt.pkg and ews.salt.pkg.use_upstream_repo }}
