# -*- mode: salt; coding: utf-8 -*-
# vim: ft=sls

{#- Get the `tplroot` from `tpldir` #}
{%- set tplroot = tpldir.split('/')[0] %}
{%- set tls_deployed_sls = tplroot ~ '.firefox.tls.deployed' %}
{%- set policies_deployed_sls = tplroot ~ '.firefox.policies.deployed' %}
{%- from tplroot ~ '/map.jinja' import mapdata as ews with context %}
{%- from tplroot ~ '/libtofs.jinja' import files_switch with context %}

include:
  - {{ tls_deployed_sls }}
  - {{ policies_deployed_sls }}

{%- set firefox = ews | traverse("firefox", False) %}
{%- set cert_dir = firefox | traverse("ca_dir") %}
{%- set policies_file = firefox | traverse("policies_file", False) %}

{#- Absolute path to local CA files #}
{%- set ca_names = firefox
      | traverse("ca_files", []) %}
{%- set ca_files = [] %}
{%- for ca_name in ca_names %}
{%-   set ca_path = cert_dir | path_join(ca_name) %}
{%-   do ca_files.append(ca_path) %}
{%- endfor %}

{%- set policies = {
      "policies": {"Certificates": {"Install": ca_files}}
    } %}

{%- if policies_file and ca_files %}
eole-workstation/firefox/tls/policies/deployed/tls-policies-file/file.managed:
  file.serialize:
    - name: {{ policies_file }}
    - dataset: {{ policies | json }}
    - formatter: json
    - serializer_opts:
      - indent: 2
      - sort_keys: True
    - merge_if_exists: true
    - require:
      - sls: {{ tls_deployed_sls }}
      - sls: {{ policies_deployed_sls }}
{%- endif %}
