# -*- mode: salt; coding: utf-8 -*-
# vim: ft=sls

{#- Get the `tplroot` from `tpldir` #}
{%- set tplroot = tpldir.split('/')[0] %}
{%- set sls_dconf = tplroot ~ ".dconf" %}

{%- if "windows" == salt["grains.get"]("kernel") | lower %}
{%-   set includes = [".windows"] %}
{%- else %}
{%-   set generic_dm_systemd = "/etc/systemd/system/display-manager.service" %}
{%-   set dm_systemd = salt["file.basename"](
          salt["file.readlink"](
              generic_dm_systemd,
              canonicalize=True
          )
      ) %}
{%-   set dm_name = dm_systemd.rpartition(".service") | first %}
{%-   set includes = [
        sls_dconf,
        "." ~ dm_name
      ] %}
{%- endif %}

include: {{ includes }}
