# -*- mode: salt; coding: utf-8 -*-
# vim: ft=sls

{#- Get the `tplroot` from `tpldir` #}
{%- set tplroot = tpldir.split('/')[0] %}
{%- from tplroot ~ '/map.jinja' import mapdata as ews with context %}
{%- set sls_package_install = tplroot ~ '.salt.minion.package.install' %}
{%- set sls_config_file = tplroot ~ '.salt.minion.config.dir' %}

{%- set saltstack = ews.salt %}

include:
  - {{ sls_config_file }}

{%- if grains['kernel'] == 'Windows' %}
{%-     set salt_cmd = "salt-call --out-file=null --local " %}
{%- else %}
{%-     set salt_cmd = "salt-call --out-file=/dev/null --local " %}
{%- endif %}

{%- set restart_cmd = salt_cmd
      ~ "test.sleep 5 && "
      ~ salt_cmd
      ~ "service.restart "
      ~ saltstack.minion.service.name
    %}

eole-workstation/salt/minion/service/running/service.enabled:
  service.enabled:
    - name: {{ saltstack.minion.service.name }}
    - onchanges:
      - sls: {{ sls_package_install }}
      - sls: {{ sls_config_file }}

eole-workstation/salt/minion/service/running/cmd.run:
  cmd.run:
    - name: {{ restart_cmd }}
    - bg: True
    - order: last
    - onchanges:
      - sls: {{ sls_package_install }}
      - sls: {{ sls_config_file }}
      - service: eole-workstation/salt/minion/service/running/service.enabled
