# -*- coding: UTF-8 -*-
###########################################################################
#
# Eole NG
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################

"""
Module qui gère les modèles au niveau GTK
"""

from era.noyau.pool import library_store
from era.noyau.dpatterns import Observable
import era.noyau.fwobjects

import gtk, gtk.glade
import gobject



# fonctions utiles #############################################################

def create_directive_treemodel(store = None, parent = None):
    """Crée un treestore à partir du classeur des directives
    store : le treestore
    parent : un iter correspondant au noeud où insérer l'arborescence
    directives : la liste des directives à représenter
    """
    if store is None:
        store = gtk.ListStore(gobject.TYPE_INT,       # priority
                              gobject.TYPE_STRING,    # src
                              gobject.TYPE_STRING,    # dest
                              gobject.TYPE_STRING,    # service
                              gobject.TYPE_STRING,    # action
                              gobject.TYPE_STRING,    # plage horaire
                              gobject.TYPE_STRING,    # groupes d'utilisateurs
                              gobject.TYPE_STRING,    # filtrage applicatif
                              gobject.TYPE_STRING,    # marquage ?
                              gobject.TYPE_BOOLEAN,   # log ?
                              gobject.TYPE_BOOLEAN,   # optionnelle ?

                              gobject.TYPE_PYOBJECT,  # la directive elle-même
                              )

    return store

def create_extremite_treemodel():

    store = gtk.ListStore(gobject.TYPE_STRING, # name
                          gobject.TYPE_STRING, # libelle
                          gobject.TYPE_STRING) # zone.name
    return store

def create_service_treestore(store = None, parent = None):
    """Crée un treestore à partir de library_store
    store : le treestore
    parent : un iter le noeud parent dans le treestore
    Si parent vaut None, alors on crée un nouvel arbre.
    """
    if store is None:
        store = gtk.TreeStore(gobject.TYPE_STRING,
                              gobject.TYPE_PYOBJECT)
        parent = None

    main_iter = store.append(parent, [_('services'),None])
    # FIXME voir si il n'est pas possible de trier en amon
    liste_services = library_store.services
    liste_services.sort()
    for service in liste_services:
        store.append(main_iter, [service.name,service])

    return store

def create_application_treestore(store = None, parent = None):
    """Crée un treestore à partir de library_store
    store : le treestore
    parent : un iter le noeud parent dans le treestore
    Si parent vaut None, alors on crée un nouvel arbre.
    """
    if store is None:
        store = gtk.TreeStore(gobject.TYPE_STRING,
                              gobject.TYPE_PYOBJECT)
        parent = None

    main_iter = store.append(parent, [_('applications'),None])
    # FIXME voir si il n'est pas possible de trier en amon
    liste_applications = library_store.applications
    liste_applications.keys().sort()
    for application in liste_applications.values():
        store.append(main_iter, [application.name,application])
    return store

def create_application_path_treestore(app_edit=None, store = None, parent = None):
    """Crée un treestore à partir de library_store
    store : le treestore
    parent : un iter le noeud parent dans le treestore
    Si parent vaut None, alors on crée un nouvel arbre.
    """
    if store is None:
        store = gtk.TreeStore(gobject.TYPE_STRING)
        parent = None
#    main_iter = store.append(parent, [_('paths')])
    if app_edit != None:
        # FIXME voir si il n'est pas possible de trier en amon
        paths = app_edit.paths
        paths.sort()
        for path in paths:
            store.append(parent, [path])
    return store

def create_app_treestore(store = None, parent = None):
    """Crée un treestore à partir de library_store
    store : le treestore
    parent : un iter le noeud parent dans le treestore
    Si parent vaut None, alors on crée un nouvel arbre.
    """
    if store is None:
        store = gtk.TreeStore(gobject.TYPE_STRING)
        parent = None
    #if app_group != None:
        # FIXME voir si il n'est pas possible de trier en amon
    #    for name in app_group.applications:
    #        store.append(parent, [name])
    return store

def create_application_group_treestore(store=None, parent=None):
    """Crée un treestore à partir de library_store
    store : le treestore
    parent : un iter le noeud parent dans le treestore
    Si parent vaut None, alors on crée un nouvel arbre.
    """

    if store is None:
        store = gtk.TreeStore(gobject.TYPE_STRING,
                              gobject.TYPE_PYOBJECT)
        parent = None
    main_iter = store.append(parent, [_('application groups'), None])
    # FIXME voir si il n'est pas possible de trier en amon
    liste_groups = library_store.app_groups
    liste_groups.keys().sort()
    for group in liste_groups.values():
        store.append(main_iter, [group.name, group])
    return store

def create_qos_treestore(store = None, parent = None):
    """Crée un treestore à partir de library_store
    store : le treestore
    parent : un iter le noeud parent dans le treestore
    Si parent vaut None, alors on crée un nouvel arbre.
    """
    if store is None:
        store = gtk.TreeStore(gobject.TYPE_STRING,
                              gobject.TYPE_PYOBJECT)
        parent = None

    main_iter = store.append(parent, [_('qos'),None])
    # XXFIXME voir si il n'est pas possible de trier en amon
    liste_qos = library_store.qos
    liste_qos.sort()
    for qos in liste_qos:
        store.append(main_iter, [qos.libelle, qos])
    return store

def create_group_treestore(store = None, parent = None):
    """Crée un treestore à partir de library_store
    store : le treestore
    parent : un iter le noeud parent dans le treestore
    Si parent vaut None, alors on crée un nouvel arbre.
    """
    if store is None:
        store = gtk.TreeStore(gobject.TYPE_STRING,
                              gobject.TYPE_PYOBJECT)
        parent = None


    main_iter = store.append(parent, [_('groups'), None])
    # FIXME voir si il n'est pas possible de trier en amon
    liste_groups = library_store.service_groups
    liste_groups.sort()
    for group in liste_groups:
        store.append(main_iter, [group.name, group])

    return store


def create_machine_treestore(store = None, parent = None, zone = None):
    """Crée un treestore à partir de library_store
    store : le treestore
    parent : un iter le noeud parent dans le treestore
    zone : la zone dont on veut voir les machines
    Si parent vaut None, alors on crée un nouvel arbre.
    """
    if store is None:
        store = gtk.TreeStore(gobject.TYPE_STRING,
                              gobject.TYPE_PYOBJECT)
        parent = None

    if zone is not None:
        node_name = "extremites (%s)"%zone.name
        extremites = library_store.get_zone_extremites(zone)

    else:
        node_name = _("all extremites")
        extremites = library_store.extremites.values()

    main_iter = store.append(parent, [node_name, None])
    extremites.sort()
    for extr in extremites:
        store.append(main_iter, [extr.name, extr])

    return store

def create_all_machines_treestore(store=None, parent=None, zones=None):
    """ crée un treestore de toutes les extrémités disponibles
    """

    if store is None:
        store = gtk.TreeStore(gobject.TYPE_STRING,
                          gobject.TYPE_PYOBJECT)

    for z in zones:
        parent_zone = store.append(parent, [z.name, None])

        extremites = library_store.get_zone_extremites(z)
        extremites.sort()
        for extr in extremites :
            store.append(parent_zone, [extr.name, extr])

    return store

def create_objects_treestore(zoneA = None, zoneB = None):
    """Crée un treestore à partir de library_store
    zoneA et zoneB sont les deux zones à isoler. Si elles
    valent None, on prend tous les objets existant.
    """
    store = gtk.TreeStore(gobject.TYPE_STRING,
                          gobject.TYPE_PYOBJECT)
    parent = None
    if zoneA is not None and zoneB is not None:
        create_machine_treestore(store, None, zoneA)
        create_machine_treestore(store, None, zoneB)
    create_machine_treestore(store, None)
    create_service_treestore(store, None)
    create_group_treestore(store, None)
    create_range_treestore(store, None)
    create_user_group_treestore(store, None)
    create_application_group_treestore(store, None)

    return store

def create_range_treestore(store = None, parent = None):
    """Crée un treestore à partir de library_store
    store : le treestore
    parent : un iter le noeud parent dans le treestore
    Si parent vaut None, alors on crée un nouvel arbre.
    """
    if store is None:
        store = gtk.TreeStore(gobject.TYPE_STRING,
                              gobject.TYPE_PYOBJECT)
        parent = None

    main_iter = store.append(parent, [_('ranges'),None])
    # FIXME voir si il n'est pas possible de trier en amon
    liste_ranges = library_store.ranges.keys()
    liste_ranges.sort()
    for timerange in liste_ranges:
        store.append(main_iter, [library_store.ranges[timerange].name,library_store.ranges[timerange]])

    return store

def sort_user_groups(a, b):
    return str(a[1].name) >= str(b[1].name)

def create_user_group_treestore(store = None, parent = None):
    """Crée un treestore à partir de library_store
    store : le treestore
    parent : un iter le noeud parent dans le treestore
    Si parent vaut None, alors on crée un nouvel arbre.
    """
    if store is None:
        store = gtk.TreeStore(gobject.TYPE_STRING,
                              gobject.TYPE_PYOBJECT)
        parent = None

    main_iter = store.append(parent, [_('user_groups'),None])
    user_groups = library_store.user_groups.items()
    user_groups.sort(sort_user_groups)
    for user_group in user_groups:
        store.append(main_iter, [library_store.user_groups[user_group[0]].name,library_store.user_groups[user_group[0]]])
    return store

def create_application_group_treestore(store = None, parent = None):
    """Crée un treestore à partir de library_store
    store : le treestore
    parent : un iter le noeud parent dans le treestore
    Si parent vaut None, alors on crée un nouvel arbre.
    """
    if store is None:
        store = gtk.TreeStore(gobject.TYPE_STRING,
                              gobject.TYPE_PYOBJECT)
        parent = None

    main_iter = store.append(parent, [_('application_groups'),None])
    app_groups = library_store.app_groups
#    app_groups.sort(sort_app_groups)
    for app_group_name, app_group in app_groups.items():
        store.append(main_iter, [app_group_name,app_group])
    return store

def set_empty_combo_model(combo):
    """Affecte un modèle à un combo
    combo : GTK ComboEntry
    """
    combo_model = gtk.ListStore(str)
    cell = gtk.CellRendererText()
    combo.pack_start(cell, True)
    combo.set_model(combo_model)
    combo_model.clear()
    return combo_model

def set_combo_model(combo, values):
    """Affecte un modèle à un combo
    combo : GTK ComboEntry
    """
    combo_model = gtk.ListStore(str)
    cell = gtk.CellRendererText()
    combo.pack_start(cell, True)
    combo.set_model(combo_model)
    combo_model.clear()
    for value in values:
        combo_model.append([value])
    return combo_model

