# -*- coding: UTF-8 -*-
###########################################################################
# 
# Eole NG  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr 
#  
###########################################################################

"""
Module concernant les options du modèle
"""

import gtk, gtk.glade
import gobject
from era.noyau.pool import library_store

class LibelleOptionsDialog:
    """Gère l'activation et la désactivation des options.
    """

    def __init__(self, glade_file, serv_edit=None):
        """
        glade : l'objet XML glade
        """
        self.glade_file = glade_file
        self.glade = gtk.glade.XML(self.glade_file,"options_dialog", "editeur")
        self.dlg = self.glade.get_widget("options_dialog")

        self.tree_view = self.glade.get_widget('options_treeview')

        handlers = {'on_options_dialog_response' : self.close,
                    # 'on_extremite_listview_dialog_delete_event' : self.stay_alive,
                    #'on_options_treeview_button_press_event':self.get_selected_clicked,
                    #'on_activate_button_clicked':self.get_selected,
                   }
        self.glade.signal_autoconnect(handlers)

        store = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_BOOLEAN, gobject.TYPE_STRING)

        renderer = gtk.CellRendererText()
        tog_renderer = gtk.CellRendererToggle()
        #gtk.CellRendererText()

        column = gtk.TreeViewColumn(_('option label'), renderer, text= 0)
        column.set_expand(True)
        column2 = gtk.TreeViewColumn(_('option active'), tog_renderer, active=1)

        self.tree_view.set_model(store)
        self.tree_view.append_column(column)
        self.tree_view.append_column(column2)
        tog_renderer.connect("toggled", self.event_toggle, store)

        for option in library_store.options.keys():
            store.append([option, library_store.options[option], library_store.options[option]])

    def event_toggle(self, cell, path, model):
        model[path][1] = not model[path][1]

    def stay_alive(self, *args):
        self.close()
        return True

    def close(self, button, code, *args):
        if code == gtk.RESPONSE_OK:
            # mise à jour de library_store
            self.tree_view.get_model().foreach(self.save_options,[])
        self.dlg.hide()

    def save_options(self, model, path, current_iter, data):
        option = str(model.get_value(current_iter,0))
        actif = model.get_value(current_iter,1)
        library_store.options[option]=int(actif)

    def show_dialog(self):
        self.dlg.show_all()
