# coding: utf-8
from xml.etree import ElementTree as ET

def read_from_file(fname):
    xml = ET.parse(fname)
    firewall = xml.getroot()
    return firewall

def compare_serv(src, dest):
    tree = 'services/service'
    test_name = "test des services: "
    
    servsrc = src.findall(tree)
    src_dict = {}
    for serv in servsrc:
        src_dict[serv.get('name')] = serv
    src_set = set(src_dict.keys())
    
    servdest = dest.findall(tree)
    dest_dict = {}
    for serv in servdest:
        dest_dict[serv.get('name')] = serv
    dest_set = set(dest_dict.keys())

    ret =  dest_set - src_set
    if ret != set([]):
        print "---------------------------"
        print test_name
        print "en plus dans la destination"
        print ret
    ret = src_set - dest_set
    if ret != set([]):
        print "---------------------------"
        print test_name
        print "en plus dans la source"
        print ret

    for serv in  dest_set & src_set:
        tsrc = src_dict[serv]
        tdest = dest_dict[serv]
        if tsrc.attrib != tdest.attrib:
            print test_name
            print u"différence pour %s"%serv

def compare_users(src, dest):
    tree = 'user_groups/user_group'
    test_name = "test des users:"
    
    servsrc = src.findall(tree)
    src_dict = {}
    for serv in servsrc:
        src_dict[serv.get('name')] = serv
    src_set = set(src_dict.keys())
    
    servdest = dest.findall(tree)
    dest_dict = {}
    for serv in servdest:
        dest_dict[serv.get('name')] = serv
    dest_set = set(dest_dict.keys())

    ret =  dest_set - src_set
    if ret != set([]):
        print "---------------------------"
        print test_name
        print "en plus dans la destination"
        print ret
    ret = src_set - dest_set
    if ret != set([]):
        print "---------------------------"
        print test_name
        print "en plus dans la source"
        print ret

    for serv in  dest_set & src_set:
        tsrc = src_dict[serv]
        tdest = dest_dict[serv]
        if tsrc.attrib != tdest.attrib:
            print test_name
            print u"différence pour %s"%serv

def compare_ranges(src, dest):
    tree = 'ranges'
    test_name = "test des ranges:"
    
    servsrc = src.findall(tree)
    src_dict = {}
    for serv in servsrc:
        src_dict[serv.get('name')] = serv
    src_set = set(src_dict.keys())
    
    servdest = dest.findall(tree)
    dest_dict = {}
    for serv in servdest:
        dest_dict[serv.get('name')] = serv
    dest_set = set(dest_dict.keys())

    ret =  dest_set - src_set
    if ret != set([]):
        print "---------------------------"
        print test_name
        print "en plus dans la destination"
        print ret
    ret = src_set - dest_set
    if ret != set([]):
        print "---------------------------"
        print test_name
        print "en plus dans la source"
        print ret

    for serv in  dest_set & src_set:
        tsrc = src_dict[serv]
        tdest = dest_dict[serv]
        if tsrc.attrib != tdest.attrib:
            print test_name
            print u"différence pour %s"%serv


def compare_serv_in_group(name, src, dest):
    tree = 'service'
    test_name = u"test du groupe de services %s : "%name
    
    servsrc = src.findall(tree)
    src_dict = {}
    for serv in servsrc:
        src_dict[serv.get('name')] = serv
    src_set = set(src_dict.keys())
    
    servdest = dest.findall(tree)
    dest_dict = {}
    for serv in servdest:
        dest_dict[serv.get('name')] = serv
    dest_set = set(dest_dict.keys())

    ret =  dest_set - src_set
    if ret != set([]):
        print "---------------------------"
        print test_name
        print "en plus dans la destination"
        print ret
    ret = src_set - dest_set
    if ret != set([]):
        print "---------------------------"
        print test_name
        print "en plus dans la source"
        print ret

    for serv in  dest_set & src_set:
        tsrc = src_dict[serv]
        tdest = dest_dict[serv]
        if tsrc.attrib != tdest.attrib:
            print test_name
            print u"différence pour %s"%serv

def compare_groupes_services(src, dest):
    tree = 'services/groupe'
    key = 'id'
    test_name = "test des groupes de services:"
    
    servsrc = src.findall(tree)
    src_dict = {}
    for serv in servsrc:
        src_dict[serv.get(key)] = serv
    src_set = set(src_dict.keys())
    
    servdest = dest.findall(tree)
    dest_dict = {}
    for serv in servdest:
        dest_dict[serv.get(key)] = serv
    dest_set = set(dest_dict.keys())

    ret =  dest_set - src_set
    if ret != set([]):
        print "---------------------------"
        print test_name
        print "en plus dans la destination"
        print ret
    ret = src_set - dest_set
    if ret != set([]):
        print "---------------------------"
        print test_name
        print "en plus dans la source"
        print ret

    for serv in  dest_set & src_set:
        tsrc = src_dict[serv]
        tdest = dest_dict[serv]
        if tsrc.attrib != tdest.attrib:
            print test_name
            print u"différence pour %s"%serv
        compare_serv_in_group(serv, tsrc, tdest)


def main():
    minimal = read_from_file('minimal.xml')
    deux_zones = read_from_file('4zones-scribe.xml')
    compare_serv(minimal, deux_zones)
    compare_users(minimal, deux_zones)
    compare_ranges(minimal, deux_zones)
    compare_groupes_services(minimal, deux_zones)

main()
