# -*- coding: utf-8 -*-
###########################################################################
#
# Eole NG
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################
"""emplacement (dans l'environnement et dans le systeme de fichiers)
utilisé pour les

- emplacement des fichiers .ini
- mise à disposition de chemins globaux pour le dossier d'install de era
- la position des dossiers de modèles

"""

import os, sys
from os.path import join, normpath, abspath, isdir, dirname

# ____________________________________________________________
# dossier racine du projet

# y a-t-il export ERA_DIR dans le .bashrc ?
try:
    ERA_DIR = os.environ['ERA_DIR']
    ERA_DOC = ERA_DIR
except Exception as e:
    if os.sys.platform == "win32":
        ERA_DIR = os.getcwd()
        ERA_DOC = ERA_DIR
    elif isdir('/usr/share/era'):
        # configuration d'installation par defaut
        ERA_DIR = "/usr/share/era"
        ERA_DOC = "/usr/share/doc/era"
    else:
        ERA_DIR = abspath(join(normpath(os.getcwd())))
        ERA_DOC = ERA_DIR
try:
    ERA_DEBUG = bool(int(os.environ['ERA_DEBUG']))
except:
    ERA_DEBUG = False

def setup_path():
    """sets up the python include paths"""
    # pour lancer era directement a partir de la et pas par era.sh
    ERAPATH = normpath(join(dirname(abspath(__file__)), '..'))
    sys.path.insert(1, ERAPATH)
    sys.path = [os.path.join(ERAPATH, "tool")] + sys.path

# ____________________________________________________________
# glade
GLADE_FILE = join(ERA_DIR, "interface", "editeur.glade")
RC_FILE = join(ERA_DIR, "interface", "editeur.rc")
# ____________________________________________________________
# i18n
APP = 'editeur'
APP_DIR = join(ERA_DIR,'i18n')
# ____________________________________________________________
# modeles
"""utilisé pour les path relatifs"""
MODELS_REPOSITORY_NAME = 'modeles'

"""fichier de configuration de l'application (principalement le comportement du compilateur)"""
CONFIG_FILE = abspath(normpath(join(ERA_DIR, 'backend', 'data', 'config.ini')))

"""fichier d'activation ou de desactivation des directives cachees"""
ACTIVE_TAGS = abspath(normpath(join(ERA_DIR, 'backend', 'data', 'active_tags')))

# ____________________________________________________________
## variables d'authentification (nufw)
"""fichier de configuration nufw pour le mapping marque-utilisateur"""
MARKGROUP_FILE = '/etc/nufw/mark_group.conf'
"""fichier de generation des acl plaintext"""
NF_ACL_PLAINTEXT = '/etc/nufw/acls.nufw'

"""gid du group "tous" (toutes les personnes identifiées)"""
GID_TOUS = 513
"""gid du group "guest" """
GID_GUEST = 253

## variables de qos
"""upload de qos"""
DEFAULT_UPLOAD_BANDWIDTH = None # 100
"""download de qos"""
DEFAULT_DOWNLOAD_BANDWIDTH = None # 1000
