#!/usr/bin/env python3
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# postes_interdits.py
#
# Génération des règles iptables
# pour l'interdiction réseau ou web
# des postes et des sous-réseaux
#
###########################################################################

def set_group_rules():
    # traitement du fichier des groupes de postes (regles ipset)
    try:
        from amon.ipset.rule_generator import RuleGenerator
        a = RuleGenerator()
        a.create_ip_sets()
    except Exception as err:
        print("!!!!!!! probleme avec poste_interdit !!!!!!!", err)
    # traitement du fichier des groupes de postes (regles iptables)
    try:
        from amon.ipset import iptables_generator
        a = iptables_generator.IptablesGenerator()
        a.create_rules()
    except Exception as err:
        print("!!!!!!! probleme avec poste_interdit !!!!!!!", err)


def main():
    # gestion des interdictions de postes et de destinations
    try:
        from amon.era import postes
        regles = postes.generate_rules()
    except Exception as err:
        print("!!!!!!! probleme avec poste_interdit !!!!!!!", err)
    # gestion des groupes de postes
    set_group_rules()


if __name__ == '__main__':
    main()
