# -*- coding: utf-8 -*-
"""high level compiler utility

module de compilation de haut niveau identique au *compiler* du backend
mais sans traduction ni fichiers d'options (regles optionnelles, regles cachées)

"""
import autopath
from os.path import join

from era.noyau.path import CONFIG_FILE
from era.backend.compiler import Compiler
from era.backend.iptwriter import IPTWriter
from era.noyau.initialize import initialize_app


def high_level_compile(model_fname, output_fname, output_inclusion_fname=None):
    """
    compilateur simple era (utile pour les tests)
    """
    matrix_model = initialize_app(model_fname)
    output = open(output_fname,'w')
    if output_inclusion_fname is not None:
        output_inclusion = open(output_inclusion_fname, 'w')
    else:
        output_inclusion = None
    compiler = Compiler(IPTWriter, output, CONFIG_FILE, output_inclusion=output_inclusion)
    compiler.compile(matrix_model)
    output.close()
    if output_inclusion_fname is not None:
        output_inclusion.close()

