# -*- coding: UTF-8 -*-
"""
Module de tests unitaires pour les parsers dom
"""
import autopath

from xml.dom.minidom import parseString, parse
from era.noyau import domparsers
from era.noyau.fwobjects import Zone,  Service, ServiceGroupe, Extremite, Directive, Flux
from node import *


def setup_module(module):
    # init zones
    zoneA = Zone('zoneA', 30, '127.0.0.1')
    zoneB = Zone('zoneB', 31, '127.0.0.1')
    zoneC = Zone('zoneC', 32, '127.0.0.1')

    module.zones = {'zoneA': zoneA,
                'zoneB': zoneB,
                'zoneC': zoneC
                    }
    # init flux
    module.flux = [module.zones['zoneA'], module.zones['zoneB']]

    # init services
    s1 = Service("serv1", "TCP", [80], "serv1", "libelle_Internet")
    s2 = Service("serv1", "TCP", [480], "serv2", "libelle2")
    s3 = Service("Youpi", "UDP", [4513], "serv3", "libelle3")
    s4 = ServiceGroupe("Groupe1", "test de groupe de services",[s1,s2])
    module.services = {"serv1" : s1, "serv2" : s2, "Youpi" : s3}
    module.groups = {"Group1" : s4}

    s_store = Service("serv1", "TCP", [8080], "serv1", "test1")
    module.library_store = []
    module.library_store.append(s_store)

    # init extremites
    e1 = Extremite(module.zones['zoneA'],"extr1", "libelle1", ["10.0.0.1"], "255.255.255.255")
    e2 = Extremite(module.zones['zoneA'],"extr2", "libelle2", ["10.0.0.2"], "255.255.255.255")
    e3 = Extremite(module.zones['zoneB'],"extr3", "libelle3", ["10.0.0.3"], "255.255.255.255")
    e4 = Extremite(module.zones['zoneC'],"extr4", "libelle4", ["10.0.0.4"], "255.255.255.255")
    module.extremites = {"extr1" : e1,"extr2" : e2,"extr3" : e3,"extr4" : e4}

# FIXME c'est le seul test qui utilise setup_module
def test_parse_group():
    """instancie un groupe de services a partir du xml
    L{era.noyau.domparsers.instantiate_group_from_dom}
    """
    doc = parseString(GROUP_NODE)
    g = domparsers.instantiate_group_from_dom(doc.firstChild, available_services = library_store)
    assert  g.id == 'groupe1'
    assert  g.libelle == 'test de groupe'
    assert  len(g.services) == 1

def test_parse_service():
    """instancie un service a partir du xml
    L{era.noyau.domparsers.instantiate_service_from_dom}
    """
    doc = parseString(SERVICE_NODE)
    s = domparsers.instantiate_service_from_dom(doc.firstChild)
    assert  s.name == "serv1"
    assert  s.protocol == "tcp"
    assert  s.port_list == [u'8080']
    assert  s.id == 'test1'
    assert  s.libelle == 'ce service est un test'

def test_parse_extremite():
    """instancie une extremite a partir du xml
    L{era.noyau.domparsers.instantiate_extremite_from_dom}
    """
    doc = parseString(EXTR_NODE)
    ext = domparsers.instantiate_extremite_from_dom(doc.firstChild, zones)
    assert  ext.name == "extr1"
    assert  ext.libelle == "libelle1"
    assert  ext.netmask == "255.255.255.255"
    assert  ext.ip_list == ['192.168.230.58','192.168.230.59','192.168.230.60']

def test_parse_directive():
    """instancie une directive a partir du xml
    L{era.noyau.domparsers.instantiate_directive_from_dom}
    """
    doc = parseString(DIRECTIVE_NODE)
    d = domparsers.instantiate_directive_from_dom(doc.firstChild,
                                                    extremites, services, groups, {})
    assert  len(d.src_list) == 2
    assert  len(d.dest_list) == 1
    assert  d.action == 1
    assert  d.attrs == 2
    assert  d.service.name == 'serv1'

def test_parse_nat_directive():
    """instancie une directive de type nat a partir du xml
       L{era.noyau.domparsers.instantiate_directive_from_dom}
    """
    doc = parseString(NAT_DIRECTIVE_NODE)
    d = domparsers.instantiate_directive_from_dom(doc.firstChild,
                                                    extremites, services, groups,{})
    assert  d.nat_extr.name == 'extr4'
    assert  d.nat_port == u'1234'

