# -*- coding: UTF-8 -*-

"""
Tests unitaires de zone dans la matrice de flux
"""

from pytest import raises

import autopath

from era.noyau.erreurs import *
from era.noyau.fwobjects import *
from era.noyau.models import *
    

def setup_module(module):
    # Une matrice de flux
    module.matrice = MatrixModel()

    # quelques objets zone, exemple : 
    # module.zone = Zone(name, level, ip, network, netmask, interface)
    module.zone1 = Zone("essai", 55, "192.168.230.22", "192.168.230.0", "255.255.255.0", "eth0")
    # créons la même zone 
    module.zone1_bis = Zone("essai", 55, "192.168.230.22", "192.168.230.0", "255.255.255.0", "eth0")
    # d'autres zones...
    module.zone2 = Zone("bastion", 100, "192.168.230.65")
    module.zone3 = Zone("zone3", 12, "192.168.230.14")

def teardown_module(module):
    module.matrice = None
    module.zone1 = None
    module.zone1_bis = None
    module.zone2 = None
    module.zone3 = None    

def test_eq():
    """Egalité de zones
    """
    assert zone1 == zone1_bis


def test_cmp():
    """Comparaison selon le niveau de sécurité de deux zones
    """
    assert not zone1 > zone2


def test_ajout_matrice():
        """Ajout d'une zone à la matrice
        """
        matrice.add_zone(zone1)
        matrice.add_zone(zone2)

        assert len(matrice.zones) == 2
        assert len(matrice.flux) == 1


def test_ajout_niveau():
        """Cohérence de l'ordonnancement des zones dans la matrice
        """
        matrice.zones = []
        matrice.add_zone(zone1)
        matrice.add_zone(zone2)
        matrice.add_zone(zone3)

        assert matrice.zones == [zone3, zone1, zone2]


         
class TestZoneBadInput:
    def setup_class(cls):
        """Mise en place des objets à tester
        """
        # Une matrice de flux
        cls.matrice = MatrixModel()

        # quelques objets zone
        # cls.zone1 = Zone(name, level, ip, network, netmask, interface)
        cls.zone1 = Zone("essai", 55, "192.168.230.22", "192.168.230.0", "255.255.255.0", "eth0")
        # créons la même zone 
        cls.zone1_bis = Zone("essai", 55, "192.168.230.22", "192.168.230.0", "255.255.255.0", "eth0")
        # d'autres zones...
        cls.zone2 = Zone("bastion", 100, "192.168.230.65")
        cls.zone3 = Zone("zone3", 12, "192.168.230.14")

        # zone vide
        cls.zone_vide = Zone("", 12, "192.168.230.14")
        cls.zone1_tri = Zone("essai_trigramme", 55, "192.168.230.22", "192.168.230.0", "255.255.255.0", "eth0")
     

    def teardown_class(cls):
        """Ménage
        """
        cls.matrice = None
        cls.zone1 = None
        cls.zone1_bis = None
        cls.zone2 = None
        cls.zone3 = None    

    def test_zone_vide(self):
        """Imossible d'ajouter une zone avec un nom vide
        """
        raises(EmptyNameError, self.matrice.add_zone, self.zone_vide)


    def test_zone_existe(self):
        """Impossible d'ajouter deux zones identiques
        """
        self.matrice.add_zone(self.zone1)
        raises(TrigrammeError, self.matrice.add_zone, self.zone1_bis)


    def test_zone_trigramme(self):
        """Les trigrammes des noms de zones sont identiques
        du coup la matrice n'accepte pas cette zone
        """
        # self.matrice.add_zone(self.zone1)
        raises(TrigrammeError, self.matrice.add_zone, self.zone1_tri)
        
