# -*- coding: utf-8 -*-

#########################################################################
# pyeole.restartonly - manages services that should never be stopped
# Copyright © 2020 Pôle de Compétence EOLE <eole@ac-dijon.fr>
#
# License CeCILL:
#  * in french: http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
#  * in english http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
#########################################################################

"""EOLE restartonly

This internal module is only for use by :mod:`pyeole.restartonly`.

"""
from .systemd import Service as ServiceSystemd

import logging

log = logging.getLogger(__name__)
log.addHandler(logging.NullHandler())

#####
##### Per action workers
#####


class Service(ServiceSystemd):
    module_name = u'Restart only'

    def cmd_start_service(self, service, ctx, message):
        self.cmd_restart_service(service, ctx, message=message)

    def cmd_stop_service(self, service, ctx, message):
        disabled_services = [s for s in service if s['disable']]
        if disabled_services:
            super().cmd_stop_service(disabled_services, ctx, message)
