#!/usr/bin/env python3
# -*- coding: UTF-8 -*-

###########################################################################
# Eole NG - 2019
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Creation des nouveaux groupe eleves-<etab> et profs-<etab>
# Synchronisation des utilisateurs dans ces groupes
#
###########################################################################

from scribe.eoleldap import get_etabs
from scribe.eolegroup import Group
from scribe.eleves import Eleve
from scribe.enseignants import Enseignant
from scribe.eoleshare import LdapExistingShare

ldapgroup = Group()
ldapgroup.ldap_admin.connect()
ldapeleves = Eleve()
ldapeleves.ldap_admin.connect()
ldapenseignant = Enseignant()
ldapenseignant.ldap_admin.connect()
ref_etab, etabs = get_etabs()
etabs.append(ref_etab)
for etab in etabs:
    print('synchronisation de {}'.format(etab))
    eleve_groupe = 'eleves-' + etab
    enseignant_groupe = 'profs-' + etab
    if not ldapgroup._is_group(eleve_groupe):
        ldapgroup._add('Base', eleve_groupe, etab=etab, description=eleve_groupe)
    if not ldapgroup._is_group(enseignant_groupe):
        try:
            ldapgroup._add('Base', enseignant_groupe, partage='rw', etab=etab, description=enseignant_groupe)
        except LdapExistingShare as msg:
            print(msg)
    for member in ldapgroup._get_attr(etab, 'memberUid'):
        if ldapeleves._is_eleve(member):
            groupe = eleve_groupe
            inscription = ldapeleves._inscription
        elif ldapenseignant._is_enseignant(member):
            groupe = enseignant_groupe
            inscription = ldapenseignant._inscription
        else:
            continue
        if groupe not in ldapgroup._get_user_groups(member):
            inscription(member, groupe, etab=etab)

