#!/usr/bin/python3
# -*- coding: utf-8  -*-

import os
import sys
import subprocess
from string import ascii_letters
from scribe.importation.config import WRITE_PRIVE

home = '/home'

def display_help():
    print("Vérifie la présence des répertoires personnels des utilisateurs et leur ré-applique les droits par défaut")
    print("{} [user] [-f --fix]".format(sys.argv[0]))
    print("    user : appliquer à un utilisateur spécifique ")
    print("    --fix : forcer la résolution des erreurs par suppression des répertoires adhomes")

def argparser():
    # récupère l'ID du groupe
    arglen = len(sys.argv)
    fix = False
    user = None
    if arglen == 1:
        return None, None
    if sys.argv[1] in ['-h', '--help']:
        display_help()
        sys.exit(0)

    if arglen > 1:
        if not sys.argv[1].startswith('--'):
            user = sys.argv[1]
        if '--fix' in sys.argv:
            fix = True

    return user, fix

def create_eleve_dirs(rep):
    dico = dict(rep=rep)
    if WRITE_PRIVE:
        cmd = """[ ! -d "%(rep)s/perso/prive" ] && mkdir -p %(rep)s/perso/prive
""" % dico
    else:
        cmd = """[ ! -d "%(rep)s/perso" ] && mkdir -p %(rep)s/perso
""" % dico
    os.system(cmd)

def create_prof_dirs(rep):
    dico = dict(rep=rep)
    cmd = """[ ! -d "%(rep)s/perso" ] && mkdir -p %(rep)s/perso
""" % dico
    os.system(cmd)

def create_adm_dirs(rep):
    dico = dict(rep=rep)
    cmd = """[ ! -d "%(rep)s/perso" ] && mkdir -p %(rep)s/perso
""" % dico
    os.system(cmd)

def get_groupe(user):
    cmde = 'id %s|grep eleves' % user
    cmdp = 'id %s|grep professeurs' % user
    cmda = 'id %s|grep administratifs' % user
    if subprocess.getstatusoutput(cmde)[0] == 0:
        return 'eleve'
    if subprocess.getstatusoutput(cmdp)[0] == 0:
        return 'professeur'
    if subprocess.getstatusoutput(cmda)[0] == 0:
        return 'administratif'
    return None

def place_droit(user, rep):
    perso = os.path.join(rep, 'perso')
    dico = dict(user=user, rep=rep, perso=perso)

    # droits élèves
    drte = """setfacl -Rbk %(perso)s
chown -R %(user)s:root %(perso)s
setfacl -PRm u::rwx,g::---,o::--- %(perso)s
setfacl -PRm g:professeurs:r-x %(perso)s
getfacl --access --absolute-names %(perso)s | setfacl -dR -M- %(perso)s
setfacl -bk %(rep)s
setfacl -m g:professeurs:--x %(rep)s
chown %(user)s %(rep)s
""" % dico
    if WRITE_PRIVE:
        drte += """if [ -d %(rep)s/perso/prive ];then
setfacl -m g:professeurs:--- %(rep)s/perso/prive
getfacl --access --absolute-names  %(rep)s/perso/prive | setfacl -d -M- %(rep)s/perso/prive
fi
""" % dico

   # droits enseignants
    drtp = """setfacl -Rbk %(perso)s
chown -R %(user)s:root %(perso)s
getfacl --access --absolute-names  %(rep)s | setfacl -dR -M- %(perso)s
setfacl -bk %(rep)s
chown %(user)s %(rep)s
""" % dico

    # droits administratifs
    drta = drtp

    grp = get_groupe(user)
    if not grp:
        print('  ###  Utilisateur %s non trouvé  ###' % user)
        return
    print("Traitement de", user, grp)
    if grp == 'eleve':
        create_eleve_dirs(rep)
        os.system(drte)
        return
    if grp == 'professeur':
        create_prof_dirs(rep)
        os.system(drtp)
        return
    if grp == 'administratif':
        create_adm_dirs(rep)
        os.system(drta)
        return

def main():
    personne, fix = argparser()
    warns = False
    if not personne:
        for i in ascii_letters:
            rep = os.path.join(home, i)
            if not os.path.isdir(rep):
                continue
            users = os.listdir(rep)
            for user in users:
                rep2 = os.path.join(rep, user)
                adrep = os.path.join('/home/adhomes', user)
                if not os.path.islink(rep2):
                    if not fix:
                        warns = True
                        print("###  Attention %s n'est pas un lien symbolique. Passe ###" % rep2)
                    else:
                        dico = dict(adrep=adrep, rep2=rep2)
                        cmdfix = """rm -rf %(adrep)s
                        mv %(rep2)s %(adrep)s
                        ln -nsf %(adrep)s %(rep2)s
                        """ % dico
                        os.system(cmdfix)
                        place_droit(user, adrep)
                else:
                    place_droit(user, adrep)
    else:
        lettre1 = personne[0]
        rep = os.path.join(home, lettre1)
        rep2 = os.path.join(rep, personne)
        user = personne
        adrep = os.path.join('/home/adhomes', user)
        if not os.path.islink(rep2):
            if not fix:
                warns = True
                print("###  Attention %s n'est pas un lien symbolique. Passe ###" % rep2)
            elif os.path.isdir(rep2):
                dico = dict(adrep=adrep, rep2=rep2)
                cmdfix = """rm -rf %(adrep)s
                mv %(rep2)s %(adrep)s
                ln -nsf %(adrep)s %(rep2)s
                """ % dico
                os.system(cmdfix)
                place_droit(user, adrep)
            else:
                dico = dict(adrep=adrep, rep2=rep2)
                cmdfix = "ln -nsf %(adrep)s %(rep2)s" % dico
                os.system(cmdfix)
                place_droit(user, adrep)
        else:
            place_droit(user, adrep)
    if warns:
        print("Des erreurs ont été rencontrés. Veuillez les résoudres ou utiliser l'option --fix pour forcer leur résolution (peut entrainer une perte de données)")

    # https://dev-eole.ac-dijon.fr/issues/15051
    drt_admin = """setfacl -Rm u:www-data:r-x /home/a/admin/perso/ressources
    setfacl -Rdm u:www-data:r-x /home/a/admin/perso/ressources
    setfacl -m u:www-data:--x /home/a/admin/perso
    setfacl -m u:www-data:--x /home/a/admin
    """
    if os.path.isdir('/home/a/admin/perso/ressources'):
        os.system(drt_admin)


if __name__ == '__main__':
    main()
