#!/usr/bin/env python3
# -*- coding: UTF-8 -*-

#########################################################
# utilitaire d'ajout d'utilisateur à des groupes dans un annuaire LDAP
# licence GPL Eole
# Bruno Boiget <bruno.boiget@ac-dijon.fr>
#########################################################

###################
# modules importés
import sys
import ldap
import ldif
from os import system
from scribe.backend_conf import *
from creole import parsedico

#####################
# variables globales
#####################

dicoEole = parsedico.parse_dico()

homebase = "/home"
smb_serveur = dicoEole["smb_netbios_name"]

###########################
# définition des fonctions
###########################

#########################################################
# fonction saisie_inter :
# ajout interactif d'un utilisateur a un (des) groupe(s)

def saisie_inter():
    print ("\n pas de fichier spécifié, passage en mode interactif \n");

    # Saisie des informations
    # login, liste de groupes

    
    # login
    login = input(" Veuillez saisir le login de l'utilisateur : ")


    # groupe
    groupe = input(" Entrez un groupe auquel ajouter l'utilisateur : ")
    temp_grp = ""

    
    # groupes supplémentaires, on crée une liste temporaire des groupes souhaités
    while (groupe != ""):
        temp_grp += groupe
        groupe = ""
        groupe = input (" Groupe supplémentaire (<entrée> pour terminer la liste) : ")
        if groupe != "":
            temp_grp+=","
    
    # Vérification de la liste des groupes et création de la liste finale

    liste_grp=temp_grp.split(',')
    temp_grp = ""
    
    for groupe in liste_grp:

        # Recherche du groupe sur le serveur ldap
        # !!! mot de passe et cn admin en dur ?
        try:
            query=ldap.open(serveur)
        except:
            sys.exit("erreur lors de la connexion à l'annuaire");
        try:
            query.simple_bind_s("cn=admin, o=gouv, c=fr",ldap_passwd)
        except:
            sys.exit("erreur lors du bind au serveur")
            
        groupe_ok = 0
        temp_grp = ""
        
        while (groupe_ok == 0):
            try:
                result_data=query.search_s("o=gouv, c=fr", ldap.SCOPE_SUBTREE, "(&(objectclass=posixGroup)(cn="+groupe+"))")
            except:
                sys.exit("erreur lors de la recherche")    
                
            if (result_data == []):
                groupe = input (" le groupe "+groupe+" n'existe pas.\n Entrez un autre nom de groupe ( rien pour ne pas le remplacer) : ")
                if groupe == "":
                    groupe_ok = 1

            else:
                # le groupe a été trouvé dans la base, on lui ajoute l'utilisateur
                retour = system("/usr/sbin/smbldap-groupmod -m "+login+" "+groupe)
                if (retour != 0):
                    rep=""
                    while ((rep != "O") and (rep != "N")):
                        rep=input("\n\nerreur lors de l'ajout de "+login+" au groupe "+groupe+", continuer ? (O/N) :")
                    if (rep == 'N'):
                        sys.exit("\nabandon, les groupes ajoutés auparavant seront pris en compte.\n\n")
                groupe_ok = 1


def saisie_non_inter(login,liste_grp):
    for groupe in liste_grp:
        # Recherche du groupe sur le serveur ldap
        # !!! mot de passe et cn admin en dur ?
        try:
            query=ldap.open(serveur)
        except:
            sys.exit("erreur lors de la connexion à l'annuaire");
        try:
            query.simple_bind_s("cn=admin, o=gouv, c=fr",ldap_passwd)
        except:
            sys.exit("erreur lors du bind au serveur")
        try:
            result_data=query.search_s("o=gouv, c=fr", ldap.SCOPE_SUBTREE, "(&(objectclass=posixGroup)(cn="+groupe+"))")
        except:
            print("\ngroupe "+groupe+" non trouvé")
        else:
            # le groupe a été trouvé dans la base, on lui retire l'utilisateur
            retour = system("/usr/sbin/smbldap-groupmod -m "+login+" "+groupe+" 2&>1 >/dev/null")
            if (retour != 0):
                print("erreur lors de l'ajout de "+login+" au groupe "+groupe)



####################
# boucle principale
def main():

    
    help = "inscription.py <utilisateur> <groupe1,gr2,...,grn>\n";
    
    # récupération des arguments de la ligne de commande
    try:
        utilisateur = sys.argv[1]
        groupes = sys.argv[2]
    except:
        # si pas de fichier, on passe par la saisie interactive
        saisie_inter()
    else:
        # on vérifie que le fichier est présent et lisible
        saisie_non_inter(utilisateur,groupes.split(','))


# si on a appelé le programme directement : on éxecute main
if __name__ == "__main__":
    main()
