#!/usr/bin/env python3
# -*- coding: UTF-8 -*-

################################################################
# utilitaire d'attribution du type de profil WinXP pour Scribe #
# licence GPL Eole                                             #
# Joël Cuissinat <joel.cuissinat@ac-dijon.fr>                  #
# Klaas TJEBBES                                                #
################################################################

###################
# modules importés
###################
import sys
import ldap
import getopt
from os import system, path, mkdir
from scribe.backend_conf import *
from creole import parsedico

#####################
# variables globales
#####################
passwd = ldap_passwd


## retourne la liste des DN contenus dans le groupe et leur nombre
def get_users(passwd,serveur,groupe):
    try:
        query=ldap.open(serveur)
        query.simple_bind_s("cn=admin,o=gouv,c=fr", passwd)
        result_user=query.search_s("o=gouv, c=fr", ldap.SCOPE_SUBTREE, \
                "(&(objectclass=posixGroup)(cn="+groupe+"))")
        query.unbind() 
    except:
        result_user=[]
    nb=0
    uids=result_user[0][1]["memberUid"]
    utilisateurs=[]
    for uid in uids:
        try:
            utilisateurs.append(get_dn(passwd,serveur,uid))
            nb+=1
        except:
            pass
    return (utilisateurs,nb)

## retourne le dn associé à l'uid
def get_dn(passwd,serveur,uid):
    try:
        query=ldap.open(serveur)
        query.simple_bind_s("cn=admin,o=gouv,c=fr", passwd)
        r=query.search_s("o=gouv, c=fr", ldap.SCOPE_SUBTREE, \
                "(&(objectclass=sambaSAMAccount)(uid="+uid+"))")
        query.unbind()
        return r[0][0]
    except:
        return ""

def get_profil(passwd,serveur,utilisateur):
    query = ldap.open(serveur)
    query.simple_bind_s("cn=admin,o=gouv,c=fr", passwd)
    r = query.search_s("o=gouv, c=fr", ldap.SCOPE_SUBTREE, \
        "(&(objectclass=sambaSAMAccount)(uid=%s))"%utilisateur)
    query.unbind()
    try:
        p = r[0][1]['sambaProfilePath'][0]
        profil = p.split('\\')[-1]
    except: profil = 'local'
    return profil

## attribution du profil aux utilisateurs
def set_profil(passwd,serveur,utilisateurs,nomserveursmb,chemin):
    query=ldap.open(serveur)
    query.simple_bind_s("cn=admin,o=gouv,c=fr", passwd)
    # ldap.modify_s(le_DN, [(une liste de tuple(s) comprenant les attributs à modifier)])
    # profiladd = une liste d'un tuple
    profil_path = "\\\\%s\\netlogon\\%s"%(nomserveursmb,chemin)
    local_profil_path = '/home/netlogon/%s'%chemin
    profiladd = [(ldap.MOD_ADD, 'sambaProfilePath', profil_path)]
    profilrep = [(ldap.MOD_REPLACE, 'sambaProfilePath', profil_path)]
    for dn in utilisateurs:
        try:
            query.modify_s(dn,profiladd)
        except:
            try:
                query.modify_s(dn,profilrep)
            except:
                pass
    # cas particulier, admin doit avoir un profil local
    query.unbind()
    system("/usr/sbin/smbldap-usermod -F '' admin")
    #création du répertoire
    if not path.isdir(local_profil_path): mkdir(local_profil_path)

## suppression de modèles aux utilisateurs
def supp_profil(passwd,serveur,utilisateurs):
    query=ldap.open(serveur)
    query.simple_bind_s("cn=admin,o=gouv,c=fr", passwd)
    profil = [(ldap.MOD_DELETE, 'sambaProfilePath', None)]
    for dn in utilisateurs:
        try:
            query.modify_s(dn,profil)
        except:
            pass
    query.unbind()

## message d'aide
def help():
    sys.exit("""   
    options possibles :
        -u (--utilisateur) U : nom de l'utilisateur
        -g (--groupe) 	   G : nom du groupe
        -a (--active)      C : active le profil obligatoire pour le groupe G
                              et utilise le chemin "\\\\<scribe>\\netlogon\\C"
        -d (--desactive)     : desactive le profil obligatoire pour le groupe G
        -l (--liste)         : donne le profil de l'utilisateur U
        -h (--help)          : affiche ce message
    
    Exemples :
        activer le profil obligatoire pour les groupe eleves :
            modifie_profil.py -g eleves -a profil2
    """)


# programme principal
def main():
    # gestion des options
    utilisateur=None
    chemin=""
    groupe=""
    active=""
    desactive=""
    liste=""
    dico = parsedico.parse_dico()

    try:
        options, args = getopt.getopt(sys.argv[1:],'u:g:a:ldh',
            ['utilisateur=',
         'groupe=',
	     'active',
	     'desactive',
         'liste',
         'help'])
             
    except getopt.GetoptError:
        er_type, er_value, er_traceback = sys.exc_info()
        er_msg = str(er_value)
        sys.exit("l'option -%s est inconnue ou nécessite un argument" % er_msg[er_msg.index('-')+1])

    for (opt,val) in options:
        # pour un utilisateur
        if (opt == '-u') or (opt == '--utilisateur'):
            utilisateur=val
        # pour un groupe
        elif (opt == '-g') or (opt == '--groupe'):
            groupe=val
        # activation
        elif (opt == '-a') or (opt == '--active'):
            chemin=val
            active="1"
        # desactivation
        elif (opt == '-d') or (opt == '--desactive'):
            desactive="1"
        # listing
        elif (opt == '-l') or (opt == '--liste'):
            liste = "1"
        # et l'aide...
        elif (opt == '-h') or (opt == '--help'):
            help()	   

    # activer le profil obligatoire au groupe
    if active == "1" and groupe != "" and chemin != "":
        utilisateurs,nb = get_users(passwd,serveur,groupe)
        nomserveursmb = dico["smb_netbios_name"]
        if nb > 0:
            set_profil(passwd, serveur, utilisateurs, nomserveursmb, chemin)
        print(nb)

    # activer le profil obligatoire à l'utilisateur
    elif active == "1" and chemin != "" and utilisateur:
        nomserveursmb = dico["smb_netbios_name"]
        user = [get_dn(passwd, serveur, utilisateur)]
        set_profil(passwd, serveur, user, nomserveursmb, chemin)
        print(1)

    # desactiver le profil obligatoire au groupe
    elif desactive == "1" and groupe != "":
        utilisateurs,nb = get_users(passwd,serveur,groupe)
        if nb > 0:
            supp_profil(passwd,serveur,utilisateurs)
        print(nb)

    # desactiver le profil obligatoire de l'utilisateur
    elif desactive == "1" and utilisateur:
        user = [get_dn(passwd, serveur, utilisateur)]
        supp_profil(passwd,serveur,user)
        print(1)

    # listing
    elif liste == "1" and utilisateur:
        print(get_profil(passwd, serveur, utilisateur))

    # aucune option
    else :
        help()


if __name__ == "__main__":
    main()

