#-*-coding:utf-8-*-

from scribe.storage import init_store , Eleve, Responsable, Adresse, \
JointureResponsableEleve, Classe, Niveau, Enseignant, EnsClasse, \
JointureClasseEnseignant, Matiere, JointureMatiereEnseignant, \
Administratif, Service, Groupe, JointureGroupeEleve, JointureGroupeEnseignant

e1 =  {'nom':u'__test__nom',
       'prenom':u'prenom__eleve__',
       'date':u'12/12/1983',
       #'classe':u'classname',
       #'niveau':u'niveau_test',
       'civilite':u'0',
       #'domaine':u'internet',
       'numero':u'1',
       'int_id':u'test',
       }

en1 = dict(int_id = u'1',
    nom = u'ens_nom',
    prenom = u'ens_prenom',
    date = u'01/01/1111',
    )

r1 = dict(int_id = u'r1',
    nom = u'nom',
    prenom = u'prenom',
    civilite = u'1',
    mail = u'resp@yahoo.fr',
    telephone = u'888',
    #tel_portable = u'')
    #tel_pro = u'')
    id_adresse = u'a1',
    #adresse = reference()
    )

a1 = dict(int_id = u'a1',
    adresse = u'rue des boulets',
    code_postal = u'75000',
    ville = u'paris',
    pays = u'france',
    )

r2 = dict(int_id = u'r2',
    nom = u'nom2',
    prenom = u'prenom2',
    civilite = u'0',
    mail = u'resp@free.fr',
    telephone = u'888',
    tel_portable = u'133',
    tel_pro = u'222',
    #id_adresse = u'a1',
    #adresse = reference()
    )

a2 = dict(int_id = u'a2',
    adresse = u'rue de Paris',
    code_postal = u'21000',
    ville = u'dijon',
    pays = u'france',
    )

adm = dict(int_id = u'admin1',
    nom = u'admin',
    prenom = u'prenom',
    date = u'01/01/1111',
#    civilite = text(default=u'')
#    mail = text(default=u'')
#    nom_patronymique = text(default=u'')
#    groupe = reference()
#    login = text(default=u'')
    )

def setup_module(module):
    module.library_store = init_store()


class TestStorage:

    def setup_class(cls):
        # toutes les initialisations ICI
        cls.eleve1 = Eleve(**e1)
        library_store.add(cls.eleve1)
        cls.resp1 = Responsable(**r1)
        library_store.add(cls.resp1)
        cls.resp2 = Responsable(**r2)
        library_store.add(cls.resp2)
        cls.add1 = Adresse(**a1)
        library_store.add(cls.add1)
        cls.add2 = Adresse(**a2)
        library_store.add(cls.add2)
        cls.niveau = Niveau(nom=u'3eme')
        library_store.add(cls.niveau)
        cls.classe = Classe(nom=u'3e1', niveau=cls.niveau)
        library_store.add(cls.classe)
        cls.ens = Enseignant(**en1)
        library_store.add(cls.ens)
        library_store.flush()

    def test_eleve(self):
        assert self.eleve1.prenom == e1['prenom']

    def test_add_parent(self):
        assert self.resp1.nom == r1['nom']

    def test_add_adresse(self):
        assert self.add1.pays == a1['pays']

    def test_affecte_adresse(self):
        resp = library_store.query(Responsable).filter_by(id_adresse=self.add1.int_id).first()
        assert resp == self.resp1
        # initialisation reference
        resp.adresse = self.add1
        assert resp.adresse.ville == a1['ville']
        self.resp2.adresse = self.add2

    def test_jointure_responsable_eleve(self):
        library_store.add(JointureResponsableEleve(eleve=self.eleve1, responsable=self.resp1))
        library_store.add(JointureResponsableEleve(eleve=self.eleve1, responsable=self.resp2))
        library_store.flush()
        assert self.resp1.get_eleves() == [self.eleve1]

    def test_add_groupes(self):
        assert self.classe.niveau.nom == u'3eme'

    def test_affectation(self):
        self.eleve1.classe = self.classe
        self.eleve1.niveau = self.niveau
        assert self.eleve1.classe.nom == u'3e1'
        assert self.niveau.get_eleves() == [self.eleve1]
        assert self.classe.get_eleves() == [self.eleve1]

    def test_add_enseignant(self):
        assert self.ens.nom == en1['nom']

    def test_jointure_ens_classe(self):
        cl = EnsClasse(nom=u'classe1')
        library_store.add(cl)
        library_store.add(JointureClasseEnseignant(classe=cl, enseignant=self.ens))
        library_store.flush()
        # FIXME : revoir l'API ?
        assert self.ens.get_classes()[0].classe == cl

    def test_jointure_ens_mat(self):
        mat = Matiere(nom=u'mat')
        library_store.add(mat)
        library_store.add(JointureMatiereEnseignant(matiere=mat, enseignant=self.ens))
        library_store.flush()
        assert self.ens.get_matieres() == [mat]


    def test_add_administratif(self):
        admin = Administratif(**adm)
        library_store.add(admin)
        grp = Service(nom=u'grp', description=u'descr')
        library_store.add(grp)
        admin.groupe = grp
        library_store.flush()
        assert admin.groupe.description == u'descr'

    def test_option(self):
        opt = Groupe(nom=u'option', description=u'option')
        library_store.add(opt)
        library_store.flush()
        assert opt.count_members() == 0
        library_store.add(JointureGroupeEleve(groupe=opt, eleve=self.eleve1))
        library_store.add(JointureGroupeEnseignant(groupe=opt, enseignant=self.ens))
        library_store.flush()
        assert self.eleve1.get_groupes()[0] == opt
        assert self.ens.get_groupes()[0] == opt
        assert opt.count_members() == 2

