#-*-coding:utf-8-*-
"""
    Tests des fonctions de la librairie eoletools
"""
from py.test import raises
from scribe.eoletools import formate_date, gen_login, ok_groupe, strip_adresse

def test_formate_date_us_fr():
    assert formate_date('2009/01/18') == '18/01/2009'
    assert formate_date('2009/01/18', '-') == '18-01-2009'
    assert formate_date('2009-01-18') == '18/01/2009'
    assert formate_date('2009-01-18', '') == '18012009'
    assert formate_date('20090118') == '18/01/2009'

def test_formate_date_fr_fr():
    assert formate_date('18/01/2009') == '18/01/2009'
    assert formate_date('18-01-2009') == '18/01/2009'

def test_gen_login():
    """
    test de la fonction gen_login
    # standard, pnom, p.nnn ou prenom.n
    """
    # individu "normal"
    ind = ('jean', 'martin')
    assert gen_login('standard', *ind) == 'jean.martin'
    assert gen_login('pnom', *ind) == 'jmartin'
    assert gen_login('p.nnn', *ind) == 'j.mar'
    assert gen_login('prenom.n', *ind) == 'jean.m'
    raises(Exception, gen_login, 'preference-invalide', *ind)

    # individu avec un prénom long
    ind = ('p'*15, 'n'*10)
    assert gen_login('standard', *ind) == 'p.%s' % ('n'*10,)
    assert gen_login('pnom', *ind) == 'p%s' % ('n'*10,)
    assert gen_login('p.nnn', *ind) == 'p.nnn'
    assert gen_login('prenom.n', *ind) == '%s.n' % ('p'*15,)

def test_ok_groupe():
    """
    test de la fonction ok_groupe
    """
    assert ok_groupe('-BEP2CSC') == 'bep2csc'
    assert ok_groupe('_t_spema') == 't_spema'
    assert ok_groupe('mp*') == 'mpe'
    assert ok_groupe('ma classe (tres bien)') == 'maclasse'
    assert ok_groupe('123456') == 'g123456'

def test_strip_adresse():
    """
    test de la fonction strip_adresse
    """
    adresse1 = """12, rue des Ecoles
Le Hameau."""
    adresse2 = """12 rue des Ecoles  LE HAMEAU """
    assert strip_adresse(adresse1) == strip_adresse(adresse2)
