#!/bin/bash

set -e

. /etc/eole/samba4-vars.conf

function updateSchemaDN()
{
   STR=${1}
   DN=${2}
   FILE=${3}

   sed -i -e "s/${STR}/${DN}/g" ${FILE}
   return ${?}
}

DN="$BASEDN"
BASEDN="CN=Schema,CN=Configuration,${DN}"

RETURNED=$(ldbsearch --option="dsdb:schema update allowed"=true -H /var/lib/samba/private/sam.ldb -b $BASEDN CN=ENTPersonAutresPrenoms CN | grep returned)
user_exists() {
    local username="${1}"
    samba-tool user show "${username}" > /dev/null 2>&1
}

if [ "$RETURNED" = "# returned 0 records" ]; then
    # Import schema
    SCHEMAS="samba.schema eole.schema eoleshare.schema radius.schema ent.schema"

    for schema in $SCHEMAS
    do
	updateSchemaDN "{DNCONFIG}" "${DN}" /etc/ldap/schema/eole/${schema}.ldif
	if [[ $? -ne 0 ]]
	then
           echo "Error updating DN for ${schema}"
           break
        fi
        ldbmodify -H /var/lib/samba/private/sam.ldb /etc/ldap/schema/eole/${schema}.ldif --option="dsdb:schema update allowed"=true
	if [[ $? -ne 0 ]]
	then
           echo "Error updating Schema ${schema} !!"
           break
	fi
    done

    ldbadd -H /var/lib/samba/private/sam.ldb /var/lib/eole/00_seth.ldif
    ldbmodify --option="dsdb:schema update allowed"=true -H /var/lib/samba/private/sam.ldb /var/lib/eole/01_seth_index.ldif
fi
PRIVATE_DIR=/etc/eole/private
PASSWORD_FILE="${PRIVATE_DIR}/eole-seth-education.password"
USER='eole-seth-education'

if ! user_exists $USER
then
    MANAGER_PASSWORD=$(cat "${PASSWORD_FILE}")

    echo "Ajout du compte de jonction au domaine '$USER'... "
    samba-tool user create --random-password $USER

    echo "Mise en conformité de l’utilisateur '$USER'... "
    samba-tool user setexpiry $USER --noexpiry
    samba-tool group addmembers 'Domain Admins' $USER
    samba-tool user setpassword $USER --newpassword="${MANAGER_PASSWORD}"
fi

PASSWORD_FILE_READER="${PRIVATE_DIR}/eole-seth-education-reader.password"
USER_READER='eole-seth-education-reader'

if ! user_exists $USER_READER
then
    MANAGER_PASSWORD=$(cat "${PASSWORD_FILE_READER}")

    echo "Ajout du compte de jonction au domaine '$USER_READER'... "
    samba-tool user create --random-password $USER_READER

    echo "Mise en conformité de l’utilisateur '$USER_READER'... "
    samba-tool user setexpiry $USER_READER --noexpiry
    samba-tool user setpassword $USER_READER --newpassword="${MANAGER_PASSWORD}"
fi

exit 0
