#!/bin/bash

VERS_10="10"
VERS_11="11"
VERS_12="12"

if ! [ -x /usr/bin/pg_dropcluster ];then
    exit 0
fi

PACKAGES_10="$(dpkg-query -W -f='${Package}\t${Status}\n' postgresql*-${VERS_10} | awk '/ok installed/ {print $1}')"
PACKAGES_11="$(dpkg-query -W -f='${Package}\t${Status}\n' postgresql*-${VERS_11} | awk '/ok installed/ {print $1}')"
PACKAGES_12="$(dpkg-query -W -f='${Package}\t${Status}\n' postgresql*-${VERS_12} | awk '/ok installed/ {print $1}')"

if  [ -n "${PACKAGES_10}" ] && [ -n "${PACKAGES_11}" ]; then

    # Démarrage du service
    systemctl start postgresql

    # Suppression du cluster 11 créé automatiquement
    pg_dropcluster --stop ${VERS_11} main

    # Mise à niveau du cluster avec pg_upgradecluster 10 main
    pg_upgradecluster -v ${VERS_11} ${VERS_10} main


    # suppression du cluster 10
    pg_dropcluster --stop ${VERS_10} main


    # s’assurer que postgresql est démarré
    systemctl start postgresql

    # désintallation de postgresql 10
	apt-eole remove ${PACKAGES_10}
fi

if  [ -n "${PACKAGES_11}" ] && [ -n "${PACKAGES_12}" ]; then

    # Démarrage du service
    systemctl start postgresql

    # Suppression du cluster 12 créé automatiquement
    pg_dropcluster --stop ${VERS_12} main

    # Mise à niveau du cluster avec pg_upgradecluster 11 main
    pg_upgradecluster -v ${VERS_12} ${VERS_11} main


    # suppression du cluster 11
    pg_dropcluster --stop ${VERS_11} main


    # s’assurer que postgresql est démarré
    systemctl start postgresql

    # désintallation de postgresql 11
	apt-eole remove ${PACKAGES_11}
fi

exit 0
