#!/bin/bash

. /usr/lib/eole/ihm.sh

if [ "$(CreoleGet module_type)" = "amon" ];then

EchoRouge "********** Flux Pare-feu globaux ******************************"
EchoRouge "***************************************************************"
EchoOrange "** Flux sortants vers l'extérieur **"
iptables -vnL FORWARD | grep ports_forward_OUT
EchoOrange "** Flux entrants depuis les zones internes **"
iptables -vnL FORWARD | grep "\-ext"
echo -e "\n"
EchoOrange "** Flux entrants de l'extérieur **"
iptables -vnL FORWARD | grep ports_forward_IN
EchoOrange "** Flux sortants vers les zones internes **"
iptables -vnL FORWARD | grep "ext-"
echo -e "\n"
EchoRouge "***************************************************************"
EchoRouge "***             Gestion du traffic par ports                ***"
EchoRouge "***************************************************************"
EchoOrange "** Output **"
iptables -vnL ports_forward_OUT | grep ACC-ports_PF_out
EchoOrange "** Input **"
iptables -vnL ports_forward_IN | grep ACC-ports_PF_in

echo -e "\n\n"
EchoRouge "****************************************************************"
EchoRouge "***       Gestion du traffic par serveurs nationaux          ***"
EchoRouge "****************************************************************"
EchoOrange "** Output **"
iptables -vnL flux_forward_OUT | grep ACC-flux_out
EchoOrange "** Input **"
iptables -vnL flux_forward_IN | grep ACC-flux_in
iptables -vnL | grep DROP_par_wan-lan
echo -e "\n"

else

EchoRouge "***************************************************************"
EchoRouge "***             Gestion du traffic par ports                ***"
EchoRouge "***************************************************************"
EchoOrange "** Output **"
iptables -vnL OUTPUT | grep ports_OUT
iptables -vnL ports_OUT | grep ACC-ports_out
EchoOrange "** Input **"
iptables -vnL INPUT | grep ports_IN
iptables -vnL ports_IN | grep ACC-ports_in
echo -e "\n"

EchoRouge "****************************************************************"
EchoRouge "***       Gestion du traffic par serveurs nationaux          ***"
EchoRouge "****************************************************************"
EchoOrange "** Output **"
iptables -vnL OUTPUT | grep flux_OUT
iptables -vnL flux_OUT | grep ACC-flux_out
EchoOrange "** Input **"
iptables -vnL INPUT | grep flux_IN
iptables -vnL flux_IN | grep ACC-flux_in
echo -e "\n"

fi
