#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""Informations sur les cartes ethernet
"""
import commands
import os

from agent import Agent
from zephir.monitor.utils import list_to_table

class Reseau(Agent):
    """Infos réseau
    """
    def __init__(self):
        self.name="reseau"
        self.description="""Informations reseau (configuration des cartes ethernet)"""
        Agent.__init__(self)
        # écriture dans les fichiers
        self.write_html()
        self.write_xml()

    HTML = """
    <div class="titlediv">
    <h1 class="newstitle">
    Informations sur les cartes réseau
    </h1>
    <a name="%s"/>
    </div>
    <div class="bodydiv">
    %s
    </div>
    """

    def _reseau(self):
        """Récupère une sortie système
        """
        exec_cmd = "/bin/cat /proc/net/dev"
        s = commands.getoutput(exec_cmd)
        lignes = s.splitlines()
        # une ligne pour chaque carte
        lignes = lignes[2:]

        d = {}
        for ligne in lignes:
            deb_ligne = ligne.split(':')[0].strip()
            fin_ligne = ligne.split(':')[1]
            champs = fin_ligne.split()
            # transforme les octets en kilo-octets
            d[deb_ligne] = [int(champs[0])/1024, int(champs[8])/1024]

        exec_cmd = "/sbin/ifconfig"
        s = commands.getoutput(exec_cmd)
        cartes = s.split("\n\n")
        
        for lignes in cartes:
            ligne = lignes.splitlines()[0]
            nom_carte = ligne.split()[0]
            ligne = lignes.splitlines()[1]
            adresses = ligne.strip()
            adr_carte = adresses[adresses.index(':')+1:].split()[0]
            # ajoute les informations au dictionnaire
            d[nom_carte].append(adr_carte)

        # transformation du dico de listes en liste de dicos (ah ah ah)
        l = []
        for device in d.keys():
            l.append({'nom':device,'entree (ko)':d[device][0],'sortie (ko)':d[device][1],'adresse ip':d[device][2]})
        return l


    def _dump_xml(self):
        """sortie en xml
        """
        resultat = self._reseau()
        return list_to_table(resultat)
        
    def _dump_html(self):
        """sortie en html
        """
        return self.HTML % (self.name, self._dump_xml())


if __name__ == "__main__":
    Reseau()
    # print res._dump_xml()
