# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""

"""

try: _ # localized string fetch function
except NameError: _ = str

from datetime import datetime, timezone
from twisted.web.microdom import *

from zephir.monitor.agentmanager import util

DATE_FORMAT = '%Y-%m-%d %H:%M:%S'

class Measure:
    """Résultat d'une mesure à un instant donné."""

    def __init__(self, date, value):
        self.date = util.timestampfromutc(date) #time.mktime(date.utctimetuple()) #date.strftime(DATE_FORMAT)
        self.value = value # {champ:valeur}

    def get_date(self):
        """@return: date de mesure, UTC"""
        return datetime.fromtimestamp(self.date, tz=timezone.utc)
	#self.date #datetime.fromtimestamp(time.mktime(time.strptime(self.date, DATE_FORMAT)))
    def get_strdate(self):
        """
        @return: représentation texte de la date de mesure en temps
          local"""
        return datetime.fromtimestamp(self.date).strftime(DATE_FORMAT)
    def get_value(self, f):
        return self.value[f]

    def __str__(self):
        return "[%s : %s]" % (self.get_strdate(), str(self.value))

    def __cmp__(self, other):
        # None n'a pas d'attribut get_date, on renvoie toujours vrai dans ce cas
        if other == None:
            return 1
        else:
            return cmp(self.get_date(), other.get_date())



class AgentDataChunk:
    """Élément de données généré par l'agent
    """
    pass


class FileData(AgentDataChunk):
    """Fichier quelconque dans le répertoire de l'agent

    TODO: optional copying to the agent data dir
    """
    def __init__(self, filename):
        self.filename = filename

class RRDFileData(FileData):
    """Fichier RRD"""
    pass

class ImgFileData(FileData):
    """Fichier image, à afficher directement plutôt que par un lien"""
    pass

class HTMLData(AgentDataChunk):
    """Code HTML, du niveau d'une balise <div> ou <p>"""
    def __init__(self, data):
        self.data = data

class MeasuresData(AgentDataChunk):
    """Table de mesures C{zephir.monitor.agentmanager.data.Measure}"""
    def __init__(self, measures, fields = ['value']):
        self.measures = measures
        self.fields = fields

class TableData(AgentDataChunk):
    """Table de valeurs
    """
    def __init__(self, columns_format, table_data=None):
        """
        @param table_data: a list of C{{key:value}} dicts (one dict
          per row, one key per column)
        
        @param columns_format: a list of (key, title, attributes,
          formatter) tuples, one for each column in C{table_data},
          where:
       
           - attributes is a C{{attr:value}} dict which describes HTML
             attributes of the corresponding table cell
         
           - formatter is a function returning a string to display the
             value in the cell; you will probably have to define a
             real function instead of using lambda.
        """
        self.table_data = table_data
        self.columns_format = []
        for (field, title, attrs, format) in columns_format:
            if format is None: format = identity
            if attrs is None: attrs = ""
            else:
                attrs = " " + ' '.join(['%s="%s"' % (k,v) for k,v in attrs.items()])
            self.columns_format.append((field, title, attrs, format))

def identity(x): return x
