# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2011
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent FreshClam
"""
from pyeole.diagnose import compare_iptables, compare_ipset, NOT_AVAILABLE, OK, NOK
from creole.config import VIRTMASTER

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import TableData
from zephir.monitor.agentmanager import status
from zephir.monitor.agentmanager.config import MODE_CONTENEUR_ACTIF, GROUPS
from os.path import isfile
from zephir.monitor.agentmanager.util import status_to_img
import time
import os

reports_file = '/var/lib/eole/reports/bastion.log'

class Bastion(Agent):
    """
    Utilisateurs connectes
    """
    def __init__(self, name, **params):
        Agent.__init__(self, name, **params)
        self.status = status.Unknown()
        self.table = TableData([
            ('status', 'état', {'align':'center'}, status_to_img),
            ('msg', 'message', {'align':'left'}, None)
        ])
        self.data = [self.table]
        self.groups = GROUPS

    def measure(self):
        display = []
        status_ = status.OK()
        try:
            ret = {}
            if isfile(reports_file) and os.stat(reports_file).st_size != 0:
                exec(compile(open(reports_file, "rb").read(), reports_file, 'exec'), {}, ret)
            if ret['STATUS'] == '0':
                last_update = time.strftime("%d %b %Y %H:%M:%S", time.localtime(float(ret['DATE'])))
                msg = "Dernière génération des règles bastion {0}".format(last_update)
                status_ = status.OK()
                lstatus = 'On'
            else:
                msg = ret['MSG']
                status_ = status.Error()
                lstatus = 'Off'
        except Exception as e:
            status_ = status.Error()
            lstatus = 'Off'
            msg = "Impossible de lire %s : %s" % (reports_file, e)
        display.append({'msg': msg, 'status': lstatus})
        #
        ipt = int(compare_iptables())
        if ipt == NOT_AVAILABLE:
            msg = "règles iptables non exportées sur le maitre"
            status_ = status.Error()
            lstatus = 'Off'
        elif ipt == NOK:
            msg = "règles iptables incorrectes sur le maitre"
            status_ = status.Error()
            lstatus = 'Off'
        else:
            msg = "règles iptables sur le maitre"
            lstatus = 'On'
        display.append({'msg': msg, 'status': lstatus})
        #
        if MODE_CONTENEUR_ACTIF:
            for container in self.groups:
                if container in [VIRTMASTER, "all"]:
                    continue
                ipt = int(compare_iptables(container))
                if ipt == NOT_AVAILABLE:
                    msg = "règles iptables non exportées sur {0}".format(container)
                    status_ = status.Error()
                    lstatus = 'Off'
                elif ipt == NOK:
                    msg = "règles iptables incorrectes sur {0}".format(container)
                    status_ = status.Error()
                    lstatus = 'Off'
                else:
                    msg = "règles iptables sur {0}".format(container)
                    lstatus = 'On'
                display.append({'msg': msg, 'status': lstatus})
        #
        ipt = int(compare_ipset())
        if ipt != NOT_AVAILABLE:
            if ipt == OK:
                msg = "règle ipset sur le maitre"
                status_ = status.OK()
                lstatus = 'On'
            else:
                msg = "règles ipset incorrectes sur le maitre"
                status_ = status.Error()
                lstatus = 'Off'
            display.append({'msg': msg, 'status': lstatus})
        self.status = status_
        return display

    def check_status(self):
        return self.status

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value
