#!/usr/bin/env python3
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# setup.py
#
# script d'installation des libraries du client Zephir
#
###########################################################################

import os, glob
import sys
from setuptools import setup
from setuptools.command.install import install
from subprocess import call

sys.dont_write_bytecode = True

BASE_DIR = '/usr/share/'
APP_DIR =  os.path.join(BASE_DIR, 'zephir')

# listing des répertoires de données
def get_data(data_dict):
    for path, dirs in data_dict.items():
        datafiles = []
        while dirs != []:
            next_dirs = []
            for d in dirs:
                cur_files = []
                dest = os.sep.join(d.split(os.sep)[1:])
                dest = os.path.join(path,dest)
                for fic in glob.glob(d+'/*'):
                    if os.path.isdir(fic):
                        next_dirs.append(fic)
                    else:
                        cur_files.append(fic)
                datafiles.append((dest, cur_files))
            dirs = next_dirs
    return datafiles

DATA = get_data({APP_DIR:['data']})

def do_pre_install_stuff():
    call(['make', 'build'])

class CustomInstall(install):
    def run(self):
        do_pre_install_stuff()
        install.run(self)

setup(
    author='eole',
    author_email='eole@ac-dijon.fr',
    name='zephir-client',
    version='2.10.0',
    description='Zephir Parc, configuration and monitoring for EOLE modules',
    url='http://www.eole.orion.education.fr',
    packages=['zephir',
              'zephir.zephir_conf',
              'zephir.monitor',
              'zephir.monitor.agents',
              'zephir.monitor.agentmanager',
              'zephir.monitor.agentmanager.templates'],
    py_modules=['twisted.plugins.eole_agents'],
    scripts=['bin/enregistrement_zephir','bin/synchro_zephir', 'bin/network_zephir'],
    data_files = DATA,
    cmdclass={'install': CustomInstall}
)
