# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
###########################################################################

"""
Agent zephir pour la génération des bilans mensuels
"""

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import TableData
from zephir.monitor.agentmanager.util import status_to_img
from zephir.monitor.agentmanager import status

class Bilan(Agent):


    def __init__(self, name, **params):
        Agent.__init__(self, name, **params)
        self.glob_status = status.OK()
        self.table = TableData([
            ('description', "Description", {'align':'left'}, None),
            ('stats', "Historique", {'align':'left'}, None),
            ])
        self.data = [self.table]


    def measure(self):
        mesures = []
        try:
            # recherche de l'identifiant zephir 
            # (nécessaire pour l'url du graphe de status des 'sous agents')
            from zephir.zephir_conf.zephir_conf import id_serveur
        except:
            # si on est pas enregistré : 0
            id_serveur = 0
           
        # agents à ne pas prendre en compte
        hidden = ['diag']
        hidden.extend(self.manager.agents['tcpservices'].tcp_services)
        self.glob_status = status.OK()
        for agent in self.manager.agents.keys():
            serv_agent = self.manager.agents[agent]
            if serv_agent.name != 'bilan' and serv_agent.name not in hidden and not serv_agent.name.endswith('Debsums'):
                if serv_agent.check_status() == status.Error():
                    self.glob_status = status.Warn()
                if serv_agent.last_measure is not None:
                    mesures.append({ 'description': '<a href=/agents/%s/%s/>%s</a>' % (id_serveur, agent, serv_agent.description),
                                     'stats': '<img src=/agents/%s/%s/status_long.png alt="Historique (%s)"/>' % (id_serveur,agent,agent)})
                else:
                    mesures.append({ 'description': agent,
                                     'stats': ''})
        return {'agents': mesures}

    
    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value['agents']

    def check_status(self):
        """remonte une erreur si un des services est tombé"""
        # pas d'alerte sur cet agent
        return self.glob_status
