#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import unittest
import xmlrpclib

from zephir.monitor.agentmanager import config as cfg


class TestXmlrpc(unittest.TestCase):
    """Nécessite un client zephir lancé"""

    def setUp(self):
        self.rpc = xmlrpclib.Server('http://localhost:%d/xmlrpc/' % cfg.DEFAULT_CONFIG['webserver_port'])

    def tearDown(self):
        self.rpc = None

    
    def test_list_agents(self):
        expected = ['users2', 'users1', 'eth0', 'cpu2', 'eth1', 'cpu1']
        result = self.rpc.list_agents()
        expected.sort() ; result.sort()
        self.assertEqual(expected, result)


    def test_status_for_agents(self):
        expected = {
            'eth0': {'level':'Unknown', 'message':''},
            'cpu1': {'level':'OK', 'message':''},
            'cpu2': {'level':'OK', 'message':'cpu2 status'},
            }
        result = self.rpc.status_for_agents(expected.keys())
        for agent_name in expected:
            self.assertEqual(expected[agent_name], result[agent_name],
                             "status of " + agent_name)

    def test_status_of_wrong_agent(self):
        result = self.rpc.status_for_agents(['eth0','bogus'])
        self.assert_(not result.has_key('bogus'))
    

if __name__ == '__main__':
    unittest.main()
