# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2010
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent zephir pour vérification de la synchronisation AAF
"""

from os.path import join, isfile, basename
from os import stat
from glob import glob
import time
from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import TableData
from zephir.monitor.agentmanager.util import status_to_img
from zephir.monitor.agentmanager import status
from scribe.importation.config import AAF_LIST_AGENT, AAF_IMPORT_DIR

class AAF(Agent):

    def __init__(self, name,
                 **params):
        Agent.__init__(self, name, **params)
        self.status = status.Unknown()
        self.table = TableData([
            ('name', "Identifiant", {'align':'left'}, None),
            ('date_err', "Date de l'erreur", {'align':'left'}, None),
            ('status', "Etat", {'align':'center'}, status_to_img),
            ])
        self.data = [self.table]
        self.measure_data = {}

    def measure(self):
        self.status = status.Unknown("Synchronisation non active")
        # liste de tous les fichiers associés
        if isfile(AAF_LIST_AGENT):
            file_list = open(AAF_LIST_AGENT).read().strip().split('\n')
        else:
            file_list = []
        # recherche des fichiers indiquant une erreur de prise en compte
        search_string = join(AAF_IMPORT_DIR, ".*.tar.gz.lock")
        list_lock = glob(search_string)
        if file_list == []:
            return {'statistics':None}
        self.status = status.OK()
        err_stats = []
        for fic in file_list:
            fic_err = join(AAF_IMPORT_DIR, '.%s.lock' % fic)
            if fic_err in list_lock:
                status_fic = 'Off'
                stats = stat(fic_err)
                date_err = time.ctime(stats.st_mtime)
                self.status = status.Error("Echec de prise en compte d'un fichier")
            else:
                status_fic = 'On'
                date_err = ""
            # récupération de la date
            err_stats.append({'name':fic, 'date_err':date_err, 'status':status_fic})
            self.measure_data[fic] = (status_fic, date_err)
        return {'statistics':err_stats}

    def errback_tunnels(self, err):
        self.status = status.Error("Erreur d'execution : erreur lors de la recherche des fichiers d'information")
        return {'statistics':None}

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value['statistics']
            
    def check_status(self):
        return self.status

