#!/bin/bash

########################################################################################
# Eole - 2014
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# zephir_dicts.sh
#
# permet de remonter une archive des dictionnaires installés
# sur une machine eole et la liste des paquets associés
#
# génère un archive contenant:
#
# - <eole_module>-<eole_version>.paqs : liste des paquets contenant des dictionnaires
# - eole/<nom_paquet>/*.xml : répertoires par applications avec dictionnaires
#
# liste des paquets de dictionnaires non installés par défaut :
#
# eole-apt-cacher-ng
# eole-cdt
# eole-dokuwiki
# eole-ejabberd
# eole-eqos
# eole-fluxbb
# eole-gaspacho-agent
# eole-gepi
# eole-grr
# eole-jappix
# eole-libvirt
# eole-ltsp-fichier
# eole-ltsp-server
# eole-lxc-controller
# eole-one-frontend
# eole-one-node
# eole-one-singlenode
# eole-ovs
# eole-piwigo
# eole-piwik
# eole-smartmontools
# eole-snmpd
# eole-spipeva
# eole-taskfreak
# eole-webcalendar
# eole-wordpress
#
# (à installer par exemple sur un module eolebase fraichement installé/mis à jour)
#

if [ -f /usr/bin/CreoleGet ]
then
    export NOM_MOD=`CreoleGet eole_module`
    export VERSION=`CreoleGet eole_release`
    [ "$VERSION" == "2.4.0" ] && VERSION="2.4"
else
    . /etc/eole/release
    export NOM_MOD=$EOLE_MODULE
    export VERSION=$EOLE_VERSION
fi
if [ -z $NOM_MOD ]
then
    echo "Nom de module non retrouvé"
    exit 1
fi
DEST_DIR=/tmp/${NOM_MOD}_${VERSION}
> /tmp/${NOM_MOD}.tmp
# recherche des dictionnaires contenant des variables
for dict in `grep -c "<creole>" /usr/share/eole/creole/dicos/*.xml | grep -v :0 | cut -d":" -f1`
do
    # paquet livrant chaque dictionnaire
    nom_paq=`dpkg -S $dict | cut -d":" -f1`
    echo "eole/$nom_paq" >> /tmp/${NOM_MOD}.tmp
    /bin/mkdir -p "$DEST_DIR/eole/${nom_paq}"
    /bin/cp -f $dict $DEST_DIR/eole/${nom_paq}/
done
# suppression doublons
cat /tmp/${NOM_MOD}.tmp | sort -u > $DEST_DIR/${NOM_MOD}-${VERSION}.paqs
/bin/rm -f /tmp/${NOM_MOD}.tmp
pushd /tmp >/dev/null
tar -czf /tmp/zephir_${NOM_MOD}-${VERSION}.tar.gz ${NOM_MOD}_${VERSION}
rm -rf ${NOM_MOD}_${VERSION}
popd >/dev/null
echo "Informations sur les dictionnaires sauvegardées dans /tmp/zephir_${NOM_MOD}-${VERSION}.tar.gz"
