#-*- coding:utf-8 -*-

from xmlrpc.client import Binary

def to_bytes(objet):
    """Transforme les objets str ou Binary contenus dans un objet en bytes
    """
    if isinstance(objet, tuple):
        l = []
        for item in objet:
            l.append(to_bytes(item))
        return tuple(l)
    if isinstance(objet, list):
        l = []
        for item in objet:
            l.append(to_bytes(item))
        return l
    if isinstance(objet, dict):
        dico={}
        for cle in objet:
            dico[cle] = to_bytes(objet[cle])
        return dico
    if isinstance(objet, str):
        string =  objet.encode()
        return string
    if isinstance(objet, Binary):
        string = objet.data
        return string
    return objet

def to_string(objet):
    """Transforme les objets bytes ou Binary contenus dans un objet en str
    """
    if isinstance(objet, tuple):
        l = []
        for item in objet:
            l.append(to_string(item))
        return tuple(l)
    if isinstance(objet, list):
        l = []
        for item in objet:
            l.append(to_string(item))
        return l
    if isinstance(objet, dict):
        dico={}
        for cle in objet:
            dico[cle] = to_string(objet[cle])
        return dico
    if isinstance(objet, bytes):
        string =  objet.decode()
        return string
    if isinstance(objet, Binary):
        string = objet.data.decode()
        return string
    return objet

