#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# updgrade_dicos.py
#  
# met à jour le répertoire des dictionnaires des modules Eole
#       
###########################################################################

import os
from zephir.backend.config import PATH_ZEPHIR, ROOT_DIR, DB_PASSWD
import psycopg2

# on récupère la liste des modules triés par n° de module
cx = psycopg2.connect(database='zephir',user='zephir',password=DB_PASSWD)
db_cursor = cx.cursor()
db_cursor.execute("""select id,libelle,version from modules""")
res = db_cursor.fetchall()
db_cursor.close()

for module in res:
    # test si version creole1/creole2
    if module[2] == 1:
        # chemin de destination du module
        dest = PATH_ZEPHIR + 'modules/%s/dictionnaire' % module[0]
        # dictionnaire à mettre en place
        nom_fic = '%s/dictionnaires/dico-%s' % (ROOT_DIR, module[1])
    else:
        dest = PATH_ZEPHIR + 'modules/%s/dicos' % module[0]
        # répertoire à mettre en place
        nom_fic = '%s/dictionnaires/%s' % (ROOT_DIR, module[1])

    # lien sur le(s) dictionnaire(s)
    if not os.path.islink(dest):
        try:
            os.system('rm -rf %s' % dest)
        except:
            pass
        res=os.system("ln -s %s %s" % (nom_fic, dest))
        if res != 0:
            print "probleme lors de l'installation du dictionnaire pour %s" % module.split(':')[1]
