#!/usr/bin/env python3
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2016
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# test_creole.py
#
# script testant le chargement des dictionnaires de chaque module
# (à lancer sur Zéphir)
#
###########################################################################

# insertion des types d'établissement
import getpass
import traceback
from pyeole.ihm import print_red
from zephir.eolerpclib import xmlrpclib, EoleProxy
from zephir.config import ADRESSE_ZEPHIR, PORT_ZEPHIR, PATH_MODULES, CREOLE_VERSIONS

login = input("entrez un nom d'utilisateur zephir [admin_zephir] : ")
if login == "":
    login = "admin_zephir"
passwd = getpass.getpass("mot de passe pour %s : " % login)

z = EoleProxy('https://%s:%s@%s:%s' % (login, passwd, ADRESSE_ZEPHIR, PORT_ZEPHIR))
dict_paths = "{0}/{1}/dicos"

# création des modules
print("test des modules Eole...")

modules_actuel = z.modules.get_module()[1]
for module in modules_actuel:
    print("Chargement des dictionnaires du module {}".format(module['libelle']))
    try:
        rc, data = z.modules.get_dico(module['id'])
        assert rc == 1, str(data)
    except Exception as err:
        print_red("Incompatibilité dans les dictionnaires : {}".format(str(err)))

print("\ntest des modules terminé")
