# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# design.py
#
# classe de base pour le design des pages web
#
###########################################################################
from twisted.web import resource
from zephir.web.config import Navigation, server_sort_keys, web_colors
from zephir.web.template.page import get_user, get_password, PageEole as Page
from zephir.web.template.page import proxy
from zephir.web.template.template import design

from zephir.web.html.erreur import *

class Design(Page):

    content = ""

    def render_design(self,request):
        factorys = {}
        if hasattr(self,'renderView'):
            self.renderView(request)
        factorys['title'] = self.wmfactory_title(request)
        factorys['menu'] = self.wmfactory_menu(request)
        factorys['groupe'] = self.wmfactory_groupe(request)
        factorys['content'] = self.wmfactory_content(request)
        factorys['copyright'] = self.wmfactory_copyright(request)
        factorys['main_color'] = web_colors['main_color']
        factorys['menu_color'] = web_colors['menu_color']
        factorys['group_color'] = web_colors['group_color']
        factorys['bg_color'] = web_colors['bg_color']
        factorys['table_color'] = web_colors['table_color']
        factorys['link_color'] = web_colors['link_color']
        factorys['hover_color'] = web_colors['hover_color']
        return design % factorys

    def wmfactory_menu(self, request):
        return Navigation().menu()

    def wmfactory_groupe(self, request):
        # groupe_alerte : si le groupe est celui des serveurs en alerte, il est mis à jour à chaque affichage
        if not request.path.endswith(b'logout'):
            try:
                groupe_alerte = request.getSession().groupe_alerte
            except:
                groupe_alerte = False
            groupe_tab = []
            if groupe_alerte == False:
                # cas d'un groupe normal
                try:
                    groupe=request.getSession().groupe_serveur
                except:
                    return ""
                # affichage du groupe enregistré dans la session
                groupe_tab = ["""<br/><center><a href="/serveur/aff_groupe">groupe actuel</a><br/>"""]
                groupe_tab.append("""<center>(%d serveurs)</center>""" % len(groupe))
                groupe_tab.append("""<a href=/serveur/remove_groupe>désélectionner</a><br/><br/>""")
                groupe_tab.append("""<a href=/serveur/action?id_groupe=-1>agir sur le groupe</a><br/><br/>""")
                groupe_tab.append("""<div class="groupe_serv"><table>""")
                for serv in groupe:
                    groupe_tab.append("""<tr><td><a href="/serveur/etat?id=%s" title="%s">%s-%s</a></td></tr>""" % (serv['id'], serv['libelle'], serv['rne'], serv['id']))
            else:
                # cas de la mini page d'alertes
                serveurs = backend(proxy(request).serveurs.get_alertes())
                serveurs.sort(key=self.sort_servers)
                groupe_tab = ["""<br/><center><a href="/serveur/aff_alertes">serveurs en alerte</a><br/>"""]
                groupe_tab.append("""<center>(%d serveurs)</center>""" % len(serveurs))
                groupe_tab.append("""<a href=/serveur/remove_groupe>désélectionner</a><br/><br/>""")
                groupe_tab.append("""<div class="groupe_serv"><table>""")
                type_err = ""
                for serveur in serveurs:
                    if serveur[5] != type_err:
                        type_err = serveur[5]
                        # affichage du type d'erreur
                        if serveur[5] == 2:
                            etat = """perte contact"""
                        elif serveur[5] == 0:
                            etat = """erreur stats"""
                        elif serveur[5] == 3:
                            etat = """blocage uucp"""
                        else:
                            etat = """blocage + stats"""
                        groupe_tab.append("""<tr><td><font color="red">%s</font></td>""" % etat)
                    groupe_tab.append("""<tr><td><a href="/serveur/etat?id=%s" title="%s">%s-%s</a></td></tr>""" % (serveur[4], serveur[2], serveur[0], serveur[4]))
            groupe_tab.append("""</table></div></center><br/>""")
            return "\n".join(groupe_tab)
        else:
            return ""

    def wmfactory_copyright(self,request):
        return "Powered By EOLE"

    def get_variante(self,zephir):
        """Dictionnaire clefs,libelle pour les variantes
        """
        try:
            variante = backend(zephir.modules.get_variante())
            libelle = {}
            for v in variante :
                libelle[v['id']] = v['libelle']

        except BackendError:
            raise BackendError("erreur lors de la récupération de la liste des variantes")

        return libelle

    def sort_servers(self,a,b):
        """comparaison de 2 serveurs
        Le tri se fait sur le n° rne et le module
        """
        etats = [2,3,4,0]
        if a[5]==b[5]:
            if a[0] > b[0]:
                return 1
            elif a[0] < b[0]:
                return -1
            else:
                return 0
        elif etats.index(int(a[5])) > etats.index(int(b[5])):
            return 1
        else:
            return -1

    def get_variante_module(self,id_module,zephir):
        """Dictionnaire clefs, libelle pour les variantes d'un module considéré
        """
        try:

            variante = backend(zephir.modules.get_variante())
            libelle = {}

            for v in variante :

                if v['module'] == id_module :
                    libelle[v['id']] = v['libelle']

        except BackendError:
            raise BackendError("erreur lors de la récupération de la liste des variantes")

        return libelle

    def get_module(self,zephir):
        """Dictionnaire clef,libelle pour les modules
        """
        try:
            # récupération des libellés des modules
            module_list = backend(zephir.modules.get_module())
            # construction du dico des libellés
            dico_libelle = {}
            for module in module_list :
                dico_libelle[module['id']] = (module['libelle'], module['version'])
        except BackendError:
            raise BackendError("erreur lors de la récupération des modules")

        return dico_libelle

