#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###################################
#
# script basique pour récupérer des valeurs de configuration sur l'ensemble des serveurs
#

import xmlrpclib, getpass, sys

if __name__ == '__main__':

    # lancé seulement si lancement en ligne de commande (pas en cas d'import dans un programme python)
    user = raw_input("nom de l'utilisateur zephir :")
    pwd = getpass.getpass("mot de passe                :")
    # si appel à distance : utiliser https et remplacer 127.0.0.1:7081 par <adresse_zephir>:7080
    zephir_proxy = xmlrpclib.ServerProxy('http://%s:%s@127.0.0.1:7081' % (user, pwd))
    # récupération des serveurs et test de l'adresse eth0 :
    ret_code, serveurs = zephir_proxy.serveurs.get_serveur()
    for serveur in serveurs:
        ret_code, config = zephir_proxy.serveurs.get_config(serveur['id'])
        if not config['adresse_ip_eth0'].startswith('10.'):
            print serveur['id'], " - ", serveur['libelle'], "IP PUBLIQUE : ", serveur['ip_publique'], "ADRESSE ETH0 : ", config['adresse_ip_eth0']
