# Generated by default/object.tt
package Paws::SecurityHub::NetworkConnectionAction;
  use Moose;
  has Blocked => (is => 'ro', isa => 'Bool');
  has ConnectionDirection => (is => 'ro', isa => 'Str');
  has LocalPortDetails => (is => 'ro', isa => 'Paws::SecurityHub::ActionLocalPortDetails');
  has Protocol => (is => 'ro', isa => 'Str');
  has RemoteIpDetails => (is => 'ro', isa => 'Paws::SecurityHub::ActionRemoteIpDetails');
  has RemotePortDetails => (is => 'ro', isa => 'Paws::SecurityHub::ActionRemotePortDetails');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::NetworkConnectionAction

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::NetworkConnectionAction object:

  $service_obj->Method(Att1 => { Blocked => $value, ..., RemotePortDetails => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::NetworkConnectionAction object:

  $result = $service_obj->Method(...);
  $result->Att1->Blocked

=head1 DESCRIPTION

Provided if C<ActionType> is C<NETWORK_CONNECTION>. It provides details
about the attempted network connection that was detected.

=head1 ATTRIBUTES


=head2 Blocked => Bool

Indicates whether the network connection attempt was blocked.


=head2 ConnectionDirection => Str

The direction of the network connection request (C<IN> or C<OUT>).


=head2 LocalPortDetails => L<Paws::SecurityHub::ActionLocalPortDetails>

Information about the port on the EC2 instance.


=head2 Protocol => Str

The protocol used to make the network connection request.


=head2 RemoteIpDetails => L<Paws::SecurityHub::ActionRemoteIpDetails>

Information about the remote IP address that issued the network
connection request.


=head2 RemotePortDetails => L<Paws::SecurityHub::ActionRemotePortDetails>

Information about the port on the remote IP address.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

