# Generated by default/object.tt
package Paws::LookoutVision::DatasetMetadata;
  use Moose;
  has CreationTimestamp => (is => 'ro', isa => 'Str');
  has DatasetType => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has StatusMessage => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutVision::DatasetMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutVision::DatasetMetadata object:

  $service_obj->Method(Att1 => { CreationTimestamp => $value, ..., StatusMessage => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutVision::DatasetMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTimestamp

=head1 DESCRIPTION

Sumary information for an Amazon Lookout for Vision dataset.

=head1 ATTRIBUTES


=head2 CreationTimestamp => Str

The Unix timestamp for the date and time that the dataset was created.


=head2 DatasetType => Str

The type of the dataset.


=head2 Status => Str

The status for the dataset.


=head2 StatusMessage => Str

The status message for the dataset.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutVision>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

