# Generated by default/object.tt
package Paws::Pinpoint::CustomDeliveryConfiguration;
  use Moose;
  has DeliveryUri => (is => 'ro', isa => 'Str', required => 1);
  has EndpointTypes => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Pinpoint::CustomDeliveryConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Pinpoint::CustomDeliveryConfiguration object:

  $service_obj->Method(Att1 => { DeliveryUri => $value, ..., EndpointTypes => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Pinpoint::CustomDeliveryConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->DeliveryUri

=head1 DESCRIPTION

Specifies the delivery configuration settings for sending a campaign or
campaign treatment through a custom channel. This object is required if
you use the CampaignCustomMessage object to define the message to send
for the campaign or campaign treatment.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DeliveryUri => Str

The destination to send the campaign or treatment to. This value can be
one of the following:

=over

=item *

The name or Amazon Resource Name (ARN) of an AWS Lambda function to
invoke to handle delivery of the campaign or treatment.

=item *

The URL for a web application or service that supports HTTPS and can
receive the message. The URL has to be a full URL, including the HTTPS
protocol.

=back



=head2 EndpointTypes => ArrayRef[Str|Undef]

The types of endpoints to send the campaign or treatment to. Each valid
value maps to a type of channel that you can associate with an endpoint
by using the ChannelType property of an endpoint.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Pinpoint>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

