package App::InteractivePerlTutorial::Chapter::FileTests::Operators;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Operators';

1;
__DATA__

=encoding utf-8

=head1 Operators

The operatorrs all take the form of -X, where the X represents the particular test. In most cases, these operators return true or false.

  -e #  tests a filename for existence;
  -M # returns the file modification time in days since the start of the program;
  -r # file or directory is readable by this (effective) user or group;
  -w #  file or directory is writable by this (effective) user or group;
  -x # file or directory is executable by this (effective) user or group;
  -o # file or directory is owned by this (effective) user;
  -R # file or directory is readable by this real user or group;
  -W # file or directory is writable by this real user or group;
  -X # file or directory is executable by this real user or group;
  -O # file or directory is owned by this real user;
  -z # file exists and has zero size (always false for directories);
  -s # file or directory exists and has nonzero size (the value is the size in bytes);
  -f # entry is a plain file;
  -d # entry is a directory;
  -l # entry is a symbolic link;
  -S # entry is a socket;
  -p # entry is a named pipe (a "fifo");
  -b # entry is a block-special file (like a mountable disk);
  -c # entry is a character-special file (like an I/O device);
  -u # file or directory is setuid;
  -g # file or directory is setgid
  -k # file or directory has the sticky; bit set;
  -t # the filehandle is a TTY (as reported by the isatty() system function; filenames can't be tested by this test);
  -T # file looks like a "text" file;
  -B # file looks like a "binary" file;
  -M # modification age (measured in days);
  -A # access age (measured in days);
  -C # inode-modification age (measured in days);

If you omit the filename or filehandle parameter to a file test (that
is, if you have just C<-r> or just C<-s>, say), the default operand is the
file named in C<$_>. By default, it tests C<STDIN>. So, to test a list of
filenames to see which ones are readable, you simply type:

 foreach (@lots_of_filenames) {
    print "$_ is readable\n" if -r;
 }


=cut
