/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockHorizontal;
import net.sourceforge.plantuml.graphic.TextBlockMarged;
import net.sourceforge.plantuml.graphic.TextBlockMinWidth;
import net.sourceforge.plantuml.graphic.TextBlockSimple;
import net.sourceforge.plantuml.graphic.TextBlockSpotted;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableImpl;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TextBlockUtils {
    private static final Graphics2D gg;
    private static final StringBounder dummyStringBounder;

    public static TextBlock create(Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple) {
        if (display == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        return TextBlockUtils.create(display, fontConfiguration, horizontalAlignment, iSkinSimple, 0.0);
    }

    public static TextBlock create(Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple, double d) {
        if (display.size() > 0) {
            if (display.get(0) instanceof Stereotype) {
                return TextBlockUtils.createStereotype(display, fontConfiguration, horizontalAlignment, iSkinSimple, 0);
            }
            if (display.get(display.size() - 1) instanceof Stereotype) {
                return TextBlockUtils.createStereotype(display, fontConfiguration, horizontalAlignment, iSkinSimple, display.size() - 1);
            }
            if (display.get(0) instanceof MessageNumber) {
                return TextBlockUtils.createMessageNumber(display, fontConfiguration, horizontalAlignment, iSkinSimple, d);
            }
        }
        return TextBlockUtils.getCreole(display, fontConfiguration, horizontalAlignment, iSkinSimple, d);
    }

    private static TextBlock getCreole(Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple, double d) {
        Sheet sheet = new CreoleParser(fontConfiguration, horizontalAlignment, iSkinSimple).createSheet(display);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, d);
        return new SheetBlock2(sheetBlock1, sheetBlock1, new UStroke(1.5));
    }

    private static TextBlock createMessageNumber(Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple iSkinSimple, double d) {
        MessageNumber messageNumber = (MessageNumber)display.get(0);
        TextBlock textBlock = TextBlockUtils.getCreole(display.subList(0, 1), fontConfiguration, horizontalAlignment, iSkinSimple, d);
        textBlock = TextBlockUtils.withMargin(textBlock, 0.0, 4.0, 0.0, 0.0);
        TextBlock textBlock2 = TextBlockUtils.getCreole(display.subList(1, display.size()), fontConfiguration, horizontalAlignment, iSkinSimple, d);
        return TextBlockUtils.mergeLR(textBlock, textBlock2, VerticalAlignment.CENTER);
    }

    private static TextBlock createStereotype(Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer, int n) {
        Stereotype stereotype = (Stereotype)display.get(n);
        if (stereotype.isSpotted()) {
            CircledCharacter circledCharacter = new CircledCharacter(stereotype.getCharacter(), stereotype.getRadius(), stereotype.getCircledFont(), stereotype.getHtmlColor(), null, fontConfiguration.getColor());
            if (stereotype.getLabel() == null) {
                return new TextBlockSpotted(circledCharacter, display.subList(1, display.size()), fontConfiguration, horizontalAlignment, spriteContainer);
            }
            return new TextBlockSpotted(circledCharacter, display, fontConfiguration, horizontalAlignment, spriteContainer);
        }
        return new TextBlockSimple(display, fontConfiguration, horizontalAlignment, spriteContainer, 0.0);
    }

    public static TextBlock withMargin(TextBlock textBlock, double d, double d2) {
        return new TextBlockMarged(textBlock, d, d, d2, d2);
    }

    public static TextBlock withMinWidth(TextBlock textBlock, double d, HorizontalAlignment horizontalAlignment) {
        return new TextBlockMinWidth(textBlock, d, horizontalAlignment);
    }

    public static TextBlock withMargin(TextBlock textBlock, double d, double d2, double d3, double d4) {
        return new TextBlockMarged(textBlock, d, d2, d3, d4);
    }

    public static TextBlock empty(final double d, final double d2) {
        return new TextBlock(){

            public void drawU(UGraphic uGraphic) {
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }
        };
    }

    public static Positionable asPositionable(TextBlock textBlock, StringBounder stringBounder, Point2D point2D) {
        return new PositionableImpl(point2D, textBlock.calculateDimension(stringBounder));
    }

    public static TextBlock mergeLR(TextBlock textBlock, TextBlock textBlock2, VerticalAlignment verticalAlignment) {
        return new TextBlockHorizontal(textBlock, textBlock2, verticalAlignment);
    }

    public static TextBlock mergeTB(TextBlock textBlock, TextBlock textBlock2, HorizontalAlignment horizontalAlignment) {
        return new TextBlockVertical2(textBlock, textBlock2, horizontalAlignment);
    }

    public static MinMax getMinMax(TextBlock textBlock, StringBounder stringBounder) {
        LimitFinder limitFinder = new LimitFinder(stringBounder, false);
        textBlock.drawU(limitFinder);
        return limitFinder.getMinMax();
    }

    public static StringBounder getDummyStringBounder() {
        return dummyStringBounder;
    }

    public static FontRenderContext getFontRenderContext() {
        return gg.getFontRenderContext();
    }

    public static UGraphic getPrinted(TextBlock textBlock, FileFormatOption fileFormatOption, ColorMapper colorMapper, double d, HtmlColor htmlColor, double d2) {
        MinMax minMax = TextBlockUtils.getMinMax(textBlock, dummyStringBounder);
        UGraphic uGraphic = fileFormatOption.createUGraphic(colorMapper, d, Dimension2DDouble.delta(minMax.getDimension(), 2.0 * d2), htmlColor, false);
        double d3 = -minMax.getMinX() + d2;
        double d4 = -minMax.getMinY() + d2;
        textBlock.drawU(uGraphic.apply(new UTranslate(d3, d4)));
        return uGraphic;
    }

    public static MinMax getMinMax(TextBlock textBlock) {
        return TextBlockUtils.getMinMax(textBlock, dummyStringBounder);
    }

    public static Dimension2D getDimension(TextBlock textBlock) {
        return textBlock.calculateDimension(dummyStringBounder);
    }

    public static LineMetrics getLineMetrics(UFont uFont, String string) {
        return uFont.getLineMetrics(gg, string);
    }

    public static FontMetrics getFontMetrics(Font font) {
        return gg.getFontMetrics(font);
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        gg = bufferedImage.createGraphics();
        dummyStringBounder = StringBounderUtils.asStringBounder(gg);
    }
}

