######################################################################
#
# 1138_utf8_by_jipse.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x00"],
        ["\x01",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x01"],
        ["\x02",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x02"],
        ["\x03",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x03"],
        ["\x37",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x04"],
        ["\x2D",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x05"],
        ["\x2E",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x06"],
        ["\x2F",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x07"],
        ["\x16",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x08"],
        ["\x05",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x09"],
        ["\x15",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x0A"],
        ["\x0B",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x0B"],
        ["\x0C",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x0C"],
        ["\x0D",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x0D"],
        ["\x0E",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x0E"],
        ["\x0F",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x0F"],
        ["\x10",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x10"],
        ["\x11",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x11"],
        ["\x12",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x12"],
        ["\x13",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x13"],
        ["\x3C",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x14"],
        ["\x3D",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x15"],
        ["\x32",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x16"],
        ["\x26",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x17"],
        ["\x18",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x18"],
        ["\x19",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x19"],
        ["\x3F",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x1A"],
        ["\x27",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x1B"],
        ["\x1C",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x1C"],
        ["\x1D",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x1D"],
        ["\x1E",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x1E"],
        ["\x1F",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x1F"],
        ["\x40",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x20"],
        ["\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x21"],
        ["\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x22"],
        ["\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x23"],
        ["\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x24"],
        ["\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x25"],
        ["\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x26"],
        ["\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x27"],
        ["\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x28"],
        ["\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x29"],
        ["\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x2A"],
        ["\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x2B"],
        ["\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x2C"],
        ["\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x2D"],
        ["\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x2E"],
        ["\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x2F"],
        ["\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x30"],
        ["\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x31"],
        ["\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x32"],
        ["\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x33"],
        ["\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x34"],
        ["\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x35"],
        ["\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x36"],
        ["\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x37"],
        ["\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x38"],
        ["\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x39"],
        ["\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x3A"],
        ["\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x3B"],
        ["\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x3C"],
        ["\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x3D"],
        ["\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x3E"],
        ["\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x3F"],
        ["\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x40"],
        ["\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x41"],
        ["\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x42"],
        ["\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x43"],
        ["\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x44"],
        ["\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x45"],
        ["\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x46"],
        ["\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x47"],
        ["\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x48"],
        ["\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x49"],
        ["\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x4A"],
        ["\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x4B"],
        ["\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x4C"],
        ["\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x4D"],
        ["\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x4E"],
        ["\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x4F"],
        ["\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x50"],
        ["\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x51"],
        ["\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x52"],
        ["\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x53"],
        ["\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x54"],
        ["\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x55"],
        ["\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x56"],
        ["\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x57"],
        ["\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x58"],
        ["\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x59"],
        ["\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x5A"],
        ["\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x5B"],
        ["\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x5C"],
        ["\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x5D"],
        ["\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x5E"],
        ["\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x5F"],
        ["\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x60"],
        ["\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x61"],
        ["\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x62"],
        ["\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x63"],
        ["\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x64"],
        ["\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x65"],
        ["\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x66"],
        ["\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x67"],
        ["\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x68"],
        ["\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x69"],
        ["\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x6A"],
        ["\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x6B"],
        ["\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x6C"],
        ["\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x6D"],
        ["\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x6E"],
        ["\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x6F"],
        ["\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x70"],
        ["\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x71"],
        ["\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x72"],
        ["\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x73"],
        ["\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x74"],
        ["\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x75"],
        ["\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x76"],
        ["\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x77"],
        ["\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x78"],
        ["\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x79"],
        ["\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x7A"],
        ["\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x7B"],
        ["\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x7C"],
        ["\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x7D"],
        ["\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x7E"],
        ["\x07",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\x7F"],
        ["\x20",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x21",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x22",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x23",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x24",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x25",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x06",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x17",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x28",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x29",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x2A",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x2B",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x2C",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x09",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x0A",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x1B",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x30",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x31",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x1A",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x33",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x34",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x35",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x36",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x08",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x38",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x39",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x3A",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x3B",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x04",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x14",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x3E",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xE1",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xB1",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA1"],
        ["\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA2"],
        ["\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA3"],
        ["\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA4"],
        ["\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA5"],
        ["\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA6"],
        ["\x47",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA7"],
        ["\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA8"],
        ["\x49",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xA9"],
        ["\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAA"],
        ["\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAB"],
        ["\x53",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAC"],
        ["\x54",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAD"],
        ["\x55",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAE"],
        ["\x56",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xAF"],
        ["\x58",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB0"],
        ["\x81",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB1"],
        ["\x82",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB2"],
        ["\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB3"],
        ["\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB4"],
        ["\x85",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB5"],
        ["\x86",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB6"],
        ["\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB7"],
        ["\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB8"],
        ["\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xB9"],
        ["\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBA"],
        ["\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBB"],
        ["\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBC"],
        ["\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBD"],
        ["\x8F",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBE"],
        ["\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBD\xBF"],
        ["\x91",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x80"],
        ["\x92",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x81"],
        ["\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x82"],
        ["\x94",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x83"],
        ["\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x84"],
        ["\x96",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x85"],
        ["\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x86"],
        ["\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x87"],
        ["\x99",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x88"],
        ["\x9A",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x89"],
        ["\x9D",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8A"],
        ["\x9E",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8B"],
        ["\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8C"],
        ["\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8D"],
        ["\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8E"],
        ["\xA4",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x8F"],
        ["\xA5",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x90"],
        ["\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x91"],
        ["\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x92"],
        ["\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x93"],
        ["\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x94"],
        ["\xAA",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x95"],
        ["\xAC",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x96"],
        ["\xAD",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x97"],
        ["\xAE",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x98"],
        ["\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x99"],
        ["\xBA",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9A"],
        ["\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9B"],
        ["\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9C"],
        ["\xBD",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9D"],
        ["\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9E"],
        ["\xBF",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xEF\xBE\x9F"],
        ["\xB2",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xB3",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xB4",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xB6",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xB8",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xCF",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xEB",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xEC",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xFC",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xFD",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\xFF",'utf8','jipse',{'INPUT_LAYOUT'=>'S'},"\xE3\x80\x93"],
        ["\x4F\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x80"],
        ["\x4F\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x81"],
        ["\x4F\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x82"],
        ["\x4F\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8C"],
        ["\x4F\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8E"],
        ["\x4F\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBB"],
        ["\x4F\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9A"],
        ["\x4F\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9B"],
        ["\x4F\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9F"],
        ["\x4F\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x81"],
        ["\x4F\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9B"],
        ["\x4F\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9C"],
        ["\x4F\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\x4F\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x80"],
        ["\x4F\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\x4F\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBE"],
        ["\x4F\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA3"],
        ["\x4F\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBF"],
        ["\x4F\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBD"],
        ["\x4F\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBE"],
        ["\x4F\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9D"],
        ["\x4F\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9E"],
        ["\x4F\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x83"],
        ["\x4F\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9D"],
        ["\x4F\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x85"],
        ["\x4F\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x86"],
        ["\x4F\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x87"],
        ["\x4F\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBC"],
        ["\x4F\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x95"],
        ["\x4F\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x90"],
        ["\x4F\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8F"],
        ["\x4F\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBC"],
        ["\x4F\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9C"],
        ["\x4F\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA5"],
        ["\x4F\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9C"],
        ["\x4F\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA6"],
        ["\x4F\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA5"],
        ["\x4F\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x98"],
        ["\x4F\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x99"],
        ["\x4F\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x9C"],
        ["\x4F\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x9D"],
        ["\x4F\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x88"],
        ["\x4F\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x89"],
        ["\x4F\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x94"],
        ["\x4F\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x95"],
        ["\x4F\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBB"],
        ["\x4F\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBD"],
        ["\x4F\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9B"],
        ["\x4F\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9D"],
        ["\x4F\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x88"],
        ["\x4F\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x89"],
        ["\x4F\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8A"],
        ["\x4F\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8B"],
        ["\x4F\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8C"],
        ["\x4F\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8D"],
        ["\x4F\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8E"],
        ["\x4F\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8F"],
        ["\x4F\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x90"],
        ["\x4F\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x91"],
        ["\x4F\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8B"],
        ["\x4F\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8D"],
        ["\x4F\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],
        ["\x4F\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x97"],
        ["\x4F\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\x4F\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9D"],
        ["\x4F\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA0"],
        ["\x4F\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9C"],
        ["\x4F\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9E"],
        ["\x4F\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA6"],
        ["\x4F\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA7"],
        ["\x4F\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9E"],
        ["\x4F\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xB4"],
        ["\x4F\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\x82"],
        ["\x4F\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\x80"],
        ["\x4F\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\x4F\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB2"],
        ["\x4F\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB3"],
        ["\x4F\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x83"],
        ["\x4F\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA5"],
        ["\x4F\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x84"],
        ["\x4F\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA0"],
        ["\x4F\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA1"],
        ["\x4F\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x85"],
        ["\x4F\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x83"],
        ["\x4F\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x86"],
        ["\x4F\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8A"],
        ["\x4F\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA0"],
        ["\x4F\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],
        ["\x4F\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x86"],
        ["\x4F\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x85"],
        ["\x4F\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8B"],
        ["\x4F\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8F"],
        ["\x4F\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8E"],
        ["\x4F\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x87"],
        ["\x7F\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x86"],
        ["\x7F\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xA1"],
        ["\x7F\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xA0"],
        ["\x7F\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB3"],
        ["\x7F\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB2"],
        ["\x7F\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xBD"],
        ["\x7F\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xBC"],
        ["\x7F\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xBB"],
        ["\x7F\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x92"],
        ["\x7F\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x92"],
        ["\x7F\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x90"],
        ["\x7F\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x91"],
        ["\x7F\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x93"],
        ["\x7F\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\x45\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x88"],
        ["\x45\xAA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x8B"],
        ["\x46\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x86"],
        ["\x46\xEB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x87"],
        ["\x45\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x82"],
        ["\x45\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x83"],
        ["\x60\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAA"],
        ["\x60\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA9"],
        ["\x45\xA5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA7"],
        ["\x45\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA8"],
        ["\x46\xEC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x92"],
        ["\x46\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x94"],
        ["\x45\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x80"],
        ["\x45\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x83"],
        ["\x60\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA0"],
        ["\x60\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\xA5"],
        ["\x46\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C\x92"],
        ["\x45\x9D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x82"],
        ["\x46\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x87"],
        ["\x60\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA1"],
        ["\x60\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x92"],
        ["\x45\xB3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xAA"],
        ["\x45\xB4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xAB"],
        ["\x60\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9A"],
        ["\x45\xBD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xBD"],
        ["\x45\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9D"],
        ["\x60\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xB5"],
        ["\x60\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAB"],
        ["\x46\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAC"],
        ["\x44\xBF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xAB"],
        ["\x44\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB0"],
        ["\x46\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAF"],
        ["\x46\xFC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAD"],
        ["\x46\xFD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAA"],
        ["\x45\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA0"],
        ["\x45\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA1"],
        ["\x45\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\x46\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\xAF"],
        ["\x7B\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x90"],
        ["\x7B\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x91"],
        ["\x7B\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x92"],
        ["\x7B\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x93"],
        ["\x7B\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x94"],
        ["\x7B\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x95"],
        ["\x7B\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x96"],
        ["\x7B\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x97"],
        ["\x7B\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x98"],
        ["\x7B\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x99"],
        ["\x7B\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA1"],
        ["\x7B\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA2"],
        ["\x7B\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA3"],
        ["\x7B\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA4"],
        ["\x7B\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA5"],
        ["\x7B\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA6"],
        ["\x7B\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA7"],
        ["\x7B\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA8"],
        ["\x7B\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA9"],
        ["\x7B\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAA"],
        ["\x7B\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAB"],
        ["\x7B\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAC"],
        ["\x7B\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAD"],
        ["\x7B\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAE"],
        ["\x7B\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAF"],
        ["\x7B\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB0"],
        ["\x7B\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB1"],
        ["\x7B\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB2"],
        ["\x7B\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB3"],
        ["\x7B\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB4"],
        ["\x7B\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB5"],
        ["\x7B\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB6"],
        ["\x7B\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB7"],
        ["\x7B\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB8"],
        ["\x7B\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB9"],
        ["\x7B\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBA"],
        ["\x7B\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x81"],
        ["\x7B\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x82"],
        ["\x7B\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x83"],
        ["\x7B\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x84"],
        ["\x7B\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x85"],
        ["\x7B\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x86"],
        ["\x7B\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x87"],
        ["\x7B\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x88"],
        ["\x7B\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x89"],
        ["\x7B\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8A"],
        ["\x7B\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8B"],
        ["\x7B\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8C"],
        ["\x7B\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8D"],
        ["\x7B\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8E"],
        ["\x7B\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8F"],
        ["\x7B\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x90"],
        ["\x7B\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x91"],
        ["\x7B\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x92"],
        ["\x7B\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x93"],
        ["\x7B\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x94"],
        ["\x7B\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x95"],
        ["\x7B\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x96"],
        ["\x7B\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x97"],
        ["\x7B\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x98"],
        ["\x7B\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x99"],
        ["\x7B\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9A"],
        ["\xE0\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x81"],
        ["\xE0\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x82"],
        ["\xE0\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x83"],
        ["\xE0\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x84"],
        ["\xE0\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x85"],
        ["\xE0\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x86"],
        ["\xE0\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x87"],
        ["\xE0\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x88"],
        ["\xE0\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x89"],
        ["\xE0\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8A"],
        ["\xE0\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8B"],
        ["\xE0\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8C"],
        ["\xE0\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8D"],
        ["\xE0\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8E"],
        ["\xE0\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8F"],
        ["\xE0\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x90"],
        ["\xE0\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x91"],
        ["\xE0\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x92"],
        ["\xE0\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x93"],
        ["\xE0\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x94"],
        ["\xE0\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x95"],
        ["\xE0\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x96"],
        ["\xE0\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x97"],
        ["\xE0\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x98"],
        ["\xE0\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x99"],
        ["\xE0\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9A"],
        ["\xE0\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9B"],
        ["\xE0\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9C"],
        ["\xE0\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9D"],
        ["\xE0\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9E"],
        ["\xE0\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9F"],
        ["\xE0\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA0"],
        ["\xE0\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA1"],
        ["\xE0\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA2"],
        ["\xE0\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA3"],
        ["\xE0\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA4"],
        ["\xE0\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA5"],
        ["\xE0\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA6"],
        ["\xE0\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA7"],
        ["\xE0\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA8"],
        ["\xE0\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA9"],
        ["\xE0\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAA"],
        ["\xE0\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAB"],
        ["\xE0\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAC"],
        ["\xE0\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAD"],
        ["\xE0\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAE"],
        ["\xE0\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAF"],
        ["\xE0\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB0"],
        ["\xE0\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB1"],
        ["\xE0\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB2"],
        ["\xE0\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB3"],
        ["\xE0\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB4"],
        ["\xE0\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB5"],
        ["\xE0\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB6"],
        ["\xE0\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB7"],
        ["\xE0\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB8"],
        ["\xE0\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB9"],
        ["\xE0\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBA"],
        ["\xE0\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBB"],
        ["\xE0\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBC"],
        ["\xE0\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBD"],
        ["\xE0\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBE"],
        ["\xE0\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBF"],
        ["\xE0\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x80"],
        ["\xE0\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x81"],
        ["\xE0\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x82"],
        ["\xE0\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x83"],
        ["\xE0\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x84"],
        ["\xE0\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x85"],
        ["\xE0\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x86"],
        ["\xE0\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x87"],
        ["\xE0\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x88"],
        ["\xE0\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x89"],
        ["\xE0\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8A"],
        ["\xE0\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8B"],
        ["\xE0\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8C"],
        ["\xE0\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8D"],
        ["\xE0\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8E"],
        ["\xE0\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8F"],
        ["\xE0\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x90"],
        ["\xE0\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x91"],
        ["\xE0\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x92"],
        ["\xE0\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x93"],
        ["\x6C\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA1"],
        ["\x6C\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA2"],
        ["\x6C\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA3"],
        ["\x6C\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA4"],
        ["\x6C\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA5"],
        ["\x6C\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA6"],
        ["\x6C\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA7"],
        ["\x6C\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA8"],
        ["\x6C\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA9"],
        ["\x6C\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAA"],
        ["\x6C\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAB"],
        ["\x6C\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAC"],
        ["\x6C\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAD"],
        ["\x6C\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAE"],
        ["\x6C\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAF"],
        ["\x6C\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB0"],
        ["\x6C\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB1"],
        ["\x6C\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB2"],
        ["\x6C\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB3"],
        ["\x6C\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB4"],
        ["\x6C\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB5"],
        ["\x6C\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB6"],
        ["\x6C\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB7"],
        ["\x6C\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB8"],
        ["\x6C\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB9"],
        ["\x6C\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBA"],
        ["\x6C\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBB"],
        ["\x6C\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBC"],
        ["\x6C\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBD"],
        ["\x6C\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBE"],
        ["\x6C\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBF"],
        ["\x6C\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x80"],
        ["\x6C\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x81"],
        ["\x6C\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x82"],
        ["\x6C\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x83"],
        ["\x6C\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x84"],
        ["\x6C\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x85"],
        ["\x6C\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x86"],
        ["\x6C\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x87"],
        ["\x6C\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x88"],
        ["\x6C\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x89"],
        ["\x6C\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8A"],
        ["\x6C\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8B"],
        ["\x6C\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8C"],
        ["\x6C\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8D"],
        ["\x6C\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8E"],
        ["\x6C\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8F"],
        ["\x6C\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x90"],
        ["\x6C\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x91"],
        ["\x6C\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x92"],
        ["\x6C\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x93"],
        ["\x6C\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x94"],
        ["\x6C\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x95"],
        ["\x6C\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x96"],
        ["\x6C\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x97"],
        ["\x6C\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x98"],
        ["\x6C\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x99"],
        ["\x6C\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9A"],
        ["\x6C\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9B"],
        ["\x6C\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9C"],
        ["\x6C\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9D"],
        ["\x6C\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9E"],
        ["\x6C\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9F"],
        ["\x6C\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA0"],
        ["\x6C\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA1"],
        ["\x6C\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA2"],
        ["\x6C\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA3"],
        ["\x6C\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA4"],
        ["\x6C\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA5"],
        ["\x6C\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA6"],
        ["\x6C\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA7"],
        ["\x6C\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA8"],
        ["\x6C\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA9"],
        ["\x6C\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAA"],
        ["\x6C\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAB"],
        ["\x6C\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAC"],
        ["\x6C\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAD"],
        ["\x6C\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAE"],
        ["\x6C\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAF"],
        ["\x6C\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB0"],
        ["\x6C\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB1"],
        ["\x6C\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB2"],
        ["\x6C\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB3"],
        ["\x6C\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB4"],
        ["\x6C\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB5"],
        ["\x6C\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB6"],
        ["\x50\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x91"],
        ["\x50\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x92"],
        ["\x50\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x93"],
        ["\x50\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x94"],
        ["\x50\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x95"],
        ["\x50\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x96"],
        ["\x50\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x97"],
        ["\x50\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x98"],
        ["\x50\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x99"],
        ["\x50\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x9A"],
        ["\x50\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x9B"],
        ["\x50\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x9C"],
        ["\x50\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x9D"],
        ["\x50\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x9E"],
        ["\x50\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\x9F"],
        ["\x50\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA0"],
        ["\x50\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],
        ["\x50\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],
        ["\x50\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],
        ["\x50\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],
        ["\x50\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\x50\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],
        ["\x50\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],
        ["\x50\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],
        ["\x50\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],
        ["\x50\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],
        ["\x50\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],
        ["\x50\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],
        ["\x50\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],
        ["\x50\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],
        ["\x50\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],
        ["\x50\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],
        ["\x50\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],
        ["\x50\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],
        ["\x50\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],
        ["\x50\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],
        ["\x50\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],
        ["\x50\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],
        ["\x50\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],
        ["\x50\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x80"],
        ["\x50\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x81"],
        ["\x50\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x83"],
        ["\x50\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x84"],
        ["\x50\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x85"],
        ["\x50\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x86"],
        ["\x50\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x87"],
        ["\x50\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x88"],
        ["\x50\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xCF\x89"],
        ["\x7D\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x90"],
        ["\x7D\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x91"],
        ["\x7D\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x92"],
        ["\x7D\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x93"],
        ["\x7D\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x94"],
        ["\x7D\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x95"],
        ["\x7D\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x81"],
        ["\x7D\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x96"],
        ["\x7D\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x97"],
        ["\x7D\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x98"],
        ["\x7D\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x99"],
        ["\x7D\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x9A"],
        ["\x7D\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x9B"],
        ["\x7D\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x9C"],
        ["\x7D\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x9D"],
        ["\x7D\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x9E"],
        ["\x7D\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\x9F"],
        ["\x7D\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA0"],
        ["\x7D\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],
        ["\x7D\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],
        ["\x7D\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],
        ["\x7D\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],
        ["\x7D\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],
        ["\x7D\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],
        ["\x7D\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],
        ["\x7D\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],
        ["\x7D\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],
        ["\x7D\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],
        ["\x7D\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],
        ["\x7D\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],
        ["\x7D\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],
        ["\x7D\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],
        ["\x7D\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],
        ["\x7D\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],
        ["\x7D\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],
        ["\x7D\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],
        ["\x7D\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],
        ["\x7D\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],
        ["\x7D\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],
        ["\x7D\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x91"],
        ["\x7D\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],
        ["\x7D\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],
        ["\x7D\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],
        ["\x7D\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],
        ["\x7D\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],
        ["\x7D\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],
        ["\x7D\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],
        ["\x7D\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],
        ["\x7D\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],
        ["\x7D\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],
        ["\x7D\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x80"],
        ["\x7D\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x81"],
        ["\x7D\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x82"],
        ["\x7D\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x83"],
        ["\x7D\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x84"],
        ["\x7D\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x85"],
        ["\x7D\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x86"],
        ["\x7D\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x87"],
        ["\x7D\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x88"],
        ["\x7D\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x89"],
        ["\x7D\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x8A"],
        ["\x7D\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x8B"],
        ["\x7D\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x8C"],
        ["\x7D\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x8D"],
        ["\x7D\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x8E"],
        ["\x7D\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xD1\x8F"],
        ["\x6B\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x80"],
        ["\x6B\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x82"],
        ["\x6B\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x8C"],
        ["\x6B\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x90"],
        ["\x6B\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x98"],
        ["\x6B\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x94"],
        ["\x6B\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9C"],
        ["\x6B\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAC"],
        ["\x6B\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA4"],
        ["\x6B\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB4"],
        ["\x6B\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBC"],
        ["\x6B\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x81"],
        ["\x6B\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x83"],
        ["\x6B\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x8F"],
        ["\x6B\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x93"],
        ["\x6B\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9B"],
        ["\x6B\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x97"],
        ["\x6B\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA3"],
        ["\x6B\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB3"],
        ["\x6B\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAB"],
        ["\x6B\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBB"],
        ["\x6B\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x95\x8B"],
        ["\x6B\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA0"],
        ["\x6B\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAF"],
        ["\x6B\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA8"],
        ["\x6B\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB7"],
        ["\x6B\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBF"],
        ["\x6B\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9D"],
        ["\x6B\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB0"],
        ["\x6B\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA5"],
        ["\x6B\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB8"],
        ["\x6B\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x95\x82"],
        ["\x60\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA0"],
        ["\x60\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA1"],
        ["\x60\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA2"],
        ["\x60\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA3"],
        ["\x60\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA4"],
        ["\x60\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA5"],
        ["\x60\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA6"],
        ["\x60\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA7"],
        ["\x60\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA8"],
        ["\x60\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA9"],
        ["\x60\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAA"],
        ["\x60\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAB"],
        ["\x60\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAC"],
        ["\x60\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAD"],
        ["\x60\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAE"],
        ["\x60\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAF"],
        ["\x60\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB0"],
        ["\x60\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB1"],
        ["\x60\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB2"],
        ["\x60\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB3"],
        ["\x60\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA0"],
        ["\x60\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA1"],
        ["\x60\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA2"],
        ["\x60\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA3"],
        ["\x60\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA4"],
        ["\x60\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA5"],
        ["\x60\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA6"],
        ["\x60\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA7"],
        ["\x60\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA8"],
        ["\x60\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA9"],
        ["\x60\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x89"],
        ["\x60\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x94"],
        ["\x60\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA2"],
        ["\x60\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x8D"],
        ["\x60\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x98"],
        ["\x60\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA7"],
        ["\x60\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x83"],
        ["\x60\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xB6"],
        ["\x60\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x91"],
        ["\x60\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x97"],
        ["\x60\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x8D"],
        ["\x60\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA6"],
        ["\x60\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA3"],
        ["\x60\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xAB"],
        ["\x60\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x8A"],
        ["\x60\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xBB"],
        ["\x60\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9C"],
        ["\x60\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9D"],
        ["\x60\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9E"],
        ["\x60\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x8E"],
        ["\x60\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x8F"],
        ["\x60\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x84"],
        ["\x60\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\xA1"],
        ["\x60\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBB"],
        ["\x60\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9D"],
        ["\x60\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9F"],
        ["\x60\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x96"],
        ["\x60\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x8D"],
        ["\x60\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xA1"],
        ["\x60\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA4"],
        ["\x60\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA5"],
        ["\x60\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA6"],
        ["\x60\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA7"],
        ["\x60\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA8"],
        ["\x60\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB1"],
        ["\x60\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB2"],
        ["\x60\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB9"],
        ["\x60\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBE"],
        ["\x60\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBD"],
        ["\x60\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBC"],
        ["\x60\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAE"],
        ["\x60\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x91"],
        ["\x60\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9F"],
        ["\x60\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\xBF"],
        ["\xF0\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9C"],
        ["\xF0\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x96"],
        ["\xF0\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x83"],
        ["\xF0\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBF"],
        ["\xF0\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x80"],
        ["\xF0\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9B"],
        ["\xF0\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xA8"],
        ["\xF0\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xB6"],
        ["\xF0\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA2"],
        ["\xF0\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB5"],
        ["\xF0\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x9C"],
        ["\xF0\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x90"],
        ["\xF0\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xAA"],
        ["\xF0\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA1"],
        ["\xF0\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA5"],
        ["\xF0\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xAD"],
        ["\xF0\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA6"],
        ["\xF0\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA6"],
        ["\x77\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB5"],
        ["\xF0\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x93"],
        ["\xF0\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA7"],
        ["\xF0\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA1"],
        ["\xF0\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB1"],
        ["\xF0\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9B"],
        ["\xF0\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x90"],
        ["\xF0\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xBB"],
        ["\xF0\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xB4"],
        ["\xF0\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA2"],
        ["\xF0\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBE"],
        ["\xF0\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x8E"],
        ["\xF0\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x96"],
        ["\xF0\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x9F"],
        ["\xF0\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB7"],
        ["\xF0\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x89"],
        ["\xF0\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB5"],
        ["\xF0\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x89"],
        ["\xF0\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x97"],
        ["\xF0\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x88"],
        ["\xF0\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x87"],
        ["\xF0\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8D"],
        ["\xF0\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8F"],
        ["\xF0\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA5"],
        ["\xF0\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8A"],
        ["\xF0\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8D"],
        ["\xF0\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9D"],
        ["\xF0\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x89"],
        ["\xF0\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB2"],
        ["\xF0\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB7"],
        ["\xF0\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x94"],
        ["\xF0\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x81"],
        ["\xF0\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x89"],
        ["\xF0\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9F"],
        ["\xF0\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8F"],
        ["\xF0\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB0"],
        ["\xF0\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x93"],
        ["\xF0\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x85"],
        ["\xF0\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xBA"],
        ["\xF0\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8F"],
        ["\xF0\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB0"],
        ["\xF0\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xBB"],
        ["\xF0\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAD"],
        ["\xF0\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xAF"],
        ["\xF0\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x83"],
        ["\xF0\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8E"],
        ["\xF0\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA3"],
        ["\xF0\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x82"],
        ["\xF0\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x95"],
        ["\xF0\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBA"],
        ["\xF0\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBB"],
        ["\xF0\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x95"],
        ["\xF0\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA5"],
        ["\xF0\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9F"],
        ["\xF0\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB2"],
        ["\xF0\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x81"],
        ["\xF0\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xAF"],
        ["\xF0\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x80"],
        ["\xF0\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB1"],
        ["\xF0\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA2"],
        ["\xF0\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB8"],
        ["\xF0\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB2"],
        ["\xF0\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA8"],
        ["\xF0\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8B"],
        ["\xF0\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAF"],
        ["\xF0\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x81"],
        ["\xF0\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB0"],
        ["\xF0\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBD"],
        ["\xF0\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA1"],
        ["\xF0\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA0"],
        ["\xF0\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xBB"],
        ["\xF0\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x95"],
        ["\xF0\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xB2"],
        ["\xF0\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAB"],
        ["\xF0\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA4"],
        ["\xF0\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAD"],
        ["\xF1\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA2"],
        ["\xF1\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB0"],
        ["\xF1\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA0"],
        ["\xF1\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xBB"],
        ["\xF1\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8B"],
        ["\xF1\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB3"],
        ["\xF1\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x87"],
        ["\xF1\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8F"],
        ["\xF1\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xBD"],
        ["\xF1\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x82"],
        ["\xF1\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA8"],
        ["\xF1\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAF"],
        ["\xF1\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9C"],
        ["\xF1\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBA"],
        ["\xF1\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x91"],
        ["\xF1\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x93"],
        ["\xF1\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBC"],
        ["\xF1\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA6"],
        ["\xF1\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x98"],
        ["\xF1\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x84"],
        ["\xF1\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9D"],
        ["\xF1\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9A"],
        ["\xF1\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBB"],
        ["\xF1\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA5"],
        ["\xF1\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA9"],
        ["\xF1\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA6"],
        ["\xF1\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x9C"],
        ["\xF1\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8F"],
        ["\xF1\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x82"],
        ["\xF1\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x91"],
        ["\xF1\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8B"],
        ["\xF1\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB2"],
        ["\xF1\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x8F"],
        ["\xF1\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x8C"],
        ["\xF1\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA1"],
        ["\xF1\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xB6"],
        ["\xF1\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB0"],
        ["\xF1\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB1"],
        ["\xF1\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA0"],
        ["\xF1\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB3"],
        ["\xF1\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x84"],
        ["\xF1\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB8"],
        ["\xF1\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB3"],
        ["\xF1\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA9"],
        ["\xF1\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9B"],
        ["\xF1\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x88"],
        ["\xF1\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8E"],
        ["\xF1\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB4"],
        ["\xF1\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB1"],
        ["\xF1\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9B"],
        ["\xF1\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA0"],
        ["\xF1\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xAD"],
        ["\xF1\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB2"],
        ["\xF1\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xAB"],
        ["\xF1\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8A"],
        ["\xF1\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x85"],
        ["\xF1\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA6"],
        ["\xF1\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x81"],
        ["\xF1\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x8A"],
        ["\xF1\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xB2"],
        ["\xF1\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x8E"],
        ["\xF1\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xAD"],
        ["\xF1\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x86"],
        ["\xF1\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x92"],
        ["\xF1\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB0"],
        ["\xF1\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x84"],
        ["\xF1\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB4"],
        ["\xF1\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB6"],
        ["\xF1\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA8"],
        ["\xF1\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA9"],
        ["\xF1\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB4"],
        ["\xF1\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBF"],
        ["\xF1\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x94"],
        ["\xF1\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x8E"],
        ["\xF1\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x94"],
        ["\xF1\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x99"],
        ["\xF1\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x95"],
        ["\xF1\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBF"],
        ["\xF1\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x81"],
        ["\xF1\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB6"],
        ["\xF1\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x91"],
        ["\xF1\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x97"],
        ["\xF1\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA0"],
        ["\xF1\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9B"],
        ["\xF1\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9B"],
        ["\xF1\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA9"],
        ["\xF1\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBC"],
        ["\xF1\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9A"],
        ["\xF1\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA5"],
        ["\xF1\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB9"],
        ["\xF1\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAE"],
        ["\xF1\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA5"],
        ["\xF1\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x80"],
        ["\xF1\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9C"],
        ["\xF2\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBC"],
        ["\xF2\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBA"],
        ["\xF2\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAA"],
        ["\xF2\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA7"],
        ["\xF2\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB4"],
        ["\xF2\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x8B"],
        ["\xF2\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x81"],
        ["\xF2\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x96"],
        ["\x77\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAC"],
        ["\xF2\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x8E"],
        ["\xF2\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x84"],
        ["\xF2\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA1"],
        ["\xF2\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x96"],
        ["\xF2\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBB"],
        ["\xF2\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x84"],
        ["\xF2\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8B"],
        ["\xF2\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB6"],
        ["\xF2\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x86"],
        ["\xF2\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB6"],
        ["\xF2\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA1"],
        ["\xF2\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x99"],
        ["\xF2\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBA"],
        ["\xF2\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB8"],
        ["\xF2\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA9"],
        ["\xF2\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA9"],
        ["\xF2\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8F"],
        ["\xF2\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB3"],
        ["\xF2\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8B"],
        ["\xF2\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x96"],
        ["\xF2\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAE"],
        ["\xF2\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x95"],
        ["\xF2\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBD"],
        ["\xF2\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xA1"],
        ["\xF2\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB3"],
        ["\xF2\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA0"],
        ["\xF2\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAF"],
        ["\xF2\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x89"],
        ["\xF2\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8F"],
        ["\xF2\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x81"],
        ["\xF2\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB6"],
        ["\xF2\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA1"],
        ["\xF2\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x91"],
        ["\xF2\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x87"],
        ["\xF2\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9C"],
        ["\xF2\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB6"],
        ["\xF2\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8C"],
        ["\xF2\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB3"],
        ["\xF2\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAB"],
        ["\xF2\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x82"],
        ["\xF2\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8D"],
        ["\xF2\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBE"],
        ["\xF2\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBC"],
        ["\xF2\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x87"],
        ["\xF2\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB1"],
        ["\xF2\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9B"],
        ["\xF2\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x84"],
        ["\xF2\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB7"],
        ["\xF2\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAF"],
        ["\xF2\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x93"],
        ["\xF2\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA6"],
        ["\xF2\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB2"],
        ["\xF2\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xA9"],
        ["\xF2\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA8"],
        ["\xF2\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA6"],
        ["\xF2\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8E"],
        ["\xF2\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x9E"],
        ["\xF2\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8A"],
        ["\xF2\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x84"],
        ["\xF2\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA8"],
        ["\xF2\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x91"],
        ["\xF2\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x99"],
        ["\xF2\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBB"],
        ["\xF2\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA5"],
        ["\xF2\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBD"],
        ["\xF2\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBE"],
        ["\xF2\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x80"],
        ["\xF2\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x85"],
        ["\xF2\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x93"],
        ["\xF2\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x95"],
        ["\xF2\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8B"],
        ["\xF2\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9A"],
        ["\xF2\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA3"],
        ["\xF2\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9E"],
        ["\xF2\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8A"],
        ["\xF2\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8A"],
        ["\xF2\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBB"],
        ["\xF2\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xAB"],
        ["\xF2\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAA"],
        ["\xF2\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x94"],
        ["\xF2\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA2"],
        ["\xF2\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x90"],
        ["\xF2\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x92"],
        ["\xF2\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x90"],
        ["\xF2\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB9"],
        ["\xF3\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x81"],
        ["\xF3\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA6"],
        ["\xF3\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB0"],
        ["\xF3\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB7"],
        ["\xF3\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB0"],
        ["\xF3\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8C"],
        ["\xF3\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x86"],
        ["\xF3\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB5"],
        ["\xF3\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA5"],
        ["\xF3\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB9"],
        ["\xF3\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8B"],
        ["\xF3\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8E"],
        ["\xF3\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x9D"],
        ["\xF3\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB1"],
        ["\xF3\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBE"],
        ["\xF3\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x96"],
        ["\xF3\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB3"],
        ["\xF3\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB3"],
        ["\xF3\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x96"],
        ["\xF3\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA8"],
        ["\xF3\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x82"],
        ["\xF3\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAF"],
        ["\xF3\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8D"],
        ["\xF3\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8B"],
        ["\xF3\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x97"],
        ["\xF3\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB2"],
        ["\xF3\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xA7"],
        ["\xF3\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB8"],
        ["\xF3\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAC"],
        ["\xF3\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xA8"],
        ["\xF3\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x99"],
        ["\xF3\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA3"],
        ["\xF3\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBF"],
        ["\x68\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8E"],
        ["\xF3\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8E"],
        ["\xF3\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x83"],
        ["\xF3\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x87"],
        ["\xF3\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x84"],
        ["\xF3\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x93"],
        ["\xF3\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xA1"],
        ["\xE8\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB9"],
        ["\xF3\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBC"],
        ["\xF3\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB8"],
        ["\xF3\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBB"],
        ["\xF3\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB2"],
        ["\xF3\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBA"],
        ["\xF3\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xAB"],
        ["\xF3\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x9A"],
        ["\xF3\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x92"],
        ["\xF3\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAB"],
        ["\xF3\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x83"],
        ["\xF3\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xAD"],
        ["\xF3\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA3"],
        ["\xF3\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x94"],
        ["\xF3\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA9"],
        ["\xF3\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA6"],
        ["\xF3\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB3"],
        ["\xF3\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBD"],
        ["\xF3\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8D"],
        ["\xF3\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8E"],
        ["\xF3\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x9B"],
        ["\xF3\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA0"],
        ["\xF3\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAB"],
        ["\xF3\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xBF"],
        ["\xF3\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB6"],
        ["\xF3\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8D"],
        ["\xF3\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9F"],
        ["\xF3\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB2"],
        ["\xF3\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9D"],
        ["\xF3\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB0"],
        ["\xF3\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAC"],
        ["\xF3\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBB"],
        ["\xF3\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x87"],
        ["\xF3\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x91"],
        ["\xF3\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9B"],
        ["\xF3\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x90"],
        ["\xF3\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x84"],
        ["\xF3\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x94"],
        ["\xF3\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB9"],
        ["\xF3\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB6"],
        ["\xF3\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9B"],
        ["\xF3\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBA"],
        ["\xF3\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x84"],
        ["\xF3\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAA"],
        ["\xF3\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x9C"],
        ["\x62\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x83"],
        ["\xF3\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB2"],
        ["\xF3\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9C"],
        ["\xF3\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x8C"],
        ["\xF3\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x9B"],
        ["\xF3\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA8"],
        ["\xF3\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA2"],
        ["\xF3\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x85"],
        ["\xF3\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB1"],
        ["\xF4\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA5"],
        ["\xF4\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x88"],
        ["\xF4\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x85"],
        ["\xF4\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA6"],
        ["\xF4\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xBE"],
        ["\xF4\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x83"],
        ["\xF4\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA0"],
        ["\xF4\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x92"],
        ["\xF4\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8A"],
        ["\xF4\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x98"],
        ["\xF4\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA7"],
        ["\xF4\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBB"],
        ["\xF4\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9A"],
        ["\xF4\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xAA"],
        ["\xF4\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA6"],
        ["\xF4\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8C"],
        ["\xF4\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x98"],
        ["\xF4\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9B"],
        ["\xF4\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB2"],
        ["\xF4\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB9"],
        ["\xF4\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA3"],
        ["\xF4\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9F"],
        ["\xF4\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA3"],
        ["\xF4\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBE"],
        ["\xF4\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9B"],
        ["\xF4\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA2"],
        ["\xF4\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x91"],
        ["\xF4\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x93"],
        ["\xF4\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xBA"],
        ["\xF4\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBE"],
        ["\xF4\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x93"],
        ["\xF4\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x97"],
        ["\xF4\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA2"],
        ["\xF4\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x97"],
        ["\x5F\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x85"],
        ["\xF4\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xB0"],
        ["\xF4\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x98"],
        ["\xF4\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA3"],
        ["\xF4\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8B"],
        ["\xF4\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBF"],
        ["\xF4\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xA1"],
        ["\xF4\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA1"],
        ["\xF4\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA9"],
        ["\xF4\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xB6"],
        ["\xF4\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB0"],
        ["\xF4\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9D"],
        ["\xF4\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA6"],
        ["\xF4\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9E"],
        ["\xF4\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB3"],
        ["\x70\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8C"],
        ["\xF4\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAB"],
        ["\xF4\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x84"],
        ["\xF4\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x91"],
        ["\xF4\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x93"],
        ["\xF4\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x91"],
        ["\xF4\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA2"],
        ["\xF4\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA5"],
        ["\xF4\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x93"],
        ["\xF4\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA8"],
        ["\xF4\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x98"],
        ["\xF4\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB8"],
        ["\xF4\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAB"],
        ["\xF4\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB8"],
        ["\xF4\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8C"],
        ["\xF4\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA9"],
        ["\xF4\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x8C"],
        ["\xF4\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xBC"],
        ["\xF4\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA9"],
        ["\xF4\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAB"],
        ["\xF4\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8B"],
        ["\xF4\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x81"],
        ["\xF4\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x91"],
        ["\xF4\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x94"],
        ["\xF4\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x98"],
        ["\xF4\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x81"],
        ["\xF4\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8E"],
        ["\xF4\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB1"],
        ["\xF4\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9C"],
        ["\xF4\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA8"],
        ["\xF4\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBA"],
        ["\xF4\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x87"],
        ["\xF4\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x89"],
        ["\xF4\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x84"],
        ["\xF4\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x90"],
        ["\xF4\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x8C"],
        ["\xF4\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBE"],
        ["\xF4\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8C"],
        ["\xF4\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xAE"],
        ["\xF4\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBA"],
        ["\xF4\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x97"],
        ["\xF4\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA2"],
        ["\xF4\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9F"],
        ["\xF4\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8B"],
        ["\xF4\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x84"],
        ["\xF5\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x9F"],
        ["\xF5\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB0"],
        ["\xF5\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x85"],
        ["\xF5\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x97"],
        ["\xF5\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBD"],
        ["\xF5\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xBF"],
        ["\xF5\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x88"],
        ["\xF5\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA3"],
        ["\xF5\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x80"],
        ["\xF5\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x80"],
        ["\xF5\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xBD"],
        ["\xF5\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8F"],
        ["\xF5\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x98"],
        ["\xF5\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB4"],
        ["\xF5\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB7"],
        ["\xF5\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8C"],
        ["\xF5\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9D"],
        ["\xF5\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xA2"],
        ["\xF5\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x8E"],
        ["\xF5\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBC"],
        ["\xF5\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x80"],
        ["\xF5\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xBD"],
        ["\xF5\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x80"],
        ["\xF5\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x93"],
        ["\xF5\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9C"],
        ["\xF5\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAF"],
        ["\xF5\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x80"],
        ["\xF5\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xAC"],
        ["\xF5\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBA"],
        ["\xF5\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA0"],
        ["\xF5\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x91"],
        ["\xF5\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x87"],
        ["\xF5\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA9"],
        ["\xF5\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xBB"],
        ["\xF5\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBC"],
        ["\xF5\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB0"],
        ["\xF5\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAC"],
        ["\xF5\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8A"],
        ["\xF5\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA0"],
        ["\xF5\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x89"],
        ["\xF5\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x83"],
        ["\xF5\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAB"],
        ["\xF5\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x94"],
        ["\xF5\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x98"],
        ["\xF5\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB0"],
        ["\xF5\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA7"],
        ["\xF5\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB5"],
        ["\xF5\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8D"],
        ["\xF5\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB4"],
        ["\xF5\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA2"],
        ["\xF5\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9A"],
        ["\xF5\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x90"],
        ["\xF5\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x86"],
        ["\xF5\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x98"],
        ["\xF5\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x85"],
        ["\xF5\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x87"],
        ["\xF5\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x91"],
        ["\xF5\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8A"],
        ["\xF5\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB8"],
        ["\xF5\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xAE"],
        ["\xF5\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x93"],
        ["\xF5\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA5"],
        ["\xF5\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x91"],
        ["\xF5\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBD"],
        ["\xF5\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x82"],
        ["\xF5\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB2"],
        ["\xF5\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA3"],
        ["\xF5\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB8"],
        ["\xF5\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x83"],
        ["\xF5\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB6"],
        ["\xF5\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAE"],
        ["\xF5\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x88"],
        ["\xF5\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9A"],
        ["\xF5\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBE"],
        ["\xF5\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA6"],
        ["\xF5\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA7"],
        ["\xF5\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9B"],
        ["\xF5\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xBB"],
        ["\xF5\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x85"],
        ["\xF5\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA8"],
        ["\xF5\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x92"],
        ["\xF5\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xA0"],
        ["\xF5\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x99"],
        ["\xF5\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA0"],
        ["\xF5\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9A"],
        ["\xF5\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB1"],
        ["\xF5\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9D"],
        ["\xF5\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB8"],
        ["\xF5\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x81"],
        ["\xF5\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA6"],
        ["\xF5\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x9A"],
        ["\xF5\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA8"],
        ["\xF5\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAB"],
        ["\xF5\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAC"],
        ["\xF6\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9B"],
        ["\xF6\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xA0"],
        ["\xF6\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x91"],
        ["\xF6\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x87"],
        ["\xF6\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB6"],
        ["\xF6\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB1"],
        ["\xF6\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB6"],
        ["\xF6\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x94"],
        ["\xF6\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA1"],
        ["\xF6\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBF"],
        ["\xF6\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAB"],
        ["\xF6\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAC"],
        ["\xF6\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x83"],
        ["\xF6\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA1"],
        ["\xF6\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB7"],
        ["\xF6\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8A"],
        ["\xF6\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAF"],
        ["\xF6\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x90"],
        ["\xF6\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAD"],
        ["\xF6\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x9F"],
        ["\xF6\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x99"],
        ["\xF6\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x8B"],
        ["\xF6\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x81"],
        ["\xF6\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x82"],
        ["\xF6\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xAD"],
        ["\xF6\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAF"],
        ["\xF6\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB8"],
        ["\xF6\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x85"],
        ["\xF6\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x88"],
        ["\xF6\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8E"],
        ["\xF6\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB7"],
        ["\xF6\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA1"],
        ["\xF6\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xBF"],
        ["\xF6\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x97"],
        ["\xF6\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9A"],
        ["\xF6\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB0"],
        ["\xF6\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9D"],
        ["\x86\xBA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xAD"],
        ["\xF6\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x81"],
        ["\xF6\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAD"],
        ["\xF6\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x80"],
        ["\xF6\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB2"],
        ["\xF6\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB5"],
        ["\xF6\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x89"],
        ["\xF6\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x90"],
        ["\xF6\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x81"],
        ["\xF6\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x85"],
        ["\xF6\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA4"],
        ["\xF6\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x87"],
        ["\xF6\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBE"],
        ["\xF6\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA6"],
        ["\xF6\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA4"],
        ["\xF6\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA3"],
        ["\xF6\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBD"],
        ["\xF6\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB4"],
        ["\xF6\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x81"],
        ["\xF6\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBD"],
        ["\xF6\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8B"],
        ["\xF6\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8A"],
        ["\xF6\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB9"],
        ["\xF6\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8C"],
        ["\xF6\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBF"],
        ["\xF6\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x9F"],
        ["\xF6\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xB9"],
        ["\xF6\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x91"],
        ["\xF6\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x91"],
        ["\xF6\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9F"],
        ["\xF6\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x80"],
        ["\xF6\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9D"],
        ["\xF6\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xB6"],
        ["\xF6\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA5"],
        ["\xF6\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBA"],
        ["\xF6\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x97"],
        ["\xF6\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x96"],
        ["\xF6\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA9"],
        ["\xF6\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA6"],
        ["\xF6\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAF"],
        ["\xF6\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x86"],
        ["\xF6\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x88"],
        ["\xF6\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x92"],
        ["\xF6\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB7"],
        ["\xF6\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9A"],
        ["\xF6\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9E"],
        ["\xF6\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xB0"],
        ["\xF6\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBA"],
        ["\xF6\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB6"],
        ["\xF6\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x93"],
        ["\xF6\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x87"],
        ["\xF6\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x85"],
        ["\xF6\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB2"],
        ["\xF6\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9B"],
        ["\xF6\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA7"],
        ["\xF6\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x91"],
        ["\xF6\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x88"],
        ["\xF7\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x98"],
        ["\xF7\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x9F"],
        ["\xF7\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x93"],
        ["\xF7\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB4"],
        ["\xF7\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA1"],
        ["\xF7\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAA"],
        ["\xF7\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x8A"],
        ["\xF7\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x88"],
        ["\xF7\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x82"],
        ["\xF7\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x97"],
        ["\xF7\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB0"],
        ["\xF7\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x91"],
        ["\xF7\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAC"],
        ["\xF7\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB2"],
        ["\xF7\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9B"],
        ["\xF7\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAB"],
        ["\xF7\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x93"],
        ["\xF7\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA4"],
        ["\xF7\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8D"],
        ["\xF7\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA1"],
        ["\xF7\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA6"],
        ["\xF7\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x88"],
        ["\xF7\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x81"],
        ["\xF7\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x82"],
        ["\xF7\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xBE"],
        ["\xF7\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x91"],
        ["\xF7\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x84"],
        ["\xF7\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x93"],
        ["\xF7\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xAD"],
        ["\xF7\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAA"],
        ["\xF7\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x8B"],
        ["\xF7\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x91"],
        ["\xF7\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA2"],
        ["\xF7\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x84"],
        ["\xF7\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB5"],
        ["\xF7\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB6"],
        ["\xF7\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA7"],
        ["\xF7\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA9"],
        ["\xF7\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB2"],
        ["\xF7\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xBA"],
        ["\xF7\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xAC"],
        ["\xF7\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAF"],
        ["\xF7\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x82"],
        ["\xF7\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x93"],
        ["\xF7\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA6"],
        ["\xF7\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBD"],
        ["\xF7\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBB"],
        ["\xF7\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8C"],
        ["\xF7\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x99"],
        ["\xF7\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8B"],
        ["\xF7\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAB"],
        ["\xF7\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x8E"],
        ["\xF7\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x8A"],
        ["\xF7\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8D"],
        ["\xF7\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x88"],
        ["\xF7\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA3"],
        ["\xF7\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xA6"],
        ["\xF7\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBD"],
        ["\x75\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x9A"],
        ["\xF7\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x8F"],
        ["\xF7\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB8"],
        ["\xF7\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x8E"],
        ["\xF7\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA8"],
        ["\xF7\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x87"],
        ["\xF7\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9F"],
        ["\xF7\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x83"],
        ["\xF7\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x80"],
        ["\xF7\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x99"],
        ["\xF7\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x81"],
        ["\xF7\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x91"],
        ["\xF7\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA0"],
        ["\xF7\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBA"],
        ["\xF7\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x94"],
        ["\xF7\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB4"],
        ["\xF7\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x90"],
        ["\xF7\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x80"],
        ["\xF7\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA3"],
        ["\xF7\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x88"],
        ["\xF7\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB6"],
        ["\xF7\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xB9"],
        ["\xF7\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA6"],
        ["\xF7\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xA5"],
        ["\xF7\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xBC"],
        ["\xF7\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB8"],
        ["\xF7\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA3"],
        ["\xF7\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA7"],
        ["\xF7\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8F"],
        ["\xF7\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x85"],
        ["\xF7\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x8C"],
        ["\xF7\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBA"],
        ["\xF7\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB2"],
        ["\xF7\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB8"],
        ["\xF7\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB3"],
        ["\xF7\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB2"],
        ["\xF8\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9C"],
        ["\xF8\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA9"],
        ["\xF8\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBD"],
        ["\xF8\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAC"],
        ["\xF8\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAE"],
        ["\xF8\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x94"],
        ["\xF8\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAF"],
        ["\xF8\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB9"],
        ["\xF8\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8C"],
        ["\xF8\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA9"],
        ["\xF8\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8B"],
        ["\xF8\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x99"],
        ["\xF8\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA2"],
        ["\xF8\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x92"],
        ["\xF8\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA3"],
        ["\xF8\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xB5"],
        ["\xF8\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xBA"],
        ["\xF8\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x95"],
        ["\xF8\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x93"],
        ["\xF8\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB8"],
        ["\xF8\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x83"],
        ["\xF8\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9F"],
        ["\xF8\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB3"],
        ["\xF8\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBB"],
        ["\xF8\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA6"],
        ["\xF8\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9B"],
        ["\xF8\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x90"],
        ["\xF8\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x84"],
        ["\xF8\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xBE"],
        ["\xF8\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x83"],
        ["\xF8\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB7"],
        ["\xF8\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x80"],
        ["\xF8\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBA"],
        ["\xF8\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x90"],
        ["\xF8\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8E"],
        ["\xF8\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8B"],
        ["\xF8\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA4"],
        ["\xF8\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBC"],
        ["\xF8\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBA"],
        ["\xF8\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x91"],
        ["\xF8\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA4"],
        ["\xF8\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB1"],
        ["\xF8\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAB"],
        ["\xF8\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA7"],
        ["\xF8\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB8"],
        ["\xF8\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x85"],
        ["\xF8\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xAF"],
        ["\xF8\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x96"],
        ["\xF8\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x90"],
        ["\xF8\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8A"],
        ["\xF8\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB4"],
        ["\xF8\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA1"],
        ["\xF8\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA1"],
        ["\xF8\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB0"],
        ["\xF8\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x8E"],
        ["\xF8\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x87"],
        ["\xF8\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA8"],
        ["\xF8\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB7"],
        ["\xF8\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x87"],
        ["\xF8\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xA7"],
        ["\xF8\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x93"],
        ["\xF8\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x94"],
        ["\xF8\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x92"],
        ["\xF8\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8D"],
        ["\xF8\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x88"],
        ["\xF8\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x89"],
        ["\xF8\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBE"],
        ["\xF8\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xAF"],
        ["\xF8\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8C"],
        ["\xF8\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA1"],
        ["\xF8\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9F"],
        ["\xF8\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA7"],
        ["\xF8\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8E"],
        ["\xF8\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9A"],
        ["\xF8\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x81"],
        ["\xF8\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x9E"],
        ["\xF8\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA4"],
        ["\xF8\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB7"],
        ["\xF8\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x90"],
        ["\xF8\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9E"],
        ["\xF8\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x89"],
        ["\xF8\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA4"],
        ["\xF8\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBC"],
        ["\xF8\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAF"],
        ["\xF8\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x99"],
        ["\xF8\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x96"],
        ["\xF8\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x89"],
        ["\xF8\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAC"],
        ["\xF8\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9F"],
        ["\xF8\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB9"],
        ["\xF8\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBE"],
        ["\xF8\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9A"],
        ["\xF8\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA3"],
        ["\xF8\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x91"],
        ["\xF9\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8E"],
        ["\xF9\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x89"],
        ["\xF9\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x91"],
        ["\xF9\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA2"],
        ["\xF9\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xBD"],
        ["\xF9\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x94"],
        ["\xF9\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9D"],
        ["\xF9\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8F"],
        ["\xF9\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA5"],
        ["\xF9\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA7"],
        ["\xF9\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB7"],
        ["\xF9\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB8"],
        ["\xF9\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x83"],
        ["\xF9\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x9A"],
        ["\xF9\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB7"],
        ["\xF9\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x98"],
        ["\xF9\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x92"],
        ["\xF9\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8C"],
        ["\xF9\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x97"],
        ["\xF9\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x98"],
        ["\xF9\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA7"],
        ["\xF9\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBB"],
        ["\x8E\x86",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x82"],
        ["\xF9\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x83"],
        ["\xF9\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB4"],
        ["\xF9\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAD"],
        ["\xF9\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA1"],
        ["\xF9\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x97"],
        ["\xF9\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8B"],
        ["\xF9\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9F"],
        ["\xF9\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAA"],
        ["\xF9\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA9"],
        ["\xF9\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAF"],
        ["\xF9\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9D"],
        ["\xF9\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB2"],
        ["\xF9\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x87"],
        ["\xF9\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAC"],
        ["\xF9\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBF"],
        ["\xF9\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA0"],
        ["\xF9\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x85"],
        ["\xF9\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x98"],
        ["\xF9\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9E"],
        ["\xF9\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB1"],
        ["\xF9\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x95"],
        ["\xF9\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x83"],
        ["\xF9\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAF"],
        ["\xF9\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB1"],
        ["\xF9\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x94"],
        ["\xF9\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x8F"],
        ["\xF9\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAA"],
        ["\xF9\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x92"],
        ["\xF9\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8C"],
        ["\xF9\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA1"],
        ["\xF9\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9B"],
        ["\xF9\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA2"],
        ["\xF9\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBC"],
        ["\xF9\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x8A"],
        ["\xF9\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB5"],
        ["\xF9\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xB1"],
        ["\x59\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xBF"],
        ["\xF9\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBC"],
        ["\xF9\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA4"],
        ["\xF9\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8D"],
        ["\xF9\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x85"],
        ["\xF9\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x99"],
        ["\xF9\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x98"],
        ["\xF9\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBB"],
        ["\xF9\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9B"],
        ["\xF9\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAB"],
        ["\xF9\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB7"],
        ["\xF9\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x88"],
        ["\xF9\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x95"],
        ["\xF9\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB7"],
        ["\xF9\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA0"],
        ["\xF9\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAA"],
        ["\xF9\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x9F"],
        ["\xAC\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB9"],
        ["\xF9\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8B"],
        ["\xF9\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xBB"],
        ["\xF9\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8A"],
        ["\xF9\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBD"],
        ["\xF9\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x80"],
        ["\xF9\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB7"],
        ["\xF9\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA0"],
        ["\xF9\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x92"],
        ["\xF9\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x84"],
        ["\xF9\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x89"],
        ["\xF9\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB0"],
        ["\xF9\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x91"],
        ["\xF9\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBD"],
        ["\xF9\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9A"],
        ["\xF9\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xA8"],
        ["\xF9\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x9B"],
        ["\xF9\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBC"],
        ["\x7A\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA4"],
        ["\x7A\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x83"],
        ["\x7A\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8A"],
        ["\x7A\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB0"],
        ["\x7A\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA4"],
        ["\x7A\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBE"],
        ["\x7A\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x9A"],
        ["\x7A\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA8"],
        ["\x7A\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x87"],
        ["\x7A\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8F"],
        ["\x7A\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x86"],
        ["\x7A\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB9"],
        ["\x7A\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB1"],
        ["\x7A\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB7"],
        ["\x7A\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x95"],
        ["\x7A\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBA"],
        ["\x7A\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAE"],
        ["\x7A\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x82"],
        ["\x7A\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9B"],
        ["\x7A\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x90"],
        ["\x7A\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x89"],
        ["\x7A\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x86"],
        ["\x7A\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAF"],
        ["\x7A\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA6"],
        ["\x7A\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xAE"],
        ["\x7A\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBB"],
        ["\x7A\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x99"],
        ["\x7A\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB3"],
        ["\x7A\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x82"],
        ["\x7A\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x90"],
        ["\x7A\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x96"],
        ["\x7A\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9F"],
        ["\x7A\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x90"],
        ["\x7A\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA7"],
        ["\x7A\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xAB"],
        ["\x7A\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB5"],
        ["\x7A\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAC"],
        ["\x7A\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8D"],
        ["\x7A\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x80"],
        ["\x7A\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x89"],
        ["\x7A\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x9E"],
        ["\x7A\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBB"],
        ["\x7A\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB0"],
        ["\x7A\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA9"],
        ["\x7A\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8D"],
        ["\x7A\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA1"],
        ["\x7A\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBD"],
        ["\x7A\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB3"],
        ["\x7A\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x88"],
        ["\x7A\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBD"],
        ["\x7A\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x87"],
        ["\x7A\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x80"],
        ["\x7A\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x95"],
        ["\x7A\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA6"],
        ["\x7A\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xAD"],
        ["\x7A\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8E"],
        ["\x7A\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB0"],
        ["\x7A\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9C"],
        ["\x7A\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x81"],
        ["\x7A\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x89"],
        ["\x7A\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9B"],
        ["\x7A\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA4"],
        ["\x7A\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA8"],
        ["\x7A\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x90"],
        ["\x7A\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAA"],
        ["\x7A\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA1"],
        ["\x7A\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB4"],
        ["\x7A\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x82"],
        ["\x7A\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAA"],
        ["\x7A\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xBA"],
        ["\x7A\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x8A"],
        ["\x7A\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB4"],
        ["\x7A\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB2"],
        ["\x7A\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8E"],
        ["\x7A\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBC"],
        ["\x7A\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x95"],
        ["\x7A\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xBA"],
        ["\x7A\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9C"],
        ["\x7A\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8A"],
        ["\x7A\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8B"],
        ["\x7A\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xBE"],
        ["\x7A\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA8"],
        ["\x7A\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x94"],
        ["\x7A\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB5"],
        ["\x7A\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x84"],
        ["\x7A\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x96"],
        ["\x7A\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA2"],
        ["\x7A\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAF"],
        ["\x7A\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9C"],
        ["\x7A\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAD"],
        ["\x7A\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB9"],
        ["\x7A\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x99"],
        ["\x7A\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8A"],
        ["\x7A\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB7"],
        ["\x5E\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9F"],
        ["\x5E\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB6"],
        ["\x5E\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAE"],
        ["\x5E\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA6"],
        ["\x5E\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAD"],
        ["\x5E\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBA"],
        ["\x5E\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA9"],
        ["\x5E\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x91"],
        ["\x5E\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x90"],
        ["\x5E\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x96"],
        ["\x5E\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8C"],
        ["\x5E\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x86"],
        ["\x5E\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAB"],
        ["\x5E\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xBF"],
        ["\x5E\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x92"],
        ["\x5E\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x89"],
        ["\x5E\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x98"],
        ["\x5E\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x82"],
        ["\x5E\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB1"],
        ["\x5E\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA8"],
        ["\x5E\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x92"],
        ["\x5E\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA3"],
        ["\x5E\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9F"],
        ["\x5E\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA6"],
        ["\x5E\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8A"],
        ["\x5E\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA3"],
        ["\x5E\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x97"],
        ["\x5E\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x82"],
        ["\x5E\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x95"],
        ["\x5E\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x83"],
        ["\x5E\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9B"],
        ["\x5E\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB8"],
        ["\x5E\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x90"],
        ["\x5E\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAC"],
        ["\x5E\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAB"],
        ["\x5E\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8B"],
        ["\x5E\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x95"],
        ["\x5E\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x94"],
        ["\x5E\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBA"],
        ["\x5E\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBF"],
        ["\x5E\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xBA"],
        ["\x5E\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB8"],
        ["\x5E\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB2"],
        ["\x5E\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA3"],
        ["\x5E\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9B"],
        ["\x5E\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAB"],
        ["\x5E\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x8B"],
        ["\x5E\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x89"],
        ["\x5E\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xBF"],
        ["\x5E\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x90"],
        ["\x5E\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8D"],
        ["\x5E\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x82"],
        ["\x5E\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAB"],
        ["\x5E\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x97"],
        ["\x5E\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9D"],
        ["\x5E\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x87"],
        ["\x5E\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAF"],
        ["\x5E\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9C"],
        ["\x5E\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAF"],
        ["\x5E\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBD"],
        ["\x5E\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA8"],
        ["\x5E\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9D"],
        ["\x5E\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA2"],
        ["\x5E\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBB"],
        ["\x5E\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x8F"],
        ["\x5E\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x85"],
        ["\x5E\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x89"],
        ["\x5E\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x81"],
        ["\x5E\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB8"],
        ["\x5E\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x99"],
        ["\x5E\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAB"],
        ["\x5E\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA2"],
        ["\x5E\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x82"],
        ["\x5E\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xB3"],
        ["\x5E\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x96"],
        ["\x5E\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9E"],
        ["\x5E\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA9"],
        ["\x5E\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA6"],
        ["\x5E\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x8C"],
        ["\x5E\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAE"],
        ["\x5E\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x87"],
        ["\x5E\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9C"],
        ["\x5E\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8C"],
        ["\x5E\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBC"],
        ["\x5E\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAF"],
        ["\x5E\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8B"],
        ["\x5E\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBC"],
        ["\x5E\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8D"],
        ["\x5E\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x90"],
        ["\x5E\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x97"],
        ["\x5E\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBA"],
        ["\x5E\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x88"],
        ["\x5E\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x81"],
        ["\x5E\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x82"],
        ["\x4C\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA1"],
        ["\x4C\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8B"],
        ["\x4C\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBB"],
        ["\x4C\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBE"],
        ["\x4C\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xBD"],
        ["\x4C\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x94"],
        ["\x4C\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x81"],
        ["\x4C\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBA"],
        ["\x4C\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8C"],
        ["\x4C\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB3"],
        ["\x4C\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAA"],
        ["\x4C\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x94"],
        ["\x4C\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9E"],
        ["\x4C\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x90"],
        ["\x4C\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBF"],
        ["\x4C\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8F"],
        ["\x4C\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x98"],
        ["\x4C\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAB"],
        ["\x4C\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBA"],
        ["\x4C\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xB8"],
        ["\x4C\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8D"],
        ["\x4C\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAB"],
        ["\x4C\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x83"],
        ["\x4C\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB1"],
        ["\x4C\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB7"],
        ["\x4C\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB1"],
        ["\x4C\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x89"],
        ["\x4C\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA4"],
        ["\x4C\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x89"],
        ["\x4C\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xBF"],
        ["\x4C\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x86"],
        ["\x4C\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBE"],
        ["\x4C\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xAA"],
        ["\x4C\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9F"],
        ["\x4C\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x80"],
        ["\x4C\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA0"],
        ["\x4C\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB2"],
        ["\x4C\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB4"],
        ["\x4C\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x9D"],
        ["\x4C\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA1"],
        ["\x68\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8A"],
        ["\x4C\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9E"],
        ["\x4C\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8E"],
        ["\x4C\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x99"],
        ["\x4C\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x84"],
        ["\x4C\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA8"],
        ["\x4C\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA6"],
        ["\x4C\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9C"],
        ["\x4C\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xAE"],
        ["\x4C\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBE"],
        ["\x4C\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x97"],
        ["\x4C\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x85"],
        ["\x4C\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9D"],
        ["\x4C\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8A"],
        ["\x4C\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAE"],
        ["\x4C\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x87"],
        ["\x4C\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xAA"],
        ["\x4C\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9F"],
        ["\x4C\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBA"],
        ["\x4C\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBA"],
        ["\x4C\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x93"],
        ["\x4C\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBC"],
        ["\x4C\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB5"],
        ["\x4C\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8C"],
        ["\x4C\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x88"],
        ["\x4C\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAB"],
        ["\x4C\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA5"],
        ["\x4C\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x82"],
        ["\x4C\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB1"],
        ["\x4C\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB9"],
        ["\x4C\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBB"],
        ["\x4C\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x96"],
        ["\x4C\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x88"],
        ["\x4C\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8B"],
        ["\x4C\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB1"],
        ["\x4C\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8A"],
        ["\x4C\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA9"],
        ["\x4C\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA0"],
        ["\x4C\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xAE"],
        ["\x4C\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAB"],
        ["\x4C\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA3"],
        ["\x4C\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x92"],
        ["\x4C\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x96"],
        ["\x4C\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x92"],
        ["\x4C\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x97"],
        ["\x4C\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xAA"],
        ["\x4C\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBF"],
        ["\x4C\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x88"],
        ["\x4C\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB9"],
        ["\x4C\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAC"],
        ["\x4C\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x80"],
        ["\x4C\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9A"],
        ["\x4C\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8E"],
        ["\x4C\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xA8"],
        ["\x7E\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x97"],
        ["\x7E\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB1"],
        ["\x7E\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9E"],
        ["\x7E\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xAE"],
        ["\x7E\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x81"],
        ["\x7E\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBE"],
        ["\x7E\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB2"],
        ["\x7E\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x80"],
        ["\x7E\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8B"],
        ["\x7E\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x82"],
        ["\x7E\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8D"],
        ["\x7E\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x92"],
        ["\x7E\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAD"],
        ["\x7E\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9F"],
        ["\x7E\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x90"],
        ["\x7E\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x86"],
        ["\x7E\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB2"],
        ["\x7E\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x90"],
        ["\x7E\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB4"],
        ["\x7E\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAF"],
        ["\x7E\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB1"],
        ["\x7E\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8B"],
        ["\x7E\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xAC"],
        ["\x7E\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x86"],
        ["\x7E\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x9C"],
        ["\x7E\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x80"],
        ["\x7E\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8F"],
        ["\x7E\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x85"],
        ["\x7E\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x81"],
        ["\x7E\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x93"],
        ["\x7E\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8E"],
        ["\x7E\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x94"],
        ["\x7E\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x81"],
        ["\x7E\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x8B"],
        ["\x7E\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA3"],
        ["\x7E\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA6"],
        ["\x7E\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8D"],
        ["\x7E\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x83"],
        ["\x7E\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x94"],
        ["\x7E\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x99"],
        ["\x7E\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xBF"],
        ["\x7E\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x91"],
        ["\x7E\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9D"],
        ["\x7E\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAE"],
        ["\x7E\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x9B"],
        ["\x7E\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xBE"],
        ["\x7E\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x9F"],
        ["\x7E\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBA"],
        ["\x7E\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x93"],
        ["\x7E\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB0"],
        ["\x7E\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8A"],
        ["\x7E\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBB"],
        ["\x7E\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA5"],
        ["\x7E\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAC"],
        ["\x7E\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA3"],
        ["\x7E\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9C"],
        ["\x7E\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xBF"],
        ["\x7E\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x86"],
        ["\x7E\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAA"],
        ["\x7E\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xAC"],
        ["\x7E\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAF"],
        ["\x7E\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x89"],
        ["\x7E\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB3"],
        ["\x7E\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x96"],
        ["\x7E\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA4"],
        ["\x7E\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBE"],
        ["\x7E\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x94"],
        ["\x7E\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA1"],
        ["\x7E\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB5"],
        ["\x7E\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x87"],
        ["\x7E\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x86"],
        ["\x7E\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA6"],
        ["\x7E\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x9D"],
        ["\x7E\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x80"],
        ["\x7E\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x91"],
        ["\x7E\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x99"],
        ["\x7E\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9A"],
        ["\x7E\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB6"],
        ["\x7E\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x92"],
        ["\x7E\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB2"],
        ["\x7E\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB8"],
        ["\x7E\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAF"],
        ["\x7E\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB7"],
        ["\x7E\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB8"],
        ["\x7E\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA9"],
        ["\x7E\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x99"],
        ["\x7E\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB3"],
        ["\x7E\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x8F"],
        ["\x7E\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x90"],
        ["\x7E\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x95"],
        ["\x7E\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA4"],
        ["\x7E\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA4"],
        ["\x7E\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB7"],
        ["\x7E\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9F"],
        ["\x6E\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9D"],
        ["\x6E\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA0"],
        ["\x6E\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x87"],
        ["\x6E\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAC"],
        ["\x6E\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA8"],
        ["\x6E\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x86"],
        ["\x6E\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB1"],
        ["\x6E\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x97"],
        ["\x6E\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA8"],
        ["\x6E\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBE"],
        ["\x6E\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xBC"],
        ["\x6E\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB5"],
        ["\x6E\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x86"],
        ["\x6E\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8F"],
        ["\x6E\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x91"],
        ["\x6E\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x9A"],
        ["\x6E\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x84"],
        ["\x6E\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x8A"],
        ["\x6E\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA0"],
        ["\x6E\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB0"],
        ["\x6E\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBF"],
        ["\x6E\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x84"],
        ["\x6E\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9B"],
        ["\x6E\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8C"],
        ["\x6E\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB7"],
        ["\x6E\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x87"],
        ["\x6E\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8C"],
        ["\x6E\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAD"],
        ["\x6E\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB6"],
        ["\x6E\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBE"],
        ["\x6E\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA2"],
        ["\x6E\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9F"],
        ["\x6E\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB5"],
        ["\x6E\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBC"],
        ["\x6E\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x88"],
        ["\x6E\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x89"],
        ["\x6E\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x98"],
        ["\x6E\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xBC"],
        ["\x6E\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA6"],
        ["\x6E\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA7"],
        ["\x6E\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x87"],
        ["\x6E\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x81"],
        ["\x6E\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x9D"],
        ["\x6E\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x81"],
        ["\x6E\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA5"],
        ["\x6E\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xB0"],
        ["\x6E\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA0"],
        ["\x6E\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x91"],
        ["\x6E\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA7"],
        ["\x6E\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB9"],
        ["\x6E\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x96"],
        ["\x6E\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x96"],
        ["\x6E\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x8B"],
        ["\x6E\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x89"],
        ["\x6E\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9D"],
        ["\x6E\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB3"],
        ["\x6E\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9F"],
        ["\x6E\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBC"],
        ["\x6E\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x94"],
        ["\x6E\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB3"],
        ["\x6E\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA1"],
        ["\x6E\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9E"],
        ["\x6E\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xA4"],
        ["\x6E\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA6"],
        ["\x6E\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xBE"],
        ["\x6E\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x98"],
        ["\x6E\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9C"],
        ["\x6E\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x98"],
        ["\x6E\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8A"],
        ["\x6E\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x88"],
        ["\x6E\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x9E"],
        ["\x6E\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x97"],
        ["\x6E\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x97"],
        ["\x6E\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB0"],
        ["\x6E\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8E"],
        ["\x6E\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB4"],
        ["\x6E\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8C"],
        ["\x6E\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xA2"],
        ["\x6E\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB8"],
        ["\x6E\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x85"],
        ["\x6E\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBE"],
        ["\x6E\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA1"],
        ["\x6E\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x96"],
        ["\x6E\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x84"],
        ["\x6E\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB6"],
        ["\x6E\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB3"],
        ["\x6E\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA3"],
        ["\x6E\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB8"],
        ["\x6E\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB2"],
        ["\x6E\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB8"],
        ["\x6E\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA0"],
        ["\x6E\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB1"],
        ["\x6E\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB4"],
        ["\x6E\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBE"],
        ["\x6F\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAD"],
        ["\x6F\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8D"],
        ["\x6F\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x96"],
        ["\x6F\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAD"],
        ["\x6F\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x94"],
        ["\x6F\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB7"],
        ["\x6F\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB2"],
        ["\x6F\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA6"],
        ["\x6F\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9F"],
        ["\x6F\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x95"],
        ["\x6F\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB1"],
        ["\x6F\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBB"],
        ["\x6F\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB8"],
        ["\x6F\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA1"],
        ["\x6F\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB5"],
        ["\x6F\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x87"],
        ["\x6F\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA0"],
        ["\x6F\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9D"],
        ["\x6F\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA9"],
        ["\x6F\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x83"],
        ["\x6F\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8E"],
        ["\x6F\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xAF"],
        ["\x6F\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB0"],
        ["\x6F\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8B"],
        ["\x6F\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAE"],
        ["\x6F\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x9B"],
        ["\x6F\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB8"],
        ["\x6F\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB1"],
        ["\x6F\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB3"],
        ["\x6F\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB9"],
        ["\x6F\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9F"],
        ["\x6F\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9E"],
        ["\x6F\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA6"],
        ["\x6F\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB3"],
        ["\x6F\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA3"],
        ["\x6F\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAF"],
        ["\x6F\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAA"],
        ["\x6F\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAA"],
        ["\x6F\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBA"],
        ["\x6F\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAB"],
        ["\x6F\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9B"],
        ["\x6F\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB2"],
        ["\x6F\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9D"],
        ["\x6F\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x87"],
        ["\x6F\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xBA"],
        ["\x6F\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x81"],
        ["\x6F\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x83"],
        ["\x6F\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB5"],
        ["\x6F\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAC"],
        ["\x6F\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8B"],
        ["\x6F\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9A"],
        ["\x6F\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBD"],
        ["\x6F\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8E"],
        ["\x6F\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8A"],
        ["\x6F\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x85"],
        ["\x6F\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA3"],
        ["\x75\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAD"],
        ["\x6F\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA5"],
        ["\x6F\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8F"],
        ["\x6F\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x88"],
        ["\x6F\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA2"],
        ["\x6F\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB3"],
        ["\x6F\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA8"],
        ["\x6F\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x97"],
        ["\x6F\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB9"],
        ["\x6F\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x82"],
        ["\x6F\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xA5"],
        ["\x6F\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA8"],
        ["\x6F\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB4"],
        ["\x6F\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x8A"],
        ["\x6F\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA1"],
        ["\x6F\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8B"],
        ["\x6F\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA0"],
        ["\x6F\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB0"],
        ["\x6F\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x82"],
        ["\x6F\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x94"],
        ["\x6F\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x90"],
        ["\x6F\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x98"],
        ["\x6F\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8F"],
        ["\x6F\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9E"],
        ["\x6F\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x84"],
        ["\x6F\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x87"],
        ["\x6F\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xA9"],
        ["\x6F\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB0"],
        ["\x6F\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA2"],
        ["\x6F\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA8"],
        ["\x6F\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9B"],
        ["\x6F\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAE"],
        ["\x6F\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x89"],
        ["\x6F\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x99"],
        ["\x6F\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x85"],
        ["\x6F\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x97"],
        ["\x6F\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x80"],
        ["\x6F\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBE"],
        ["\x7C\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x84"],
        ["\x7C\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xBA"],
        ["\x7C\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB8"],
        ["\x7C\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x96"],
        ["\x7C\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xAC"],
        ["\x7C\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9D"],
        ["\x7C\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAF"],
        ["\x7C\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x84"],
        ["\x7C\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB6"],
        ["\x7C\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA2"],
        ["\x7C\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x93"],
        ["\x7C\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x81"],
        ["\x7C\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA7"],
        ["\x7C\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x90"],
        ["\x7C\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBF"],
        ["\x7C\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB4"],
        ["\x7C\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9F"],
        ["\x7C\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB4"],
        ["\x7C\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB2"],
        ["\x7C\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x96"],
        ["\x7C\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA3"],
        ["\x7C\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x85"],
        ["\x7C\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB2"],
        ["\x7C\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9F"],
        ["\x7C\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9B"],
        ["\x7C\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBE"],
        ["\x7C\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x96"],
        ["\x7C\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB0"],
        ["\x7C\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBD"],
        ["\x7C\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xBF"],
        ["\x7C\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA0"],
        ["\x7C\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x93"],
        ["\x7C\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8B"],
        ["\x7C\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9D"],
        ["\x7C\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x92"],
        ["\x7C\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x92"],
        ["\x7C\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x99"],
        ["\x7C\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x89"],
        ["\x7C\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8E"],
        ["\x7C\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x86"],
        ["\x7C\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xBB"],
        ["\x7C\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAD"],
        ["\x7C\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9C"],
        ["\x7C\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9A"],
        ["\x7C\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA5"],
        ["\x7C\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x94"],
        ["\x7C\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x90"],
        ["\x7C\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xB3"],
        ["\x7C\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8D"],
        ["\x7C\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8D"],
        ["\x7C\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBE"],
        ["\x7C\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x8A"],
        ["\x7C\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAC"],
        ["\x7C\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA4"],
        ["\x7C\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA1"],
        ["\x7C\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x9F"],
        ["\x7C\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA9"],
        ["\x7C\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x87"],
        ["\x7C\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x99"],
        ["\x7C\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA5"],
        ["\x7C\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x82"],
        ["\x7C\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x98"],
        ["\x7C\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xAD"],
        ["\x7C\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x83"],
        ["\x7C\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x80"],
        ["\x7C\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAC"],
        ["\x7C\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAA"],
        ["\x7C\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB6"],
        ["\x7C\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8C"],
        ["\x7C\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x89"],
        ["\x7C\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x99"],
        ["\x7C\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x88"],
        ["\x7C\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x83"],
        ["\x7C\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA0"],
        ["\x7C\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA3"],
        ["\x7C\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x82"],
        ["\x7C\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x96"],
        ["\x7C\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9D"],
        ["\x7C\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA6"],
        ["\x7C\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x87"],
        ["\x7C\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB0"],
        ["\x7C\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x93"],
        ["\x7C\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB4"],
        ["\x7C\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x89"],
        ["\x7C\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x85"],
        ["\x7C\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x97"],
        ["\x7C\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x93"],
        ["\x7C\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9C"],
        ["\x7C\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8E"],
        ["\x7C\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xBD"],
        ["\x7C\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8B"],
        ["\x7C\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBF"],
        ["\x7C\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAD"],
        ["\x7C\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9A"],
        ["\xC1\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8A"],
        ["\xC1\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA8"],
        ["\xC1\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xBA"],
        ["\xC1\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9B"],
        ["\xC1\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB9"],
        ["\xC1\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA6"],
        ["\xC1\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAE"],
        ["\x71\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8E"],
        ["\xC1\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xB5"],
        ["\xC1\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB8"],
        ["\xC1\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB7"],
        ["\xC1\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xAD"],
        ["\xC1\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x91"],
        ["\xC1\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x83"],
        ["\xC1\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAE"],
        ["\xC1\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8D"],
        ["\xC1\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x84"],
        ["\xC1\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB8"],
        ["\xC1\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xB6"],
        ["\xC1\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA8"],
        ["\xC1\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x85"],
        ["\xC1\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x95"],
        ["\xC1\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB3"],
        ["\xC1\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8E"],
        ["\xC1\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x8C"],
        ["\xC1\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x91"],
        ["\xC1\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA8"],
        ["\xC1\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAA"],
        ["\xC1\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBE"],
        ["\xC1\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBD"],
        ["\xC1\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9A"],
        ["\xC1\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x99"],
        ["\xC1\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8F"],
        ["\xC1\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8E"],
        ["\xC1\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x8E"],
        ["\xC1\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x96"],
        ["\xC1\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x9F"],
        ["\xC1\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x97"],
        ["\xC1\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA0"],
        ["\xC1\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x84"],
        ["\xC1\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x87"],
        ["\xC1\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB4"],
        ["\xC1\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBB"],
        ["\xC1\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA1"],
        ["\xC1\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xA0"],
        ["\xC1\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA7"],
        ["\xC1\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB5"],
        ["\xC1\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8C"],
        ["\xC1\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA2"],
        ["\xC1\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x89"],
        ["\xC1\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAA"],
        ["\xC1\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAE"],
        ["\xC1\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x8F"],
        ["\xC1\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBD"],
        ["\xC1\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8B"],
        ["\xC1\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA4"],
        ["\xC1\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9D"],
        ["\xC1\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA3"],
        ["\xC1\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB3"],
        ["\xC1\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x9C"],
        ["\xC1\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x83"],
        ["\xC1\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBF"],
        ["\xC1\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBB"],
        ["\xC1\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8D"],
        ["\xC1\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA9"],
        ["\xC1\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB9"],
        ["\xC1\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA3"],
        ["\xC1\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8D"],
        ["\xC1\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBD"],
        ["\xC1\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x95"],
        ["\xC1\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA5"],
        ["\xC1\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x89"],
        ["\xC1\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA9"],
        ["\xC1\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB8"],
        ["\xC1\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x93"],
        ["\xC1\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9F"],
        ["\xC1\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8F"],
        ["\xC1\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9C"],
        ["\xC1\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA1"],
        ["\xC1\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x89"],
        ["\xC1\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x98"],
        ["\xC1\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAC"],
        ["\xC1\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBC"],
        ["\xC1\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBB"],
        ["\xC1\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x85"],
        ["\xC1\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB0"],
        ["\xC1\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x81"],
        ["\xC1\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAD"],
        ["\xC1\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x97"],
        ["\xC1\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x9C"],
        ["\xC1\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x92"],
        ["\xC1\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8F"],
        ["\xC1\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x97"],
        ["\xC1\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8E"],
        ["\xC2\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x93"],
        ["\xC2\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xB5"],
        ["\xC2\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x88"],
        ["\xC2\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA0"],
        ["\xC2\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x83"],
        ["\xC2\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB4"],
        ["\xC2\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x87"],
        ["\xC2\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB3"],
        ["\xC2\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAF"],
        ["\xC2\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x89"],
        ["\xC2\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9F"],
        ["\xC2\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAC"],
        ["\xC2\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xB3"],
        ["\xC2\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9F"],
        ["\xC2\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x97"],
        ["\xC2\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x9E"],
        ["\xC2\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8A"],
        ["\xC2\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8F"],
        ["\xC2\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9A"],
        ["\xC2\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x92"],
        ["\xC2\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x96"],
        ["\xC2\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB6"],
        ["\xC2\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x83"],
        ["\xC2\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x98"],
        ["\xC2\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xAB"],
        ["\xC2\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8A"],
        ["\xC2\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x8D"],
        ["\xC2\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x91"],
        ["\xC2\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x9C"],
        ["\xC2\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x96"],
        ["\xC2\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9A"],
        ["\xC2\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAA"],
        ["\xC2\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB0"],
        ["\xC2\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x91"],
        ["\xC2\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xBE"],
        ["\xC2\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x95"],
        ["\xC2\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA5"],
        ["\xC2\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB0"],
        ["\xC2\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x93"],
        ["\xC2\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x81"],
        ["\xC2\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB5"],
        ["\xC2\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x95"],
        ["\xC2\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x80"],
        ["\xC2\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x84"],
        ["\xC2\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xA8"],
        ["\xC2\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x93"],
        ["\xC2\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x86"],
        ["\xC2\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBE"],
        ["\xC2\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x90"],
        ["\xC2\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB1"],
        ["\xC2\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAF"],
        ["\xC2\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x85"],
        ["\xC2\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA0"],
        ["\xC2\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8B"],
        ["\xC2\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB4"],
        ["\xC2\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBF"],
        ["\xC2\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB0"],
        ["\xC2\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x9E"],
        ["\xC2\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8E"],
        ["\xC2\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xBF"],
        ["\xC2\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x94"],
        ["\xC2\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x8B"],
        ["\xC2\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB8"],
        ["\xC2\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x80"],
        ["\xC2\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xAE"],
        ["\xC2\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8A"],
        ["\xC2\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9B"],
        ["\xC2\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x9B"],
        ["\xC2\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA3"],
        ["\xC2\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB0"],
        ["\xC2\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA7"],
        ["\xC2\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAC"],
        ["\xC2\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x8D"],
        ["\xC2\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8C"],
        ["\xC2\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB9"],
        ["\xC2\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x9D"],
        ["\xC2\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA7"],
        ["\xC2\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x93"],
        ["\xC2\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x84"],
        ["\xC2\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x85"],
        ["\xC2\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x98"],
        ["\xC2\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9E"],
        ["\xC2\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x93"],
        ["\xC2\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xA2"],
        ["\xC2\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAF"],
        ["\xC2\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA2"],
        ["\xC2\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x97"],
        ["\xC2\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB8"],
        ["\xC2\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x81"],
        ["\xC2\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBE"],
        ["\xC2\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB8"],
        ["\xC2\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA7"],
        ["\xC2\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xB8"],
        ["\xC2\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAA"],
        ["\xC3\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA9"],
        ["\xC3\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x86"],
        ["\xC3\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x94"],
        ["\xC3\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB0"],
        ["\xC3\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAA"],
        ["\xC3\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB1"],
        ["\xC3\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBD"],
        ["\xC3\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAA"],
        ["\xC3\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBF"],
        ["\xC3\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x9A"],
        ["\xC3\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xB7"],
        ["\xC3\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB8"],
        ["\xC3\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x88"],
        ["\xC3\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBD"],
        ["\xC3\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB0"],
        ["\xC3\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB9"],
        ["\xC3\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x98"],
        ["\xC3\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x86"],
        ["\xC3\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA6"],
        ["\xC3\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x85"],
        ["\xC3\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA2"],
        ["\xC3\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA6"],
        ["\xC3\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8E"],
        ["\xC3\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA1"],
        ["\xC3\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9B"],
        ["\xC3\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAD"],
        ["\xC3\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAD"],
        ["\xC3\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAF"],
        ["\xC3\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAA"],
        ["\xC3\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBB"],
        ["\xC3\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBD"],
        ["\xC3\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x86"],
        ["\xC3\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8B"],
        ["\xC3\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x95"],
        ["\xC3\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x9B"],
        ["\xC3\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA3"],
        ["\xC3\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x87"],
        ["\xC3\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBE"],
        ["\xC3\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAD"],
        ["\xC3\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x96"],
        ["\xC3\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x80"],
        ["\xC3\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB5"],
        ["\xC3\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB7"],
        ["\xC3\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x87"],
        ["\xC3\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA4"],
        ["\xC3\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA5"],
        ["\xC3\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB0"],
        ["\xC3\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9B"],
        ["\xC3\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA5"],
        ["\xC3\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xBA"],
        ["\xC3\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA0"],
        ["\xC3\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB4"],
        ["\xC3\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9A"],
        ["\xC3\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAE"],
        ["\xC3\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xB4"],
        ["\xC3\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x98"],
        ["\xC3\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x85"],
        ["\xC3\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xB3"],
        ["\xC3\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x89"],
        ["\xC3\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9C"],
        ["\xC3\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB9"],
        ["\xC3\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x91"],
        ["\xC3\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x84"],
        ["\xC3\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x90"],
        ["\xC3\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA9"],
        ["\xC3\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x92"],
        ["\xC3\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB6"],
        ["\xC3\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA1"],
        ["\xC3\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x80"],
        ["\xC3\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAD"],
        ["\xC3\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB2"],
        ["\xC3\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x99"],
        ["\xC3\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA0"],
        ["\xC3\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBD"],
        ["\xC3\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBC"],
        ["\xC3\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB1"],
        ["\xC3\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA8"],
        ["\xC3\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xAB"],
        ["\xC3\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB7"],
        ["\xC3\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBB"],
        ["\xC3\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8E"],
        ["\xC3\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB3"],
        ["\xC3\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x90"],
        ["\xC3\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x97"],
        ["\xC3\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA6"],
        ["\xC3\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAA"],
        ["\xC3\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA7"],
        ["\xC3\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x97"],
        ["\xC3\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAF"],
        ["\xC3\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x81"],
        ["\xC3\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x86"],
        ["\xC3\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8B"],
        ["\xC3\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8B"],
        ["\xC3\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB5"],
        ["\xC4\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x96"],
        ["\xC4\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB3"],
        ["\xC4\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x81"],
        ["\xC4\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x94"],
        ["\xC4\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB5"],
        ["\xC4\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAB"],
        ["\xC4\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB4"],
        ["\xC4\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB2"],
        ["\xC4\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x91"],
        ["\xC4\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA2"],
        ["\xC4\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9D"],
        ["\xC4\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAE"],
        ["\xC4\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x92"],
        ["\xC4\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBA"],
        ["\xC4\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xBA"],
        ["\xC4\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB4"],
        ["\xC4\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB9"],
        ["\xC4\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB8"],
        ["\xC4\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB6"],
        ["\xC4\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBF"],
        ["\xC4\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9C"],
        ["\xC4\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x85"],
        ["\xC4\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xB3"],
        ["\xC4\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9A"],
        ["\xC4\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x95\xB7"],
        ["\xC4\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x82"],
        ["\xC4\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA5"],
        ["\xC4\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x85"],
        ["\xC4\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x97"],
        ["\xC4\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB4"],
        ["\xC4\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x95"],
        ["\xC4\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x88"],
        ["\xC4\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8D"],
        ["\xC4\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x83"],
        ["\xC4\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAE"],
        ["\xC4\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB3"],
        ["\xC4\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA5"],
        ["\xC4\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9C"],
        ["\xC4\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8E"],
        ["\xC4\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8C"],
        ["\xC4\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xBD"],
        ["\xC4\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x9A"],
        ["\xC4\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9B"],
        ["\xC4\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9A"],
        ["\x86\xEB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x9A"],
        ["\xC4\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x82"],
        ["\xC4\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB4"],
        ["\xC4\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBB"],
        ["\xC4\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x83"],
        ["\xC4\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAC"],
        ["\xC4\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x98"],
        ["\xC4\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBB"],
        ["\xC4\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA6"],
        ["\xC4\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB4"],
        ["\xC4\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x94"],
        ["\xC4\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBF"],
        ["\xC4\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB0"],
        ["\xC4\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xAA"],
        ["\xE3\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB7"],
        ["\xC4\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAC"],
        ["\xC4\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAC"],
        ["\xC4\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAA"],
        ["\xC4\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8A"],
        ["\xC4\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA3"],
        ["\xC4\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB4"],
        ["\xC4\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAD"],
        ["\xC4\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8E"],
        ["\xC4\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x9C"],
        ["\xC4\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB5"],
        ["\xC4\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x83"],
        ["\xC4\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x9E"],
        ["\xC4\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x88"],
        ["\xC4\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA4"],
        ["\xC4\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9A"],
        ["\xC4\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9D"],
        ["\xC4\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x95"],
        ["\xC4\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAD"],
        ["\xC4\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB7"],
        ["\xC4\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9F"],
        ["\xC4\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8C"],
        ["\xC4\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB5"],
        ["\xC4\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBA"],
        ["\xC4\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x90"],
        ["\xC4\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAF"],
        ["\xC4\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x80"],
        ["\xC4\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x87"],
        ["\xC4\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8E"],
        ["\xC4\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8B"],
        ["\xC4\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA0"],
        ["\xC4\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x87"],
        ["\xC4\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x82"],
        ["\xC4\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA6"],
        ["\xC4\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x84"],
        ["\xC4\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x93"],
        ["\xC5\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB8"],
        ["\xC5\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xAD"],
        ["\xC5\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x98"],
        ["\xC5\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x8E"],
        ["\xC5\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA5"],
        ["\xC5\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x98"],
        ["\xC5\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA2"],
        ["\xC5\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB5"],
        ["\xC5\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB4"],
        ["\xC5\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x84"],
        ["\xC5\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x9B"],
        ["\xC5\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA9"],
        ["\xC5\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x91"],
        ["\xC5\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBA"],
        ["\xC5\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xB2"],
        ["\xC5\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB9"],
        ["\xC5\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA4"],
        ["\xC5\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8D"],
        ["\xC5\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAD"],
        ["\xC5\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x84"],
        ["\xC5\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB8"],
        ["\xAC\xB8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xAB"],
        ["\xC5\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA9"],
        ["\xC5\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x95"],
        ["\xC5\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x97"],
        ["\xC5\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBB"],
        ["\xC5\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8F"],
        ["\xC5\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9C"],
        ["\xC5\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBC"],
        ["\xC5\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xA2"],
        ["\xA9\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9B"],
        ["\xC5\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB9"],
        ["\xC5\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9D"],
        ["\xC5\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBF"],
        ["\xC5\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB1"],
        ["\xC5\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB0"],
        ["\xC5\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xBB"],
        ["\xC5\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8E"],
        ["\xC5\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x90"],
        ["\xC5\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB5"],
        ["\xC5\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x97"],
        ["\xC5\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xAC"],
        ["\xC5\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA0"],
        ["\xC5\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x92"],
        ["\xC5\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x97"],
        ["\xC5\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9C"],
        ["\xC5\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA1"],
        ["\xC5\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBB"],
        ["\xC5\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9F"],
        ["\xC5\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xAD"],
        ["\xC5\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x94"],
        ["\xC5\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xBD"],
        ["\xC5\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8D"],
        ["\xC5\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA5"],
        ["\x59\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xBA"],
        ["\xC5\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAA"],
        ["\xC5\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA6"],
        ["\xC5\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x9F"],
        ["\xC5\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB4"],
        ["\xC5\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x92"],
        ["\xC5\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x92"],
        ["\xC5\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x9A"],
        ["\xC5\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAC"],
        ["\xC5\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8D"],
        ["\xC5\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x80"],
        ["\xC5\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x90"],
        ["\xC5\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x94"],
        ["\xC5\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x98"],
        ["\xC5\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x97"],
        ["\xC5\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x95"],
        ["\xC5\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB6"],
        ["\xC5\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x8B"],
        ["\xC5\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBC"],
        ["\xC5\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x95"],
        ["\xC5\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAD"],
        ["\xC5\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB1"],
        ["\xC5\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x83"],
        ["\x4A\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBC"],
        ["\xC5\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x9F"],
        ["\xC5\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x97"],
        ["\xC5\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x98"],
        ["\xC5\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAF"],
        ["\x5F\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x9B"],
        ["\xC5\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAF"],
        ["\xC5\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x88"],
        ["\xC5\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x93"],
        ["\xC5\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x98"],
        ["\xC5\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xB7"],
        ["\xC5\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x89"],
        ["\xC5\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x94"],
        ["\xC5\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x92"],
        ["\xC5\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x96"],
        ["\xC5\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB1"],
        ["\xC5\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB0"],
        ["\xC6\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA3"],
        ["\xC6\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA9"],
        ["\xC6\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA4"],
        ["\xC6\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8E"],
        ["\xC6\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x84"],
        ["\xC6\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x86"],
        ["\xC6\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x8F"],
        ["\xC6\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x83"],
        ["\xC6\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8F"],
        ["\xC6\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x99"],
        ["\xC6\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB6"],
        ["\xC6\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAD"],
        ["\xC6\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB0"],
        ["\xC6\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x98"],
        ["\xC6\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8D"],
        ["\xC6\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x95"],
        ["\xC6\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8C"],
        ["\xC6\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x82"],
        ["\xC6\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8E"],
        ["\xC6\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA7"],
        ["\xC6\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9E"],
        ["\xC6\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9E"],
        ["\xC6\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB3"],
        ["\xC6\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA5"],
        ["\xC6\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB4"],
        ["\xC6\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x84"],
        ["\xC6\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x93"],
        ["\xC6\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x85"],
        ["\xC6\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA0"],
        ["\xC6\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x87"],
        ["\xC6\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBF"],
        ["\xC6\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x97"],
        ["\xC6\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB3"],
        ["\xC6\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x9C"],
        ["\xC6\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB9"],
        ["\xC6\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA3"],
        ["\xC6\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBF"],
        ["\xC6\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA4"],
        ["\xC6\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x92"],
        ["\xC6\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xAC"],
        ["\xC6\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAD"],
        ["\xC6\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x83"],
        ["\xC6\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA1"],
        ["\xC6\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB8"],
        ["\xC6\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x81"],
        ["\xC6\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB4"],
        ["\xC6\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8A"],
        ["\xC6\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB6"],
        ["\xC6\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xAB"],
        ["\xC6\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x85"],
        ["\xC6\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x89"],
        ["\xC6\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9E"],
        ["\xC6\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB8"],
        ["\xC6\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAF"],
        ["\xC6\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x87"],
        ["\xC6\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA6"],
        ["\xC6\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x8C"],
        ["\xC6\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x9A"],
        ["\xC6\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x81"],
        ["\xC6\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x93"],
        ["\xC6\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x91"],
        ["\xC6\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x87"],
        ["\xC6\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8D"],
        ["\xC6\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x88"],
        ["\xC6\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA3"],
        ["\xC6\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x85"],
        ["\xC6\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8D"],
        ["\xC6\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAA"],
        ["\xC6\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x99"],
        ["\xC6\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8E"],
        ["\xC6\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x98"],
        ["\xC6\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBA"],
        ["\xC6\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8B"],
        ["\xC6\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA2"],
        ["\xC6\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xB4"],
        ["\xC6\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x84"],
        ["\xC6\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB7"],
        ["\xC6\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x97"],
        ["\xC6\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA0"],
        ["\xC6\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x9F"],
        ["\xC6\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA3"],
        ["\xC6\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9D"],
        ["\xC6\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8C"],
        ["\xC6\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBC"],
        ["\xC6\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x90"],
        ["\x72\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA9"],
        ["\xC6\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x82"],
        ["\xC6\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x91"],
        ["\xC6\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x89"],
        ["\xC6\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB9"],
        ["\xC6\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBF"],
        ["\xC6\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA5"],
        ["\xC6\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xB3"],
        ["\xC6\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA5"],
        ["\xC7\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x82"],
        ["\xC7\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBF"],
        ["\xC7\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xAE"],
        ["\xC7\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBB"],
        ["\xC7\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8A"],
        ["\xC7\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8D"],
        ["\xC7\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x8D"],
        ["\xC7\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA1"],
        ["\xC7\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB0"],
        ["\xC7\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA2"],
        ["\xC7\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA7"],
        ["\xC7\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB1"],
        ["\xC7\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAB"],
        ["\xC7\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB1"],
        ["\xC7\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB4"],
        ["\xC7\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB5"],
        ["\xC7\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBB"],
        ["\xC7\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9A"],
        ["\xC7\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x83"],
        ["\xC7\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x98"],
        ["\xC7\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x83"],
        ["\xC7\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBC"],
        ["\xC7\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8B"],
        ["\xC7\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9C"],
        ["\xC7\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA2"],
        ["\xC7\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA9"],
        ["\xC7\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x83"],
        ["\xC7\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8D"],
        ["\xC7\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBD"],
        ["\xC7\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB3"],
        ["\xC7\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBF"],
        ["\xC7\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB2"],
        ["\xC7\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x97"],
        ["\xC7\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA4"],
        ["\xC7\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB4"],
        ["\xC7\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x8A"],
        ["\xC7\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAD"],
        ["\xC7\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x87"],
        ["\xC7\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB7"],
        ["\xC7\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA2"],
        ["\xC7\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBE"],
        ["\xC7\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB6"],
        ["\xC7\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xB4"],
        ["\xC7\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x86"],
        ["\xC7\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB5"],
        ["\xC7\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAD"],
        ["\xC7\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAC"],
        ["\xC7\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB3"],
        ["\xC7\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x83"],
        ["\xC7\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9D"],
        ["\xC7\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x92"],
        ["\xC7\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x97"],
        ["\xC7\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAF"],
        ["\xC7\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x83"],
        ["\xC7\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x8C"],
        ["\xC7\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8C"],
        ["\xC7\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xBA"],
        ["\xC7\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xA9"],
        ["\xC7\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8D"],
        ["\xC7\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8D"],
        ["\xC7\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB9"],
        ["\xC7\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x92"],
        ["\xC7\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x85"],
        ["\xC7\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB3"],
        ["\xC7\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA4"],
        ["\xC7\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBD"],
        ["\xC7\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB7"],
        ["\xC7\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB2"],
        ["\xC7\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA0"],
        ["\xC7\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xAA"],
        ["\xC7\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x99"],
        ["\x69\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xBF"],
        ["\xC7\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA4"],
        ["\xC7\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA7"],
        ["\xC7\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA9"],
        ["\xC7\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xAF"],
        ["\xC7\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA5"],
        ["\xC7\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9A"],
        ["\xC7\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8D"],
        ["\xC7\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8F"],
        ["\xC7\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x8A"],
        ["\xC7\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBD"],
        ["\xC7\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x94"],
        ["\xC7\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x95"],
        ["\xC7\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB6"],
        ["\xC7\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x84"],
        ["\xC7\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAB"],
        ["\xC7\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9D"],
        ["\xC7\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA0"],
        ["\xC7\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x86"],
        ["\xC7\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9B"],
        ["\xC7\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xAB"],
        ["\xC7\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x81"],
        ["\xC7\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA6"],
        ["\xC8\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBD"],
        ["\xC8\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB1"],
        ["\xC8\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xB2"],
        ["\xC8\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB8"],
        ["\xC8\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x87"],
        ["\xC8\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x88"],
        ["\xC8\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA8"],
        ["\xC8\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA1"],
        ["\xC8\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x8C"],
        ["\xC8\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x91"],
        ["\xC8\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA0"],
        ["\xC8\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAB"],
        ["\xC8\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA2"],
        ["\xC8\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x8C"],
        ["\xC8\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBA"],
        ["\xC8\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x97"],
        ["\xC8\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAA"],
        ["\xC8\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x90"],
        ["\xC8\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB0"],
        ["\xC8\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9C"],
        ["\xC8\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8F"],
        ["\xC8\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA5"],
        ["\xC8\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA9"],
        ["\xC8\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xBA"],
        ["\xC8\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x99"],
        ["\xC8\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA4"],
        ["\xC8\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xBC"],
        ["\xC8\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB4"],
        ["\xC8\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA4"],
        ["\xC8\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x8A"],
        ["\xC8\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8D"],
        ["\xC8\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9B"],
        ["\xC8\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x86"],
        ["\xC8\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAC"],
        ["\xC8\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x91"],
        ["\xC8\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBF"],
        ["\xC8\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xBE"],
        ["\xC8\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x8E"],
        ["\xC8\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x88"],
        ["\xC8\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAF"],
        ["\xC8\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAD"],
        ["\xC8\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x94"],
        ["\xC8\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x81"],
        ["\xC8\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAC"],
        ["\xC8\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA9"],
        ["\xC8\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA9"],
        ["\xC8\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x84"],
        ["\xC8\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x86"],
        ["\xC8\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA9"],
        ["\xC8\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x92"],
        ["\xC8\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAF"],
        ["\xC8\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBD"],
        ["\xC8\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA9"],
        ["\xC8\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAA"],
        ["\xC8\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA4"],
        ["\xC8\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x90"],
        ["\xC8\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x83"],
        ["\xC8\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAE"],
        ["\xC8\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xAA"],
        ["\xC8\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x91"],
        ["\xC8\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA6"],
        ["\xC8\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x83"],
        ["\xC8\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x87"],
        ["\xC8\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBC"],
        ["\xC8\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB2"],
        ["\xC8\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x89"],
        ["\xC8\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB9"],
        ["\xC8\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xAB"],
        ["\xC8\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x90"],
        ["\xC8\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x94"],
        ["\xC8\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x8C"],
        ["\xC8\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB2"],
        ["\xC8\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xAE"],
        ["\xC8\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x91"],
        ["\xC8\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x98"],
        ["\xC8\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8B"],
        ["\xC8\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB7"],
        ["\xC8\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA5"],
        ["\xC8\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAB"],
        ["\xC8\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB9"],
        ["\xC8\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBB"],
        ["\xC8\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBF"],
        ["\xC8\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x9E"],
        ["\xC8\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9B"],
        ["\xC8\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8B"],
        ["\xC8\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB8"],
        ["\xC8\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x99"],
        ["\xC8\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBE"],
        ["\xC8\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAE"],
        ["\xC8\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x87"],
        ["\xC8\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x98"],
        ["\xC8\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB5"],
        ["\xC8\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x89"],
        ["\xC8\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8E"],
        ["\xC9\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xBB"],
        ["\xC9\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8A"],
        ["\xC9\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x97"],
        ["\xC9\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB9"],
        ["\xC9\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8B"],
        ["\xC9\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAD"],
        ["\xC9\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA6"],
        ["\xC9\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9D"],
        ["\xC9\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB1"],
        ["\xC9\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x98"],
        ["\xC9\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBC"],
        ["\xC9\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x85"],
        ["\xC9\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA2"],
        ["\xC9\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x86"],
        ["\xC9\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xBC"],
        ["\x4A\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xA7"],
        ["\xC9\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAB"],
        ["\xC9\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9B"],
        ["\xC9\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x90"],
        ["\xC9\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBE"],
        ["\xC9\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAC"],
        ["\xC9\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB5"],
        ["\xC9\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAA"],
        ["\xC9\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x99"],
        ["\xC9\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB7"],
        ["\xC9\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x82"],
        ["\xC9\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA2"],
        ["\xC9\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA8"],
        ["\xC9\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA8"],
        ["\xC9\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x95"],
        ["\xC9\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xB9"],
        ["\xC9\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9F"],
        ["\xC9\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x8F"],
        ["\xC9\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x85"],
        ["\xC9\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x92"],
        ["\xC9\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x97"],
        ["\xC9\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA8"],
        ["\xC9\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB2"],
        ["\xC9\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9C"],
        ["\xC9\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAD"],
        ["\xC9\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAD"],
        ["\xC9\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x81"],
        ["\xC9\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAC"],
        ["\xC9\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8C"],
        ["\xC9\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9C"],
        ["\xC9\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x95"],
        ["\xC9\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA7"],
        ["\xC9\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x93"],
        ["\xC9\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBB"],
        ["\xC9\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8F"],
        ["\xC9\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB6"],
        ["\xC9\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8D"],
        ["\xC9\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x98"],
        ["\xC9\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA0"],
        ["\xC9\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAB"],
        ["\xC9\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA6"],
        ["\xC9\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x8C"],
        ["\xC9\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA8"],
        ["\xC9\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x83"],
        ["\xC9\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x9C"],
        ["\xC9\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x96"],
        ["\xC9\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB6"],
        ["\xC9\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB7"],
        ["\xC9\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA7"],
        ["\xC9\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAE"],
        ["\xC9\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAE"],
        ["\xC9\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB6"],
        ["\xC9\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA6"],
        ["\xC9\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x90"],
        ["\xC9\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9A"],
        ["\xC9\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x99"],
        ["\xC9\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9C"],
        ["\xC9\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA0"],
        ["\xC9\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA6"],
        ["\xC9\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB4"],
        ["\xC9\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\x9C"],
        ["\xC9\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x84"],
        ["\xC9\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAE"],
        ["\xC9\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAB"],
        ["\xC9\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA6"],
        ["\xC9\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9E"],
        ["\xC9\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA1"],
        ["\xC9\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAA"],
        ["\xC9\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA8"],
        ["\xC9\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x81"],
        ["\xC9\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x93"],
        ["\xC9\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xA8"],
        ["\xC9\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xBA"],
        ["\xC9\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x97"],
        ["\xC9\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8F"],
        ["\xC9\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAF"],
        ["\xC9\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA9"],
        ["\xC9\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x85"],
        ["\xC9\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8D"],
        ["\xD1\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8F"],
        ["\xD1\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB9"],
        ["\xD1\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x87"],
        ["\xD1\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x86"],
        ["\xD1\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB5"],
        ["\xD1\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x97"],
        ["\xD1\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x95"],
        ["\xD1\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB8"],
        ["\xD1\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8F"],
        ["\xD1\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA9"],
        ["\xD1\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x92"],
        ["\xD1\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x86"],
        ["\xD1\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBB"],
        ["\xD1\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB4"],
        ["\xD1\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB3"],
        ["\xD1\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA4"],
        ["\xD1\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xAE"],
        ["\xD1\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9A"],
        ["\xD1\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAE"],
        ["\xD1\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x89"],
        ["\xD1\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9E"],
        ["\xD1\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9B"],
        ["\xD1\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB0"],
        ["\xD1\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x87"],
        ["\xD1\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9E"],
        ["\xD1\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x99"],
        ["\xD1\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB5"],
        ["\xD1\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB5"],
        ["\xD1\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x80"],
        ["\xD1\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA3"],
        ["\xD1\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB3"],
        ["\xD1\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8A"],
        ["\xD1\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x84"],
        ["\xD1\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA6"],
        ["\xD1\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xBD"],
        ["\xD1\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x89"],
        ["\xD1\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9B"],
        ["\xD1\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB3"],
        ["\xD1\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x81"],
        ["\xD1\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xBB"],
        ["\xD1\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x81"],
        ["\xD1\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x96"],
        ["\xD1\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA7"],
        ["\xD1\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA5"],
        ["\xD1\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA5"],
        ["\xD1\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x91"],
        ["\xD1\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x86"],
        ["\xD1\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x8F"],
        ["\xD1\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x89"],
        ["\xD1\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x87"],
        ["\xD1\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x87"],
        ["\xD1\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA8"],
        ["\xD1\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBA"],
        ["\xD1\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x94"],
        ["\xD1\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8D"],
        ["\xD1\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xBF"],
        ["\xD1\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x89"],
        ["\xD1\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA9"],
        ["\xD1\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x81"],
        ["\xD1\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAD"],
        ["\xD1\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9D"],
        ["\xD1\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x97"],
        ["\xD1\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xAA"],
        ["\xD1\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x83"],
        ["\xD1\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x95"],
        ["\xD1\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA9"],
        ["\xD1\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAB"],
        ["\xD1\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9C"],
        ["\xD1\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x94"],
        ["\xD1\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x82"],
        ["\xD1\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9F"],
        ["\xD1\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x93"],
        ["\xD1\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x95"],
        ["\xD1\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8A"],
        ["\xD1\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAE"],
        ["\xD1\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8D"],
        ["\xD1\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBF"],
        ["\xD1\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA9"],
        ["\xD1\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA3"],
        ["\xD1\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB8"],
        ["\xD1\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x85"],
        ["\xD1\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x86"],
        ["\xD1\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB1"],
        ["\xD1\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x89"],
        ["\xD1\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9D"],
        ["\xD1\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB0"],
        ["\xD1\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAF"],
        ["\xD1\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA9"],
        ["\xD1\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x96"],
        ["\xD1\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB1"],
        ["\xD1\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA7"],
        ["\xD1\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBE"],
        ["\xD1\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB9"],
        ["\xD1\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8B"],
        ["\xD2\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x95"],
        ["\xD2\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA1"],
        ["\xD2\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xB9"],
        ["\xD2\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xB2"],
        ["\xD2\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAB"],
        ["\xD2\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9E"],
        ["\xD2\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB3"],
        ["\xD2\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8C"],
        ["\xD2\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAC"],
        ["\xD2\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x82"],
        ["\xD2\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x92"],
        ["\xD2\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xAA"],
        ["\xD2\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8A"],
        ["\xD2\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA6"],
        ["\xD2\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x92"],
        ["\xD2\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBD"],
        ["\xD2\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB3"],
        ["\xD2\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAC"],
        ["\xD2\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8F"],
        ["\xD2\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA1"],
        ["\xD2\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x8D"],
        ["\xD2\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x96"],
        ["\xD2\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8A"],
        ["\xD2\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA8"],
        ["\xD2\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xBD"],
        ["\xD2\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x98"],
        ["\xD2\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x99"],
        ["\xD2\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBF"],
        ["\xD2\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB4"],
        ["\xD2\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9B"],
        ["\xD2\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x90"],
        ["\xD2\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x92"],
        ["\xD2\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x92"],
        ["\xD2\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA1"],
        ["\xD2\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAA"],
        ["\xD2\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA8"],
        ["\xD2\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x80"],
        ["\xD2\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8C"],
        ["\xD2\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBF"],
        ["\xD2\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xBE"],
        ["\xD2\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xB2"],
        ["\xD2\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA0"],
        ["\xD2\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAC"],
        ["\xD2\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x97"],
        ["\xD2\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x95"],
        ["\xD2\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9C"],
        ["\xD2\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xA8"],
        ["\xD2\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB2"],
        ["\xD2\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB4"],
        ["\xD2\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA7"],
        ["\xD2\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA6"],
        ["\xD2\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x86"],
        ["\xD2\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA6"],
        ["\xD2\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x83"],
        ["\xD2\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xA1"],
        ["\xD2\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x86"],
        ["\xD2\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x80"],
        ["\xD2\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x8C"],
        ["\xD2\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x94"],
        ["\xD2\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAC"],
        ["\xD2\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBB"],
        ["\xD2\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA1"],
        ["\xD2\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x86"],
        ["\xD2\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA9"],
        ["\xD2\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA8"],
        ["\xD2\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x94"],
        ["\xD2\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBB"],
        ["\xD2\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8B"],
        ["\xD2\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xB9"],
        ["\xD2\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA7"],
        ["\xD2\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9A"],
        ["\xD2\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8E"],
        ["\xD2\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA9"],
        ["\x90\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x99"],
        ["\xD2\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x95"],
        ["\xD2\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9C"],
        ["\xD2\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x95"],
        ["\xD2\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAA"],
        ["\xD2\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBE"],
        ["\xD2\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x92"],
        ["\xD2\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9D"],
        ["\xD2\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA6"],
        ["\xD2\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA3"],
        ["\xD2\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x88"],
        ["\xD2\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB9"],
        ["\xD2\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAB"],
        ["\xD2\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAB"],
        ["\xD2\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x84"],
        ["\xD7\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAD"],
        ["\xD2\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAD"],
        ["\xD2\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBF"],
        ["\xD2\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x87"],
        ["\xD2\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA2"],
        ["\xD2\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x80"],
        ["\xD3\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAB"],
        ["\xD3\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x93"],
        ["\xD3\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB3"],
        ["\xD3\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAA"],
        ["\xD3\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x85"],
        ["\xD3\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB3"],
        ["\xD3\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x95"],
        ["\xD3\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAC"],
        ["\xD3\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x86"],
        ["\xD3\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9C"],
        ["\xD3\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8A"],
        ["\xD3\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x91"],
        ["\xD3\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x94"],
        ["\xD3\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x88"],
        ["\xD3\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x99"],
        ["\xD3\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8D"],
        ["\xD3\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x91"],
        ["\xD3\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA0"],
        ["\xD3\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x99"],
        ["\xD3\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA2"],
        ["\xD3\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA1"],
        ["\xD3\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9F"],
        ["\xD3\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9B"],
        ["\xD3\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xA7"],
        ["\xD3\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA1"],
        ["\xD3\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8B"],
        ["\xD3\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xBF"],
        ["\xD3\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x98"],
        ["\xD3\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA5"],
        ["\xD3\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8D"],
        ["\xD3\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBD"],
        ["\xD3\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8E"],
        ["\xD3\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9F"],
        ["\xD3\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB7"],
        ["\xD3\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x98"],
        ["\xD3\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB4"],
        ["\xD3\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAA"],
        ["\xD3\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9D"],
        ["\xD3\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x85"],
        ["\xD3\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8D"],
        ["\xD3\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x89"],
        ["\xD3\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBF"],
        ["\xD3\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xAC"],
        ["\xD3\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA2"],
        ["\xD3\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBA"],
        ["\xD3\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB8"],
        ["\xD3\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA1"],
        ["\xD3\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x82"],
        ["\xD3\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x84"],
        ["\xD3\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9F"],
        ["\xD3\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9B"],
        ["\xD3\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9B"],
        ["\xD3\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB2"],
        ["\xD3\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB2"],
        ["\xD3\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x97"],
        ["\xD3\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x99"],
        ["\xD3\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB2"],
        ["\xD3\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA8"],
        ["\xD3\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x99"],
        ["\xD3\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAE"],
        ["\xD3\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA2"],
        ["\xD3\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBF"],
        ["\xD3\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x85"],
        ["\xD3\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA4"],
        ["\xD3\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBB"],
        ["\xD3\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xBE"],
        ["\xD3\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB0"],
        ["\xD3\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8F"],
        ["\xD3\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB6"],
        ["\xD3\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8B"],
        ["\xD3\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x80"],
        ["\xD3\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x81"],
        ["\xD3\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9F"],
        ["\xD3\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB6"],
        ["\xD3\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9C"],
        ["\xD3\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBA"],
        ["\xD3\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB6"],
        ["\xD3\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8E"],
        ["\xD3\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA5"],
        ["\xD3\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA2"],
        ["\xD3\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x84"],
        ["\xD3\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB9"],
        ["\xD3\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x84"],
        ["\xD3\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAC"],
        ["\xD3\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB3"],
        ["\xD3\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8D"],
        ["\xD3\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x96"],
        ["\xD3\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB3"],
        ["\x68\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAE"],
        ["\xD3\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x93"],
        ["\xD3\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x89"],
        ["\xD3\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x88"],
        ["\xD3\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB9"],
        ["\xD3\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x92"],
        ["\xD4\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAD"],
        ["\xD4\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB8"],
        ["\xD4\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAF"],
        ["\xD4\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x91"],
        ["\xD4\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xAA"],
        ["\xD4\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x87"],
        ["\xD4\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8B"],
        ["\xD4\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA5"],
        ["\xD4\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBD"],
        ["\xD4\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA0"],
        ["\xD4\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x82"],
        ["\xD4\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x96"],
        ["\xD4\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x89"],
        ["\xD4\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9A"],
        ["\xD4\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xA7"],
        ["\xD4\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8C"],
        ["\xD4\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB6"],
        ["\xD4\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB7"],
        ["\xD4\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB1"],
        ["\xD4\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x90"],
        ["\xD4\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x95"],
        ["\xD4\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x98"],
        ["\xD4\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8A"],
        ["\xD4\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x91"],
        ["\xD4\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB5"],
        ["\xD4\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x84"],
        ["\xD4\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x8D"],
        ["\xD4\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x95"],
        ["\xD4\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x88"],
        ["\xD4\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x99"],
        ["\xD4\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8E"],
        ["\xD4\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x89"],
        ["\xD4\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBF"],
        ["\xD4\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x90"],
        ["\xD4\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAD"],
        ["\xD4\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBC"],
        ["\xD4\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x96"],
        ["\xD4\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB9"],
        ["\xD4\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB8"],
        ["\xD4\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9A"],
        ["\xD4\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xBA"],
        ["\xD4\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x81"],
        ["\xD4\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9C"],
        ["\xD4\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x8A"],
        ["\xD4\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x98"],
        ["\xD4\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8B"],
        ["\xD4\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB6"],
        ["\xD4\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x94"],
        ["\xD4\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA8"],
        ["\xD4\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAF"],
        ["\xD4\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8A"],
        ["\xD4\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x80"],
        ["\xD4\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x89"],
        ["\xD4\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x89"],
        ["\xD4\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x81"],
        ["\xD4\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA1"],
        ["\xD4\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x8A"],
        ["\xA5\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA5"],
        ["\xD4\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xBD"],
        ["\xD4\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x8A"],
        ["\xD4\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xBE"],
        ["\xD4\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x91"],
        ["\xD4\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB2"],
        ["\xD4\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x83"],
        ["\xD4\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB4"],
        ["\xD4\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8C"],
        ["\xD4\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBC"],
        ["\xD4\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x80"],
        ["\xD4\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x85"],
        ["\xD4\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBA"],
        ["\xD4\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB8"],
        ["\xD4\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA5"],
        ["\xD4\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xB1"],
        ["\xD4\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBC"],
        ["\xD4\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB7"],
        ["\xD4\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9B"],
        ["\xD4\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA1"],
        ["\xD4\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xBD"],
        ["\xD4\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xAA"],
        ["\xD4\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xB1"],
        ["\xD4\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB5"],
        ["\xD4\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x90"],
        ["\xD4\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x84"],
        ["\xD4\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAB"],
        ["\xD4\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8D"],
        ["\xD4\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xAD"],
        ["\xD4\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA7"],
        ["\xD4\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA9"],
        ["\xD4\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8F"],
        ["\xD4\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA5"],
        ["\xD4\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8E"],
        ["\xD4\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA8"],
        ["\xD4\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x86"],
        ["\xD4\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x83"],
        ["\xD5\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA2"],
        ["\xD5\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x8F"],
        ["\xD5\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xA1"],
        ["\xD5\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8C"],
        ["\xD5\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA2"],
        ["\xD5\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB8"],
        ["\xD5\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8B"],
        ["\xD5\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x87"],
        ["\xD5\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8B"],
        ["\xD5\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x8E"],
        ["\xD5\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA0"],
        ["\xD5\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA5"],
        ["\xD5\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x89"],
        ["\xD5\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x81"],
        ["\xD5\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9C"],
        ["\xD5\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x89"],
        ["\xD5\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x99"],
        ["\xD5\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAB"],
        ["\xD5\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x92"],
        ["\xD5\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x86"],
        ["\xD5\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9C"],
        ["\xD5\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x8D"],
        ["\xD5\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB6"],
        ["\xD5\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAE"],
        ["\xD5\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x85"],
        ["\xD5\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9C"],
        ["\xD5\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x86"],
        ["\xD5\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAE"],
        ["\xD5\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x9A"],
        ["\xD5\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA1"],
        ["\xD5\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8C"],
        ["\xD5\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAE"],
        ["\xD5\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x99"],
        ["\xD5\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x81"],
        ["\xD5\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xBC"],
        ["\xD5\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9F"],
        ["\xD5\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x82"],
        ["\xD5\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAD"],
        ["\xD5\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9C"],
        ["\xD5\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA7"],
        ["\xD5\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAF"],
        ["\xD5\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x92"],
        ["\xD5\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBC"],
        ["\xD5\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8F"],
        ["\xD5\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB5"],
        ["\xD5\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x98"],
        ["\xD5\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9B"],
        ["\xD5\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x91"],
        ["\xD5\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAB"],
        ["\xD5\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x98"],
        ["\xD5\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x97"],
        ["\xD5\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8B"],
        ["\xD5\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x90"],
        ["\xD5\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB3"],
        ["\xD5\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA8"],
        ["\xD5\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAA"],
        ["\xD5\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA3"],
        ["\xD5\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x97"],
        ["\xD5\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9F"],
        ["\xD5\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA0"],
        ["\xD5\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x81"],
        ["\xD5\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x99"],
        ["\xD5\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAF"],
        ["\xD5\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9E"],
        ["\xD5\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA4"],
        ["\xD5\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB6"],
        ["\xD5\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8B"],
        ["\xD5\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB7"],
        ["\xD5\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB1"],
        ["\xD5\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBA"],
        ["\xD5\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9C"],
        ["\xD5\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB2"],
        ["\xD5\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBC"],
        ["\xD5\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x93"],
        ["\xD5\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB4"],
        ["\xD5\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB7"],
        ["\xD5\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB6"],
        ["\xD5\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8A"],
        ["\xD5\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x97"],
        ["\xD5\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA2"],
        ["\xD5\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA6"],
        ["\xD5\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB4"],
        ["\xD5\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x97"],
        ["\xD5\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA3"],
        ["\xD5\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x88"],
        ["\xD5\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x82"],
        ["\xD5\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x89"],
        ["\xD5\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8B"],
        ["\xD5\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x90"],
        ["\xD5\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA3"],
        ["\xD5\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x89"],
        ["\xD5\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBE"],
        ["\xD5\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB4"],
        ["\xD5\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xAF"],
        ["\xD6\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAE"],
        ["\xD6\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA3"],
        ["\xD6\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAC"],
        ["\xD6\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x82"],
        ["\xD6\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xAF"],
        ["\xD6\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x93"],
        ["\xD6\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x89"],
        ["\xD6\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x82"],
        ["\xD6\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAF"],
        ["\xD6\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB2"],
        ["\xD6\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB4"],
        ["\xD6\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x81"],
        ["\xD6\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8A"],
        ["\xD6\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x84"],
        ["\xD6\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x97"],
        ["\xD6\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBC"],
        ["\xD6\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x94"],
        ["\xD6\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAA"],
        ["\xD6\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x8F"],
        ["\xD6\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA2"],
        ["\xD6\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBC"],
        ["\x63\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xAD"],
        ["\xD6\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x81"],
        ["\xD6\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBE"],
        ["\xD6\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8B"],
        ["\xD6\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x8E"],
        ["\xD6\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAD"],
        ["\xD6\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x93"],
        ["\xD6\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x84"],
        ["\xD6\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x8B"],
        ["\xD6\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xB2"],
        ["\xD6\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x96"],
        ["\xD6\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAD"],
        ["\xD6\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8C"],
        ["\xD6\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB1"],
        ["\xD6\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAA"],
        ["\xD6\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x84"],
        ["\xD6\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x87"],
        ["\xD6\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x91"],
        ["\xD6\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA0"],
        ["\xD6\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB2"],
        ["\xD6\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x99"],
        ["\xD6\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x98"],
        ["\xD6\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x90"],
        ["\xD6\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAB"],
        ["\xD6\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x81"],
        ["\xD6\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA8"],
        ["\xD6\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x80"],
        ["\xD6\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xBE"],
        ["\xD6\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x97"],
        ["\xD6\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x95"],
        ["\xD7\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8C"],
        ["\xD7\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x90"],
        ["\xD7\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x95"],
        ["\xD7\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAA"],
        ["\xD7\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB1"],
        ["\xD7\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB6"],
        ["\xD7\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBC"],
        ["\xD7\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBF"],
        ["\xD7\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x82"],
        ["\xD7\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x96"],
        ["\xD7\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x98"],
        ["\xD7\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x82"],
        ["\xD7\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x85"],
        ["\xD7\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAB"],
        ["\xD7\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8A"],
        ["\xD7\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x92"],
        ["\xD7\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8D"],
        ["\xD7\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8E"],
        ["\xD7\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9E"],
        ["\xD7\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9F"],
        ["\xD7\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA0"],
        ["\xD7\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA2"],
        ["\xD7\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB0"],
        ["\xD7\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB3"],
        ["\xD7\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB6"],
        ["\xD7\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8E"],
        ["\xD7\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8D"],
        ["\xD7\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x84"],
        ["\xD7\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x86"],
        ["\xD7\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x82"],
        ["\xD7\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x97"],
        ["\xD7\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9E"],
        ["\xD7\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAD"],
        ["\xD7\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9F"],
        ["\xD7\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB7"],
        ["\xD7\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x89"],
        ["\xD7\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9A"],
        ["\xD7\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB0"],
        ["\xD7\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9B"],
        ["\xD7\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9D"],
        ["\xD7\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x97"],
        ["\xD7\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x87"],
        ["\xD7\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB6"],
        ["\xD7\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x88"],
        ["\xD7\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8F"],
        ["\xD7\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x98"],
        ["\xD7\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBB"],
        ["\xD7\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xA9"],
        ["\xD7\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB0"],
        ["\xD7\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x91"],
        ["\xD7\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xAF"],
        ["\xD7\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x86"],
        ["\xD7\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x96"],
        ["\xD2\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x98"],
        ["\xD7\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x94"],
        ["\xD7\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9F"],
        ["\xD7\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8E"],
        ["\xD7\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x98"],
        ["\xD7\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9B"],
        ["\xD7\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x91"],
        ["\xD7\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9A"],
        ["\xD7\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x90"],
        ["\xD7\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA4"],
        ["\xD7\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA5"],
        ["\xD7\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9A"],
        ["\xD7\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA8"],
        ["\xD7\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x94"],
        ["\xD7\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAA"],
        ["\xD7\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA5"],
        ["\xD7\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x85"],
        ["\xD7\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9C"],
        ["\xD7\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB6"],
        ["\xD7\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA1"],
        ["\xD7\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA9"],
        ["\xD7\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAC"],
        ["\xD7\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBE"],
        ["\xD7\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xAF"],
        ["\xD7\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x91"],
        ["\xD7\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x86"],
        ["\xD7\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x83"],
        ["\xD7\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x87"],
        ["\xD7\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x83"],
        ["\xD7\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x95"],
        ["\xD7\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x90"],
        ["\xD7\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x88"],
        ["\xD7\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x9A"],
        ["\xD7\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x96"],
        ["\xD7\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xAC"],
        ["\xD7\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB8"],
        ["\xD7\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x80"],
        ["\xD7\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x9A"],
        ["\xD7\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x85"],
        ["\xD7\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB4"],
        ["\xD7\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB2"],
        ["\xD8\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x89"],
        ["\xD8\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8A"],
        ["\xD8\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB3"],
        ["\xD8\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x82"],
        ["\xD8\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x96"],
        ["\xD8\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x9E"],
        ["\xD8\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA5"],
        ["\xD8\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xAD"],
        ["\xD8\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA3"],
        ["\xD8\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xAE"],
        ["\xD8\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB9"],
        ["\xD8\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB5"],
        ["\xD8\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x89"],
        ["\xD8\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x81"],
        ["\xD8\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x82"],
        ["\xD8\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x96"],
        ["\xD8\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x95"],
        ["\xD8\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x94"],
        ["\xD8\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9A"],
        ["\xD8\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xA1"],
        ["\xD8\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBA"],
        ["\xD8\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB7"],
        ["\xD8\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBC"],
        ["\xD8\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBB"],
        ["\xD8\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBF"],
        ["\xD8\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x80"],
        ["\xD8\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x92"],
        ["\xD8\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8C"],
        ["\xD8\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x94"],
        ["\xD8\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA2"],
        ["\xD8\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB8"],
        ["\xD8\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA9"],
        ["\xD8\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAA"],
        ["\xD8\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAE"],
        ["\xD8\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x80"],
        ["\xD8\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x82"],
        ["\xD8\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x98"],
        ["\xD8\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8C"],
        ["\xD8\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x89"],
        ["\xD8\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8F"],
        ["\xD8\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x91"],
        ["\xD8\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x93"],
        ["\xD8\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x95"],
        ["\xD8\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x96"],
        ["\xD8\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA4"],
        ["\xD8\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA6"],
        ["\xD8\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA2"],
        ["\xD8\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA9"],
        ["\xD8\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAA"],
        ["\xD8\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAB"],
        ["\xD8\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB3"],
        ["\xD8\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB1"],
        ["\xD8\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB2"],
        ["\xD8\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB0"],
        ["\xD8\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB5"],
        ["\xD8\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xBD"],
        ["\xD8\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x85"],
        ["\xD8\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x89"],
        ["\xD8\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9B"],
        ["\xD8\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA0"],
        ["\xD8\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x95"],
        ["\xD8\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA9"],
        ["\xD8\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAD"],
        ["\xD8\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB0"],
        ["\xD8\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB5"],
        ["\xD8\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBE"],
        ["\xD8\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x84"],
        ["\xD8\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8B"],
        ["\xD8\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x94"],
        ["\xD8\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8E"],
        ["\xD8\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA7"],
        ["\xD8\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xAA"],
        ["\xD8\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xAE"],
        ["\xD8\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB3"],
        ["\xD8\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB9"],
        ["\xD8\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8F"],
        ["\xD8\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x84"],
        ["\xD8\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8B"],
        ["\xD8\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8C"],
        ["\xD8\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9E"],
        ["\xD8\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x94"],
        ["\xD8\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAA"],
        ["\xD8\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB4"],
        ["\xD8\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA9"],
        ["\xD8\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB3"],
        ["\xD8\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xBF"],
        ["\xD8\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xBD"],
        ["\xD8\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x8D"],
        ["\xD8\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x94"],
        ["\xD8\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x92"],
        ["\xD8\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB1"],
        ["\xD8\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x88"],
        ["\xD8\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x91"],
        ["\xD8\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA8"],
        ["\xD9\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA7"],
        ["\xD9\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAC"],
        ["\xD9\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAD"],
        ["\xD9\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBC"],
        ["\xD9\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB5"],
        ["\xD9\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x81"],
        ["\xD9\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x8D"],
        ["\xD9\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x97"],
        ["\xD9\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9E"],
        ["\xD9\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA3"],
        ["\xD9\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA6"],
        ["\xD9\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAD"],
        ["\xD9\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA0"],
        ["\xD9\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB3"],
        ["\xD9\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB5"],
        ["\xD9\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB8"],
        ["\xD9\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB9"],
        ["\xD9\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x86"],
        ["\xD9\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x88"],
        ["\xD9\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB8"],
        ["\xD9\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8D"],
        ["\xD9\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x90"],
        ["\xD9\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8F"],
        ["\xD9\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x95"],
        ["\xD9\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9A"],
        ["\xD9\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA3"],
        ["\xD9\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xAF"],
        ["\xD9\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB1"],
        ["\xD9\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB3"],
        ["\xD9\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB8"],
        ["\xD9\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x80"],
        ["\xD9\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x86"],
        ["\xD9\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x85"],
        ["\xD9\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x97"],
        ["\xD9\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x89"],
        ["\xD9\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x8D"],
        ["\xD9\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x96"],
        ["\xD9\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9E"],
        ["\xD9\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA9"],
        ["\xD9\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAE"],
        ["\xD9\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x98"],
        ["\xD9\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBB"],
        ["\xD9\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB7"],
        ["\xD9\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x82"],
        ["\xD9\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x96"],
        ["\xD9\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA0"],
        ["\xD9\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA6"],
        ["\xD9\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA5"],
        ["\xD9\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xAE"],
        ["\xD9\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB0"],
        ["\xD9\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB6"],
        ["\xD9\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x83"],
        ["\xD9\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x92"],
        ["\xD9\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x99"],
        ["\xD9\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9F"],
        ["\xD9\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBC"],
        ["\xD9\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAE"],
        ["\xD9\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAE"],
        ["\xD9\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA8"],
        ["\xD9\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAD"],
        ["\xD9\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xBA"],
        ["\xD9\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x81"],
        ["\xD9\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBD"],
        ["\xD9\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x80"],
        ["\xD9\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAC"],
        ["\xD9\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAD"],
        ["\xD9\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBC"],
        ["\xD9\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAE"],
        ["\xD9\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB6"],
        ["\xD9\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA9"],
        ["\xD9\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9D"],
        ["\xD9\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8E"],
        ["\xD9\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8F"],
        ["\xD9\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB5"],
        ["\xD9\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8E"],
        ["\xD9\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x9F"],
        ["\xD9\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB1"],
        ["\xD9\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB7"],
        ["\xD9\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB0"],
        ["\xD9\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x92"],
        ["\xD9\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBB"],
        ["\xD9\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x80"],
        ["\xD9\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB6"],
        ["\xD9\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x84"],
        ["\xD9\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x90"],
        ["\xD9\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x86"],
        ["\xD9\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x87"],
        ["\xD9\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA2"],
        ["\xD9\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB8"],
        ["\xD9\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA5"],
        ["\xD9\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAC"],
        ["\xD9\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x84"],
        ["\xD9\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x88"],
        ["\xD9\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA8"],
        ["\xE2\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAB"],
        ["\xE2\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x82"],
        ["\xE2\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA4"],
        ["\xE2\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBE"],
        ["\xE2\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBC"],
        ["\xE2\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x98"],
        ["\xE2\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA5"],
        ["\xE2\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA6"],
        ["\xE2\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x8F"],
        ["\xE2\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x94"],
        ["\xE2\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBD"],
        ["\xE2\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAE"],
        ["\xE2\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAD"],
        ["\xE2\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBA"],
        ["\xE2\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA2"],
        ["\xE2\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB9"],
        ["\xE2\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x80"],
        ["\xE2\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA3"],
        ["\xE2\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8C"],
        ["\xE2\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAE"],
        ["\xE2\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9C"],
        ["\xE2\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x85"],
        ["\xE2\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x96"],
        ["\xE2\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x97"],
        ["\xE2\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB8"],
        ["\xE2\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB3"],
        ["\xE2\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9D"],
        ["\xE2\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x99"],
        ["\xE2\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x80"],
        ["\xE2\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAF"],
        ["\xE2\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8A"],
        ["\xE2\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9F"],
        ["\xE2\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBB"],
        ["\xE2\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBE"],
        ["\xE2\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x98"],
        ["\xE2\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9E"],
        ["\xE2\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAE"],
        ["\xE2\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBC"],
        ["\xE2\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x83"],
        ["\xE2\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA9"],
        ["\xE2\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x87"],
        ["\xE2\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA8"],
        ["\xE2\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9A"],
        ["\xE2\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x85"],
        ["\xE2\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9F"],
        ["\xE2\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x84"],
        ["\xE2\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9C"],
        ["\xE2\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA4"],
        ["\xE2\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x94"],
        ["\xE2\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x94"],
        ["\xE2\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xB7"],
        ["\xE2\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x96"],
        ["\xE2\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xBE"],
        ["\xE2\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xBD"],
        ["\xE2\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x9B"],
        ["\xE2\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xB9"],
        ["\xE2\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x8E"],
        ["\xE2\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x90"],
        ["\xE2\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x9F"],
        ["\xE2\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB4"],
        ["\xE2\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB6"],
        ["\xE2\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB2"],
        ["\xE2\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB8"],
        ["\xE2\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAB"],
        ["\xE2\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA4"],
        ["\xE2\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xAF"],
        ["\xE2\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAC"],
        ["\xE2\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAA"],
        ["\xE2\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x86"],
        ["\xE2\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x80"],
        ["\xE2\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8A"],
        ["\xE2\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA0"],
        ["\xE2\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x94"],
        ["\xE2\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8F"],
        ["\xE2\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA5"],
        ["\xE2\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xAE"],
        ["\xE2\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB6"],
        ["\xE2\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB4"],
        ["\xE2\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x82"],
        ["\xE2\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xBC"],
        ["\xE2\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x81"],
        ["\xE2\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x83"],
        ["\xE2\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x80"],
        ["\xE2\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x88"],
        ["\xE2\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x8E"],
        ["\xE2\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x91"],
        ["\xE2\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x93"],
        ["\xE2\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x97"],
        ["\xE2\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xAE"],
        ["\xE2\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB9"],
        ["\xE2\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x80"],
        ["\xE2\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBF"],
        ["\xE2\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x84"],
        ["\xE2\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x89"],
        ["\xE3\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x88"],
        ["\xE3\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8B"],
        ["\xE3\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8D"],
        ["\xE3\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x93"],
        ["\xE3\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x98"],
        ["\xE3\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x96"],
        ["\xE3\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x87"],
        ["\xE3\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x9C"],
        ["\xE3\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA6"],
        ["\xE3\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB7"],
        ["\xE3\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB8"],
        ["\xE3\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8E"],
        ["\xE3\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xBB"],
        ["\xE3\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x80"],
        ["\xE3\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8F"],
        ["\xE3\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA9"],
        ["\xE3\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x80"],
        ["\xE3\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x88"],
        ["\xE3\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA1"],
        ["\xE3\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xBF"],
        ["\xE3\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x89"],
        ["\xE3\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x93"],
        ["\xE3\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA0"],
        ["\xE3\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB3"],
        ["\xE3\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA4"],
        ["\xE3\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xAA"],
        ["\xE3\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB0"],
        ["\xE3\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x83"],
        ["\xE3\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x86"],
        ["\xE3\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x94"],
        ["\xE3\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x92"],
        ["\xE3\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x93"],
        ["\xE3\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x8A"],
        ["\xE3\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x96"],
        ["\xE3\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA3"],
        ["\xE3\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x8B"],
        ["\xE3\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x99"],
        ["\xE3\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x9D"],
        ["\xE3\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB2"],
        ["\xE3\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA1"],
        ["\xE3\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA2"],
        ["\xE3\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8B"],
        ["\xE3\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB0"],
        ["\xE3\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x80"],
        ["\xE3\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x92"],
        ["\xE3\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xBD"],
        ["\xE3\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB9"],
        ["\xE3\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x85"],
        ["\xE3\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB9"],
        ["\xE3\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9F"],
        ["\xE3\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAB"],
        ["\xE3\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBA"],
        ["\xE3\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9E"],
        ["\xE3\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBB"],
        ["\xE3\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB8"],
        ["\xE3\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAE"],
        ["\xE3\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x85"],
        ["\xE3\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x93"],
        ["\xE3\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x91"],
        ["\xE3\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x97"],
        ["\xE3\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x99"],
        ["\xE3\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x98"],
        ["\xE3\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA5"],
        ["\xE3\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9C"],
        ["\xE3\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA4"],
        ["\xE3\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9F"],
        ["\xE3\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAF"],
        ["\xC4\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBA"],
        ["\xE3\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB9"],
        ["\xE3\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBB"],
        ["\xE3\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBC"],
        ["\xE3\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBD"],
        ["\xE3\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x82"],
        ["\xE3\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8A"],
        ["\xE3\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x90"],
        ["\xE3\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9B"],
        ["\xE3\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA6"],
        ["\xE3\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA5"],
        ["\xE3\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAC"],
        ["\xE3\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAD"],
        ["\xE3\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB2"],
        ["\xE3\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB8"],
        ["\xE3\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xBE"],
        ["\xE3\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x92"],
        ["\xE3\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x95"],
        ["\xE3\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x90"],
        ["\xE3\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x8E"],
        ["\xE3\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9A"],
        ["\xE3\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x98"],
        ["\xE3\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA2"],
        ["\xE3\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA0"],
        ["\xE3\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA7"],
        ["\xE3\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAC"],
        ["\xE3\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA9"],
        ["\xE4\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB8"],
        ["\xE4\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x81"],
        ["\xE4\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9D"],
        ["\xE4\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9E"],
        ["\xE4\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAB"],
        ["\xE4\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA3"],
        ["\xE4\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xB2"],
        ["\xE4\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x86"],
        ["\xE4\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA8"],
        ["\xE4\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9C"],
        ["\xE4\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8D"],
        ["\xE4\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x99"],
        ["\xE4\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9A"],
        ["\xE4\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA5"],
        ["\xE4\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9F"],
        ["\xE4\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x91"],
        ["\xE4\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9C"],
        ["\xE4\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x89"],
        ["\xE4\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9A"],
        ["\xE4\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x80"],
        ["\xE4\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAC"],
        ["\xE4\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x89"],
        ["\xE4\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xB5"],
        ["\xE4\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xB6"],
        ["\xE4\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA2"],
        ["\xE4\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAA"],
        ["\xE4\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9A"],
        ["\xE4\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBC"],
        ["\xE4\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBE"],
        ["\xE4\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x8B"],
        ["\xE4\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x82"],
        ["\xE4\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBD"],
        ["\xE4\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA3"],
        ["\xE4\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x97"],
        ["\xE4\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA6"],
        ["\xE4\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA9"],
        ["\xE4\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x96"],
        ["\xE4\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xBA"],
        ["\xE4\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xBB"],
        ["\xE4\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x8C"],
        ["\xE4\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x8B"],
        ["\xE4\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x96"],
        ["\xE4\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB2"],
        ["\xE4\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x90"],
        ["\xE4\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAA"],
        ["\xE4\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB6"],
        ["\xE4\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xBE"],
        ["\xE4\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x83"],
        ["\xE4\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x85"],
        ["\xE4\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x80"],
        ["\xE4\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x91"],
        ["\xE4\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x95"],
        ["\xE4\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9A"],
        ["\xE4\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9B"],
        ["\xE4\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA5"],
        ["\xE4\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA9"],
        ["\xE4\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB0"],
        ["\xE4\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB3"],
        ["\xE4\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB5"],
        ["\xE4\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB8"],
        ["\xE4\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x88"],
        ["\xE4\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xBA"],
        ["\xE4\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x80"],
        ["\xE4\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x83"],
        ["\xE4\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA6"],
        ["\xE4\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB8"],
        ["\xE4\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x83"],
        ["\xE4\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x87"],
        ["\xE4\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x89"],
        ["\xE4\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x94"],
        ["\xE4\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x90"],
        ["\xE4\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA4"],
        ["\xE4\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA6"],
        ["\xE4\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA2"],
        ["\xE4\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9E"],
        ["\xE4\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA5"],
        ["\xE4\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAB"],
        ["\xE4\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB0"],
        ["\xE4\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB6"],
        ["\xE4\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB3"],
        ["\xE4\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x85"],
        ["\xE4\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x87"],
        ["\xE4\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x88"],
        ["\xE4\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8D"],
        ["\xE4\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x93"],
        ["\xE4\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA0"],
        ["\xE4\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA2"],
        ["\xE4\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA8"],
        ["\xE4\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB8"],
        ["\xE4\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB9"],
        ["\xE4\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x81"],
        ["\xE4\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x86"],
        ["\xE4\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8E"],
        ["\xE4\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x93"],
        ["\xE5\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x90"],
        ["\xE5\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8F"],
        ["\xE5\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB1"],
        ["\xE5\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAC"],
        ["\xE5\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAE"],
        ["\xE5\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xA2"],
        ["\xE5\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB6"],
        ["\xE5\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB9"],
        ["\xE5\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x8C"],
        ["\xE5\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x91"],
        ["\xE5\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x94"],
        ["\xE5\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9B"],
        ["\xE5\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAB"],
        ["\xE5\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBB"],
        ["\xE5\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB6"],
        ["\xE5\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBC"],
        ["\xE5\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB7"],
        ["\xE5\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x85"],
        ["\xE5\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBE"],
        ["\xE5\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x87"],
        ["\xE5\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x99"],
        ["\xE5\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA9"],
        ["\xE5\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBD"],
        ["\xE5\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBA"],
        ["\xE5\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAD"],
        ["\xE5\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x8C"],
        ["\xE5\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAA"],
        ["\xE5\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8B"],
        ["\xE5\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x95"],
        ["\xE5\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x97"],
        ["\xE5\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x9C"],
        ["\xE5\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9F"],
        ["\xE5\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9B"],
        ["\xE5\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x91"],
        ["\xE5\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x94"],
        ["\xE5\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA2"],
        ["\xE5\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9A"],
        ["\xE5\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x99"],
        ["\xE5\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x98"],
        ["\xE5\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8C"],
        ["\xE5\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x92"],
        ["\xE5\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8E"],
        ["\xE5\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8B"],
        ["\xE5\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAC"],
        ["\xE5\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB3"],
        ["\xE5\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB6"],
        ["\xE5\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x87"],
        ["\xE5\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x84"],
        ["\xE5\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x82"],
        ["\xE5\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA2"],
        ["\xE5\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x9D"],
        ["\xE5\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xAC"],
        ["\xE5\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xAE"],
        ["\xE5\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBD"],
        ["\xE5\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x90"],
        ["\xE5\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB7"],
        ["\xE5\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBC"],
        ["\xE5\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x89"],
        ["\xE5\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8D"],
        ["\xE5\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x93"],
        ["\xE5\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x92"],
        ["\xE5\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x96"],
        ["\xE5\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9B"],
        ["\xE5\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xAB"],
        ["\xE5\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB2"],
        ["\xE5\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB5"],
        ["\xE5\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x8B"],
        ["\xE5\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9A"],
        ["\xE5\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x99"],
        ["\xE5\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x91"],
        ["\xE5\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9B"],
        ["\xE5\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB6"],
        ["\xE5\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB7"],
        ["\xE5\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x84"],
        ["\xE5\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x83"],
        ["\xE5\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x80"],
        ["\xE5\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x8E"],
        ["\xE5\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x97"],
        ["\xE5\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x94"],
        ["\xE5\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x9F"],
        ["\xE5\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA2"],
        ["\xE5\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA4"],
        ["\xE5\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x87"],
        ["\xE5\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB5"],
        ["\xE5\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB6"],
        ["\xE5\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBA"],
        ["\xE5\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBC"],
        ["\xE5\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBF"],
        ["\xE5\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA0"],
        ["\xE5\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x81"],
        ["\xE5\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x82"],
        ["\xE5\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x88"],
        ["\xE5\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x90"],
        ["\xE5\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8F"],
        ["\xE6\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x96"],
        ["\xE6\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA3"],
        ["\xE6\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9D"],
        ["\xE6\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9A"],
        ["\xE6\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9B"],
        ["\xE6\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA2"],
        ["\xE6\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA1"],
        ["\xE6\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA8"],
        ["\xE6\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA9"],
        ["\xE6\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xAC"],
        ["\xE6\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB1"],
        ["\xE6\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB3"],
        ["\xE6\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB0"],
        ["\xE6\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB4"],
        ["\xE6\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB8"],
        ["\xE6\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBE"],
        ["\xE6\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x83"],
        ["\xE6\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x89"],
        ["\xE6\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x9D"],
        ["\xE6\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x9C"],
        ["\xE6\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8B"],
        ["\xE6\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x91"],
        ["\xE6\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x96"],
        ["\xE6\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA9"],
        ["\xE6\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xAD"],
        ["\xE6\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB8"],
        ["\xE6\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x88"],
        ["\xE6\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8C"],
        ["\xE6\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8E"],
        ["\xE6\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xAF"],
        ["\xE6\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x91"],
        ["\xE6\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x96"],
        ["\xE6\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x97"],
        ["\xE6\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x99"],
        ["\xE6\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA1"],
        ["\xE6\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAD"],
        ["\xE6\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB3"],
        ["\xE6\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB7"],
        ["\xE6\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x83"],
        ["\xE6\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x82"],
        ["\xE6\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBF"],
        ["\xE6\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8A"],
        ["\xE6\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x88"],
        ["\xE6\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x91"],
        ["\xE6\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x87"],
        ["\xE6\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x9E"],
        ["\xE6\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x99"],
        ["\xE6\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x98"],
        ["\xE6\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA0"],
        ["\xE6\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA8"],
        ["\xE6\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAD"],
        ["\xE6\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xBC"],
        ["\xE6\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x96"],
        ["\xE6\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBB"],
        ["\xE6\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA4"],
        ["\xE6\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB8"],
        ["\xE6\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB1"],
        ["\xE6\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9D"],
        ["\xE6\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB3"],
        ["\xE6\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBF"],
        ["\xE6\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA1"],
        ["\xE6\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA0"],
        ["\xE6\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x99"],
        ["\xE6\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x90"],
        ["\xE6\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA9"],
        ["\xE6\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8E"],
        ["\xE6\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xB1"],
        ["\xE6\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9B"],
        ["\xE6\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x95"],
        ["\xE6\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAB"],
        ["\xE6\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA6"],
        ["\xE6\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8F"],
        ["\xE6\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xBA"],
        ["\xE6\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9A"],
        ["\xE6\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x81"],
        ["\xE6\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAA"],
        ["\xE6\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB7"],
        ["\xE6\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9F"],
        ["\xE6\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8A"],
        ["\xE6\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x86"],
        ["\xE6\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8D"],
        ["\xE6\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA3"],
        ["\xE6\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x83"],
        ["\xE6\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA4"],
        ["\xE6\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x82"],
        ["\xE6\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAC"],
        ["\xE6\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAB"],
        ["\xE6\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x99"],
        ["\xE6\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x81"],
        ["\xE6\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8D"],
        ["\xE6\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA7"],
        ["\xE6\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x83"],
        ["\xE6\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9A"],
        ["\xE7\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x84"],
        ["\xE7\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9B"],
        ["\xE7\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x96"],
        ["\xE7\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x97"],
        ["\xE7\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x92"],
        ["\xE7\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA7"],
        ["\xE7\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8B"],
        ["\xE7\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA1"],
        ["\xE7\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB8"],
        ["\xE7\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA0"],
        ["\xE7\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x93"],
        ["\xE7\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB4"],
        ["\xE7\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB0"],
        ["\xE7\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBD"],
        ["\xE7\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x86"],
        ["\xE7\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB5"],
        ["\xE7\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x98"],
        ["\xE7\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8D"],
        ["\xE7\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x95"],
        ["\xE7\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x86"],
        ["\xE7\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB6"],
        ["\xE7\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB7"],
        ["\xE7\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x80"],
        ["\xE7\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB4"],
        ["\xE7\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xBA"],
        ["\xE7\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x83"],
        ["\xE7\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA1"],
        ["\xE7\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xBB"],
        ["\xE7\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB1"],
        ["\xE7\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8D"],
        ["\xE7\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8E"],
        ["\xE7\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x87"],
        ["\xE7\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBE"],
        ["\xE7\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA8"],
        ["\xE7\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA7"],
        ["\xE7\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8A"],
        ["\xE7\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBF"],
        ["\xE7\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBC"],
        ["\xE7\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xAC"],
        ["\xE7\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xB4"],
        ["\xE7\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBD"],
        ["\xE7\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x82"],
        ["\xE7\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x84"],
        ["\xE7\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB3"],
        ["\xE7\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB7"],
        ["\xE7\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x98"],
        ["\xE7\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x99"],
        ["\xE7\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9A"],
        ["\xE7\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAB"],
        ["\xE7\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB4"],
        ["\xE7\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAF"],
        ["\xE7\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA5"],
        ["\xE7\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB1"],
        ["\xE7\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9F"],
        ["\xE7\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9D"],
        ["\xE7\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x93"],
        ["\xE7\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB5"],
        ["\xE7\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x99"],
        ["\xE7\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x96"],
        ["\xE7\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x87"],
        ["\xE7\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAC"],
        ["\xE7\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x94"],
        ["\xE7\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x9A"],
        ["\xE7\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8A"],
        ["\xE7\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x91"],
        ["\xE7\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAB"],
        ["\xE7\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAE"],
        ["\xE7\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8C"],
        ["\xE7\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8A"],
        ["\xE7\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x89"],
        ["\xE7\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB7"],
        ["\xE7\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x88"],
        ["\xE7\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x83"],
        ["\xE7\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x86"],
        ["\xE7\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBA"],
        ["\xE7\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8B"],
        ["\xE7\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB9"],
        ["\xE7\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8D"],
        ["\xE7\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xA6"],
        ["\xE7\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xA3"],
        ["\xE7\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB6"],
        ["\xE7\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBA"],
        ["\xE7\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB4"],
        ["\xE7\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBF"],
        ["\xE7\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBD"],
        ["\xE7\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBC"],
        ["\xE7\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBE"],
        ["\xE7\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x80"],
        ["\xE7\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x88"],
        ["\xE7\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x89"],
        ["\xE7\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8D"],
        ["\xE7\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8C"],
        ["\xE7\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x94"],
        ["\xE7\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9B"],
        ["\xE8\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9E"],
        ["\xE8\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA1"],
        ["\xE8\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAA"],
        ["\xE8\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAE"],
        ["\xE8\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB0"],
        ["\xE8\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB2"],
        ["\xE8\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB3"],
        ["\xE8\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x81"],
        ["\xE8\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8E"],
        ["\xE8\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9E"],
        ["\xE8\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA3"],
        ["\xE8\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9B"],
        ["\xE8\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA0"],
        ["\xE8\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA8"],
        ["\xE8\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBC"],
        ["\xE8\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x82"],
        ["\xE8\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x89"],
        ["\xE8\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBE"],
        ["\xE8\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x92"],
        ["\xE8\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x93"],
        ["\xE8\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x96"],
        ["\xE8\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x94"],
        ["\xE8\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x83"],
        ["\xE8\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x94"],
        ["\xE8\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x97"],
        ["\xE8\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x91"],
        ["\xE8\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBB"],
        ["\xE8\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8F"],
        ["\xE8\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBF"],
        ["\xE8\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x86"],
        ["\xE8\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x94"],
        ["\xE8\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x88"],
        ["\xE8\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9C"],
        ["\xE8\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8C"],
        ["\xE8\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8A"],
        ["\xE8\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x82"],
        ["\xE8\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x87"],
        ["\xE8\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9B"],
        ["\xE8\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x89"],
        ["\xE8\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x8C"],
        ["\xE8\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAE"],
        ["\xE8\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB1"],
        ["\xE8\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xA7"],
        ["\xE8\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x82"],
        ["\xE8\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x88"],
        ["\xE8\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAF"],
        ["\xE8\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB5"],
        ["\xE8\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x90"],
        ["\xE8\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBE"],
        ["\xE8\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8D"],
        ["\xE8\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x9C"],
        ["\xE8\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8F"],
        ["\xE8\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x96"],
        ["\xE8\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8E"],
        ["\xE8\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x80"],
        ["\xE8\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAB"],
        ["\xE8\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB6"],
        ["\xE8\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA3"],
        ["\xE8\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8F"],
        ["\xE8\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x89"],
        ["\xE8\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x9F"],
        ["\xE8\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB5"],
        ["\xE8\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAB"],
        ["\xE8\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA9"],
        ["\xE8\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBE"],
        ["\xE8\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA9"],
        ["\xE8\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x80"],
        ["\xE8\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x86"],
        ["\xE8\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA3"],
        ["\xE8\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x89"],
        ["\xE8\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x92"],
        ["\xE8\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB6"],
        ["\xE8\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x84"],
        ["\xE8\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x96"],
        ["\xE8\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xB4"],
        ["\xE8\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x86"],
        ["\xE8\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x93"],
        ["\xE8\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA6"],
        ["\xE8\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xB6"],
        ["\xE8\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9D"],
        ["\xE8\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x97"],
        ["\xE8\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA8"],
        ["\xE8\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x8F"],
        ["\xE8\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA7"],
        ["\xE8\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xAF"],
        ["\xE8\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB6"],
        ["\xE8\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x8E"],
        ["\xF3\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAA"],
        ["\xE8\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x95"],
        ["\xE8\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x93"],
        ["\xE8\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA5"],
        ["\xE8\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA9"],
        ["\xE8\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x88"],
        ["\xE8\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBC"],
        ["\xE9\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x9A"],
        ["\xE9\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x92"],
        ["\xE9\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x85"],
        ["\xE9\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x87"],
        ["\xE9\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBB"],
        ["\xE9\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x98"],
        ["\xE9\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x82"],
        ["\xE9\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB1"],
        ["\xE9\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA7"],
        ["\xE9\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x89"],
        ["\xE9\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA0"],
        ["\xE9\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA1"],
        ["\xE9\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xAC"],
        ["\xE9\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA3"],
        ["\xE9\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xAF"],
        ["\xE9\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAC"],
        ["\xE9\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB6"],
        ["\xE9\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB4"],
        ["\xE9\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB2"],
        ["\xE9\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBA"],
        ["\xE9\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x80"],
        ["\xE9\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBD"],
        ["\xE9\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x98"],
        ["\xE9\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9C"],
        ["\xE9\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x85"],
        ["\xE9\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA4"],
        ["\xE9\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA3"],
        ["\xE9\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAB"],
        ["\xE9\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB4"],
        ["\xE9\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB5"],
        ["\xE9\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB7"],
        ["\xE9\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB6"],
        ["\xE9\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB8"],
        ["\xE9\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8B"],
        ["\xE9\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x88"],
        ["\xE9\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x96"],
        ["\xE9\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x95"],
        ["\xE9\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8D"],
        ["\xE9\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x98"],
        ["\xE9\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x9E"],
        ["\xE9\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x9D"],
        ["\xE9\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB2"],
        ["\xE9\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB8"],
        ["\xE9\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x82"],
        ["\xE9\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x83"],
        ["\xE9\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8A"],
        ["\xE9\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9B"],
        ["\xE9\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9F"],
        ["\xE9\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAB"],
        ["\xE9\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB7"],
        ["\xE9\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x83"],
        ["\xE9\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x86"],
        ["\xE9\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x81"],
        ["\xE9\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x84"],
        ["\xE9\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8C"],
        ["\xE9\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x92"],
        ["\xE9\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x9B"],
        ["\xE9\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x99"],
        ["\xE9\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA0"],
        ["\xE9\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA1"],
        ["\xE9\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xB1"],
        ["\xE9\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB2"],
        ["\xE9\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8A"],
        ["\xE9\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x83"],
        ["\xE9\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBB"],
        ["\xE9\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB3"],
        ["\xE9\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB5"],
        ["\xE9\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB6"],
        ["\xE9\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB4"],
        ["\xE9\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9C"],
        ["\xE9\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8F"],
        ["\xE9\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x84"],
        ["\xE9\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x89"],
        ["\xE9\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x81"],
        ["\xE9\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9E"],
        ["\xE9\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9D"],
        ["\xE9\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA4"],
        ["\xE9\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA7"],
        ["\xE9\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA8"],
        ["\xE9\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9F"],
        ["\xE9\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA2"],
        ["\xE9\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB0"],
        ["\xE9\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x83"],
        ["\xE9\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x88"],
        ["\xE9\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x8E"],
        ["\xE9\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x89"],
        ["\xE9\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x84"],
        ["\xE9\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x98"],
        ["\xE9\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x9D"],
        ["\xE9\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x81"],
        ["\xE9\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB9"],
        ["\xE9\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x89"],
        ["\xE9\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBE"],
        ["\xE9\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBC"],
        ["\x4A\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x84"],
        ["\x4A\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB8"],
        ["\x4A\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x96"],
        ["\x4A\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9A"],
        ["\x4A\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA0"],
        ["\x4A\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBF"],
        ["\x4A\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA6"],
        ["\x4A\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA9"],
        ["\x4A\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB0"],
        ["\x4A\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB5"],
        ["\x4A\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB7"],
        ["\x4A\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8F"],
        ["\x4A\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x96"],
        ["\x4A\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9E"],
        ["\x4A\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA6"],
        ["\x4A\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA7"],
        ["\x4A\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB8"],
        ["\x4A\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAE"],
        ["\x4A\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBF"],
        ["\x4A\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB6"],
        ["\x4A\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x81"],
        ["\x4A\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB8"],
        ["\x4A\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB7"],
        ["\x4A\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x86"],
        ["\x4A\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9E"],
        ["\x4A\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA0"],
        ["\x4A\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x99"],
        ["\x4A\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA3"],
        ["\x4A\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA4"],
        ["\x4A\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x89"],
        ["\x4A\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB0"],
        ["\x4A\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA9"],
        ["\x4A\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBC"],
        ["\x4A\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAA"],
        ["\x4A\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x8C"],
        ["\x4A\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x8B"],
        ["\x4A\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA6"],
        ["\x4A\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA1"],
        ["\x4A\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x85"],
        ["\x4A\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB7"],
        ["\x4A\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAF"],
        ["\x4A\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB4"],
        ["\x4A\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAC"],
        ["\x4A\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB3"],
        ["\x4A\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA9"],
        ["\x4A\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB8"],
        ["\x4A\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA4"],
        ["\x4A\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9E"],
        ["\x4A\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9D"],
        ["\x4A\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA2"],
        ["\x4A\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAE"],
        ["\x4A\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB9"],
        ["\x4A\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8E"],
        ["\x4A\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x86"],
        ["\x4A\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA7"],
        ["\xC9\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x9C"],
        ["\x4A\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x9E"],
        ["\x4A\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x86"],
        ["\x4A\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA9"],
        ["\x4A\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x80"],
        ["\x4A\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8D"],
        ["\x4A\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB2"],
        ["\x4A\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8E"],
        ["\x4A\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB3"],
        ["\x4A\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAB"],
        ["\x4A\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x99"],
        ["\x4A\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xA3"],
        ["\x4A\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB7"],
        ["\x4A\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBF"],
        ["\x4A\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9F"],
        ["\x4A\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x8F"],
        ["\x4A\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAD"],
        ["\x4A\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x94"],
        ["\x4A\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9D"],
        ["\x4A\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9B"],
        ["\x4A\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x83"],
        ["\xC5\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAE"],
        ["\x4A\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB9"],
        ["\x4A\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB4"],
        ["\x4A\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB5"],
        ["\x4A\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA0"],
        ["\x4A\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBA"],
        ["\x4A\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8F"],
        ["\x4A\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x8D"],
        ["\x4A\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBE"],
        ["\x4A\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x81"],
        ["\x4A\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8A"],
        ["\x4A\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x88"],
        ["\x4A\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x98"],
        ["\x4A\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA2"],
        ["\x4A\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA6"],
        ["\x4A\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA1"],
        ["\x4A\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8C"],
        ["\x4A\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8D"],
        ["\x5B\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x94"],
        ["\x5B\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA7"],
        ["\x5B\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x95"],
        ["\x5B\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB6"],
        ["\x5B\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x92"],
        ["\x5B\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x84"],
        ["\x5B\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x97"],
        ["\x5B\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA3"],
        ["\x5B\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA5"],
        ["\x5B\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB9"],
        ["\x5B\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA0"],
        ["\x5B\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAF"],
        ["\x5B\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA8"],
        ["\x5B\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xAA"],
        ["\x5B\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9A"],
        ["\x5B\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA3"],
        ["\x5B\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA1"],
        ["\x5B\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x86"],
        ["\x5B\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB9"],
        ["\x5B\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB7"],
        ["\x5B\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9C"],
        ["\x5B\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB8"],
        ["\x5B\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAB"],
        ["\x5B\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x94"],
        ["\x5B\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBE"],
        ["\x5B\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAE"],
        ["\x5B\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB9"],
        ["\x5B\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB4"],
        ["\x5B\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBD"],
        ["\x5B\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x99"],
        ["\x5B\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB0"],
        ["\x5B\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA1"],
        ["\x5B\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9E"],
        ["\x5B\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9D"],
        ["\x5B\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x81"],
        ["\x5B\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAA"],
        ["\x5B\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB2"],
        ["\x5B\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xAE"],
        ["\x5B\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x90"],
        ["\x5B\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBF"],
        ["\x5B\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x81"],
        ["\x5B\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x93"],
        ["\x5B\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBE"],
        ["\x5B\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8E"],
        ["\x5B\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA8"],
        ["\x5B\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8A"],
        ["\x5B\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x9D"],
        ["\x5B\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBB"],
        ["\x5B\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x83"],
        ["\x5B\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA7"],
        ["\x5B\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAE"],
        ["\x5B\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x91"],
        ["\x5B\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA0"],
        ["\x5B\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x9C"],
        ["\x5B\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x95"],
        ["\x5B\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB4"],
        ["\x5B\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x9E"],
        ["\x5B\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA8"],
        ["\x5B\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x82"],
        ["\x5B\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9B"],
        ["\x5B\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBF"],
        ["\x5B\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x8A"],
        ["\x5B\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB9"],
        ["\x5B\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB2"],
        ["\x5B\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA7"],
        ["\x5B\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x85"],
        ["\x5B\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB1"],
        ["\x5B\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9E"],
        ["\x5B\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAD"],
        ["\x5B\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x94"],
        ["\x5B\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAB"],
        ["\x5B\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8A"],
        ["\x5B\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x92"],
        ["\x5B\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x81"],
        ["\x5B\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA3"],
        ["\x5B\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x93"],
        ["\x5B\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x84"],
        ["\x5B\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8C"],
        ["\x5B\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB2"],
        ["\x5B\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB6"],
        ["\x5B\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB8"],
        ["\x5B\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x87"],
        ["\x5B\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA2"],
        ["\x5B\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x99"],
        ["\x5B\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA6"],
        ["\x5B\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x88"],
        ["\x5B\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB8"],
        ["\x5B\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA2"],
        ["\x5B\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x90"],
        ["\x5B\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8D"],
        ["\x5B\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA0"],
        ["\x5B\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x84"],
        ["\x5B\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA2"],
        ["\x5B\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA3"],
        ["\x5A\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x97"],
        ["\x5A\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x97"],
        ["\x5A\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xBB"],
        ["\x5A\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x83"],
        ["\x5A\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x82"],
        ["\x5A\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xB8"],
        ["\x5A\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xB3"],
        ["\x5A\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAC"],
        ["\x5A\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9E"],
        ["\x5A\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x91"],
        ["\x5A\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9F"],
        ["\x5A\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAA"],
        ["\x5A\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9A"],
        ["\x5A\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xAA"],
        ["\x5A\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBB"],
        ["\x5A\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x85"],
        ["\x5A\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x96"],
        ["\x5A\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBA"],
        ["\x5A\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x92"],
        ["\x5A\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x96"],
        ["\x5A\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xB1"],
        ["\x5A\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9F"],
        ["\x5A\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB8"],
        ["\x5A\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB7"],
        ["\x5A\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9C"],
        ["\x5A\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB9"],
        ["\x5A\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAE"],
        ["\x5A\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x87"],
        ["\x5A\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x83"],
        ["\x5A\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x89"],
        ["\x5A\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x90"],
        ["\x5A\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x99"],
        ["\x5A\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x94"],
        ["\x5A\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x9B"],
        ["\x5A\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x9F"],
        ["\x5A\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA1"],
        ["\x5A\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB8"],
        ["\x5A\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB9"],
        ["\x5A\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBF"],
        ["\x5A\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x80"],
        ["\x5A\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x84"],
        ["\x5A\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x83"],
        ["\x5A\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8D"],
        ["\x5A\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x98"],
        ["\x5A\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x95"],
        ["\x5A\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x9E"],
        ["\x5A\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xA4"],
        ["\x5A\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAA"],
        ["\x5A\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAB"],
        ["\x5A\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAF"],
        ["\x5A\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB2"],
        ["\x5A\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB1"],
        ["\x5A\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB3"],
        ["\x5A\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB7"],
        ["\x5A\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBC"],
        ["\x5A\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x86"],
        ["\x5A\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8B"],
        ["\x5A\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x93"],
        ["\x5A\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9F"],
        ["\x5A\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAC"],
        ["\x5A\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAB"],
        ["\x5A\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xB3"],
        ["\x5A\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAF"],
        ["\x5A\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBE"],
        ["\x5A\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x88"],
        ["\x5A\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x93"],
        ["\x5A\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x94"],
        ["\x5A\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x9B"],
        ["\x5A\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xA4"],
        ["\x5A\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xA3"],
        ["\x5A\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9E"],
        ["\x5A\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x95"],
        ["\x5A\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA2"],
        ["\x5A\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xAA"],
        ["\x5A\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x82"],
        ["\x5A\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x8D"],
        ["\x5A\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9A"],
        ["\x5A\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x81"],
        ["\x5A\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9B"],
        ["\x5A\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBE"],
        ["\x5A\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA8"],
        ["\x5A\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB3"],
        ["\x5A\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x92"],
        ["\x5A\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x90"],
        ["\x5A\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x84"],
        ["\x5A\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB1"],
        ["\x5A\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x93"],
        ["\x5A\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBD"],
        ["\x5A\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x97"],
        ["\x5A\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x85"],
        ["\x5A\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9D"],
        ["\x5A\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAE"],
        ["\x5A\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB1"],
        ["\x5A\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBE"],
        ["\x5F\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBA"],
        ["\x5F\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9B"],
        ["\x5F\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAF"],
        ["\x5F\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x99"],
        ["\x5F\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAA"],
        ["\x5F\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9F"],
        ["\x5F\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8D"],
        ["\x5F\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB6"],
        ["\x5F\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAB"],
        ["\x5F\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBD"],
        ["\x5F\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB8"],
        ["\x5F\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x99"],
        ["\x5F\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB5"],
        ["\x5F\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB3"],
        ["\x5F\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x92"],
        ["\x5F\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8C"],
        ["\x5F\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA3"],
        ["\x5F\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x93"],
        ["\x5F\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA4"],
        ["\x5F\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9A"],
        ["\x5F\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB9"],
        ["\x5F\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x99"],
        ["\x5F\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8E"],
        ["\x5F\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x95"],
        ["\xC5\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA4"],
        ["\x5F\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x85"],
        ["\x5F\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB9"],
        ["\x5F\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x95"],
        ["\x5F\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x8A"],
        ["\x5F\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB5"],
        ["\x5F\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x87"],
        ["\x5F\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA6"],
        ["\x5F\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB8"],
        ["\x5F\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x86"],
        ["\x5F\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAC"],
        ["\x5F\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9E"],
        ["\x5F\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8C"],
        ["\x5F\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA8"],
        ["\x5F\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x92"],
        ["\x5F\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x85"],
        ["\x5F\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBA"],
        ["\x5F\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x99"],
        ["\x5F\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA4"],
        ["\x5F\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x95"],
        ["\x5F\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAA"],
        ["\x5F\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAE"],
        ["\x5F\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAD"],
        ["\x5F\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAE"],
        ["\x5F\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAE"],
        ["\x5F\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x99"],
        ["\x5F\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xB2"],
        ["\x5F\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9F"],
        ["\x5F\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBE"],
        ["\x5F\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA3"],
        ["\x5F\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAB"],
        ["\x5F\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAB"],
        ["\x5F\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xB6"],
        ["\x5F\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8D"],
        ["\x5F\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9F"],
        ["\x5F\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x83"],
        ["\x5F\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBA"],
        ["\x5F\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8E"],
        ["\x5F\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA4"],
        ["\x5F\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBF"],
        ["\x5F\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9D"],
        ["\x5F\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB8"],
        ["\x5F\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x82"],
        ["\x5F\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAA"],
        ["\x5F\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x98"],
        ["\x5F\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x89"],
        ["\x5F\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB7"],
        ["\x5F\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x93"],
        ["\x5F\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBD"],
        ["\x5F\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAF"],
        ["\x5F\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x84"],
        ["\x5F\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB2"],
        ["\x5F\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x94"],
        ["\x5F\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x95"],
        ["\x5F\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x8F"],
        ["\x5F\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA5"],
        ["\x5F\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x82"],
        ["\x5F\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9F"],
        ["\x5F\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x81"],
        ["\x5F\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x91"],
        ["\xF4\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x8C"],
        ["\x5F\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAC"],
        ["\x5F\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB8"],
        ["\x5F\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBE"],
        ["\x5F\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBF"],
        ["\x5F\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB2"],
        ["\x5F\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB1"],
        ["\x5F\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAF"],
        ["\x5F\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB2"],
        ["\x5F\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8C"],
        ["\x6D\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBE"],
        ["\x6D\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x93"],
        ["\x6D\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB7"],
        ["\x6D\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x86"],
        ["\x6D\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBA"],
        ["\x6D\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB8"],
        ["\x6D\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x81"],
        ["\x6D\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x80"],
        ["\x6D\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAF"],
        ["\x6D\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9B"],
        ["\x6D\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB3"],
        ["\x6D\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAD"],
        ["\x6D\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x82"],
        ["\x6D\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBC"],
        ["\x6D\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x98"],
        ["\x6D\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x8E"],
        ["\x6D\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x91"],
        ["\x6D\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x82"],
        ["\x6D\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA6"],
        ["\x6D\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB3"],
        ["\x6D\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA3"],
        ["\x6D\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA1"],
        ["\x6D\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA4"],
        ["\x6D\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB9"],
        ["\x6D\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x86"],
        ["\x6D\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xAA"],
        ["\x6D\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9F"],
        ["\x6D\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x95"],
        ["\x6D\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAC"],
        ["\x6D\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x94"],
        ["\x6D\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x98"],
        ["\x6D\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB1"],
        ["\x6D\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAE"],
        ["\x6D\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9B"],
        ["\x6D\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x89"],
        ["\x6D\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8B"],
        ["\x6D\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBA"],
        ["\x6D\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x91"],
        ["\x6D\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x81"],
        ["\x6D\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8F"],
        ["\x6D\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBE"],
        ["\x6D\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9B"],
        ["\x6D\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9A"],
        ["\x6D\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB4"],
        ["\x6D\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9D"],
        ["\x6D\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x98"],
        ["\x6D\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9F"],
        ["\x6D\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB0"],
        ["\x6D\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xBE"],
        ["\x6D\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB2"],
        ["\x6D\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x91"],
        ["\x6D\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xA3"],
        ["\x6D\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x99"],
        ["\x6D\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x92"],
        ["\x6D\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAF"],
        ["\x6D\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xB1"],
        ["\x6D\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAC"],
        ["\x6D\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB8"],
        ["\x6D\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB3"],
        ["\x6D\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAE"],
        ["\x6D\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9F"],
        ["\x6D\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8B"],
        ["\x6D\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9D"],
        ["\x6D\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x99"],
        ["\x6D\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x89"],
        ["\x6D\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xBD"],
        ["\x6D\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9C"],
        ["\x6D\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x99"],
        ["\x6D\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA5"],
        ["\x6D\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x95"],
        ["\x6D\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x88"],
        ["\x6D\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA6"],
        ["\x6D\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA2"],
        ["\x6D\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8C"],
        ["\x6D\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x96"],
        ["\x6D\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xAC"],
        ["\x6D\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x8F"],
        ["\x6D\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBB"],
        ["\x6D\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x84"],
        ["\x6D\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x95"],
        ["\x6D\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xA8"],
        ["\x6D\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xAC"],
        ["\x6D\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x97"],
        ["\x6D\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB9"],
        ["\x6D\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xBE"],
        ["\x6D\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x92"],
        ["\x6D\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x89"],
        ["\x6D\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x94"],
        ["\x6D\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x8E"],
        ["\x6D\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA0"],
        ["\x6D\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAC"],
        ["\x6D\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA7"],
        ["\x6D\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xB5"],
        ["\x6D\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBC"],
        ["\x79\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xB9"],
        ["\x79\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBF"],
        ["\x79\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x8D"],
        ["\x79\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x90"],
        ["\x79\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x9B"],
        ["\x79\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xA8"],
        ["\x79\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAD"],
        ["\x79\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAC"],
        ["\x79\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB0"],
        ["\x79\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB2"],
        ["\x79\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBB"],
        ["\x79\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBC"],
        ["\x79\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBF"],
        ["\x79\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x80"],
        ["\x79\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x86"],
        ["\x79\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x8B"],
        ["\x79\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x98"],
        ["\x79\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB4"],
        ["\x79\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBE"],
        ["\x79\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x82"],
        ["\x79\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x81"],
        ["\x79\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x87"],
        ["\x79\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x92"],
        ["\x79\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x96"],
        ["\x79\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA2"],
        ["\x79\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA7"],
        ["\x79\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB9"],
        ["\x79\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB2"],
        ["\x79\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x83"],
        ["\x79\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x86"],
        ["\x79\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x84"],
        ["\x79\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x8E"],
        ["\x79\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x92"],
        ["\x79\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA2"],
        ["\x79\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA0"],
        ["\x79\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA1"],
        ["\x79\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB9"],
        ["\x79\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB7"],
        ["\x79\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8F"],
        ["\x79\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x97"],
        ["\x79\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x8A"],
        ["\x79\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9C"],
        ["\x79\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x96"],
        ["\x79\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9D"],
        ["\x79\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB4"],
        ["\x79\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAF"],
        ["\x79\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA9"],
        ["\x79\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA5"],
        ["\x79\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBE"],
        ["\x79\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x8E"],
        ["\x79\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x8F"],
        ["\x79\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x98"],
        ["\x79\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x97"],
        ["\x79\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAA"],
        ["\x79\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA8"],
        ["\x79\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB0"],
        ["\x79\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB8"],
        ["\x79\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB5"],
        ["\x79\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBB"],
        ["\x79\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBA"],
        ["\x79\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x88"],
        ["\x79\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB3"],
        ["\x79\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8E"],
        ["\x79\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBB"],
        ["\x79\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x80"],
        ["\x79\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA5"],
        ["\x79\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAE"],
        ["\x79\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x9E"],
        ["\x79\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA2"],
        ["\x79\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x85"],
        ["\x79\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAF"],
        ["\x79\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA5"],
        ["\x79\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB8"],
        ["\x79\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB2"],
        ["\x79\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xBA"],
        ["\x79\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x95"],
        ["\x79\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xBF"],
        ["\x79\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9F"],
        ["\x79\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x99"],
        ["\x79\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x81"],
        ["\x79\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9C"],
        ["\x79\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA9"],
        ["\x79\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB0"],
        ["\x79\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA3"],
        ["\x79\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAA"],
        ["\x95\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB6"],
        ["\x79\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xBE"],
        ["\x79\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x8B"],
        ["\x79\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x9E"],
        ["\x79\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA7"],
        ["\x79\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x8A"],
        ["\x79\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x8F"],
        ["\x79\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x94"],
        ["\x79\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB1"],
        ["\x57\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA0"],
        ["\x57\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA3"],
        ["\x57\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA7"],
        ["\x57\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA9"],
        ["\x57\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xAE"],
        ["\x57\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB2"],
        ["\x57\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB0"],
        ["\x57\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB1"],
        ["\x57\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB8"],
        ["\x57\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB7"],
        ["\x57\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x84"],
        ["\x57\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x83"],
        ["\x57\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x85"],
        ["\x57\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8C"],
        ["\x57\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8E"],
        ["\x57\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8D"],
        ["\x57\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x95"],
        ["\x57\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x93"],
        ["\x57\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9E"],
        ["\x57\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA6"],
        ["\x57\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAC"],
        ["\x57\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBC"],
        ["\x57\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x84"],
        ["\x57\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8D"],
        ["\x57\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8A"],
        ["\x57\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x89"],
        ["\x57\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9B"],
        ["\x57\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x86"],
        ["\x57\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9A"],
        ["\x57\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA9"],
        ["\x57\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA4"],
        ["\x57\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA7"],
        ["\x57\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAB"],
        ["\x57\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAD"],
        ["\x57\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB8"],
        ["\x57\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB6"],
        ["\x57\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x86"],
        ["\x57\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x87"],
        ["\x57\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB4"],
        ["\x57\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8A"],
        ["\x57\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x89"],
        ["\x57\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x82"],
        ["\x57\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x94"],
        ["\x57\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x9A"],
        ["\x57\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x9D"],
        ["\x57\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA5"],
        ["\x57\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA3"],
        ["\x57\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x82"],
        ["\x57\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB3"],
        ["\x57\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x83"],
        ["\x57\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB5"],
        ["\x57\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBD"],
        ["\x57\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB8"],
        ["\x57\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBC"],
        ["\x57\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB1"],
        ["\x57\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8D"],
        ["\x57\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8A"],
        ["\x57\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x92"],
        ["\x57\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x99"],
        ["\x57\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA3"],
        ["\x57\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9E"],
        ["\x57\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBE"],
        ["\x57\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBF"],
        ["\x57\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBC"],
        ["\x57\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x81"],
        ["\x57\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB0"],
        ["\x57\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBA"],
        ["\x57\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB2"],
        ["\x57\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB3"],
        ["\x57\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8B"],
        ["\x57\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8D"],
        ["\x57\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x89"],
        ["\x57\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x9F"],
        ["\x57\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA7"],
        ["\x57\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA0"],
        ["\x57\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA1"],
        ["\x57\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA2"],
        ["\x57\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA4"],
        ["\x57\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB4"],
        ["\x57\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB0"],
        ["\x57\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xBB"],
        ["\x57\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x87"],
        ["\x57\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x88"],
        ["\x57\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x86"],
        ["\x57\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x9C"],
        ["\x57\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x98"],
        ["\x57\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA1"],
        ["\x57\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA2"],
        ["\x57\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA8"],
        ["\x57\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA9"],
        ["\x57\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAA"],
        ["\x57\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA7"],
        ["\x57\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAC"],
        ["\x57\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB0"],
        ["\x59\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB2"],
        ["\x59\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB6"],
        ["\x59\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB8"],
        ["\x59\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBC"],
        ["\x59\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x80"],
        ["\x59\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x83"],
        ["\x59\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x88"],
        ["\x59\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x8B"],
        ["\x59\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x8E"],
        ["\x59\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x96"],
        ["\x59\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x93"],
        ["\x59\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x99"],
        ["\x59\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9A"],
        ["\x59\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB0"],
        ["\x59\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB4"],
        ["\x59\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB8"],
        ["\x59\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB9"],
        ["\x59\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xBA"],
        ["\x59\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x82"],
        ["\x59\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8D"],
        ["\x59\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x96"],
        ["\x59\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x92"],
        ["\x59\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9E"],
        ["\x59\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA1"],
        ["\x59\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA5"],
        ["\x59\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA7"],
        ["\x59\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAA"],
        ["\x59\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xAF"],
        ["\x59\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBB"],
        ["\x59\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x88"],
        ["\x59\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x87"],
        ["\x59\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x84"],
        ["\x59\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA9"],
        ["\x59\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA4"],
        ["\x59\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9E"],
        ["\x59\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA5"],
        ["\x59\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA6"],
        ["\x59\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9B"],
        ["\x59\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB7"],
        ["\x59\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB8"],
        ["\x59\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x87"],
        ["\x59\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9A"],
        ["\x59\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA8"],
        ["\x59\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xAB"],
        ["\x59\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9B"],
        ["\x59\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA5"],
        ["\x59\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBF"],
        ["\x59\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBE"],
        ["\x59\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xB9"],
        ["\x59\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x8E"],
        ["\x59\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x8B"],
        ["\x59\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x91"],
        ["\x59\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA0"],
        ["\x59\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x9E"],
        ["\x59\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB0"],
        ["\x59\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB6"],
        ["\x59\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB9"],
        ["\x59\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBF"],
        ["\x59\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBC"],
        ["\x59\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBD"],
        ["\x59\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBB"],
        ["\x59\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x87"],
        ["\x59\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x8D"],
        ["\x59\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x97"],
        ["\x59\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9A"],
        ["\x59\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9C"],
        ["\x59\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA3"],
        ["\x59\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAE"],
        ["\x59\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xBC"],
        ["\x59\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x8C"],
        ["\x59\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x92"],
        ["\xF9\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xA6"],
        ["\x59\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA0"],
        ["\xC5\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAA"],
        ["\x59\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x85"],
        ["\x59\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8E"],
        ["\x59\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xB4"],
        ["\x59\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x86"],
        ["\x59\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xBC"],
        ["\x59\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x9A"],
        ["\x59\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8C"],
        ["\x59\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA3"],
        ["\x59\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xB5"],
        ["\x59\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAA"],
        ["\x59\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAF"],
        ["\x59\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x91"],
        ["\x59\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x86"],
        ["\x59\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8B"],
        ["\x59\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x94"],
        ["\x59\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBE"],
        ["\x59\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBC"],
        ["\x59\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x85"],
        ["\x59\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8A"],
        ["\x59\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xAC"],
        ["\x62\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA7"],
        ["\x62\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x9A"],
        ["\x62\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBD"],
        ["\x62\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xB4"],
        ["\x62\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x87"],
        ["\x62\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x92"],
        ["\x62\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x91"],
        ["\x62\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x99"],
        ["\x62\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAC"],
        ["\x62\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAB"],
        ["\x62\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x80"],
        ["\x62\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA0"],
        ["\x62\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x97"],
        ["\x62\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9F"],
        ["\x62\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9A"],
        ["\x62\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x95"],
        ["\x62\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x93"],
        ["\x62\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xBA"],
        ["\x62\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xBF"],
        ["\x62\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8A"],
        ["\x62\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x9D"],
        ["\x62\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA7"],
        ["\x62\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8B"],
        ["\x62\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xAA"],
        ["\x62\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xAE"],
        ["\x62\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB3"],
        ["\x62\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB9"],
        ["\x62\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBA"],
        ["\x62\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x89"],
        ["\x62\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x95"],
        ["\x62\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA7"],
        ["\x62\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xAC"],
        ["\x62\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA1"],
        ["\x62\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA3"],
        ["\x62\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x88"],
        ["\x62\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8D"],
        ["\x62\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x98"],
        ["\x62\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x99"],
        ["\x62\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xA0"],
        ["\x62\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9F"],
        ["\x62\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x80"],
        ["\x62\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB1"],
        ["\x62\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBB"],
        ["\x62\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBE"],
        ["\x62\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB7"],
        ["\x62\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x83"],
        ["\x62\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x97"],
        ["\x62\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x89"],
        ["\x62\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA1"],
        ["\x62\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA2"],
        ["\x62\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA9"],
        ["\x62\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x9D"],
        ["\x62\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB0"],
        ["\x62\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB9"],
        ["\x62\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBD"],
        ["\x62\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x88"],
        ["\x62\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x97"],
        ["\x62\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x95"],
        ["\x62\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x98"],
        ["\x62\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x96"],
        ["\x62\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xA9"],
        ["\xF3\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x88"],
        ["\x62\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB0"],
        ["\x62\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB6"],
        ["\x62\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x85"],
        ["\x62\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x84"],
        ["\x62\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBF"],
        ["\x62\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x83"],
        ["\x62\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x87"],
        ["\x62\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8A"],
        ["\x62\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8D"],
        ["\x62\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8F"],
        ["\x62\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x95"],
        ["\x62\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x93"],
        ["\x62\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x99"],
        ["\x62\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9A"],
        ["\x62\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9D"],
        ["\x62\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA1"],
        ["\x62\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA2"],
        ["\x62\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA6"],
        ["\x62\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAD"],
        ["\x62\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB0"],
        ["\x62\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x82"],
        ["\x62\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8F"],
        ["\x62\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8A"],
        ["\x62\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x86"],
        ["\x62\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB3"],
        ["\x62\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x98"],
        ["\x62\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x99"],
        ["\x62\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x9E"],
        ["\x62\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB5"],
        ["\x62\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA8"],
        ["\x62\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB6"],
        ["\x62\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x90"],
        ["\x63\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xBA"],
        ["\x63\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x84"],
        ["\x63\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8D"],
        ["\x63\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8B"],
        ["\x63\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8C"],
        ["\x63\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x85"],
        ["\x63\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB5"],
        ["\x63\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA5"],
        ["\x63\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB4"],
        ["\x63\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA7"],
        ["\x63\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB0"],
        ["\x63\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB1"],
        ["\x63\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAC"],
        ["\x63\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAE"],
        ["\x63\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9D"],
        ["\x63\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x98"],
        ["\x63\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9F"],
        ["\x63\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8D"],
        ["\x63\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9C"],
        ["\x63\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9A"],
        ["\x63\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8B"],
        ["\x63\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x92"],
        ["\x63\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8F"],
        ["\x63\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x9D"],
        ["\x63\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x99"],
        ["\x63\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8B"],
        ["\x63\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x81"],
        ["\x63\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8C"],
        ["\x63\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8F"],
        ["\x63\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB4"],
        ["\x63\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x86"],
        ["\x63\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x9D"],
        ["\x63\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA9"],
        ["\x63\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x91"],
        ["\x63\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x94"],
        ["\x63\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA6"],
        ["\x63\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA5"],
        ["\xD6\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA0"],
        ["\x63\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x80"],
        ["\x63\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x87"],
        ["\x63\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x93"],
        ["\x63\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB3"],
        ["\x63\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB7"],
        ["\x63\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x97"],
        ["\x63\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8D"],
        ["\x63\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB6"],
        ["\x63\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA3"],
        ["\x63\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA7"],
        ["\x63\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xAA"],
        ["\x63\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x9F"],
        ["\x63\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB7"],
        ["\x63\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xAB"],
        ["\x63\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBD"],
        ["\x63\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8C"],
        ["\x63\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x83"],
        ["\x63\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x94"],
        ["\x63\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8F"],
        ["\x63\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x80"],
        ["\x63\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x90"],
        ["\x63\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x98"],
        ["\x63\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x9F"],
        ["\x63\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA4"],
        ["\x63\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x96"],
        ["\x63\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA5"],
        ["\x63\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xAC"],
        ["\x63\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB5"],
        ["\x63\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x83"],
        ["\x63\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x90"],
        ["\x63\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA4"],
        ["\x63\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAD"],
        ["\x63\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA2"],
        ["\x63\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAB"],
        ["\x63\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA1"],
        ["\x63\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA8"],
        ["\x63\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB3"],
        ["\x63\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB2"],
        ["\x63\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB1"],
        ["\x63\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAE"],
        ["\x63\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB9"],
        ["\x63\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBD"],
        ["\x63\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x80"],
        ["\x63\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x85"],
        ["\x63\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x82"],
        ["\x63\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x98"],
        ["\x63\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x92"],
        ["\x63\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9C"],
        ["\x63\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA2"],
        ["\x63\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBB"],
        ["\x63\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xAF"],
        ["\x63\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB2"],
        ["\x63\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB4"],
        ["\x63\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB6"],
        ["\x63\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBA"],
        ["\x63\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x86"],
        ["\x64\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x82"],
        ["\x64\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9C"],
        ["\x64\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x95"],
        ["\x64\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8A"],
        ["\x64\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x85"],
        ["\x64\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8B"],
        ["\x64\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAE"],
        ["\x64\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB2"],
        ["\x64\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBF"],
        ["\x64\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB5"],
        ["\x64\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x86"],
        ["\x64\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB3"],
        ["\x64\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x96"],
        ["\x64\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8E"],
        ["\x64\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB2"],
        ["\x64\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA8"],
        ["\x64\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xAE"],
        ["\x64\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8F"],
        ["\x64\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA3"],
        ["\x64\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x93"],
        ["\x64\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x89"],
        ["\x64\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9B"],
        ["\x64\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x8F"],
        ["\x64\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xBD"],
        ["\x64\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9B"],
        ["\x64\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBA"],
        ["\x64\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAE"],
        ["\x64\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA3"],
        ["\x64\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB5"],
        ["\x64\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x87"],
        ["\x64\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBD"],
        ["\x64\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAB"],
        ["\x64\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBD"],
        ["\x64\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA2"],
        ["\x64\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAF"],
        ["\x64\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9C"],
        ["\x64\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB8"],
        ["\x64\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9F"],
        ["\x64\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB0"],
        ["\x64\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x98"],
        ["\x64\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9D"],
        ["\x64\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA4"],
        ["\x64\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9E"],
        ["\x64\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xBB"],
        ["\x64\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB2"],
        ["\x64\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA1"],
        ["\x64\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x85"],
        ["\x64\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x8A"],
        ["\x64\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA3"],
        ["\x64\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA1"],
        ["\x64\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x92"],
        ["\x64\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB1"],
        ["\x64\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9F"],
        ["\x64\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x89"],
        ["\x64\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x8B"],
        ["\x64\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA2"],
        ["\x64\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x86"],
        ["\x64\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA6"],
        ["\x64\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBB"],
        ["\x64\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB5"],
        ["\x64\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB9"],
        ["\x64\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x83"],
        ["\x64\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB7"],
        ["\x64\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB2"],
        ["\x64\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBA"],
        ["\x64\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA7"],
        ["\x64\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9D"],
        ["\x64\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x96"],
        ["\x64\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9E"],
        ["\x64\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x99"],
        ["\x64\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9A"],
        ["\x64\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB9"],
        ["\x64\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAA"],
        ["\x64\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA9"],
        ["\x64\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBC"],
        ["\x64\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBB"],
        ["\x64\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x83"],
        ["\x64\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x95"],
        ["\x64\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBD"],
        ["\x64\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAE"],
        ["\x64\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBF"],
        ["\x64\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x88"],
        ["\x64\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x89"],
        ["\x64\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8C"],
        ["\x64\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x92"],
        ["\x64\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x90"],
        ["\x64\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x93"],
        ["\x64\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x94"],
        ["\x64\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x96"],
        ["\x64\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8E"],
        ["\x64\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9B"],
        ["\x64\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9C"],
        ["\x64\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xB8"],
        ["\x64\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xBA"],
        ["\x65\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x85"],
        ["\x65\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8C"],
        ["\x65\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8D"],
        ["\x65\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8E"],
        ["\x65\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x90"],
        ["\x65\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x91"],
        ["\x65\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x95"],
        ["\x65\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x94"],
        ["\x65\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x98"],
        ["\x65\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x9F"],
        ["\x65\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA0"],
        ["\x65\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA8"],
        ["\x65\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA9"],
        ["\x65\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA7"],
        ["\x65\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB8"],
        ["\x65\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x82"],
        ["\x65\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x86"],
        ["\x65\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x83"],
        ["\x65\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x88"],
        ["\x65\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x87"],
        ["\x65\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8C"],
        ["\x65\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x94"],
        ["\x65\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9E"],
        ["\x65\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9D"],
        ["\x65\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9A"],
        ["\x65\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA3"],
        ["\x65\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAF"],
        ["\x65\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB2"],
        ["\x65\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB9"],
        ["\x65\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAE"],
        ["\x65\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB6"],
        ["\x65\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB8"],
        ["\x65\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB1"],
        ["\x65\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x85"],
        ["\x65\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x86"],
        ["\x65\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8A"],
        ["\x65\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x95"],
        ["\x65\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x94"],
        ["\x65\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA1"],
        ["\x65\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA6"],
        ["\x65\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA9"],
        ["\x65\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB3"],
        ["\x65\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB9"],
        ["\x65\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9C"],
        ["\x65\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x86"],
        ["\x65\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x84"],
        ["\x65\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8B"],
        ["\x65\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x92"],
        ["\x65\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x98"],
        ["\x65\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x99"],
        ["\x65\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x9C"],
        ["\x65\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA1"],
        ["\x65\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA8"],
        ["\x65\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBF"],
        ["\x65\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBB"],
        ["\x65\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x8A"],
        ["\x65\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x86"],
        ["\x65\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x92"],
        ["\x65\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x98"],
        ["\x65\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9A"],
        ["\x65\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9F"],
        ["\x65\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA2"],
        ["\x65\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA8"],
        ["\x65\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB3"],
        ["\x65\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB2"],
        ["\x65\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB0"],
        ["\x65\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB6"],
        ["\x65\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB9"],
        ["\x65\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBD"],
        ["\x65\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBF"],
        ["\x65\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x84"],
        ["\x65\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x86"],
        ["\x65\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x85"],
        ["\x65\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9B"],
        ["\x65\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x93"],
        ["\x65\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9A"],
        ["\x65\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAD"],
        ["\x65\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x90"],
        ["\x65\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAC"],
        ["\x65\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9B"],
        ["\x65\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA5"],
        ["\x65\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x99"],
        ["\x65\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9D"],
        ["\x65\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x84"],
        ["\x65\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9A"],
        ["\x65\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x96"],
        ["\x65\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x89"],
        ["\x65\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xAF"],
        ["\x65\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB1"],
        ["\x65\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9B"],
        ["\x65\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA9"],
        ["\x65\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA3"],
        ["\x65\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xAF"],
        ["\x65\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8B"],
        ["\x66\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8B"],
        ["\x66\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x86"],
        ["\x66\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xBE"],
        ["\x66\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x93"],
        ["\x66\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x91"],
        ["\x66\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBC"],
        ["\x66\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB1"],
        ["\x66\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAE"],
        ["\x66\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA5"],
        ["\x66\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA6"],
        ["\x66\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB4"],
        ["\x66\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x83"],
        ["\x66\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x88"],
        ["\x66\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x8A"],
        ["\x66\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x80"],
        ["\x66\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x82"],
        ["\x66\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA0"],
        ["\x66\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x95"],
        ["\x66\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA4"],
        ["\x66\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA3"],
        ["\x66\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x9F"],
        ["\x66\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x93"],
        ["\x66\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA9"],
        ["\x66\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB0"],
        ["\x66\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB5"],
        ["\x66\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBE"],
        ["\x66\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB8"],
        ["\x66\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBD"],
        ["\x66\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x80"],
        ["\x66\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x82"],
        ["\x66\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBA"],
        ["\x66\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x89"],
        ["\x66\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x8D"],
        ["\x66\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x91"],
        ["\x66\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x99"],
        ["\x66\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x98"],
        ["\x66\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x88"],
        ["\x66\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9A"],
        ["\x66\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9F"],
        ["\x66\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA0"],
        ["\x66\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA7"],
        ["\x66\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBA"],
        ["\x66\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBB"],
        ["\x66\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBE"],
        ["\x66\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x81"],
        ["\x66\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x82"],
        ["\x66\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x85"],
        ["\x66\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x87"],
        ["\x66\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8A"],
        ["\x66\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8D"],
        ["\x66\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x90"],
        ["\x66\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x96"],
        ["\x66\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xA9"],
        ["\x66\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAB"],
        ["\x66\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB8"],
        ["\x66\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB3"],
        ["\x66\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x80"],
        ["\x66\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x99"],
        ["\x66\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x98"],
        ["\x66\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9D"],
        ["\x66\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9A"],
        ["\x66\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9F"],
        ["\x66\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA4"],
        ["\x66\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA2"],
        ["\x66\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA8"],
        ["\x66\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAA"],
        ["\x66\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAB"],
        ["\x66\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAE"],
        ["\x66\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB1"],
        ["\x66\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB7"],
        ["\x66\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB8"],
        ["\x66\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xBE"],
        ["\x66\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8D"],
        ["\x66\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x92"],
        ["\x66\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAB"],
        ["\x66\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x9F"],
        ["\x66\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBB"],
        ["\x66\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAC"],
        ["\x66\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA1"],
        ["\x66\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA3"],
        ["\x66\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9F"],
        ["\x66\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x92"],
        ["\x66\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB4"],
        ["\x66\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB3"],
        ["\x66\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBA"],
        ["\x66\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x93"],
        ["\x66\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x83"],
        ["\x66\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBB"],
        ["\x66\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB9"],
        ["\x66\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9E"],
        ["\x66\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x86"],
        ["\x66\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9C"],
        ["\x66\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x89"],
        ["\x66\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x99"],
        ["\x67\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB5"],
        ["\x67\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB4"],
        ["\x67\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x96"],
        ["\x67\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB2"],
        ["\x67\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB1"],
        ["\x67\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x80"],
        ["\x67\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB9"],
        ["\x67\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x90"],
        ["\x67\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x85"],
        ["\x67\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAF"],
        ["\x67\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAB"],
        ["\x67\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x97"],
        ["\x67\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x98"],
        ["\x67\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x85"],
        ["\x67\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9A"],
        ["\x67\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xAA"],
        ["\x67\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9F"],
        ["\x67\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA2"],
        ["\x67\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x96"],
        ["\x67\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA3"],
        ["\x67\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8E"],
        ["\x67\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x87"],
        ["\x67\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8A"],
        ["\x67\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBC"],
        ["\x67\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xB5"],
        ["\x67\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB3"],
        ["\x67\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB5"],
        ["\x67\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA0"],
        ["\x67\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x89"],
        ["\x67\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA8"],
        ["\x67\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB4"],
        ["\x67\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x93"],
        ["\x67\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAB"],
        ["\x67\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8E"],
        ["\x67\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xBD"],
        ["\x67\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x83"],
        ["\x67\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x98"],
        ["\x67\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8B"],
        ["\x67\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x81"],
        ["\x67\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB7"],
        ["\x67\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x87"],
        ["\x67\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA0"],
        ["\x67\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB2"],
        ["\x67\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8D"],
        ["\x67\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA2"],
        ["\x67\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA0"],
        ["\x67\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xBD"],
        ["\x67\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB8"],
        ["\x67\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x86"],
        ["\x67\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xBB"],
        ["\x67\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAD"],
        ["\x67\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xAA"],
        ["\x67\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xBC"],
        ["\x67\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x9A"],
        ["\x67\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x84"],
        ["\x67\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB7"],
        ["\x67\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAB"],
        ["\x67\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xAD"],
        ["\x67\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAE"],
        ["\x67\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x82"],
        ["\x67\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA9"],
        ["\x67\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x86"],
        ["\x67\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xAC"],
        ["\x67\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAF"],
        ["\x67\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB9"],
        ["\x67\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB5"],
        ["\x67\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8A"],
        ["\x67\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA2"],
        ["\x67\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB9"],
        ["\x67\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBF"],
        ["\x67\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9F"],
        ["\x67\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x99"],
        ["\x67\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8D"],
        ["\x67\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBB"],
        ["\x67\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x9A"],
        ["\x67\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x90"],
        ["\x67\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x81"],
        ["\x67\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x86"],
        ["\x67\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x96"],
        ["\x67\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xA1"],
        ["\x67\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA1"],
        ["\x67\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBF"],
        ["\x67\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xB4"],
        ["\x67\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x97"],
        ["\x67\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x98"],
        ["\x67\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAC"],
        ["\x67\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9F"],
        ["\x67\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x95"],
        ["\x67\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x94"],
        ["\x67\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBC"],
        ["\x67\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x80"],
        ["\x67\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA3"],
        ["\x67\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x98"],
        ["\x67\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x88"],
        ["\x68\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x81"],
        ["\x4C\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x82"],
        ["\x68\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8B"],
        ["\x68\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x95"],
        ["\x68\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x80"],
        ["\x68\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA4"],
        ["\x68\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x88"],
        ["\x68\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x91"],
        ["\x68\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x8A"],
        ["\x68\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA8"],
        ["\x68\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAD"],
        ["\x68\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x94"],
        ["\x68\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9B"],
        ["\xD3\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xAA"],
        ["\x68\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x87"],
        ["\x68\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9C"],
        ["\x68\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xB7"],
        ["\x68\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xBE"],
        ["\x68\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x90"],
        ["\x68\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x89"],
        ["\x68\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xBA"],
        ["\x68\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8F"],
        ["\x68\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xB9"],
        ["\x68\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x90"],
        ["\x68\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x95"],
        ["\x68\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9D"],
        ["\x68\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA5"],
        ["\x68\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9C"],
        ["\x68\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB9"],
        ["\x68\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x8A"],
        ["\x68\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x93"],
        ["\x68\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x8B"],
        ["\x68\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBE"],
        ["\x68\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBA"],
        ["\x68\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x86"],
        ["\x68\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA2"],
        ["\x68\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x9A"],
        ["\x68\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xB0"],
        ["\x68\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xBF"],
        ["\x68\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x8D"],
        ["\x68\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x95"],
        ["\x68\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x94"],
        ["\x68\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9F"],
        ["\x68\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xA7"],
        ["\x68\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB1"],
        ["\x68\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x93"],
        ["\x68\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA3"],
        ["\x68\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA9"],
        ["\x68\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAA"],
        ["\x68\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8B"],
        ["\x68\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8C"],
        ["\x68\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB6"],
        ["\x68\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAF"],
        ["\x68\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x84"],
        ["\x68\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x86"],
        ["\x68\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB0"],
        ["\x68\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x89"],
        ["\xF3\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA3"],
        ["\x68\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAB"],
        ["\x68\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x94"],
        ["\x68\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9E"],
        ["\x68\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA9"],
        ["\x68\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAC"],
        ["\x68\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9F"],
        ["\x68\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9B"],
        ["\x68\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAF"],
        ["\x68\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x92"],
        ["\x68\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x86"],
        ["\x68\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x88"],
        ["\x68\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x80"],
        ["\x68\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x83"],
        ["\x68\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBB"],
        ["\x68\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x91"],
        ["\x68\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x89"],
        ["\x68\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8D"],
        ["\x68\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xB9"],
        ["\x68\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8A"],
        ["\x68\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB4"],
        ["\x68\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBF"],
        ["\x68\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB7"],
        ["\x68\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBB"],
        ["\x68\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA5"],
        ["\x68\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA9"],
        ["\x68\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9A"],
        ["\x68\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA0"],
        ["\x68\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x9F"],
        ["\x68\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB8"],
        ["\x68\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8C"],
        ["\x68\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8E"],
        ["\x68\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB4"],
        ["\x68\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x97"],
        ["\x68\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA8"],
        ["\x68\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xAE"],
        ["\x68\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x99"],
        ["\x69\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x93"],
        ["\x69\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA3"],
        ["\x69\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xAA"],
        ["\xC7\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x85"],
        ["\x69\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xA2"],
        ["\x69\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x9F"],
        ["\x69\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x82"],
        ["\x69\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAF"],
        ["\x69\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x8B"],
        ["\x69\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBD"],
        ["\x69\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x80"],
        ["\x69\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x90"],
        ["\x69\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x96"],
        ["\x69\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAB"],
        ["\x69\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x84"],
        ["\x69\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xB3"],
        ["\x69\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x87"],
        ["\x69\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x86"],
        ["\x69\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBB"],
        ["\x69\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAF"],
        ["\x69\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB2"],
        ["\x69\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xA0"],
        ["\x69\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8F"],
        ["\x69\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8D"],
        ["\x69\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xBE"],
        ["\x69\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB6"],
        ["\x69\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB7"],
        ["\x69\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8E"],
        ["\x69\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x92"],
        ["\x69\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x91"],
        ["\x69\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x96"],
        ["\x69\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x95"],
        ["\x69\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA2"],
        ["\x69\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA1"],
        ["\x69\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB1"],
        ["\x69\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB6"],
        ["\x69\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB9"],
        ["\x69\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA7"],
        ["\x69\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xBB"],
        ["\x69\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x84"],
        ["\x69\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x82"],
        ["\x69\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x92"],
        ["\x69\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x99"],
        ["\x69\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9E"],
        ["\x69\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA2"],
        ["\x69\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xAB"],
        ["\x69\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x81"],
        ["\x69\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBE"],
        ["\x69\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x9E"],
        ["\x69\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB5"],
        ["\x69\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBD"],
        ["\x69\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB5"],
        ["\x69\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB2"],
        ["\x69\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x82"],
        ["\x69\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x97"],
        ["\x69\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x92"],
        ["\x69\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAE"],
        ["\x69\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x99"],
        ["\x69\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA2"],
        ["\x69\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x8D"],
        ["\x69\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA4"],
        ["\x69\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB0"],
        ["\x69\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xBF"],
        ["\x69\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB1"],
        ["\x69\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x83"],
        ["\x69\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x84"],
        ["\x69\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x94"],
        ["\x69\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x98"],
        ["\x69\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x99"],
        ["\x69\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9D"],
        ["\x69\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB9"],
        ["\x69\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x82"],
        ["\x69\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBC"],
        ["\x69\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB4"],
        ["\x69\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xA8"],
        ["\x69\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB2"],
        ["\x69\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x84"],
        ["\x69\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x8C"],
        ["\x69\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x8A"],
        ["\x69\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x93"],
        ["\x69\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x83"],
        ["\x69\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9E"],
        ["\x69\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xA5"],
        ["\x69\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xAA"],
        ["\x69\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xAB"],
        ["\x69\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x81"],
        ["\x69\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x84"],
        ["\x69\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xBB"],
        ["\x69\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB6"],
        ["\x69\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB8"],
        ["\x69\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x8C"],
        ["\x69\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9D"],
        ["\x69\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA0"],
        ["\x69\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x9E"],
        ["\x70\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA6"],
        ["\x70\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA4"],
        ["\x70\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAD"],
        ["\x70\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAA"],
        ["\x70\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAF"],
        ["\x70\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB4"],
        ["\x70\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB7"],
        ["\x70\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xBE"],
        ["\x70\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x83"],
        ["\x70\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x88"],
        ["\x70\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8A"],
        ["\x70\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x93"],
        ["\x70\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x98"],
        ["\x70\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA1"],
        ["\x70\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA9"],
        ["\x70\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA6"],
        ["\x70\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAC"],
        ["\x70\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAF"],
        ["\x70\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB2"],
        ["\x70\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBA"],
        ["\x70\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBD"],
        ["\x70\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBF"],
        ["\x70\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x80"],
        ["\x70\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9A"],
        ["\x70\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9C"],
        ["\x70\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9D"],
        ["\x70\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA7"],
        ["\x70\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB4"],
        ["\x70\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB8"],
        ["\x70\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x83"],
        ["\x70\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x96"],
        ["\x70\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x90"],
        ["\x70\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8C"],
        ["\x70\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9B"],
        ["\x70\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9D"],
        ["\x70\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA5"],
        ["\x70\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB6"],
        ["\x70\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x81"],
        ["\x70\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9B"],
        ["\x70\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x92"],
        ["\x70\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x86"],
        ["\x70\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x88"],
        ["\x70\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xBC"],
        ["\x70\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAD"],
        ["\x70\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAC"],
        ["\x70\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA2"],
        ["\x70\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x85"],
        ["\x70\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x82"],
        ["\x70\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x84"],
        ["\x70\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA8"],
        ["\x70\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA1"],
        ["\x70\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x91"],
        ["\x70\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA5"],
        ["\x70\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA6"],
        ["\x70\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x9A"],
        ["\x70\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA3"],
        ["\x70\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x84"],
        ["\x70\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8D"],
        ["\x70\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x82"],
        ["\x70\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9A"],
        ["\xF4\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAB"],
        ["\x70\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB3"],
        ["\x70\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA7"],
        ["\x70\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA4"],
        ["\x70\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB1"],
        ["\x70\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x94"],
        ["\x70\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA0"],
        ["\x70\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA2"],
        ["\x70\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB7"],
        ["\x70\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9E"],
        ["\x70\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9B"],
        ["\x70\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8C"],
        ["\x70\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x87"],
        ["\x70\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9A"],
        ["\x70\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA1"],
        ["\x70\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x96"],
        ["\x70\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x90"],
        ["\x70\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x97"],
        ["\x70\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA0"],
        ["\x70\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xB3"],
        ["\x70\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAB"],
        ["\x70\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA6"],
        ["\x70\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAB"],
        ["\x70\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xBE"],
        ["\x70\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA8"],
        ["\x70\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x81"],
        ["\x70\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8C"],
        ["\x70\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8F"],
        ["\x70\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8E"],
        ["\x70\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x89"],
        ["\x70\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x96"],
        ["\x70\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9B"],
        ["\x70\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9A"],
        ["\x70\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAB"],
        ["\x71\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9F"],
        ["\x71\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAC"],
        ["\x71\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAF"],
        ["\x71\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB4"],
        ["\x71\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xBD"],
        ["\x71\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x80"],
        ["\x71\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8C"],
        ["\x71\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8E"],
        ["\x71\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x92"],
        ["\x71\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x93"],
        ["\x71\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x96"],
        ["\x71\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x99"],
        ["\x71\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x9A"],
        ["\x71\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBA"],
        ["\x71\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x81"],
        ["\x71\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBF"],
        ["\x71\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x88"],
        ["\x71\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8C"],
        ["\x71\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8E"],
        ["\x71\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x90"],
        ["\x71\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x95"],
        ["\x71\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA2"],
        ["\x71\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAC"],
        ["\x71\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xB8"],
        ["\x71\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xBA"],
        ["\x71\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x82"],
        ["\x71\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x89"],
        ["\x71\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x85"],
        ["\x71\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8A"],
        ["\x71\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8D"],
        ["\x71\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8E"],
        ["\x71\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x94"],
        ["\x71\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xBC"],
        ["\x71\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x98"],
        ["\x71\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9D"],
        ["\x71\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAD"],
        ["\x71\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAA"],
        ["\x71\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBD"],
        ["\x71\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB2"],
        ["\x71\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB3"],
        ["\x71\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAE"],
        ["\x71\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB6"],
        ["\x71\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x88"],
        ["\x71\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x81"],
        ["\xC1\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA4"],
        ["\x71\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA3"],
        ["\x71\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9A"],
        ["\x71\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBD"],
        ["\x71\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBA"],
        ["\x71\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBB"],
        ["\x71\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x84"],
        ["\x71\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x85"],
        ["\x71\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8A"],
        ["\x71\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x87"],
        ["\x71\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8F"],
        ["\x71\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8D"],
        ["\x71\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x90"],
        ["\x71\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8E"],
        ["\x71\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x93"],
        ["\x71\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8D"],
        ["\x71\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x94"],
        ["\x71\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x96"],
        ["\x71\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA7"],
        ["\x71\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAD"],
        ["\x71\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB1"],
        ["\x71\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB3"],
        ["\x71\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x81"],
        ["\x71\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x99"],
        ["\x71\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x82"],
        ["\x71\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xBE"],
        ["\x71\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xBA"],
        ["\x71\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8F"],
        ["\x71\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9A"],
        ["\x71\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x96"],
        ["\x71\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8C"],
        ["\x71\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9B"],
        ["\x71\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8B"],
        ["\x71\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAA"],
        ["\x71\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAB"],
        ["\x71\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9F"],
        ["\x71\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA3"],
        ["\x71\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBC"],
        ["\x71\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x88"],
        ["\x71\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x89"],
        ["\x71\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBF"],
        ["\x71\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9D"],
        ["\x71\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9E"],
        ["\x71\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x90"],
        ["\x71\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9F"],
        ["\x71\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x82"],
        ["\x71\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB5"],
        ["\x71\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB0"],
        ["\x71\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB4"],
        ["\x71\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x8A"],
        ["\x72\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x87"],
        ["\x72\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x89"],
        ["\x72\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x8C"],
        ["\x72\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x90"],
        ["\x72\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x88"],
        ["\x72\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x99"],
        ["\x72\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA4"],
        ["\x72\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA0"],
        ["\x72\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xAA"],
        ["\x72\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA3"],
        ["\x72\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x95"],
        ["\x72\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB6"],
        ["\x72\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB2"],
        ["\x72\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xBC"],
        ["\x72\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x81"],
        ["\x72\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x87"],
        ["\x72\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x85"],
        ["\x72\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x84"],
        ["\x72\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8B"],
        ["\x72\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8A"],
        ["\x72\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x93"],
        ["\x72\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x91"],
        ["\x72\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x94"],
        ["\x72\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x99"],
        ["\x72\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAA"],
        ["\x72\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xA1"],
        ["\x72\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAC"],
        ["\x72\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xB0"],
        ["\x72\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x86"],
        ["\x72\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xB1"],
        ["\x72\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xBE"],
        ["\x72\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x85"],
        ["\x72\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x88"],
        ["\x72\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8B"],
        ["\x72\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x9B"],
        ["\x72\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xA3"],
        ["\x72\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBC"],
        ["\x72\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBB"],
        ["\x72\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xAB"],
        ["\x72\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBE"],
        ["\x72\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x8A"],
        ["\x72\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x85"],
        ["\x72\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x95"],
        ["\x72\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x92"],
        ["\x72\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x99"],
        ["\x72\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x93"],
        ["\x72\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9C"],
        ["\x72\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9F"],
        ["\x72\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9B"],
        ["\x72\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x8C"],
        ["\x72\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xA6"],
        ["\x72\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB3"],
        ["\x72\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBB"],
        ["\x72\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB9"],
        ["\x72\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x85"],
        ["\x72\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x82"],
        ["\x72\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBE"],
        ["\x72\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8C"],
        ["\x72\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x89"],
        ["\x72\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x86"],
        ["\x72\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8E"],
        ["\x72\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x97"],
        ["\x72\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x9C"],
        ["\x72\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA2"],
        ["\x72\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA3"],
        ["\x72\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA4"],
        ["\x72\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9C"],
        ["\x72\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9F"],
        ["\x72\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA3"],
        ["\x72\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAD"],
        ["\x72\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAF"],
        ["\x72\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB7"],
        ["\x72\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x9A"],
        ["\x72\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA5"],
        ["\x72\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA2"],
        ["\x72\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAA"],
        ["\x72\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAF"],
        ["\xC6\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x87"],
        ["\x72\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB4"],
        ["\x72\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x85"],
        ["\x72\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB9"],
        ["\x72\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xBA"],
        ["\x72\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x91"],
        ["\x72\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x95"],
        ["\x72\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA1"],
        ["\x72\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8D"],
        ["\x72\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9E"],
        ["\x72\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x96"],
        ["\x72\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8B"],
        ["\x72\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA7"],
        ["\x72\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB6"],
        ["\x72\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB5"],
        ["\x72\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB9"],
        ["\x72\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB8"],
        ["\x73\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8F"],
        ["\x73\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x90"],
        ["\x73\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x91"],
        ["\x73\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x92"],
        ["\x73\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8E"],
        ["\x73\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x89"],
        ["\x73\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xBE"],
        ["\x73\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x96"],
        ["\x73\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x98"],
        ["\x73\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x9E"],
        ["\x73\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA8"],
        ["\x73\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAF"],
        ["\x73\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB6"],
        ["\x73\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA8"],
        ["\x73\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB2"],
        ["\x73\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x82"],
        ["\x73\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBD"],
        ["\x73\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x81"],
        ["\x73\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x80"],
        ["\x73\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x8A"],
        ["\x73\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x89"],
        ["\x73\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x8F"],
        ["\x73\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA8"],
        ["\x73\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xAF"],
        ["\x73\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB1"],
        ["\x73\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB5"],
        ["\x73\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA2"],
        ["\x73\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA4"],
        ["\x73\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x88"],
        ["\x73\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x9B"],
        ["\x73\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x82"],
        ["\x73\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x92"],
        ["\x73\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x99"],
        ["\x73\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB2"],
        ["\x73\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB0"],
        ["\x73\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8A"],
        ["\x73\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x96"],
        ["\x73\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x98"],
        ["\x73\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA3"],
        ["\x73\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA5"],
        ["\x73\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA9"],
        ["\x73\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB3"],
        ["\x73\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB2"],
        ["\x73\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x8B"],
        ["\x73\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x89"],
        ["\x73\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x82"],
        ["\x73\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xA2"],
        ["\x73\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAB"],
        ["\x73\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAF"],
        ["\x73\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAA"],
        ["\x73\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB5"],
        ["\x73\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB4"],
        ["\x73\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xBA"],
        ["\x73\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x80"],
        ["\x73\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x81"],
        ["\x73\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x89"],
        ["\x73\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8B"],
        ["\x73\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x90"],
        ["\x73\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x96"],
        ["\x73\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9F"],
        ["\x73\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA1"],
        ["\x73\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9B"],
        ["\x73\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBC"],
        ["\x73\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB5"],
        ["\x73\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB6"],
        ["\x73\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x9E"],
        ["\x73\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBF"],
        ["\x73\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x94"],
        ["\x73\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xAC"],
        ["\x73\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x95"],
        ["\x73\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x91"],
        ["\x73\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9E"],
        ["\x73\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x97"],
        ["\x73\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x85"],
        ["\x73\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x89"],
        ["\x73\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA4"],
        ["\x73\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x88"],
        ["\x73\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x95"],
        ["\x73\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xBF"],
        ["\x73\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x8B"],
        ["\x73\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x90"],
        ["\x73\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9C"],
        ["\x73\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x96"],
        ["\x73\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x93"],
        ["\x73\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9B"],
        ["\x73\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9A"],
        ["\x73\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x8F"],
        ["\x73\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xB9"],
        ["\x73\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xB7"],
        ["\x73\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA9"],
        ["\x73\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x8F"],
        ["\x73\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBA"],
        ["\x73\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x84"],
        ["\x73\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAE"],
        ["\x74\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x99"],
        ["\x74\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA2"],
        ["\x74\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9A"],
        ["\x74\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA3"],
        ["\x74\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xBA"],
        ["\x74\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xB5"],
        ["\x74\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xBB"],
        ["\x74\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x9C"],
        ["\x74\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xA0"],
        ["\x74\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xBC"],
        ["\x74\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAE"],
        ["\x74\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x96"],
        ["\x74\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xB0"],
        ["\x74\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAC"],
        ["\x74\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAD"],
        ["\x74\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x94"],
        ["\x74\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xB9"],
        ["\x74\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x96"],
        ["\x74\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x97"],
        ["\x74\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA8"],
        ["\x74\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA5"],
        ["\x74\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x98"],
        ["\x74\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x83"],
        ["\x74\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x9D"],
        ["\x74\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x90"],
        ["\x74\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x88"],
        ["\x74\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA4"],
        ["\x74\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x9A"],
        ["\x74\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x94"],
        ["\x74\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x93"],
        ["\x74\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x83"],
        ["\x74\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x87"],
        ["\x74\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x90"],
        ["\x74\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB6"],
        ["\x74\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xAB"],
        ["\x74\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB5"],
        ["\x74\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xA1"],
        ["\x74\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xBA"],
        ["\x74\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x81"],
        ["\x74\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x92"],
        ["\x74\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x84"],
        ["\x74\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9B"],
        ["\x74\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA0"],
        ["\x74\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA2"],
        ["\x74\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9E"],
        ["\x74\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xAA"],
        ["\x74\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xA9"],
        ["\x74\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB0"],
        ["\x74\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB5"],
        ["\x74\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB7"],
        ["\x74\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBD"],
        ["\x74\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9A"],
        ["\x74\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBC"],
        ["\x74\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBE"],
        ["\x74\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x92\x81"],
        ["\x74\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBF"],
        ["\x74\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x82"],
        ["\x74\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x87"],
        ["\x74\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8A"],
        ["\x74\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x94"],
        ["\x74\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x96"],
        ["\x74\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x98"],
        ["\x74\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x99"],
        ["\x74\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA0"],
        ["\x74\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA8"],
        ["\x74\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA7"],
        ["\x74\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xAD"],
        ["\x74\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBC"],
        ["\x74\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBB"],
        ["\x74\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xB9"],
        ["\x74\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBE"],
        ["\x74\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8A"],
        ["\x74\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB6"],
        ["\x74\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x83"],
        ["\x74\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8D"],
        ["\x74\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8C"],
        ["\x74\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x95"],
        ["\x74\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x94"],
        ["\x74\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x96"],
        ["\x74\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x9C"],
        ["\x74\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\xA1"],
        ["\x74\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\xA5"],
        ["\x74\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\xA2"],
        ["\x74\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xA1"],
        ["\x74\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xA8"],
        ["\x74\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAE"],
        ["\x74\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAF"],
        ["\x74\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x82"],
        ["\x74\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8C"],
        ["\x74\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8F"],
        ["\x74\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8B"],
        ["\x74\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB7"],
        ["\x74\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9C"],
        ["\x74\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9E"],
        ["\x75\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9D"],
        ["\x75\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9F"],
        ["\x75\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA6"],
        ["\x75\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB2"],
        ["\x75\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xAC"],
        ["\x75\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8D"],
        ["\x75\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x98"],
        ["\x75\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x95"],
        ["\x75\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x97"],
        ["\x75\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xAA"],
        ["\x75\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA7"],
        ["\x75\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB1"],
        ["\x75\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB2"],
        ["\x75\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB0"],
        ["\x75\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB4"],
        ["\x75\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB6"],
        ["\x75\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB8"],
        ["\x75\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB9"],
        ["\x75\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8E"],
        ["\x75\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8B"],
        ["\x75\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x89"],
        ["\x75\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8D"],
        ["\x75\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x8D"],
        ["\x75\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9C"],
        ["\x75\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8D"],
        ["\x75\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x95"],
        ["\x75\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB9"],
        ["\x75\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x84"],
        ["\x75\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x86"],
        ["\x75\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x88"],
        ["\x75\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x93"],
        ["\x75\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8E"],
        ["\x75\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x91"],
        ["\x75\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8F"],
        ["\x75\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x96"],
        ["\x75\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x99"],
        ["\x75\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xA4"],
        ["\x75\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xAA"],
        ["\x75\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB0"],
        ["\x75\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB9"],
        ["\x75\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xBD"],
        ["\x75\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xBE"],
        ["\x75\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x84"],
        ["\x75\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x86"],
        ["\x75\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x88"],
        ["\x75\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x82"],
        ["\x75\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x89"],
        ["\x75\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x9C"],
        ["\x75\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA0"],
        ["\x75\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA4"],
        ["\x75\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA6"],
        ["\x75\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA8"],
        ["\x75\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x92"],
        ["\x75\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAB"],
        ["\x6F\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB1"],
        ["\x75\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB9"],
        ["\x75\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x85"],
        ["\x75\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xBC"],
        ["\x75\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x81"],
        ["\x75\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xBA"],
        ["\x75\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x86"],
        ["\x75\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8B"],
        ["\x75\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8F"],
        ["\x75\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x90"],
        ["\x75\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x9C"],
        ["\x75\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA8"],
        ["\x75\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA6"],
        ["\x75\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA3"],
        ["\x75\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xB3"],
        ["\x75\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xB4"],
        ["\x75\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x83"],
        ["\x75\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x86"],
        ["\x75\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x88"],
        ["\x75\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x8B"],
        ["\x75\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x9C"],
        ["\x75\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xAD"],
        ["\x75\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8F"],
        ["\x75\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB2"],
        ["\x75\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9F"],
        ["\x75\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB6"],
        ["\x75\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB5"],
        ["\x75\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8F"],
        ["\x75\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8C"],
        ["\xF7\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB8"],
        ["\x75\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xA4"],
        ["\x75\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xA1"],
        ["\x75\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB7"],
        ["\x75\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBD"],
        ["\x75\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x86"],
        ["\x75\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8F"],
        ["\x75\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8B"],
        ["\x75\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xAB"],
        ["\x75\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xAF"],
        ["\x75\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB0"],
        ["\x76\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB1"],
        ["\x76\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB4"],
        ["\x76\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB3"],
        ["\x76\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xAA"],
        ["\x76\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xAF"],
        ["\x76\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xB1"],
        ["\x76\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xB6"],
        ["\x76\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x84"],
        ["\x76\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x83"],
        ["\x76\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x86"],
        ["\x76\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xA9"],
        ["\x76\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAB"],
        ["\x76\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x83"],
        ["\x76\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x89"],
        ["\x76\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x92"],
        ["\x76\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x94"],
        ["\x76\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x98"],
        ["\x76\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA1"],
        ["\x76\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x9D"],
        ["\x76\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x9E"],
        ["\x76\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA4"],
        ["\x76\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA0"],
        ["\x76\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xAC"],
        ["\x76\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xAE"],
        ["\x76\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xBD"],
        ["\x76\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xBE"],
        ["\x76\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x82"],
        ["\x76\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x89"],
        ["\x76\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x85"],
        ["\x76\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x90"],
        ["\x76\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x8B"],
        ["\x76\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x91"],
        ["\x76\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x92"],
        ["\x76\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x8C"],
        ["\x76\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x95"],
        ["\x76\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x97"],
        ["\x76\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x98"],
        ["\x76\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xA5"],
        ["\x76\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAD"],
        ["\x76\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAE"],
        ["\x76\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xBC"],
        ["\x76\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x9F"],
        ["\x76\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x9B"],
        ["\x76\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x9D"],
        ["\x76\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x98"],
        ["\x76\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x91"],
        ["\x76\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xAD"],
        ["\x76\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xAE"],
        ["\x76\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB1"],
        ["\x76\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB2"],
        ["\x76\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xBB"],
        ["\x76\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB8"],
        ["\x76\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x81"],
        ["\x76\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x8F"],
        ["\x76\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x85"],
        ["\x76\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xA2"],
        ["\x76\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x99"],
        ["\x76\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xAB"],
        ["\x76\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB7"],
        ["\x76\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x85"],
        ["\x76\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x82"],
        ["\x76\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x80"],
        ["\x76\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x83"],
        ["\x76\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xBE"],
        ["\x76\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x95"],
        ["\x76\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x8D"],
        ["\x76\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9B"],
        ["\x76\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x97"],
        ["\x76\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9F"],
        ["\x76\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA2"],
        ["\x76\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA5"],
        ["\x76\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA4"],
        ["\x76\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA9"],
        ["\x76\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xAB"],
        ["\x76\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xAA"],
        ["\x76\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xAD"],
        ["\x76\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB0"],
        ["\x76\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xBC"],
        ["\x76\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x80"],
        ["\x76\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x8F"],
        ["\x76\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x91"],
        ["\x76\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x93"],
        ["\x76\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x94"],
        ["\x76\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x9E"],
        ["\x76\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x9F"],
        ["\x76\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA2"],
        ["\x76\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA3"],
        ["\x76\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA6"],
        ["\x76\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAF"],
        ["\x76\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAB"],
        ["\x76\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAE"],
        ["\x76\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB4"],
        ["\x76\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB1"],
        ["\x76\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB7"],
        ["\x77\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xBB"],
        ["\x77\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x86"],
        ["\x77\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x98"],
        ["\x77\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x9A"],
        ["\x77\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x9F"],
        ["\x77\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA2"],
        ["\x77\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA3"],
        ["\x77\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA5"],
        ["\x77\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA7"],
        ["\x77\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA8"],
        ["\x77\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA9"],
        ["\x77\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAA"],
        ["\x77\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAE"],
        ["\x77\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAF"],
        ["\x77\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xB2"],
        ["\x77\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x84"],
        ["\x77\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x83"],
        ["\x77\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8F"],
        ["\x77\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8D"],
        ["\x77\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8E"],
        ["\x77\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x91"],
        ["\x77\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x98"],
        ["\x77\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB4"],
        ["\x77\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x93"],
        ["\x77\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x83"],
        ["\x77\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x91"],
        ["\x77\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x96"],
        ["\x77\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x97"],
        ["\x77\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x9F"],
        ["\x77\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xA0"],
        ["\x77\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xA8"],
        ["\x77\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB4"],
        ["\x77\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x80"],
        ["\x77\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x8A"],
        ["\x77\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB9"],
        ["\x77\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x86"],
        ["\x77\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x8F"],
        ["\x77\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x91"],
        ["\x77\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x92"],
        ["\x77\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA3"],
        ["\x77\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA2"],
        ["\x77\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA4"],
        ["\x77\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x94"],
        ["\x77\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA1"],
        ["\xF0\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBA"],
        ["\x77\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB2"],
        ["\x77\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB1"],
        ["\x77\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB0"],
        ["\x77\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x95"],
        ["\x77\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x94"],
        ["\x77\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x89"],
        ["\x77\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x93"],
        ["\x77\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8C"],
        ["\x77\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x86"],
        ["\x77\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x88"],
        ["\x77\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x92"],
        ["\x77\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8A"],
        ["\x77\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x84"],
        ["\x77\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAE"],
        ["\x77\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x9B"],
        ["\x77\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA5"],
        ["\x77\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA4"],
        ["\x77\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA1"],
        ["\x77\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB0"],
        ["\x77\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x87"],
        ["\x77\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB2"],
        ["\x77\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x86"],
        ["\x77\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBE"],
        ["\x77\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x9A"],
        ["\x77\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA0"],
        ["\x77\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA7"],
        ["\x77\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB6"],
        ["\x77\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB8"],
        ["\x77\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA7"],
        ["\x77\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xAC"],
        ["\x77\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB0"],
        ["\x77\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x89"],
        ["\x77\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x88"],
        ["\x77\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xAB"],
        ["\x77\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x83"],
        ["\x77\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x86"],
        ["\x77\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAA"],
        ["\x77\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA6"],
        ["\xF2\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xAF"],
        ["\x77\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA3"],
        ["\x77\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9F"],
        ["\x77\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x84"],
        ["\x77\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x95"],
        ["\x77\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x92"],
        ["\x77\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x81"],
        ["\x77\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBF"],
        ["\x77\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBE"],
        ["\x77\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x86"],
        ["\x77\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x88"],
        ["\x78\x4F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9D"],
        ["\x78\x7F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9E"],
        ["\x78\x7B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA4"],
        ["\x78\xE0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x91"],
        ["\x78\x6C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x90"],
        ["\x78\x50",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x99"],
        ["\x78\x7D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB2"],
        ["\x78\x4D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x89"],
        ["\x78\x5D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x87"],
        ["\x78\x5C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xAB"],
        ["\x78\x4E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAF"],
        ["\x78\x6B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xBA"],
        ["\x78\x60",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x9A"],
        ["\x78\x4B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xA4"],
        ["\x78\x61",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xA9"],
        ["\x78\xF0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB2"],
        ["\x78\xF1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x84"],
        ["\x78\xF2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x81"],
        ["\x78\xF3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBB"],
        ["\x78\xF4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB8"],
        ["\x78\xF5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBA"],
        ["\x78\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x86"],
        ["\x78\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x8F"],
        ["\x78\xF8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x82"],
        ["\x78\xF9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x99"],
        ["\x78\x7A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x93"],
        ["\x78\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB8"],
        ["\x78\x4C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xA6"],
        ["\x78\x7E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xAD"],
        ["\x78\x6E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xAF"],
        ["\x78\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xBD"],
        ["\x78\x7C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9A"],
        ["\x78\xC1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9B"],
        ["\x78\xC2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9E"],
        ["\x78\xC3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB5"],
        ["\x78\xC4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB9"],
        ["\x78\xC5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBD"],
        ["\x78\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x81"],
        ["\x78\xC7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x88"],
        ["\x78\xC8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x8B"],
        ["\x78\xC9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x8C"],
        ["\x78\xD1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x92"],
        ["\x78\xD2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x95"],
        ["\x78\xD3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x91"],
        ["\x78\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9D"],
        ["\x78\xD5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA5"],
        ["\x78\xD6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA9"],
        ["\x78\xD7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB8"],
        ["\x78\xD8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xAA"],
        ["\x78\xD9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xAD"],
        ["\x78\xE2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA1"],
        ["\x78\xE3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8C"],
        ["\x78\xE4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8E"],
        ["\x78\xE5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8F"],
        ["\x78\xE6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x90"],
        ["\x78\xE7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x94"],
        ["\x78\xE8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9C"],
        ["\x78\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9E"],
        ["\x78\x4A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9D"],
        ["\x78\x5B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xA0"],
        ["\x78\x5A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xA5"],
        ["\x78\x5F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xA8"],
        ["\x78\x6D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xAF"],
        ["\x78\x79",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB4"],
        ["\x78\x57",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB6"],
        ["\x78\x59",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB7"],
        ["\x78\x62",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xB9"],
        ["\x78\x63",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xBB"],
        ["\x78\x64",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xBC"],
        ["\x78\x65",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\xBD"],
        ["\x78\x66",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x87"],
        ["\x78\x67",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x88"],
        ["\x78\x68",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB7"],
        ["\x78\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x95"],
        ["\x78\x70",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xA1"],
        ["\x78\x71",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xAC"],
        ["\x78\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xBE"],
        ["\x78\x73",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8A"],
        ["\x78\x74",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x92"],
        ["\x78\x75",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x94"],
        ["\x78\x76",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA3"],
        ["\x78\x77",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x9F"],
        ["\x78\x78",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA0"],
        ["\x78\x80",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA1"],
        ["\x78\x8B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA6"],
        ["\x78\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA7"],
        ["\x78\x9C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xAC"],
        ["\x78\xA0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xAA"],
        ["\x78\xAB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB7"],
        ["\x78\xB0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB2"],
        ["\x78\xC0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xB6"],
        ["\x78\x6A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x95"],
        ["\x78\xD0",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x9C"],
        ["\x78\xA1",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\xA0"],
        ["\xF6\xC6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xAF"],
        ["\xD2\x69",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x87"],
        ["\xD4\xE9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x99"],
        ["\x79\x9B",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA4"],
        ["\x84\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9C"],
        ["\x94\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x99"],
        ["\x42\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB0"],
        ["\x42\x8F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB1"],
        ["\x42\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB2"],
        ["\x42\x91",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB3"],
        ["\x42\x92",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB4"],
        ["\x42\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB5"],
        ["\x42\x94",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB6"],
        ["\x42\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB7"],
        ["\x42\x96",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB8"],
        ["\x42\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xB9"],
        ["\x45\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA4"],
        ["\x43\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x87"],
        ["\x43\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x82"],
        ["\x9A\xAE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8A"],
        ["\xA3\x49",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9C"],
        ["\xA7\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x88"],
        ["\xA6\xCF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x88"],
        ["\x9F\x9D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x9C"],
        ["\x82\xEC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x89"],
        ["\x93\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xBB"],
        ["\x8E\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB1"],
        ["\x90\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x88"],
        ["\xA7\x86",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB9"],
        ["\x8E\xAA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBB"],
        ["\x8A\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x85"],
        ["\x82\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA8"],
        ["\x82\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA1"],
        ["\x82\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBC"],
        ["\x82\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x80"],
        ["\x82\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x83"],
        ["\x82\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB9"],
        ["\x82\xAC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x96"],
        ["\x82\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x92"],
        ["\x82\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8A"],
        ["\x8A\xBA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9A"],
        ["\x82\xB3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x94"],
        ["\x82\xEB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8D"],
        ["\x83\x82",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x80"],
        ["\x83\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA2"],
        ["\x83\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBF"],
        ["\x83\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9E"],
        ["\x83\x91",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x86"],
        ["\x83\x94",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB0"],
        ["\x83\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x82"],
        ["\x83\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x94"],
        ["\x83\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB4"],
        ["\x83\xAA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x98"],
        ["\x83\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8A"],
        ["\x83\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA4"],
        ["\x83\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x9D"],
        ["\x84\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xBE"],
        ["\xA9\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAC"],
        ["\x84\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x95"],
        ["\x84\x92",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9C"],
        ["\x84\x94",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA6"],
        ["\x84\xA5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x80"],
        ["\x84\xAE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9B"],
        ["\x84\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x80"],
        ["\x84\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x87"],
        ["\x84\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA4"],
        ["\x85\x47",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB2"],
        ["\x85\x54",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x93"],
        ["\x85\x81",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB2"],
        ["\x85\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9D"],
        ["\x85\x8F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x8E"],
        ["\x85\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x9C"],
        ["\x85\xA4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8A"],
        ["\x85\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA9"],
        ["\x85\xB2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBF"],
        ["\x85\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x86"],
        ["\x86\xAC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x99"],
        ["\x86\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA5"],
        ["\x86\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xAC"],
        ["\x86\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x88"],
        ["\x86\xB8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x87"],
        ["\x86\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x8F"],
        ["\xC4\xD4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x90"],
        ["\x87\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9E"],
        ["\x87\x55",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB2"],
        ["\x87\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8B"],
        ["\x87\x9E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x93"],
        ["\x87\xA4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9B"],
        ["\x87\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9D"],
        ["\x87\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA3"],
        ["\x87\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA4"],
        ["\x87\xB6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBA"],
        ["\x88\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x96"],
        ["\x88\x9D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x80"],
        ["\x88\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAF"],
        ["\x88\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x98"],
        ["\x88\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAC"],
        ["\x88\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x9E"],
        ["\x88\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA6"],
        ["\x88\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBA"],
        ["\x89\x49",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB5"],
        ["\x89\x81",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA7"],
        ["\x97\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x93"],
        ["\x89\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x91"],
        ["\x89\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x82"],
        ["\x89\x91",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAD"],
        ["\x89\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB8"],
        ["\x89\xAA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB9"],
        ["\x89\xBA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x90"],
        ["\x8A\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA1"],
        ["\x8A\x92",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB4"],
        ["\x8A\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA7"],
        ["\x8A\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB7"],
        ["\x8A\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9E"],
        ["\x8C\x49",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9D"],
        ["\x8C\x81",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x85"],
        ["\x85\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8A"],
        ["\x8C\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9E"],
        ["\x8C\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x95"],
        ["\x8C\x9A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA0"],
        ["\x8C\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB2"],
        ["\x8C\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x91"],
        ["\x8C\xAC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xB7"],
        ["\x8C\xAE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xB0"],
        ["\x86\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x98"],
        ["\x8C\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x93"],
        ["\x8D\x81",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xA6"],
        ["\x8D\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB5"],
        ["\x8D\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA0"],
        ["\x8D\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9D"],
        ["\x8D\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8E"],
        ["\x8D\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8E"],
        ["\x8E\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x80"],
        ["\x8E\x85",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x95"],
        ["\xF9\xF7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBB"],
        ["\x8E\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x89"],
        ["\x8E\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAE"],
        ["\x8E\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9E"],
        ["\x8E\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA4"],
        ["\x8E\xAC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA5"],
        ["\x8E\xB2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x97"],
        ["\x8E\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x99"],
        ["\x8E\xB6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x92"],
        ["\x8E\xB8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB3"],
        ["\x8E\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x99"],
        ["\x96\xAE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA0"],
        ["\x8F\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB2"],
        ["\x8F\x53",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBF"],
        ["\x8E\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBA"],
        ["\x8F\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8E"],
        ["\x8F\x8F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4\xA9"],
        ["\x8F\x99",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA6"],
        ["\x8F\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xBB"],
        ["\x8F\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x92"],
        ["\x8F\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x80"],
        ["\x8F\xB4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x81"],
        ["\x8F\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x84"],
        ["\x90\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8F"],
        ["\x90\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x93"],
        ["\x90\x91",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA8"],
        ["\x90\xAD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x94"],
        ["\x97\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x98"],
        ["\x90\xB6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA2"],
        ["\x90\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB0"],
        ["\x90\xB8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xAB"],
        ["\x90\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x86"],
        ["\x90\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB3"],
        ["\x90\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xBE"],
        ["\x91\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA2"],
        ["\x91\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA4"],
        ["\x91\xA4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x96"],
        ["\x91\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xBF"],
        ["\x91\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9C"],
        ["\x91\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x86"],
        ["\x91\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xAF"],
        ["\x91\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9A"],
        ["\x92\x47",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x84"],
        ["\x92\x86",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x87"],
        ["\x92\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAF"],
        ["\x92\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x96"],
        ["\x92\x9D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAC"],
        ["\x92\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8F"],
        ["\x92\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB8"],
        ["\x92\xBF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB2"],
        ["\x92\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBC"],
        ["\x92\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB9"],
        ["\x92\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9C"],
        ["\x92\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA7"],
        ["\x92\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBC"],
        ["\x93\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBF"],
        ["\x93\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x88"],
        ["\x93\xBF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB5"],
        ["\x93\xB6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB5"],
        ["\x93\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x85"],
        ["\x93\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x87"],
        ["\x93\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA8"],
        ["\x93\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x85"],
        ["\x93\xFC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAB"],
        ["\x94\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x8F"],
        ["\x94\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x84"],
        ["\x94\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x9C"],
        ["\x94\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x86"],
        ["\x94\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x87"],
        ["\x94\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x95"],
        ["\x94\xA5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x81"],
        ["\x94\xAA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBE"],
        ["\x94\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB1"],
        ["\x94\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xBE"],
        ["\x94\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA4"],
        ["\x94\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x96"],
        ["\x95\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB7"],
        ["\x95\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBD"],
        ["\x95\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x89"],
        ["\x95\x92",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x96"],
        ["\x95\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA3"],
        ["\x95\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x92"],
        ["\x95\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x87"],
        ["\x95\x9E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB5"],
        ["\x95\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA6"],
        ["\x95\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAA"],
        ["\x95\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA9"],
        ["\x95\xAD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAE"],
        ["\x95\xCF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA2"],
        ["\x95\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x89"],
        ["\x95\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x9F"],
        ["\x96\x53",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x81"],
        ["\x96\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAF"],
        ["\x96\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x82"],
        ["\x96\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9C"],
        ["\x96\xBA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9E"],
        ["\x96\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9B"],
        ["\x96\xBF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xA6"],
        ["\x96\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x97"],
        ["\x96\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x86"],
        ["\x84\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAF"],
        ["\x97\x81",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA1"],
        ["\x97\x85",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x8E"],
        ["\x97\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xA4"],
        ["\x97\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xBA"],
        ["\x97\xBA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xB0"],
        ["\x97\xBD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x98"],
        ["\x97\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x99"],
        ["\x97\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9A"],
        ["\x98\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x94"],
        ["\x98\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9B"],
        ["\x98\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x9B"],
        ["\x98\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x91"],
        ["\x98\xEB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA7"],
        ["\x98\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9C"],
        ["\x98\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAB"],
        ["\x99\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9E"],
        ["\x99\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9D"],
        ["\x9A\x47",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x88"],
        ["\x9A\x53",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9C"],
        ["\x9A\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB7"],
        ["\x9A\x86",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA0"],
        ["\x9A\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x96"],
        ["\x9A\xAA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x92"],
        ["\x90\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x87"],
        ["\x9A\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA1"],
        ["\x9A\xEC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9E"],
        ["\x9E\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x81"],
        ["\x9E\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xA2"],
        ["\x9E\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBF"],
        ["\x9F\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x87"],
        ["\x9E\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB6"],
        ["\x9F\x82",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x88"],
        ["\x9F\x94",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB4"],
        ["\x9F\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x93"],
        ["\x9F\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x99"],
        ["\x9F\xCF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAB"],
        ["\x9F\xFD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\x9F"],
        ["\xA2\x49",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xB0"],
        ["\xA2\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA0"],
        ["\xA2\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA1"],
        ["\xA2\xB4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x87"],
        ["\xA3\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB5"],
        ["\xA3\x9D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x92"],
        ["\xA3\xBA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB7"],
        ["\xA3\xBF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB9"],
        ["\xA3\xB4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA7"],
        ["\xA3\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBE"],
        ["\xA3\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9F"],
        ["\xA3\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA2"],
        ["\xA3\xCF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB6"],
        ["\xA3\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x93"],
        ["\xA3\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xBF"],
        ["\xA4\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xB0"],
        ["\xA4\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xB4"],
        ["\xA4\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x92"],
        ["\xA4\x96",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB6"],
        ["\xA4\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA3"],
        ["\xA4\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8F"],
        ["\xA4\xFD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA4"],
        ["\xA5\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA5"],
        ["\xA5\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA7"],
        ["\xA5\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x9E"],
        ["\xA5\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA6"],
        ["\xA5\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x95"],
        ["\xA5\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xA7"],
        ["\xA6\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9A"],
        ["\xA6\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x97"],
        ["\xA6\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9E"],
        ["\xA6\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xAD"],
        ["\xA6\x92",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xAE"],
        ["\xA6\x8F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA4"],
        ["\xA6\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA5"],
        ["\xA6\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x86"],
        ["\xA6\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x90"],
        ["\xA6\x9E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8A"],
        ["\xA6\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xBA"],
        ["\xA6\xAC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x80"],
        ["\xA6\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xBC"],
        ["\xA6\xBD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x8E"],
        ["\xA6\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x99"],
        ["\xA6\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x91"],
        ["\xA6\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB9"],
        ["\xA6\xB6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA7"],
        ["\xA6\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xA7"],
        ["\xA6\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xB7"],
        ["\xA6\xB8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xB8"],
        ["\xA6\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA7"],
        ["\xA6\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x97"],
        ["\xA6\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x99"],
        ["\xA7\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x90"],
        ["\xA7\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA7"],
        ["\xA7\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x95"],
        ["\xA6\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA0"],
        ["\xA6\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x93"],
        ["\xA7\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA5"],
        ["\xA7\x49",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA1"],
        ["\xA7\x56",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBB"],
        ["\xA7\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA8"],
        ["\xA7\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9E"],
        ["\xA7\x85",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBF"],
        ["\xA7\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9D"],
        ["\xA7\x82",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x82"],
        ["\xA7\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xB0"],
        ["\xA7\x94",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x97"],
        ["\xA7\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xA4"],
        ["\xA7\xBF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x86"],
        ["\xA7\xBA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x9E"],
        ["\xA7\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xB8"],
        ["\xA7\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB1"],
        ["\xA7\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x85"],
        ["\xA7\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x88"],
        ["\xA7\xFC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x92"],
        ["\xA8\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7\x9C"],
        ["\xA8\x91",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xA9"],
        ["\xA8\x92",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9D"],
        ["\xA8\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xAF"],
        ["\xA8\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB3"],
        ["\xA8\xAA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xBB"],
        ["\xA8\xAD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x83"],
        ["\xA8\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x8D"],
        ["\xA8\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x8F"],
        ["\xA8\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x91"],
        ["\xA8\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x95"],
        ["\xA9\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x97"],
        ["\xA9\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xA5"],
        ["\xA9\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAA"],
        ["\xA9\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAB"],
        ["\xA9\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA7"],
        ["\xA9\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAC"],
        ["\xA9\x94",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x9E"],
        ["\xA9\xAD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x8E"],
        ["\xA9\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x99"],
        ["\xA9\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x9C"],
        ["\xA9\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB5"],
        ["\xA9\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB2"],
        ["\xA9\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x8F"],
        ["\xA9\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB1"],
        ["\xAA\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xBB"],
        ["\xAA\x56",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x80"],
        ["\xA8\x9A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB0"],
        ["\xAA\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAB"],
        ["\xAA\xBA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8\xAD"],
        ["\xAA\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x99"],
        ["\xAA\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x91"],
        ["\x45\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x95"],
        ["\x45\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x96"],
        ["\x45\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x97"],
        ["\x45\xB2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA2"],
        ["\x45\xAD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x83"],
        ["\x45\xB6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xB6"],
        ["\x45\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xB7"],
        ["\x43\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x94"],
        ["\x43\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB7"],
        ["\x43\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB6"],
        ["\x43\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x81"],
        ["\x43\xCF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x80"],
        ["\x43\xB3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x97"],
        ["\x43\xB6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x98"],
        ["\x43\xB4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x96"],
        ["\x43\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x99"],
        ["\x43\xBD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x84"],
        ["\x45\xAC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x93"],
        ["\x44\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x8B"],
        ["\x45\xEB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA0"],
        ["\x45\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA6"],
        ["\x45\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA5"],
        ["\x45\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xA3"],
        ["\x42\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\x93"],
        ["\x42\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\x94"],
        ["\x45\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x81"],
        ["\x45\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x82"],
        ["\x45\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x87"],
        ["\x45\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x89"],
        ["\x45\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x8A"],
        ["\x45\x47",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x8D"],
        ["\x45\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x8E"],
        ["\x45\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x8F"],
        ["\x45\x49",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x91"],
        ["\x45\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x93"],
        ["\x45\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x94"],
        ["\x45\x53",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x96"],
        ["\x45\x55",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x9A"],
        ["\x45\x56",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x9B"],
        ["\x45\x58",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x9C"],
        ["\x45\x81",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\x9D"],
        ["\x45\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA0"],
        ["\x45\x82",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\x45\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],
        ["\x45\x85",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],
        ["\x45\x86",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],
        ["\x45\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],
        ["\x45\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xA9"],
        ["\x45\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAA"],
        ["\x45\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],
        ["\x45\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAD"],
        ["\x45\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],
        ["\x45\x8F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB1"],
        ["\x45\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB3"],
        ["\x45\x91",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB4"],
        ["\x45\x92",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB6"],
        ["\x45\x96",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],
        ["\x45\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],
        ["\x45\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],
        ["\x45\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],
        ["\x45\x99",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC3\xBF"],
        ["\x45\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x93"],
        ["\x45\x54",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xC5\x92"],
        ["\x43\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xB6"],
        ["\x43\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xB7"],
        ["\x43\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xB8"],
        ["\x43\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xB9"],
        ["\x43\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBA"],
        ["\x43\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBB"],
        ["\x43\xEB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBC"],
        ["\x43\xEC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBD"],
        ["\x43\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBE"],
        ["\x43\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D\xBF"],
        ["\x42\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xBA"],
        ["\x42\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xBB"],
        ["\x41\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x90"],
        ["\x41\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x91"],
        ["\x41\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x92"],
        ["\x41\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x93"],
        ["\x41\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x94"],
        ["\x41\xCF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x95"],
        ["\x41\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x96"],
        ["\x41\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x97"],
        ["\x41\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x98"],
        ["\x41\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x99"],
        ["\x41\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9A"],
        ["\x44\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9B"],
        ["\x44\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9C"],
        ["\x44\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9D"],
        ["\x44\x8F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9E"],
        ["\x44\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\x9F"],
        ["\x44\x91",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA0"],
        ["\x44\x92",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA1"],
        ["\x44\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA2"],
        ["\x44\x94",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA3"],
        ["\x44\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA4"],
        ["\x44\x96",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA5"],
        ["\x44\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA6"],
        ["\x44\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA7"],
        ["\x44\x99",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA8"],
        ["\x44\x9A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x93\xA9"],
        ["\x41\xFD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x90"],
        ["\x41\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x91"],
        ["\x41\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x92"],
        ["\x42\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x93"],
        ["\x42\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x94"],
        ["\x42\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x95"],
        ["\x42\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x96"],
        ["\x42\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x97"],
        ["\x42\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x98"],
        ["\x42\x47",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\x99"],
        ["\x41\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA0"],
        ["\x41\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA3"],
        ["\x41\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xBA"],
        ["\x41\xEB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA9"],
        ["\x41\xEC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xA5"],
        ["\x41\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xAD"],
        ["\x41\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B\xAC"],
        ["\x42\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xAA"],
        ["\x42\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xAB"],
        ["\x82\x54",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB0"],
        ["\x82\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8D"],
        ["\x82\xA5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBD"],
        ["\x82\x99",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBF"],
        ["\x82\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8B"],
        ["\x82\xAD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x88"],
        ["\x82\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xAA"],
        ["\x82\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBE"],
        ["\x82\xB2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x97"],
        ["\x83\x56",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8E"],
        ["\x82\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x98"],
        ["\x83\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA7"],
        ["\x83\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAE"],
        ["\x83\xA4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8C"],
        ["\x83\xAD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB2"],
        ["\x83\xAE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x90"],
        ["\x83\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA6"],
        ["\x83\xBA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x86"],
        ["\x83\xB3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x83"],
        ["\x83\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9E"],
        ["\x83\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x95"],
        ["\x84\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9E"],
        ["\x84\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAE"],
        ["\x84\x55",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x81"],
        ["\x84\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x89"],
        ["\x84\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x97"],
        ["\x84\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x88"],
        ["\x85\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA1"],
        ["\x85\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA3"],
        ["\x85\x58",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9D"],
        ["\x85\x9D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8D"],
        ["\x85\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBF"],
        ["\x85\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x96"],
        ["\x85\xBA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA1"],
        ["\x85\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x86"],
        ["\x85\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x8E"],
        ["\x85\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x90"],
        ["\x85\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAD"],
        ["\x85\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x8E"],
        ["\x86\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x88"],
        ["\x86\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x8E"],
        ["\x86\x49",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xBB"],
        ["\x86\x54",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x89"],
        ["\x86\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA6"],
        ["\x86\x82",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAF"],
        ["\x86\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB2"],
        ["\x86\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x9E"],
        ["\x86\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xAC"],
        ["\x86\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8A"],
        ["\x86\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xAF"],
        ["\x86\xA4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB3"],
        ["\x86\xA5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB4"],
        ["\x86\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA4"],
        ["\x86\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB5"],
        ["\x92\x99",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBF"],
        ["\x86\xCF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x89"],
        ["\xC5\xF6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA1"],
        ["\x86\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA4"],
        ["\x86\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xBC"],
        ["\x87\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x89"],
        ["\x87\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xA9"],
        ["\x87\x82",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8E"],
        ["\x87\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x94"],
        ["\x87\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9A"],
        ["\x87\x86",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA9"],
        ["\x87\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8C"],
        ["\x87\xAD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAD"],
        ["\x87\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8B"],
        ["\x87\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x92"],
        ["\x87\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x83"],
        ["\x87\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x92"],
        ["\x87\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9D"],
        ["\x87\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x93"],
        ["\x87\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA3"],
        ["\x87\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAD"],
        ["\x87\xFD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xB7"],
        ["\x87\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xBE"],
        ["\x87\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9E"],
        ["\x88\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x84"],
        ["\x88\x58",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x99"],
        ["\x88\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xBD"],
        ["\x88\x91",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x93"],
        ["\x88\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xBA"],
        ["\x88\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x8F"],
        ["\x88\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x9F"],
        ["\x88\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAA"],
        ["\x89\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x92"],
        ["\x89\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB4"],
        ["\x89\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA0"],
        ["\x89\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA7"],
        ["\xE6\x5E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x81"],
        ["\x89\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x98"],
        ["\x89\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x98"],
        ["\x89\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x9E"],
        ["\x8A\x47",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xBE"],
        ["\x8A\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8B"],
        ["\x8A\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x87"],
        ["\x8A\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB6"],
        ["\x8A\x96",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBD"],
        ["\x8A\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x80"],
        ["\x8A\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA4"],
        ["\x8A\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBD"],
        ["\x8A\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x89"],
        ["\x8A\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x9C"],
        ["\xA5\x92",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA7"],
        ["\x8A\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAF"],
        ["\x8A\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x89"],
        ["\x8A\xEB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA1"],
        ["\x8C\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA9"],
        ["\x8C\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8D"],
        ["\x8C\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x94"],
        ["\x8C\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xB3"],
        ["\x8C\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x87"],
        ["\x8C\x82",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9D"],
        ["\x8C\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9E"],
        ["\x8C\x9D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9C"],
        ["\x8C\xBA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xAB"],
        ["\x8C\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8D"],
        ["\x8C\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBC"],
        ["\x8C\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA2"],
        ["\x8D\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x83"],
        ["\x8D\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x96"],
        ["\x8D\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9A"],
        ["\x8D\x55",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x84"],
        ["\x8D\x54",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x96"],
        ["\x8D\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBC"],
        ["\x8A\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x8A"],
        ["\x8D\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x98"],
        ["\x8D\x8F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xB9"],
        ["\x8D\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x83"],
        ["\x8D\x99",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA5"],
        ["\x8D\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA5"],
        ["\x8D\xB2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBE"],
        ["\x8D\xB4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBF"],
        ["\x8D\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8A"],
        ["\x8D\xBF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x90"],
        ["\x8D\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA9"],
        ["\x8D\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA7"],
        ["\x8E\x99",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA2"],
        ["\x8E\x9A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAB"],
        ["\x8E\x94",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB0"],
        ["\x8E\x9D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8C"],
        ["\x8E\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA1"],
        ["\x8E\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB7"],
        ["\x8E\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB8"],
        ["\x8E\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x8D"],
        ["\x8F\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBB"],
        ["\x8F\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x88"],
        ["\x8F\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA8"],
        ["\x8F\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x93"],
        ["\x8F\x91",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB3"],
        ["\x8F\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x87"],
        ["\x8F\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBB"],
        ["\x8F\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x93"],
        ["\x8F\xA4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x98"],
        ["\x8F\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9B"],
        ["\x8F\xBD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB9"],
        ["\x8F\xAE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x97"],
        ["\x8F\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x9D"],
        ["\x8F\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB1"],
        ["\x8F\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB2"],
        ["\x90\x54",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x90"],
        ["\x90\x49",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA8"],
        ["\x90\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAD"],
        ["\x90\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB0"],
        ["\x90\x58",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB1"],
        ["\x90\x55",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xBC"],
        ["\x90\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8A"],
        ["\x90\x94",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB5"],
        ["\x90\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x82"],
        ["\x90\x92",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA3"],
        ["\x90\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x80"],
        ["\x90\xB2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8F"],
        ["\x90\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x85"],
        ["\x90\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x90"],
        ["\x90\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x9B"],
        ["\x90\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x89"],
        ["\x91\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA7"],
        ["\x91\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9B"],
        ["\x91\x86",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB5"],
        ["\x91\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x86"],
        ["\x91\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x96"],
        ["\x91\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x82"],
        ["\x91\x9A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAD"],
        ["\x91\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8F"],
        ["\x91\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x90"],
        ["\x91\xAA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB3"],
        ["\x91\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x99"],
        ["\x91\xB6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x85"],
        ["\x91\xCF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9C"],
        ["\x91\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x86"],
        ["\x91\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x94"],
        ["\x91\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA0"],
        ["\x91\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAB"],
        ["\x91\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAE"],
        ["\x92\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8E"],
        ["\x92\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAE"],
        ["\x92\x54",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB9"],
        ["\x92\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA5"],
        ["\x92\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x82"],
        ["\x92\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x94"],
        ["\x92\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xBF"],
        ["\x92\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x84"],
        ["\x92\xA5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x96"],
        ["\x92\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x84"],
        ["\x92\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9E"],
        ["\x93\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB1"],
        ["\x93\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x87"],
        ["\x93\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x9A"],
        ["\x93\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAA"],
        ["\x93\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB3"],
        ["\x93\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x99"],
        ["\x93\xB3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9E"],
        ["\x93\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA2"],
        ["\x93\xA4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBE"],
        ["\x93\x99",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x8C"],
        ["\x93\x9A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x8D"],
        ["\x93\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x94"],
        ["\x93\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA7"],
        ["\x93\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB9"],
        ["\x93\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB0"],
        ["\x93\xEB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x9D"],
        ["\x93\xEC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xA4"],
        ["\x8E\x91",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xA4"],
        ["\x93\xFD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB7"],
        ["\x94\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x94"],
        ["\x94\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x98"],
        ["\x94\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xA4"],
        ["\x94\x56",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9E"],
        ["\x94\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x92"],
        ["\x94\x92",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA0"],
        ["\x94\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x85"],
        ["\x94\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x92"],
        ["\x94\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x84"],
        ["\x94\xAC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x80"],
        ["\x94\xB2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x96"],
        ["\x94\xB8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x9B"],
        ["\x94\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBB"],
        ["\x94\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA8"],
        ["\x95\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBC"],
        ["\x95\x55",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x95"],
        ["\x95\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8F"],
        ["\x95\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x99"],
        ["\x95\x91",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA9"],
        ["\x95\xBD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x9A"],
        ["\x95\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x9B"],
        ["\x95\xAA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA8"],
        ["\x95\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAB"],
        ["\x95\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xAF"],
        ["\x95\xB8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x86"],
        ["\x95\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x8B"],
        ["\x95\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x97"],
        ["\x95\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x86"],
        ["\x95\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x87"],
        ["\x95\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x9C"],
        ["\x96\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x90"],
        ["\x96\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA6"],
        ["\x95\xFC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA8"],
        ["\x96\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xBF"],
        ["\x96\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x88"],
        ["\x96\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x89"],
        ["\x96\x49",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x9A"],
        ["\x96\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB9"],
        ["\x96\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x92"],
        ["\x96\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA4"],
        ["\x96\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x80"],
        ["\x96\x99",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x96"],
        ["\x96\x9D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x99"],
        ["\x96\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xAD"],
        ["\x96\xA4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA5"],
        ["\x96\xA5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAD"],
        ["\x96\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB1"],
        ["\x96\xB3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xAA"],
        ["\x96\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8C"],
        ["\x96\xB8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8E"],
        ["\x96\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB1"],
        ["\x96\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x99"],
        ["\x96\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB6"],
        ["\x96\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x8D"],
        ["\x96\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9C"],
        ["\x96\xEC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9F"],
        ["\x97\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAA"],
        ["\x97\x56",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xAD"],
        ["\x97\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x83"],
        ["\x97\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xA8"],
        ["\x97\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAE"],
        ["\x97\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAD"],
        ["\x97\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x80"],
        ["\x97\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xB7"],
        ["\x97\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xB1"],
        ["\x97\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xB4"],
        ["\x97\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9C"],
        ["\x98\x82",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB8"],
        ["\x98\x86",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x88"],
        ["\x89\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8A"],
        ["\x99\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x94"],
        ["\x98\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xAB"],
        ["\x98\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x83"],
        ["\x98\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB9"],
        ["\x98\xAD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x9D"],
        ["\x96\xCF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x85"],
        ["\x98\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xA0"],
        ["\x98\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8E"],
        ["\x98\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBD"],
        ["\x99\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAD"],
        ["\x99\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x87"],
        ["\x99\x55",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA0"],
        ["\x99\x58",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAD"],
        ["\x99\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAF"],
        ["\x99\x9E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x97"],
        ["\x99\x99",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x99"],
        ["\x99\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB1"],
        ["\x96\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA0"],
        ["\x99\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x99"],
        ["\x99\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xAD"],
        ["\x99\xBF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB9"],
        ["\x99\xB2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x94"],
        ["\x99\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA0"],
        ["\x99\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x99"],
        ["\x99\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9D"],
        ["\x99\xEC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x88"],
        ["\x99\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x93"],
        ["\x99\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9D"],
        ["\x99\xFC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA3"],
        ["\x9A\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB1"],
        ["\x9A\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x81"],
        ["\x9A\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x93"],
        ["\x9A\x81",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x8B"],
        ["\x9A\x82",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA6"],
        ["\x9A\x85",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x82"],
        ["\x9A\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x88"],
        ["\x9A\x96",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x91"],
        ["\x9A\x94",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x95"],
        ["\x9A\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x87"],
        ["\x9A\xCF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x91"],
        ["\x9A\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x97"],
        ["\x9A\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xBF"],
        ["\x9A\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8E"],
        ["\x9A\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x9F"],
        ["\x9A\xFD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAC"],
        ["\x9D\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBA"],
        ["\x9D\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x94"],
        ["\x9D\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA6"],
        ["\x9D\x85",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA0"],
        ["\x9D\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x98"],
        ["\x9D\x94",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8A"],
        ["\xAA\xEC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAD"],
        ["\x9D\xB6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB4"],
        ["\x9D\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8E"],
        ["\x9E\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA9"],
        ["\x9E\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB7"],
        ["\x9E\x85",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBE"],
        ["\x9E\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x95"],
        ["\x9E\xB3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA7"],
        ["\x9E\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xBF"],
        ["\x9E\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x80"],
        ["\x9E\xFC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAA"],
        ["\x9F\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xAF"],
        ["\x9F\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x8F"],
        ["\xA2\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8E"],
        ["\xA2\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x92"],
        ["\xA2\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x90"],
        ["\xA2\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA9"],
        ["\xA2\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xB8"],
        ["\xA2\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x97"],
        ["\xA2\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xAC"],
        ["\xA2\xAA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBC"],
        ["\xA2\xAC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBD"],
        ["\xA2\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x88"],
        ["\xA2\xB2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x96"],
        ["\xA2\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x98"],
        ["\xA2\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAA"],
        ["\xA2\xFC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x8A"],
        ["\xA2\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x8E"],
        ["\xA3\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9A"],
        ["\xA3\x53",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xA7"],
        ["\xA3\x54",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB0"],
        ["\xA3\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x94"],
        ["\xA3\x92",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA5"],
        ["\xA3\x9A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x95"],
        ["\xA3\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA2"],
        ["\xA3\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x87"],
        ["\xA3\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x8E"],
        ["\xA3\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9D"],
        ["\xA3\xBD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA1"],
        ["\xA3\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB5"],
        ["\x86\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x86"],
        ["\xA3\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x94"],
        ["\xA3\xEC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x99"],
        ["\xA4\x47",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x89"],
        ["\xA4\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA1"],
        ["\xA4\x8F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBE"],
        ["\xA4\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8E"],
        ["\xA4\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x91"],
        ["\xA4\xA5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x97"],
        ["\xA4\xAC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xA0"],
        ["\xA4\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xBB"],
        ["\xA4\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBA"],
        ["\xA4\xB8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9E"],
        ["\xA4\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAD"],
        ["\xA4\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x94"],
        ["\x84\xB4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA6"],
        ["\xA4\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB5"],
        ["\xA4\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA4"],
        ["\xA5\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA8"],
        ["\xA5\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAE"],
        ["\xA5\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xAD"],
        ["\xA5\xAE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x88"],
        ["\xA5\xB4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA2"],
        ["\xA5\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB3"],
        ["\xA5\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x85"],
        ["\xA5\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x87"],
        ["\xA5\xCF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x9D"],
        ["\xA5\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xAF"],
        ["\xA5\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB4"],
        ["\xA5\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x96"],
        ["\xA5\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xAF"],
        ["\xA5\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB1"],
        ["\xA5\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB4"],
        ["\xA5\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x9B"],
        ["\xA6\x54",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x9E"],
        ["\xA4\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xBC"],
        ["\xA6\x94",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBB"],
        ["\xA6\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB1"],
        ["\xA6\x96",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x87"],
        ["\xA6\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB8"],
        ["\xA6\xAA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x83"],
        ["\xA6\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x8F"],
        ["\xA7\x47",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9F"],
        ["\xA7\x96",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x89"],
        ["\xA7\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xA4"],
        ["\xA7\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xBA"],
        ["\xA7\xAE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x9F"],
        ["\xA7\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x84"],
        ["\xA7\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xBD"],
        ["\xA7\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB3"],
        ["\xA7\xCF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x8A"],
        ["\xA7\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xAB"],
        ["\xA7\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB1"],
        ["\xA7\xFD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8E"],
        ["\xA2\xAE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA9"],
        ["\xA8\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBD"],
        ["\xA8\x47",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8B"],
        ["\xA8\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x90"],
        ["\xA8\x58",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x98"],
        ["\x86\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x84"],
        ["\xA8\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA5"],
        ["\xAA\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9E"],
        ["\xA8\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA9"],
        ["\xA8\xAE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x8E"],
        ["\xA3\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x9A"],
        ["\xA8\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB3"],
        ["\xAA\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xBA"],
        ["\xA8\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x81"],
        ["\xA8\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x9E"],
        ["\xA8\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8A"],
        ["\xA8\xEB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x9E"],
        ["\xA8\xEC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAB"],
        ["\xA8\xFC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x92"],
        ["\xA8\xFD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x93"],
        ["\xA9\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x99"],
        ["\xC5\x6F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9A"],
        ["\xA9\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xAC"],
        ["\xA9\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xBA"],
        ["\xA9\x54",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x88"],
        ["\xA9\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x82"],
        ["\xA9\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x83"],
        ["\xA9\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xAE"],
        ["\xA9\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB8"],
        ["\xA9\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x8A"],
        ["\xA9\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x82"],
        ["\xA9\xB6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x88"],
        ["\xA9\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x9E"],
        ["\xA9\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB9"],
        ["\xA9\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xA6"],
        ["\xA9\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x84"],
        ["\xA9\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x9E"],
        ["\xAA\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x8E"],
        ["\xAA\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA5"],
        ["\xAA\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA3"],
        ["\xAA\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x93"],
        ["\xAA\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA3"],
        ["\xAA\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB7"],
        ["\xAA\x96",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9D"],
        ["\xAA\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9E"],
        ["\xAA\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x83"],
        ["\xAA\x9D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x87"],
        ["\xAA\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xBC"],
        ["\xAA\xAD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x96"],
        ["\xAA\xB6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA4"],
        ["\xAA\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xAC"],
        ["\xF9\x72",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB4"],
        ["\xAA\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x90"],
        ["\xAA\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xB9"],
        ["\x8A\x81",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x90"],
        ["\xAA\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x94"],
        ["\x86\x91",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\xA2"],
        ["\x82\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x82"],
        ["\x82\x53",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAB"],
        ["\x82\x56",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAE"],
        ["\x82\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB9"],
        ["\x82\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x90"],
        ["\x82\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB1"],
        ["\x82\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB5"],
        ["\x82\xAA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBE"],
        ["\x82\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x94"],
        ["\x82\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB8"],
        ["\x82\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB2"],
        ["\x82\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xBE"],
        ["\x82\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x85"],
        ["\x82\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8B"],
        ["\x82\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8F"],
        ["\x83\x47",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB2"],
        ["\x83\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x80"],
        ["\x83\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x93"],
        ["\x83\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9C"],
        ["\x83\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x97"],
        ["\x83\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xA3"],
        ["\x83\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xA6"],
        ["\x83\x85",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xAA"],
        ["\x83\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x84"],
        ["\x83\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA9"],
        ["\x88\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA9"],
        ["\x88\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB0"],
        ["\x88\xEB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB5"],
        ["\x89\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x89"],
        ["\x89\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x86"],
        ["\x89\x85",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xAB"],
        ["\x89\x92",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xA1"],
        ["\x89\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x88"],
        ["\x89\xA5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x92"],
        ["\x89\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x94"],
        ["\x89\xBD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA0"],
        ["\x89\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x80"],
        ["\x89\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x92"],
        ["\x89\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x95"],
        ["\x89\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAE"],
        ["\x85\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA3"],
        ["\x84\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xBC"],
        ["\x84\x53",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB4"],
        ["\x84\x54",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x82"],
        ["\x84\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x96"],
        ["\x84\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x91"],
        ["\x84\xCF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8A"],
        ["\x9A\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8B"],
        ["\x84\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x82"],
        ["\x85\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAC"],
        ["\x85\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x95"],
        ["\x85\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9A"],
        ["\x85\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xA6"],
        ["\x85\xAE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBF"],
        ["\x85\xB3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x81"],
        ["\x85\xBF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x89"],
        ["\x85\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x87"],
        ["\x85\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8A"],
        ["\x85\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA0"],
        ["\x85\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA1"],
        ["\x85\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x91"],
        ["\x85\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA9"],
        ["\x86\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x90"],
        ["\x86\x53",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xBD"],
        ["\x86\x55",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xBF"],
        ["\x86\x8F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xAD"],
        ["\x86\x92",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x8D"],
        ["\x86\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8C"],
        ["\x86\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xBB"],
        ["\x86\xB2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x9A"],
        ["\x86\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9E"],
        ["\x86\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB8"],
        ["\x86\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x9E"],
        ["\x86\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA0"],
        ["\x86\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB9"],
        ["\x87\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x8F"],
        ["\x86\xFD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x90"],
        ["\x87\x56",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB1"],
        ["\x87\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x86"],
        ["\x87\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA4"],
        ["\x87\xAE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB5"],
        ["\x87\xBF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9F"],
        ["\x87\xB8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x88"],
        ["\x87\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9E"],
        ["\x87\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA4"],
        ["\x87\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAE"],
        ["\x87\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x95"],
        ["\x87\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA5"],
        ["\x87\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9C"],
        ["\x87\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9F"],
        ["\x88\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBA"],
        ["\x88\x54",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xB5"],
        ["\x88\x53",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x88"],
        ["\x88\x55",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB4"],
        ["\x88\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x8C"],
        ["\x88\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xBF"],
        ["\x88\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x81"],
        ["\x8A\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x88"],
        ["\x82\x47",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8E"],
        ["\x8A\x8F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9C"],
        ["\x8A\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x84"],
        ["\x8A\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x92"],
        ["\x8A\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x94"],
        ["\x8A\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA2"],
        ["\x8A\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xAE"],
        ["\x8A\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xAF"],
        ["\x8C\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x97"],
        ["\x84\xAA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xBF"],
        ["\x8C\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB0"],
        ["\x8C\x8F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB1"],
        ["\x8C\x9E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x92"],
        ["\x8C\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x93"],
        ["\x8C\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9E"],
        ["\x8C\xBF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xBC"],
        ["\x8C\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x93"],
        ["\x8C\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x97"],
        ["\x8C\xB8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA8"],
        ["\x8C\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAD"],
        ["\x8C\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x95"],
        ["\x8C\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x9F"],
        ["\x8C\xFD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA9"],
        ["\x8D\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8C"],
        ["\x8D\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x91"],
        ["\x8D\x53",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x95"],
        ["\x8F\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBD"],
        ["\x8A\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xB5"],
        ["\x8D\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x84"],
        ["\x8D\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8E"],
        ["\x8D\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x84"],
        ["\x8A\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9C"],
        ["\x8D\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x89"],
        ["\x8D\xAA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA5"],
        ["\x8D\xAE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB3"],
        ["\x8D\xB3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x97"],
        ["\x8D\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x84"],
        ["\x8D\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x94"],
        ["\x8D\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x81"],
        ["\x8E\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBF"],
        ["\x8E\x53",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x82"],
        ["\x8E\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xB2"],
        ["\x8E\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xB9"],
        ["\x8E\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x84"],
        ["\x8E\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x88"],
        ["\x8E\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA1"],
        ["\x8E\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x85"],
        ["\x8E\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x91"],
        ["\x8E\xBD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9B"],
        ["\x8E\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAA"],
        ["\x8E\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAB"],
        ["\x8E\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x92"],
        ["\x8E\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB1"],
        ["\x8F\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB5"],
        ["\x8F\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x85"],
        ["\x8F\x94",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8C"],
        ["\x8F\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9D"],
        ["\x8F\xAD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB6"],
        ["\x8F\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x99"],
        ["\x8F\xB2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB7"],
        ["\x8F\xCF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBB"],
        ["\x84\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8C"],
        ["\x8F\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x96"],
        ["\x90\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9A"],
        ["\x90\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAA"],
        ["\x90\x53",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x96"],
        ["\x90\x81",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x99"],
        ["\x90\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAC"],
        ["\x90\x96",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBB"],
        ["\x90\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x96"],
        ["\x89\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA6"],
        ["\x90\x9D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB7"],
        ["\x90\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x96"],
        ["\x90\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB3"],
        ["\x90\xBF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x91"],
        ["\x90\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB2"],
        ["\x90\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA4"],
        ["\x90\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x91"],
        ["\x90\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x9F"],
        ["\x91\x47",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x90"],
        ["\x91\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xAC"],
        ["\x91\x49",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xB1"],
        ["\x91\x82",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x90"],
        ["\x91\x81",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x91"],
        ["\x91\x85",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xAF"],
        ["\x91\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8A"],
        ["\x91\x8F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x98"],
        ["\xA6\x58",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x89"],
        ["\x91\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xA7"],
        ["\x8D\x9A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAE"],
        ["\xA8\xB4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xB1"],
        ["\x91\xAC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB5"],
        ["\x91\xBD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x8D"],
        ["\x91\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x89"],
        ["\x91\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x94"],
        ["\x91\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x97"],
        ["\x91\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x96"],
        ["\x91\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA9"],
        ["\x92\x42",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAC"],
        ["\x92\x82",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x80"],
        ["\x92\x49",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8A"],
        ["\x92\x55",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA7"],
        ["\x92\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBC"],
        ["\x92\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB0"],
        ["\x92\x9E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x88"],
        ["\x92\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8E"],
        ["\x92\xA4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9F"],
        ["\x92\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA9"],
        ["\x92\xB3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB6"],
        ["\x92\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x91"],
        ["\x92\xCC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x93"],
        ["\x92\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x97"],
        ["\x92\xB8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xA3"],
        ["\x92\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x83"],
        ["\x93\x86",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB9"],
        ["\x93\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBC"],
        ["\x93\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBD"],
        ["\x93\x94",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x90"],
        ["\x93\xA5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x96"],
        ["\x93\xB2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xAF"],
        ["\x93\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9A"],
        ["\x93\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xBC"],
        ["\x93\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAC"],
        ["\x93\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAE"],
        ["\x98\xB2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB6"],
        ["\x93\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x95"],
        ["\x83\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x97"],
        ["\x94\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x93"],
        ["\x94\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9C"],
        ["\x94\x53",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x87"],
        ["\x94\x82",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xAF"],
        ["\x94\x55",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xB1"],
        ["\x8E\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8A"],
        ["\x94\x99",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x80"],
        ["\x94\x9D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xA0"],
        ["\x9A\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x82"],
        ["\x94\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA3"],
        ["\x94\xB6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB8"],
        ["\x94\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBF"],
        ["\x94\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAD"],
        ["\x94\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAE"],
        ["\x94\xDB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x8C"],
        ["\x94\xDF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x99"],
        ["\xA2\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAC"],
        ["\x94\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB1"],
        ["\x94\xFC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBD"],
        ["\x95\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAB"],
        ["\x95\x47",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x81"],
        ["\x95\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x85"],
        ["\x95\x58",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x98"],
        ["\x95\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x9C"],
        ["\x95\x82",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x9E"],
        ["\x95\x8C",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB9"],
        ["\x95\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x85"],
        ["\x95\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8B"],
        ["\x95\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB9"],
        ["\x95\x9D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xBA"],
        ["\x95\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x81"],
        ["\x95\xAC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA4"],
        ["\x95\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB9"],
        ["\x95\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x92"],
        ["\x95\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB1"],
        ["\x95\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x99"],
        ["\x95\xFD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xAB"],
        ["\x96\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xB9"],
        ["\x96\x56",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x80"],
        ["\x96\x58",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x90"],
        ["\x96\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB1"],
        ["\x96\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xBE"],
        ["\x96\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x81"],
        ["\x96\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x80"],
        ["\x96\x96",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB9"],
        ["\x96\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x93"],
        ["\x96\x9A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA5"],
        ["\x96\x9E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB3"],
        ["\x96\xB2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xA7"],
        ["\x96\xEB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xAA"],
        ["\x96\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xB2"],
        ["\x96\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x9A"],
        ["\x96\xFD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA2"],
        ["\x97\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9E"],
        ["\x97\x47",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA4"],
        ["\x82\xDC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA6"],
        ["\x97\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xB4"],
        ["\x97\x53",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xBB"],
        ["\x97\x55",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x86"],
        ["\x97\x96",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA4"],
        ["\x97\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x9E"],
        ["\x97\x9A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x88"],
        ["\x97\xA4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA0"],
        ["\x97\x9F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA1"],
        ["\xA7\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBA"],
        ["\x97\xA5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBB"],
        ["\x97\xBC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBB"],
        ["\x97\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9B"],
        ["\x97\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA7"],
        ["\x97\xFA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xB2"],
        ["\x98\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x96"],
        ["\x98\x83",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x82"],
        ["\x98\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x96"],
        ["\x98\x95",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8A"],
        ["\x98\x9D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x91"],
        ["\x98\x9A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9B"],
        ["\x98\x9E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9E"],
        ["\x98\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB8"],
        ["\x98\xAC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8C"],
        ["\x98\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x9F"],
        ["\x98\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xAA"],
        ["\x98\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAC"],
        ["\x98\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBC"],
        ["\x99\x49",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xBD"],
        ["\x99\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAE"],
        ["\x99\x44",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB1"],
        ["\x99\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA4"],
        ["\x99\x85",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA6"],
        ["\x99\x56",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA9"],
        ["\x99\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x91"],
        ["\x99\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9B"],
        ["\x99\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xBC"],
        ["\x99\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x94"],
        ["\x99\x9A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x9A"],
        ["\x96\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8B"],
        ["\x99\xA4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8F"],
        ["\x99\xBD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xAE"],
        ["\x99\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB7"],
        ["\x99\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x88"],
        ["\xA9\x8A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA6"],
        ["\x99\xED",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x83"],
        ["\x99\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x89"],
        ["\x9A\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBE"],
        ["\x9A\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x87"],
        ["\x9A\x51",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xAA"],
        ["\x9A\x58",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x88"],
        ["\x9A\x55",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x8C"],
        ["\x9A\x91",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x97"],
        ["\x9A\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB1"],
        ["\x9A\x99",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9D"],
        ["\x9A\x97",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA0"],
        ["\x9A\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA7"],
        ["\x9A\xAD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBE"],
        ["\x9A\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x86"],
        ["\x9A\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x91"],
        ["\x9A\xBE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x83"],
        ["\x9A\xBF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x84"],
        ["\x9A\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x92"],
        ["\x9A\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA1"],
        ["\x9A\xCA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA3"],
        ["\x9A\xEA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAD"],
        ["\x9A\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8F"],
        ["\x9A\xFE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA5"],
        ["\x9D\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAF"],
        ["\x9D\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8A"],
        ["\x9D\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA4"],
        ["\x9D\x52",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB0"],
        ["\x9D\x58",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB5"],
        ["\x9D\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x98"],
        ["\x9D\x91",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x96"],
        ["\x9D\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA4"],
        ["\x8F\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAC"],
        ["\x9D\xBA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xA1"],
        ["\x9D\xBB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xA2"],
        ["\x9D\xBD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB4"],
        ["\x9D\xBF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x86"],
        ["\x9D\xB8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB9"],
        ["\x9E\x48",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBA"],
        ["\x9E\xB6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8D"],
        ["\x9E\xEF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x91"],
        ["\x9F\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x8A"],
        ["\x9F\x86",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x8F"],
        ["\x9F\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9A"],
        ["\x9F\x9A",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xA6"],
        ["\x9F\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xB0"],
        ["\x9F\xCB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA2"],
        ["\xA2\x99",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x96"],
        ["\xA2\xA2",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB7"],
        ["\xA2\xA3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xBA"],
        ["\xA2\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB1"],
        ["\xA2\xAF",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x99"],
        ["\xA2\xBA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x98"],
        ["\xA2\xBD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xA0"],
        ["\xA2\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x81"],
        ["\xA2\xB5",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8B"],
        ["\xA2\xB8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA8"],
        ["\xA2\xB9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB2"],
        ["\xA5\xA9",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9F"],
        ["\xA2\xCE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA4"],
        ["\xA2\xEE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x80"],
        ["\xA3\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9B"],
        ["\xA3\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB1"],
        ["\x9A\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x89"],
        ["\xA3\x90",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB0"],
        ["\xA3\x9E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x91"],
        ["\xA3\xAD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x85"],
        ["\xA3\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x8D"],
        ["\xA3\xA8",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x98"],
        ["\xA3\xB6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x97"],
        ["\xA3\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBC"],
        ["\xA3\xEB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x83"],
        ["\xA4\x43",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xB9"],
        ["\xA4\x45",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x85"],
        ["\xA4\x46",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x87"],
        ["\x9D\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x94"],
        ["\xA4\x85",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x96"],
        ["\xA4\x89",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x99"],
        ["\xA4\x99",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x84"],
        ["\xA4\xFB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x8D"],
        ["\xA5\x8F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x84"],
        ["\xA6\xB4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA5"],
        ["\xA6\xCD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x89"],
        ["\xA8\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8D"],
        ["\x86\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAC"],
        ["\xA8\x88",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x82"],
        ["\xA8\xB3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x8C"],
        ["\xA8\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8D"],
        ["\x93\x58",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x96"],
        ["\xA9\xBA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xAF"],
        ["\xA9\xB3",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA9"],
        ["\xA9\xB7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x92"],
        ["\xA9\xDA",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB3"],
        ["\xA9\xFC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB2"],
        ["\xAA\x41",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x87"],
        ["\xAA\x54",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xAA"],
        ["\xAA\x49",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xAB"],
        ["\xAA\x81",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xBA"],
        ["\xAA\x84",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA9"],
        ["\xAA\x86",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAA"],
        ["\xAA\x87",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB1"],
        ["\xAA\x8D",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA9"],
        ["\xAA\x8E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xAE"],
        ["\xAA\x8F",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB0"],
        ["\xAA\x93",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x8B"],
        ["\xAA\x98",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x98"],
        ["\xAA\xA4",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA2"],
        ["\xAA\xA6",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB7"],
        ["\xAA\xA7",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x8D"],
        ["\xAA\xAC",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xA1"],
        ["\xA8\x9E",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB5"],
        ["\xAA\xAE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x83"],
        ["\xAA\xBD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9C"],
        ["\xAA\xDD",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x99"],
        ["\xAA\xDE",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xB7"],
        ["\xAA\xEB",'utf8','jipse',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x81"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        my @option_content = ();
        push(@option_content, qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}})        if exists $option->{'INPUT_LAYOUT'};
        push(@option_content, qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}})  if exists $option->{'OUTPUT_SHIFTING'};
        push(@option_content, qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}}) if exists $option->{'SPACE'};
        push(@option_content, qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}})   if exists $option->{'GETA'};
        $option_content = "{@option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
