/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngFlashcoder {
    private final List<BufferedImage> flashcodes;

    public PngFlashcoder(List<BufferedImage> list) {
        this.flashcodes = list;
    }

    public BufferedImage processImage(BufferedImage bufferedImage, Color color) {
        if (this.flashcodes != null) {
            bufferedImage = this.addImage(bufferedImage, color);
        }
        return bufferedImage;
    }

    private BufferedImage addImage(BufferedImage bufferedImage, Color color) {
        double d = Math.max(bufferedImage.getWidth(), PngFlashcoder.getWidth(this.flashcodes));
        double d2 = bufferedImage.getHeight() + PngFlashcoder.getHeight(this.flashcodes);
        BufferedImage bufferedImage2 = new BufferedImage((int)d, (int)d2, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        UAntiAliasing.ANTI_ALIASING_OFF.apply(graphics2D);
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        graphics2D.drawImage(bufferedImage, null, 0, 0);
        int n = 0;
        for (BufferedImage bufferedImage3 : this.flashcodes) {
            graphics2D.drawImage(bufferedImage3, null, n, bufferedImage.getHeight());
            n += bufferedImage3.getWidth();
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static int getHeight(List<BufferedImage> list) {
        int n = 0;
        for (BufferedImage bufferedImage : list) {
            n = Math.max(n, bufferedImage.getWidth());
        }
        return n;
    }

    public static int getWidth(List<BufferedImage> list) {
        int n = 0;
        for (BufferedImage bufferedImage : list) {
            n += bufferedImage.getWidth();
        }
        return n;
    }
}

