
#
# Copyright (C) 2000  Daemon Consulting Inc.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

package SpeedyMake::mod_speedycgi;

require '../src/SpeedyMake.pm';
@ISA = 'SpeedyMake';

sub inc {'apache'}
sub clean_files_extra { 'mod_speedycgi_cmds.c' }
sub main_file_full {'mod_speedycgi'}

package mod_speedycgi;

use strict;

SpeedyMake::mod_speedycgi->init;

print "Writing Makefile for mod_speedycgi\n";

open(F, '>Makefile');
select F;

print join("\n\n",
    "##\n## Generated by Makefile.PL\n##",
    'all: mod_speedycgi.so',
    SpeedyMake::mod_speedycgi->symlink_c_files,
    SpeedyMake::mod_speedycgi->speedy_h_cmds,
    SpeedyMake::mod_speedycgi->optdefs_cmds,
    ''
);
foreach my $x (
    [qw(SRC_CFILES src_files_c)],
    [qw(OFILES src_files_o)],
    [qw(C_FILE_CLEAN clean_files_c)],
)
{
    my($def, $method) = @$x;
    printf "${def}=%s\n\n", join(' ', SpeedyMake::mod_speedycgi->$method());
}

open(F2, 'Makefile.tmpl');
print <F2>;
close(F2);

close(F);
