# Generated by default/object.tt
package Paws::SageMaker::AssociationSummary;
  use Moose;
  has AssociationType => (is => 'ro', isa => 'Str');
  has CreatedBy => (is => 'ro', isa => 'Paws::SageMaker::UserContext');
  has CreationTime => (is => 'ro', isa => 'Str');
  has DestinationArn => (is => 'ro', isa => 'Str');
  has DestinationName => (is => 'ro', isa => 'Str');
  has DestinationType => (is => 'ro', isa => 'Str');
  has SourceArn => (is => 'ro', isa => 'Str');
  has SourceName => (is => 'ro', isa => 'Str');
  has SourceType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::AssociationSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::AssociationSummary object:

  $service_obj->Method(Att1 => { AssociationType => $value, ..., SourceType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::AssociationSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->AssociationType

=head1 DESCRIPTION

Lists a summary of the properties of an association. An association is
an entity that links other lineage or experiment entities. An example
would be an association between a training job and a model.

=head1 ATTRIBUTES


=head2 AssociationType => Str

The type of the association.


=head2 CreatedBy => L<Paws::SageMaker::UserContext>




=head2 CreationTime => Str

When the association was created.


=head2 DestinationArn => Str

The Amazon Resource Name (ARN) of the destination.


=head2 DestinationName => Str

The name of the destination.


=head2 DestinationType => Str

The destination type.


=head2 SourceArn => Str

The ARN of the source.


=head2 SourceName => Str

The name of the source.


=head2 SourceType => Str

The source type.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

