/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class LOBTypeCompiler
extends BaseTypeCompiler {
    public boolean comparable(TypeId typeId, boolean bl, ClassFactory classFactory) {
        return false;
    }

    public boolean convertible(TypeId typeId, boolean bl) {
        return typeId.isBlobTypeId();
    }

    public boolean compatible(TypeId typeId) {
        return this.convertible(typeId, false);
    }

    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        return typeId.isBlobTypeId();
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.BitDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 440: {
                return "java.sql.Blob";
            }
        }
        return null;
    }

    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return dataTypeDescriptor.getMaximumWidth();
    }

    protected String nullMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 440: {
                return "getNullBlob";
            }
        }
        return null;
    }

    protected String dataValueMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 440: {
                return "getBlobDataValue";
            }
        }
        return null;
    }
}

