# Generated by default/object.tt
package Paws::IoTSiteWise::BatchPutAssetPropertyErrorEntry;
  use Moose;
  has EntryId => (is => 'ro', isa => 'Str', request_name => 'entryId', traits => ['NameInRequest'], required => 1);
  has Errors => (is => 'ro', isa => 'ArrayRef[Paws::IoTSiteWise::BatchPutAssetPropertyError]', request_name => 'errors', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::BatchPutAssetPropertyErrorEntry

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::BatchPutAssetPropertyErrorEntry object:

  $service_obj->Method(Att1 => { EntryId => $value, ..., Errors => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::BatchPutAssetPropertyErrorEntry object:

  $result = $service_obj->Method(...);
  $result->Att1->EntryId

=head1 DESCRIPTION

Contains error information for asset property value entries that are
associated with the BatchPutAssetPropertyValue
(https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchPutAssetPropertyValue.html)
API.

=head1 ATTRIBUTES


=head2 B<REQUIRED> EntryId => Str

The ID of the failed entry.


=head2 B<REQUIRED> Errors => ArrayRef[L<Paws::IoTSiteWise::BatchPutAssetPropertyError>]

The list of update property value errors.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

