# Generated by default/object.tt
package Paws::SecurityHub::AwsIamAccessKeyDetails;
  use Moose;
  has AccessKeyId => (is => 'ro', isa => 'Str');
  has AccountId => (is => 'ro', isa => 'Str');
  has CreatedAt => (is => 'ro', isa => 'Str');
  has PrincipalId => (is => 'ro', isa => 'Str');
  has PrincipalName => (is => 'ro', isa => 'Str');
  has PrincipalType => (is => 'ro', isa => 'Str');
  has SessionContext => (is => 'ro', isa => 'Paws::SecurityHub::AwsIamAccessKeySessionContext');
  has Status => (is => 'ro', isa => 'Str');
  has UserName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsIamAccessKeyDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsIamAccessKeyDetails object:

  $service_obj->Method(Att1 => { AccessKeyId => $value, ..., UserName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsIamAccessKeyDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessKeyId

=head1 DESCRIPTION

IAM access key details related to a finding.

=head1 ATTRIBUTES


=head2 AccessKeyId => Str

The identifier of the access key.


=head2 AccountId => Str

The AWS account ID of the account for the key.


=head2 CreatedAt => Str

Indicates when the IAM access key was created.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 PrincipalId => Str

The ID of the principal associated with an access key.


=head2 PrincipalName => Str

The name of the principal.


=head2 PrincipalType => Str

The type of principal associated with an access key.


=head2 SessionContext => L<Paws::SecurityHub::AwsIamAccessKeySessionContext>

Information about the session that the key was used for.


=head2 Status => Str

The status of the IAM access key related to a finding.


=head2 UserName => Str

The user associated with the IAM access key related to a finding.

The C<UserName> parameter has been replaced with the C<PrincipalName>
parameter because access keys can also be assigned to principals that
are not IAM users.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

