package Win32::ADSIEnumerations;
{
  $Win32::ADSIEnumerations::VERSION = '0.02';
}

#ABSTRACT: constants for the Active Directory Service Interfaces (ADSI) enumerations

use strict;
use warnings;

#ADSI_DIALECT_ENUM
use constant ADSI_DIALECT_LDAP => 0;
use constant ADSI_DIALECT_SQL => 0x1;
#ADSTYPEENUM
use constant ADSTYPE_INVALID => 0;
use constant ADSTYPE_DN_STRING => 1;
use constant ADSTYPE_CASE_EXACT_STRING => 2;
use constant ADSTYPE_CASE_IGNORE_STRING => 3;
use constant ADSTYPE_PRINTABLE_STRING => 4;
use constant ADSTYPE_NUMERIC_STRING => 5;
use constant ADSTYPE_BOOLEAN => 6;
use constant ADSTYPE_INTEGER => 7;
use constant ADSTYPE_OCTET_STRING => 8;
use constant ADSTYPE_UTC_TIME => 9;
use constant ADSTYPE_LARGE_INTEGER => 10;
use constant ADSTYPE_PROV_SPECIFIC => 11;
use constant ADSTYPE_OBJECT_CLASS => 12;
use constant ADSTYPE_CASEIGNORE_LIST => 13;
use constant ADSTYPE_OCTET_LIST => 14;
use constant ADSTYPE_PATH => 15;
use constant ADSTYPE_POSTALADDRESS => 16;
use constant ADSTYPE_TIMESTAMP => 17;
use constant ADSTYPE_BACKLINK => 18;
use constant ADSTYPE_TYPEDNAME => 19;
use constant ADSTYPE_HOLD => 20;
use constant ADSTYPE_NETADDRESS => 21;
use constant ADSTYPE_REPLICAPOINTER => 22;
use constant ADSTYPE_FAXNUMBER => 23;
use constant ADSTYPE_EMAIL => 24;
use constant ADSTYPE_NT_SECURITY_DESCRIPTOR => 25;
use constant ADSTYPE_UNKNOWN => 26;
use constant ADSTYPE_DN_WITH_BINARY => 27;
use constant ADSTYPE_DN_WITH_STRING => 28;
#ADS_ACEFLAG_ENUM
use constant ADS_ACEFLAG_INHERIT_ACE => 0x2;
use constant ADS_ACEFLAG_NO_PROPAGATE_INHERIT_ACE => 0x4;
use constant ADS_ACEFLAG_INHERIT_ONLY_ACE => 0x8;
use constant ADS_ACEFLAG_INHERITED_ACE => 0x10;
use constant ADS_ACEFLAG_VALID_INHERIT_FLAGS => 0x1f;
use constant ADS_ACEFLAG_SUCCESSFUL_ACCESS => 0x40;
use constant ADS_ACEFLAG_FAILED_ACCESS => 0x80;
#ADS_ACETYPE_ENUM
use constant ADS_ACETYPE_ACCESS_ALLOWED => 0;
use constant ADS_ACETYPE_ACCESS_DENIED => 0x1;
use constant ADS_ACETYPE_SYSTEM_AUDIT => 0x2;
use constant ADS_ACETYPE_ACCESS_ALLOWED_OBJECT => 0x5;
use constant ADS_ACETYPE_ACCESS_DENIED_OBJECT => 0x6;
use constant ADS_ACETYPE_SYSTEM_AUDIT_OBJECT => 0x7;
use constant ADS_ACETYPE_SYSTEM_ALARM_OBJECT => 0x8;
use constant ADS_ACETYPE_ACCESS_ALLOWED_CALLBACK => 0x9;
use constant ADS_ACETYPE_ACCESS_DENIED_CALLBACK => 0xA;
use constant ADS_ACETYPE_ACCESS_ALLOWED_CALLBACK_OBJECT => 0xB;
use constant ADS_ACETYPE_ACCESS_DENIED_CALLBACK_OBJECT => 0xC;
use constant ADS_ACETYPE_SYSTEM_AUDIT_CALLBACK => 0xD;
use constant ADS_ACETYPE_SYSTEM_ALARM_CALLBACK => 0xE;
use constant ADS_ACETYPE_SYSTEM_AUDIT_CALLBACK_OBJECT => 0xF;
use constant ADS_ACETYPE_SYSTEM_ALARM_CALLBACK_OBJECT => 0x10;
#ADS_AUTHENTICATION_ENUM
use constant ADS_SECURE_AUTHENTICATION => 0x1;
use constant ADS_USE_ENCRYPTION => 0x2;
use constant ADS_USE_SSL => 0x2;
use constant ADS_READONLY_SERVER => 0x4;
use constant ADS_PROMPT_CREDENTIALS => 0x8;
use constant ADS_NO_AUTHENTICATION => 0x10;
use constant ADS_FAST_BIND => 0x20;
use constant ADS_USE_SIGNING => 0x40;
use constant ADS_USE_SEALING => 0x80;
use constant ADS_USE_DELEGATION => 0x100;
use constant ADS_SERVER_BIND => 0x200;
use constant ADS_NO_REFERRAL_CHASING => 0x400;
use constant ADS_AUTH_RESERVED => 0x80000000;
#ADS_CHASE_REFERRALS_ENUM
use constant ADS_CHASE_REFERRALS_NEVER => 0x00;
use constant ADS_CHASE_REFERRALS_SUBORDINATE => 0x20;
use constant ADS_CHASE_REFERRALS_EXTERNAL => 0x40;
use constant ADS_CHASE_REFERRALS_ALWAYS => 0x20 | 0x40;
#ADS_DEREFENUM
use constant ADS_DEREF_NEVER => 0;
use constant ADS_DEREF_SEARCHING => 1;
use constant ADS_DEREF_FINDING => 2;
use constant ADS_DEREF_ALWAYS => 3;
#ADS_DISPLAY_ENUM
use constant ADS_DISPLAY_FULL => 1;
use constant ADS_DISPLAY_VALUE_ONLY => 2;
#ADS_ESCAPE_MODE_ENUM
use constant ADS_ESCAPEDMODE_DEFAULT => 1;
use constant ADS_ESCAPEDMODE_ON => 2;
use constant ADS_ESCAPEDMODE_OFF => 3;
use constant ADS_ESCAPEDMODE_OFF_EX => 4;
#ADS_FLAGTYPE_ENUM
use constant ADS_FLAG_OBJECT_TYPE_PRESENT => 0x1;
use constant ADS_FLAG_INHERITED_OBJECT_TYPE_PRESENT => 0x2;
#ADS_FORMAT_ENUM
use constant ADS_FORMAT_WINDOWS => 1;
use constant ADS_FORMAT_WINDOWS_NO_SERVER => 2;
use constant ADS_FORMAT_WINDOWS_DN => 3;
use constant ADS_FORMAT_WINDOWS_PARENT => 4;
use constant ADS_FORMAT_X500 => 5;
use constant ADS_FORMAT_X500_NO_SERVER => 6;
use constant ADS_FORMAT_X500_DN => 7;
use constant ADS_FORMAT_X500_PARENT => 8;
use constant ADS_FORMAT_SERVER => 9;
use constant ADS_FORMAT_PROVIDER => 10;
use constant ADS_FORMAT_LEAF => 11;
#ADS_GROUP_TYPE_ENUM
use constant ADS_GROUP_TYPE_GLOBAL_GROUP => 0x00000002;
use constant ADS_GROUP_TYPE_DOMAIN_LOCAL_GROUP => 0x00000004;
use constant ADS_GROUP_TYPE_LOCAL_GROUP => 0x00000004;
use constant ADS_GROUP_TYPE_UNIVERSAL_GROUP => 0x00000008;
use constant ADS_GROUP_TYPE_SECURITY_ENABLED => 0x80000000;
#ADS_NAME_INITTYPE_ENUM
use constant ADS_NAME_INITTYPE_DOMAIN => 1;
use constant ADS_NAME_INITTYPE_SERVER => 2;
use constant ADS_NAME_INITTYPE_GC => 3;
#ADS_NAME_TYPE_ENUM
use constant ADS_NAME_TYPE_1779 => 1;
use constant ADS_NAME_TYPE_CANONICAL => 2;
use constant ADS_NAME_TYPE_NT4 => 3;
use constant ADS_NAME_TYPE_DISPLAY => 4;
use constant ADS_NAME_TYPE_DOMAIN_SIMPLE => 5;
use constant ADS_NAME_TYPE_ENTERPRISE_SIMPLE => 6;
use constant ADS_NAME_TYPE_GUID => 7;
use constant ADS_NAME_TYPE_UNKNOWN => 8;
use constant ADS_NAME_TYPE_USER_PRINCIPAL_NAME => 9;
use constant ADS_NAME_TYPE_CANONICAL_EX => 10;
use constant ADS_NAME_TYPE_SERVICE_PRINCIPAL_NAME => 11;
use constant ADS_NAME_TYPE_SID_OR_SID_HISTORY_NAME => 12;
#ADS_OPTION_ENUM
use constant ADS_OPTION_SERVERNAME => 0;
use constant ADS_OPTION_REFERRALS => 1;
use constant ADS_OPTION_PAGE_SIZE => 2;
use constant ADS_OPTION_SECURITY_MASK => 3;
use constant ADS_OPTION_MUTUAL_AUTH_STATUS => 4;
use constant ADS_OPTION_QUOTA => 5;
use constant ADS_OPTION_PASSWORD_PORTNUMBER => 6;
use constant ADS_OPTION_PASSWORD_METHOD => 7;
use constant ADS_OPTION_ACCUMULATIVE_MODIFICATION => 8;
use constant ADS_OPTION_SKIP_SID_LOOKUP => 9;
#ADS_PASSWORD_ENCODING_ENUM
use constant ADS_PASSWORD_ENCODE_REQUIRE_SSL => 0;
use constant ADS_PASSWORD_ENCODE_CLEAR => 1;
#ADS_PATHTYPE_ENUM
use constant ADS_PATH_FILE => 1;
use constant ADS_PATH_FILESHARE => 2;
use constant ADS_PATH_REGISTRY => 3;
#ADS_PREFERENCES_ENUM
use constant ADSIPROP_ASYNCHRONOUS => 0;
use constant ADSIPROP_DEREF_ALIASES => 0x1;
use constant ADSIPROP_SIZE_LIMIT => 0x2;
use constant ADSIPROP_TIME_LIMIT => 0x3;
use constant ADSIPROP_ATTRIBTYPES_ONLY => 0x4;
use constant ADSIPROP_SEARCH_SCOPE => 0x5;
use constant ADSIPROP_TIMEOUT => 0x6;
use constant ADSIPROP_PAGESIZE => 0x7;
use constant ADSIPROP_PAGED_TIME_LIMIT => 0x8;
use constant ADSIPROP_CHASE_REFERRALS => 0x9;
use constant ADSIPROP_SORT_ON => 0xa;
use constant ADSIPROP_CACHE_RESULTS => 0xb;
use constant ADSIPROP_ADSIFLAG => 0xc;
#ADS_PROPERTY_OPERATION_ENUM
use constant ADS_PROPERTY_CLEAR => 1;
use constant ADS_PROPERTY_UPDATE => 2;
use constant ADS_PROPERTY_APPEND => 3;
use constant ADS_PROPERTY_DELETE => 4;
#ADS_RIGHTS_ENUM
use constant ADS_RIGHT_DELETE => 0x10000;
use constant ADS_RIGHT_READ_CONTROL => 0x20000;
use constant ADS_RIGHT_WRITE_DAC => 0x40000;
use constant ADS_RIGHT_WRITE_OWNER => 0x80000;
use constant ADS_RIGHT_SYNCHRONIZE => 0x100000;
use constant ADS_RIGHT_ACCESS_SYSTEM_SECURITY => 0x1000000;
use constant ADS_RIGHT_GENERIC_READ => 0x80000000;
use constant ADS_RIGHT_GENERIC_WRITE => 0x40000000;
use constant ADS_RIGHT_GENERIC_EXECUTE => 0x20000000;
use constant ADS_RIGHT_GENERIC_ALL => 0x10000000;
use constant ADS_RIGHT_DS_CREATE_CHILD => 0x1;
use constant ADS_RIGHT_DS_DELETE_CHILD => 0x2;
use constant ADS_RIGHT_ACTRL_DS_LIST => 0x4;
use constant ADS_RIGHT_DS_SELF => 0x8;
use constant ADS_RIGHT_DS_READ_PROP => 0x10;
use constant ADS_RIGHT_DS_WRITE_PROP => 0x20;
use constant ADS_RIGHT_DS_DELETE_TREE => 0x40;
use constant ADS_RIGHT_DS_LIST_OBJECT => 0x80;
use constant ADS_RIGHT_DS_CONTROL_ACCESS => 0x100;
#ADS_SCOPEENUM
use constant ADS_SCOPE_BASE => 0;
use constant ADS_SCOPE_ONELEVEL => 1;
use constant ADS_SCOPE_SUBTREE => 2;
#ADS_SD_CONTROL_ENUM
use constant ADS_SD_CONTROL_SE_OWNER_DEFAULTED => 0x0001;
use constant ADS_SD_CONTROL_SE_GROUP_DEFAULTED => 0x0002;
use constant ADS_SD_CONTROL_SE_DACL_PRESENT => 0x0004;
use constant ADS_SD_CONTROL_SE_DACL_DEFAULTED => 0x0008;
use constant ADS_SD_CONTROL_SE_SACL_PRESENT => 0x0010;
use constant ADS_SD_CONTROL_SE_SACL_DEFAULTED => 0x0020;
use constant ADS_SD_CONTROL_SE_DACL_AUTO_INHERIT_REQ => 0x0100;
use constant ADS_SD_CONTROL_SE_SACL_AUTO_INHERIT_REQ => 0x0200;
use constant ADS_SD_CONTROL_SE_DACL_AUTO_INHERITED => 0x0400;
use constant ADS_SD_CONTROL_SE_SACL_AUTO_INHERITED => 0x0800;
use constant ADS_SD_CONTROL_SE_DACL_PROTECTED => 0x1000;
use constant ADS_SD_CONTROL_SE_SACL_PROTECTED => 0x2000;
use constant ADS_SD_CONTROL_SE_SELF_RELATIVE => 0x8000;
#ADS_SD_FORMAT_ENUM
use constant ADS_SD_FORMAT_IID => 1;
use constant ADS_SD_FORMAT_RAW => 2;
use constant ADS_SD_FORMAT_HEXSTRING => 3;
#ADS_SD_REVISION_ENUM
use constant ADS_SD_REVISION_DS => 4;
#ADS_SEARCHPREF_ENUM
use constant ADS_SEARCHPREF_ASYNCHRONOUS => 0;
use constant ADS_SEARCHPREF_DEREF_ALIASES => 1;
use constant ADS_SEARCHPREF_SIZE_LIMIT => 2;
use constant ADS_SEARCHPREF_TIME_LIMIT => 3;
use constant ADS_SEARCHPREF_ATTRIBTYPES_ONLY => 4;
use constant ADS_SEARCHPREF_SEARCH_SCOPE => 5;
use constant ADS_SEARCHPREF_TIMEOUT => 6;
use constant ADS_SEARCHPREF_PAGESIZE => 7;
use constant ADS_SEARCHPREF_PAGED_TIME_LIMIT => 8;
use constant ADS_SEARCHPREF_CHASE_REFERRALS => 9;
use constant ADS_SEARCHPREF_SORT_ON => 10;
use constant ADS_SEARCHPREF_CACHE_RESULTS => 11;
use constant ADS_SEARCHPREF_DIRSYNC => 12;
use constant ADS_SEARCHPREF_TOMBSTONE => 13;
use constant ADS_SEARCHPREF_VLV => 14;
use constant ADS_SEARCHPREF_ATTRIBUTE_QUERY => 15;
use constant ADS_SEARCHPREF_SECURITY_MASK => 16;
use constant ADS_SEARCHPREF_DIRSYNC_FLAG => 17;
use constant ADS_SEARCHPREF_EXTENDED_DN => 18;
#ADS_SECURITY_INFO_ENUM
use constant ADS_SECURITY_INFO_OWNER => 0x1;
use constant ADS_SECURITY_INFO_GROUP => 0x2;
use constant ADS_SECURITY_INFO_DACL => 0x4;
use constant ADS_SECURITY_INFO_SACL => 0x8;
#ADS_SETTYPE_ENUM
use constant ADS_SETTYPE_FULL => 1;
use constant ADS_SETTYPE_PROVIDER => 2;
use constant ADS_SETTYPE_SERVER => 3;
use constant ADS_SETTYPE_DN => 4;
#ADS_STATUSENUM
use constant ADS_STATUS_S_OK => 0;
use constant ADS_STATUS_INVALID_SEARCHPREF => 1;
use constant ADS_STATUS_INVALID_SEARCHPREFVALUE => 2;
#ADS_SYSTEMFLAG_ENUM
use constant ADS_SYSTEMFLAG_DISALLOW_DELETE => 0x80000000;
use constant ADS_SYSTEMFLAG_CONFIG_ALLOW_RENAME => 0x40000000;
use constant ADS_SYSTEMFLAG_CONFIG_ALLOW_MOVE => 0x20000000;
use constant ADS_SYSTEMFLAG_CONFIG_ALLOW_LIMITED_MOVE => 0x10000000;
use constant ADS_SYSTEMFLAG_DOMAIN_DISALLOW_RENAME => 0x08000000;
use constant ADS_SYSTEMFLAG_DOMAIN_DISALLOW_MOVE => 0x04000000;
use constant ADS_SYSTEMFLAG_CR_NTDS_NC => 0x1;
use constant ADS_SYSTEMFLAG_CR_NTDS_DOMAIN => 0x2;
use constant ADS_SYSTEMFLAG_ATTR_NOT_REPLICATED => 0x1;
use constant ADS_SYSTEMFLAG_ATTR_IS_CONSTRUCTED => 0x4;
#ADS_USER_FLAG_ENUM
use constant ADS_UF_SCRIPT => 0x1;
use constant ADS_UF_ACCOUNTDISABLE => 0x2;
use constant ADS_UF_HOMEDIR_REQUIRED => 0x8;
use constant ADS_UF_LOCKOUT => 0x10;
use constant ADS_UF_PASSWD_NOTREQD => 0x20;
use constant ADS_UF_PASSWD_CANT_CHANGE => 0x40;
use constant ADS_UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED => 0x80;
use constant ADS_UF_TEMP_DUPLICATE_ACCOUNT => 0x100;
use constant ADS_UF_NORMAL_ACCOUNT => 0x200;
use constant ADS_UF_INTERDOMAIN_TRUST_ACCOUNT => 0x800;
use constant ADS_UF_WORKSTATION_TRUST_ACCOUNT => 0x1000;
use constant ADS_UF_SERVER_TRUST_ACCOUNT => 0x2000;
use constant ADS_UF_DONT_EXPIRE_PASSWD => 0x10000;
use constant ADS_UF_MNS_LOGON_ACCOUNT => 0x20000;
use constant ADS_UF_SMARTCARD_REQUIRED => 0x40000;
use constant ADS_UF_TRUSTED_FOR_DELEGATION => 0x80000;
use constant ADS_UF_NOT_DELEGATED => 0x100000;
use constant ADS_UF_USE_DES_KEY_ONLY => 0x200000;
use constant ADS_UF_DONT_REQUIRE_PREAUTH => 0x400000;
use constant ADS_UF_PASSWORD_EXPIRED => 0x800000;
use constant ADS_UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION => 0x1000000;

require Exporter;
our @ISA = qw(Exporter);

our @EXPORT_OK = (
  'ADS_ACEFLAG_INHERIT_ACE',
  'ADS_ACEFLAG_NO_PROPAGATE_INHERIT_ACE',
  'ADS_ACEFLAG_INHERIT_ONLY_ACE',
  'ADS_ACEFLAG_INHERITED_ACE',
  'ADS_ACEFLAG_VALID_INHERIT_FLAGS',
  'ADS_ACEFLAG_SUCCESSFUL_ACCESS',
  'ADS_ACEFLAG_FAILED_ACCESS',
  'ADS_ACETYPE_ACCESS_ALLOWED',
  'ADS_ACETYPE_ACCESS_DENIED',
  'ADS_ACETYPE_SYSTEM_AUDIT',
  'ADS_ACETYPE_ACCESS_ALLOWED_OBJECT',
  'ADS_ACETYPE_ACCESS_DENIED_OBJECT',
  'ADS_ACETYPE_SYSTEM_AUDIT_OBJECT',
  'ADS_ACETYPE_SYSTEM_ALARM_OBJECT',
  'ADS_ACETYPE_ACCESS_ALLOWED_CALLBACK',
  'ADS_ACETYPE_ACCESS_DENIED_CALLBACK',
  'ADS_ACETYPE_ACCESS_ALLOWED_CALLBACK_OBJECT',
  'ADS_ACETYPE_ACCESS_DENIED_CALLBACK_OBJECT',
  'ADS_ACETYPE_SYSTEM_AUDIT_CALLBACK',
  'ADS_ACETYPE_SYSTEM_ALARM_CALLBACK',
  'ADS_ACETYPE_SYSTEM_AUDIT_CALLBACK_OBJECT',
  'ADS_ACETYPE_SYSTEM_ALARM_CALLBACK_OBJECT',
  'ADS_SECURE_AUTHENTICATION',
  'ADS_USE_ENCRYPTION',
  'ADS_USE_SSL',
  'ADS_READONLY_SERVER',
  'ADS_PROMPT_CREDENTIALS',
  'ADS_NO_AUTHENTICATION',
  'ADS_FAST_BIND',
  'ADS_USE_SIGNING',
  'ADS_USE_SEALING',
  'ADS_USE_DELEGATION',
  'ADS_SERVER_BIND',
  'ADS_NO_REFERRAL_CHASING',
  'ADS_AUTH_RESERVED',
  'ADS_CHASE_REFERRALS_NEVER',
  'ADS_CHASE_REFERRALS_SUBORDINATE',
  'ADS_CHASE_REFERRALS_EXTERNAL',
  'ADS_CHASE_REFERRALS_ALWAYS',
  'ADS_DEREF_NEVER',
  'ADS_DEREF_SEARCHING',
  'ADS_DEREF_FINDING',
  'ADS_DEREF_ALWAYS',
  'ADS_DISPLAY_FULL',
  'ADS_DISPLAY_VALUE_ONLY',
  'ADS_ESCAPEDMODE_DEFAULT',
  'ADS_ESCAPEDMODE_ON',
  'ADS_ESCAPEDMODE_OFF',
  'ADS_ESCAPEDMODE_OFF_EX',
  'ADS_FLAG_OBJECT_TYPE_PRESENT',
  'ADS_FLAG_INHERITED_OBJECT_TYPE_PRESENT',
  'ADS_FORMAT_WINDOWS',
  'ADS_FORMAT_WINDOWS_NO_SERVER',
  'ADS_FORMAT_WINDOWS_DN',
  'ADS_FORMAT_WINDOWS_PARENT',
  'ADS_FORMAT_X500',
  'ADS_FORMAT_X500_NO_SERVER',
  'ADS_FORMAT_X500_DN',
  'ADS_FORMAT_X500_PARENT',
  'ADS_FORMAT_SERVER',
  'ADS_FORMAT_PROVIDER',
  'ADS_FORMAT_LEAF',
  'ADS_GROUP_TYPE_GLOBAL_GROUP',
  'ADS_GROUP_TYPE_DOMAIN_LOCAL_GROUP',
  'ADS_GROUP_TYPE_LOCAL_GROUP',
  'ADS_GROUP_TYPE_UNIVERSAL_GROUP',
  'ADS_GROUP_TYPE_SECURITY_ENABLED',
  'ADS_NAME_INITTYPE_DOMAIN',
  'ADS_NAME_INITTYPE_SERVER',
  'ADS_NAME_INITTYPE_GC',
  'ADS_NAME_TYPE_1779',
  'ADS_NAME_TYPE_CANONICAL',
  'ADS_NAME_TYPE_NT4',
  'ADS_NAME_TYPE_DISPLAY',
  'ADS_NAME_TYPE_DOMAIN_SIMPLE',
  'ADS_NAME_TYPE_ENTERPRISE_SIMPLE',
  'ADS_NAME_TYPE_GUID',
  'ADS_NAME_TYPE_UNKNOWN',
  'ADS_NAME_TYPE_USER_PRINCIPAL_NAME',
  'ADS_NAME_TYPE_CANONICAL_EX',
  'ADS_NAME_TYPE_SERVICE_PRINCIPAL_NAME',
  'ADS_NAME_TYPE_SID_OR_SID_HISTORY_NAME',
  'ADS_OPTION_SERVERNAME',
  'ADS_OPTION_REFERRALS',
  'ADS_OPTION_PAGE_SIZE',
  'ADS_OPTION_SECURITY_MASK',
  'ADS_OPTION_MUTUAL_AUTH_STATUS',
  'ADS_OPTION_QUOTA',
  'ADS_OPTION_PASSWORD_PORTNUMBER',
  'ADS_OPTION_PASSWORD_METHOD',
  'ADS_OPTION_ACCUMULATIVE_MODIFICATION',
  'ADS_OPTION_SKIP_SID_LOOKUP',
  'ADS_PASSWORD_ENCODE_REQUIRE_SSL',
  'ADS_PASSWORD_ENCODE_CLEAR',
  'ADS_PATH_FILE',
  'ADS_PATH_FILESHARE',
  'ADS_PATH_REGISTRY',
  'ADSIPROP_ASYNCHRONOUS',
  'ADSIPROP_DEREF_ALIASES',
  'ADSIPROP_SIZE_LIMIT',
  'ADSIPROP_TIME_LIMIT',
  'ADSIPROP_ATTRIBTYPES_ONLY',
  'ADSIPROP_SEARCH_SCOPE',
  'ADSIPROP_TIMEOUT',
  'ADSIPROP_PAGESIZE',
  'ADSIPROP_PAGED_TIME_LIMIT',
  'ADSIPROP_CHASE_REFERRALS',
  'ADSIPROP_SORT_ON',
  'ADSIPROP_CACHE_RESULTS',
  'ADSIPROP_ADSIFLAG',
  'ADS_PROPERTY_CLEAR',
  'ADS_PROPERTY_UPDATE',
  'ADS_PROPERTY_APPEND',
  'ADS_PROPERTY_DELETE',
  'ADS_RIGHT_DELETE',
  'ADS_RIGHT_READ_CONTROL',
  'ADS_RIGHT_WRITE_DAC',
  'ADS_RIGHT_WRITE_OWNER',
  'ADS_RIGHT_SYNCHRONIZE',
  'ADS_RIGHT_ACCESS_SYSTEM_SECURITY',
  'ADS_RIGHT_GENERIC_READ',
  'ADS_RIGHT_GENERIC_WRITE',
  'ADS_RIGHT_GENERIC_EXECUTE',
  'ADS_RIGHT_GENERIC_ALL',
  'ADS_RIGHT_DS_CREATE_CHILD',
  'ADS_RIGHT_DS_DELETE_CHILD',
  'ADS_RIGHT_ACTRL_DS_LIST',
  'ADS_RIGHT_DS_SELF',
  'ADS_RIGHT_DS_READ_PROP',
  'ADS_RIGHT_DS_WRITE_PROP',
  'ADS_RIGHT_DS_DELETE_TREE',
  'ADS_RIGHT_DS_LIST_OBJECT',
  'ADS_RIGHT_DS_CONTROL_ACCESS',
  'ADS_SCOPE_BASE',
  'ADS_SCOPE_ONELEVEL',
  'ADS_SCOPE_SUBTREE',
  'ADS_SD_CONTROL_SE_OWNER_DEFAULTED',
  'ADS_SD_CONTROL_SE_GROUP_DEFAULTED',
  'ADS_SD_CONTROL_SE_DACL_PRESENT',
  'ADS_SD_CONTROL_SE_DACL_DEFAULTED',
  'ADS_SD_CONTROL_SE_SACL_PRESENT',
  'ADS_SD_CONTROL_SE_SACL_DEFAULTED',
  'ADS_SD_CONTROL_SE_DACL_AUTO_INHERIT_REQ',
  'ADS_SD_CONTROL_SE_SACL_AUTO_INHERIT_REQ',
  'ADS_SD_CONTROL_SE_DACL_AUTO_INHERITED',
  'ADS_SD_CONTROL_SE_SACL_AUTO_INHERITED',
  'ADS_SD_CONTROL_SE_DACL_PROTECTED',
  'ADS_SD_CONTROL_SE_SACL_PROTECTED',
  'ADS_SD_CONTROL_SE_SELF_RELATIVE',
  'ADS_SD_FORMAT_IID',
  'ADS_SD_FORMAT_RAW',
  'ADS_SD_FORMAT_HEXSTRING',
  'ADS_SD_REVISION_DS',
  'ADS_SEARCHPREF_ASYNCHRONOUS',
  'ADS_SEARCHPREF_DEREF_ALIASES',
  'ADS_SEARCHPREF_SIZE_LIMIT',
  'ADS_SEARCHPREF_TIME_LIMIT',
  'ADS_SEARCHPREF_ATTRIBTYPES_ONLY',
  'ADS_SEARCHPREF_SEARCH_SCOPE',
  'ADS_SEARCHPREF_TIMEOUT',
  'ADS_SEARCHPREF_PAGESIZE',
  'ADS_SEARCHPREF_PAGED_TIME_LIMIT',
  'ADS_SEARCHPREF_CHASE_REFERRALS',
  'ADS_SEARCHPREF_SORT_ON',
  'ADS_SEARCHPREF_CACHE_RESULTS',
  'ADS_SEARCHPREF_DIRSYNC',
  'ADS_SEARCHPREF_TOMBSTONE',
  'ADS_SEARCHPREF_VLV',
  'ADS_SEARCHPREF_ATTRIBUTE_QUERY',
  'ADS_SEARCHPREF_SECURITY_MASK',
  'ADS_SEARCHPREF_DIRSYNC_FLAG',
  'ADS_SEARCHPREF_EXTENDED_DN',
  'ADS_SECURITY_INFO_OWNER',
  'ADS_SECURITY_INFO_GROUP',
  'ADS_SECURITY_INFO_DACL',
  'ADS_SECURITY_INFO_SACL',
  'ADS_SETTYPE_FULL',
  'ADS_SETTYPE_PROVIDER',
  'ADS_SETTYPE_SERVER',
  'ADS_SETTYPE_DN',
  'ADS_STATUS_S_OK',
  'ADS_STATUS_INVALID_SEARCHPREF',
  'ADS_STATUS_INVALID_SEARCHPREFVALUE',
  'ADS_SYSTEMFLAG_DISALLOW_DELETE',
  'ADS_SYSTEMFLAG_CONFIG_ALLOW_RENAME',
  'ADS_SYSTEMFLAG_CONFIG_ALLOW_MOVE',
  'ADS_SYSTEMFLAG_CONFIG_ALLOW_LIMITED_MOVE',
  'ADS_SYSTEMFLAG_DOMAIN_DISALLOW_RENAME',
  'ADS_SYSTEMFLAG_DOMAIN_DISALLOW_MOVE',
  'ADS_SYSTEMFLAG_CR_NTDS_NC',
  'ADS_SYSTEMFLAG_CR_NTDS_DOMAIN',
  'ADS_SYSTEMFLAG_ATTR_NOT_REPLICATED',
  'ADS_SYSTEMFLAG_ATTR_IS_CONSTRUCTED',
  'ADS_UF_SCRIPT',
  'ADS_UF_ACCOUNTDISABLE',
  'ADS_UF_HOMEDIR_REQUIRED',
  'ADS_UF_LOCKOUT',
  'ADS_UF_PASSWD_NOTREQD',
  'ADS_UF_PASSWD_CANT_CHANGE',
  'ADS_UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED',
  'ADS_UF_TEMP_DUPLICATE_ACCOUNT',
  'ADS_UF_NORMAL_ACCOUNT',
  'ADS_UF_INTERDOMAIN_TRUST_ACCOUNT',
  'ADS_UF_WORKSTATION_TRUST_ACCOUNT',
  'ADS_UF_SERVER_TRUST_ACCOUNT',
  'ADS_UF_DONT_EXPIRE_PASSWD',
  'ADS_UF_MNS_LOGON_ACCOUNT',
  'ADS_UF_SMARTCARD_REQUIRED',
  'ADS_UF_TRUSTED_FOR_DELEGATION',
  'ADS_UF_NOT_DELEGATED',
  'ADS_UF_USE_DES_KEY_ONLY',
  'ADS_UF_DONT_REQUIRE_PREAUTH',
  'ADS_UF_PASSWORD_EXPIRED',
  'ADS_UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION',
  'ADSI_DIALECT_LDAP',
  'ADSI_DIALECT_SQL',
  'ADSTYPE_INVALID',
  'ADSTYPE_DN_STRING',
  'ADSTYPE_CASE_EXACT_STRING',
  'ADSTYPE_CASE_IGNORE_STRING',
  'ADSTYPE_PRINTABLE_STRING',
  'ADSTYPE_NUMERIC_STRING',
  'ADSTYPE_BOOLEAN',
  'ADSTYPE_INTEGER',
  'ADSTYPE_OCTET_STRING',
  'ADSTYPE_UTC_TIME',
  'ADSTYPE_LARGE_INTEGER',
  'ADSTYPE_PROV_SPECIFIC',
  'ADSTYPE_OBJECT_CLASS',
  'ADSTYPE_CASEIGNORE_LIST',
  'ADSTYPE_OCTET_LIST',
  'ADSTYPE_PATH',
  'ADSTYPE_POSTALADDRESS',
  'ADSTYPE_TIMESTAMP',
  'ADSTYPE_BACKLINK',
  'ADSTYPE_TYPEDNAME',
  'ADSTYPE_HOLD',
  'ADSTYPE_NETADDRESS',
  'ADSTYPE_REPLICAPOINTER',
  'ADSTYPE_FAXNUMBER',
  'ADSTYPE_EMAIL',
  'ADSTYPE_NT_SECURITY_DESCRIPTOR',
  'ADSTYPE_UNKNOWN',
  'ADSTYPE_DN_WITH_BINARY',
  'ADSTYPE_DN_WITH_STRING',
);

our %EXPORT_TAGS = (
  'ADS_SD_CONTROL_ENUM' => [
    'ADS_SD_CONTROL_SE_OWNER_DEFAULTED',
    'ADS_SD_CONTROL_SE_GROUP_DEFAULTED',
    'ADS_SD_CONTROL_SE_DACL_PRESENT',
    'ADS_SD_CONTROL_SE_DACL_DEFAULTED',
    'ADS_SD_CONTROL_SE_SACL_PRESENT',
    'ADS_SD_CONTROL_SE_SACL_DEFAULTED',
    'ADS_SD_CONTROL_SE_DACL_AUTO_INHERIT_REQ',
    'ADS_SD_CONTROL_SE_SACL_AUTO_INHERIT_REQ',
    'ADS_SD_CONTROL_SE_DACL_AUTO_INHERITED',
    'ADS_SD_CONTROL_SE_SACL_AUTO_INHERITED',
    'ADS_SD_CONTROL_SE_DACL_PROTECTED',
    'ADS_SD_CONTROL_SE_SACL_PROTECTED',
    'ADS_SD_CONTROL_SE_SELF_RELATIVE'
  ],
  'ADS_SCOPEENUM' => [
    'ADS_SCOPE_BASE',
    'ADS_SCOPE_ONELEVEL',
    'ADS_SCOPE_SUBTREE'
  ],
  'ADS_NAME_INITTYPE_ENUM' => [
    'ADS_NAME_INITTYPE_DOMAIN',
    'ADS_NAME_INITTYPE_SERVER',
    'ADS_NAME_INITTYPE_GC'
  ],
  'ADS_GROUP_TYPE_ENUM' => [
    'ADS_GROUP_TYPE_GLOBAL_GROUP',
    'ADS_GROUP_TYPE_DOMAIN_LOCAL_GROUP',
    'ADS_GROUP_TYPE_LOCAL_GROUP',
    'ADS_GROUP_TYPE_UNIVERSAL_GROUP',
    'ADS_GROUP_TYPE_SECURITY_ENABLED'
  ],
  'ADS_ESCAPE_MODE_ENUM' => [
    'ADS_ESCAPEDMODE_DEFAULT',
    'ADS_ESCAPEDMODE_ON',
    'ADS_ESCAPEDMODE_OFF',
    'ADS_ESCAPEDMODE_OFF_EX'
  ],
  'ADS_ACETYPE_ENUM' => [
    'ADS_ACETYPE_ACCESS_ALLOWED',
    'ADS_ACETYPE_ACCESS_DENIED',
    'ADS_ACETYPE_SYSTEM_AUDIT',
    'ADS_ACETYPE_ACCESS_ALLOWED_OBJECT',
    'ADS_ACETYPE_ACCESS_DENIED_OBJECT',
    'ADS_ACETYPE_SYSTEM_AUDIT_OBJECT',
    'ADS_ACETYPE_SYSTEM_ALARM_OBJECT',
    'ADS_ACETYPE_ACCESS_ALLOWED_CALLBACK',
    'ADS_ACETYPE_ACCESS_DENIED_CALLBACK',
    'ADS_ACETYPE_ACCESS_ALLOWED_CALLBACK_OBJECT',
    'ADS_ACETYPE_ACCESS_DENIED_CALLBACK_OBJECT',
    'ADS_ACETYPE_SYSTEM_AUDIT_CALLBACK',
    'ADS_ACETYPE_SYSTEM_ALARM_CALLBACK',
    'ADS_ACETYPE_SYSTEM_AUDIT_CALLBACK_OBJECT',
    'ADS_ACETYPE_SYSTEM_ALARM_CALLBACK_OBJECT'
  ],
  'ADS_SETTYPE_ENUM' => [
    'ADS_SETTYPE_FULL',
    'ADS_SETTYPE_PROVIDER',
    'ADS_SETTYPE_SERVER',
    'ADS_SETTYPE_DN'
  ],
  'ADS_CHASE_REFERRALS_ENUM' => [
    'ADS_CHASE_REFERRALS_NEVER',
    'ADS_CHASE_REFERRALS_SUBORDINATE',
    'ADS_CHASE_REFERRALS_EXTERNAL',
    'ADS_CHASE_REFERRALS_ALWAYS'
  ],
  'ADS_OPTION_ENUM' => [
    'ADS_OPTION_SERVERNAME',
    'ADS_OPTION_REFERRALS',
    'ADS_OPTION_PAGE_SIZE',
    'ADS_OPTION_SECURITY_MASK',
    'ADS_OPTION_MUTUAL_AUTH_STATUS',
    'ADS_OPTION_QUOTA',
    'ADS_OPTION_PASSWORD_PORTNUMBER',
    'ADS_OPTION_PASSWORD_METHOD',
    'ADS_OPTION_ACCUMULATIVE_MODIFICATION',
    'ADS_OPTION_SKIP_SID_LOOKUP'
  ],
  'ADS_FLAGTYPE_ENUM' => [
    'ADS_FLAG_OBJECT_TYPE_PRESENT',
    'ADS_FLAG_INHERITED_OBJECT_TYPE_PRESENT'
  ],
  'ADS_AUTHENTICATION_ENUM' => [
    'ADS_SECURE_AUTHENTICATION',
    'ADS_USE_ENCRYPTION',
    'ADS_USE_SSL',
    'ADS_READONLY_SERVER',
    'ADS_PROMPT_CREDENTIALS',
    'ADS_NO_AUTHENTICATION',
    'ADS_FAST_BIND',
    'ADS_USE_SIGNING',
    'ADS_USE_SEALING',
    'ADS_USE_DELEGATION',
    'ADS_SERVER_BIND',
    'ADS_NO_REFERRAL_CHASING',
    'ADS_AUTH_RESERVED'
  ],
  'ADS_SD_REVISION_ENUM' => [
    'ADS_SD_REVISION_DS'
  ],
  'ADSTYPEENUM' => [
    'ADSTYPE_INVALID',
    'ADSTYPE_DN_STRING',
    'ADSTYPE_CASE_EXACT_STRING',
    'ADSTYPE_CASE_IGNORE_STRING',
    'ADSTYPE_PRINTABLE_STRING',
    'ADSTYPE_NUMERIC_STRING',
    'ADSTYPE_BOOLEAN',
    'ADSTYPE_INTEGER',
    'ADSTYPE_OCTET_STRING',
    'ADSTYPE_UTC_TIME',
    'ADSTYPE_LARGE_INTEGER',
    'ADSTYPE_PROV_SPECIFIC',
    'ADSTYPE_OBJECT_CLASS',
    'ADSTYPE_CASEIGNORE_LIST',
    'ADSTYPE_OCTET_LIST',
    'ADSTYPE_PATH',
    'ADSTYPE_POSTALADDRESS',
    'ADSTYPE_TIMESTAMP',
    'ADSTYPE_BACKLINK',
    'ADSTYPE_TYPEDNAME',
    'ADSTYPE_HOLD',
    'ADSTYPE_NETADDRESS',
    'ADSTYPE_REPLICAPOINTER',
    'ADSTYPE_FAXNUMBER',
    'ADSTYPE_EMAIL',
    'ADSTYPE_NT_SECURITY_DESCRIPTOR',
    'ADSTYPE_UNKNOWN',
    'ADSTYPE_DN_WITH_BINARY',
    'ADSTYPE_DN_WITH_STRING'
  ],
  'ADS_SD_FORMAT_ENUM' => [
    'ADS_SD_FORMAT_IID',
    'ADS_SD_FORMAT_RAW',
    'ADS_SD_FORMAT_HEXSTRING'
  ],
  'ADS_DEREFENUM' => [
    'ADS_DEREF_NEVER',
    'ADS_DEREF_SEARCHING',
    'ADS_DEREF_FINDING',
    'ADS_DEREF_ALWAYS'
  ],
  'ADS_FORMAT_ENUM' => [
    'ADS_FORMAT_WINDOWS',
    'ADS_FORMAT_WINDOWS_NO_SERVER',
    'ADS_FORMAT_WINDOWS_DN',
    'ADS_FORMAT_WINDOWS_PARENT',
    'ADS_FORMAT_X500',
    'ADS_FORMAT_X500_NO_SERVER',
    'ADS_FORMAT_X500_DN',
    'ADS_FORMAT_X500_PARENT',
    'ADS_FORMAT_SERVER',
    'ADS_FORMAT_PROVIDER',
    'ADS_FORMAT_LEAF'
  ],
  'ADS_STATUSENUM' => [
    'ADS_STATUS_S_OK',
    'ADS_STATUS_INVALID_SEARCHPREF',
    'ADS_STATUS_INVALID_SEARCHPREFVALUE'
  ],
  'ADS_RIGHTS_ENUM' => [
    'ADS_RIGHT_DELETE',
    'ADS_RIGHT_READ_CONTROL',
    'ADS_RIGHT_WRITE_DAC',
    'ADS_RIGHT_WRITE_OWNER',
    'ADS_RIGHT_SYNCHRONIZE',
    'ADS_RIGHT_ACCESS_SYSTEM_SECURITY',
    'ADS_RIGHT_GENERIC_READ',
    'ADS_RIGHT_GENERIC_WRITE',
    'ADS_RIGHT_GENERIC_EXECUTE',
    'ADS_RIGHT_GENERIC_ALL',
    'ADS_RIGHT_DS_CREATE_CHILD',
    'ADS_RIGHT_DS_DELETE_CHILD',
    'ADS_RIGHT_ACTRL_DS_LIST',
    'ADS_RIGHT_DS_SELF',
    'ADS_RIGHT_DS_READ_PROP',
    'ADS_RIGHT_DS_WRITE_PROP',
    'ADS_RIGHT_DS_DELETE_TREE',
    'ADS_RIGHT_DS_LIST_OBJECT',
    'ADS_RIGHT_DS_CONTROL_ACCESS'
  ],
  'ADS_ACEFLAG_ENUM' => [
    'ADS_ACEFLAG_INHERIT_ACE',
    'ADS_ACEFLAG_NO_PROPAGATE_INHERIT_ACE',
    'ADS_ACEFLAG_INHERIT_ONLY_ACE',
    'ADS_ACEFLAG_INHERITED_ACE',
    'ADS_ACEFLAG_VALID_INHERIT_FLAGS',
    'ADS_ACEFLAG_SUCCESSFUL_ACCESS',
    'ADS_ACEFLAG_FAILED_ACCESS'
  ],
  'ADS_DISPLAY_ENUM' => [
    'ADS_DISPLAY_FULL',
    'ADS_DISPLAY_VALUE_ONLY'
  ],
  'ADS_NAME_TYPE_ENUM' => [
    'ADS_NAME_TYPE_1779',
    'ADS_NAME_TYPE_CANONICAL',
    'ADS_NAME_TYPE_NT4',
    'ADS_NAME_TYPE_DISPLAY',
    'ADS_NAME_TYPE_DOMAIN_SIMPLE',
    'ADS_NAME_TYPE_ENTERPRISE_SIMPLE',
    'ADS_NAME_TYPE_GUID',
    'ADS_NAME_TYPE_UNKNOWN',
    'ADS_NAME_TYPE_USER_PRINCIPAL_NAME',
    'ADS_NAME_TYPE_CANONICAL_EX',
    'ADS_NAME_TYPE_SERVICE_PRINCIPAL_NAME',
    'ADS_NAME_TYPE_SID_OR_SID_HISTORY_NAME'
  ],
  'ADS_PREFERENCES_ENUM' => [
    'ADSIPROP_ASYNCHRONOUS',
    'ADSIPROP_DEREF_ALIASES',
    'ADSIPROP_SIZE_LIMIT',
    'ADSIPROP_TIME_LIMIT',
    'ADSIPROP_ATTRIBTYPES_ONLY',
    'ADSIPROP_SEARCH_SCOPE',
    'ADSIPROP_TIMEOUT',
    'ADSIPROP_PAGESIZE',
    'ADSIPROP_PAGED_TIME_LIMIT',
    'ADSIPROP_CHASE_REFERRALS',
    'ADSIPROP_SORT_ON',
    'ADSIPROP_CACHE_RESULTS',
    'ADSIPROP_ADSIFLAG'
  ],
  'ADS_PROPERTY_OPERATION_ENUM' => [
    'ADS_PROPERTY_CLEAR',
    'ADS_PROPERTY_UPDATE',
    'ADS_PROPERTY_APPEND',
    'ADS_PROPERTY_DELETE'
  ],
  'ADS_SEARCHPREF_ENUM' => [
    'ADS_SEARCHPREF_ASYNCHRONOUS',
    'ADS_SEARCHPREF_DEREF_ALIASES',
    'ADS_SEARCHPREF_SIZE_LIMIT',
    'ADS_SEARCHPREF_TIME_LIMIT',
    'ADS_SEARCHPREF_ATTRIBTYPES_ONLY',
    'ADS_SEARCHPREF_SEARCH_SCOPE',
    'ADS_SEARCHPREF_TIMEOUT',
    'ADS_SEARCHPREF_PAGESIZE',
    'ADS_SEARCHPREF_PAGED_TIME_LIMIT',
    'ADS_SEARCHPREF_CHASE_REFERRALS',
    'ADS_SEARCHPREF_SORT_ON',
    'ADS_SEARCHPREF_CACHE_RESULTS',
    'ADS_SEARCHPREF_DIRSYNC',
    'ADS_SEARCHPREF_TOMBSTONE',
    'ADS_SEARCHPREF_VLV',
    'ADS_SEARCHPREF_ATTRIBUTE_QUERY',
    'ADS_SEARCHPREF_SECURITY_MASK',
    'ADS_SEARCHPREF_DIRSYNC_FLAG',
    'ADS_SEARCHPREF_EXTENDED_DN'
  ],
  'ADSI_DIALECT_ENUM' => [
    'ADSI_DIALECT_LDAP',
    'ADSI_DIALECT_SQL'
  ],
  'ADS_PATHTYPE_ENUM' => [
    'ADS_PATH_FILE',
    'ADS_PATH_FILESHARE',
    'ADS_PATH_REGISTRY'
  ],
  'ADS_SYSTEMFLAG_ENUM' => [
    'ADS_SYSTEMFLAG_DISALLOW_DELETE',
    'ADS_SYSTEMFLAG_CONFIG_ALLOW_RENAME',
    'ADS_SYSTEMFLAG_CONFIG_ALLOW_MOVE',
    'ADS_SYSTEMFLAG_CONFIG_ALLOW_LIMITED_MOVE',
    'ADS_SYSTEMFLAG_DOMAIN_DISALLOW_RENAME',
    'ADS_SYSTEMFLAG_DOMAIN_DISALLOW_MOVE',
    'ADS_SYSTEMFLAG_CR_NTDS_NC',
    'ADS_SYSTEMFLAG_CR_NTDS_DOMAIN',
    'ADS_SYSTEMFLAG_ATTR_NOT_REPLICATED',
    'ADS_SYSTEMFLAG_ATTR_IS_CONSTRUCTED'
  ],
  'ADS_USER_FLAG_ENUM' => [
    'ADS_UF_SCRIPT',
    'ADS_UF_ACCOUNTDISABLE',
    'ADS_UF_HOMEDIR_REQUIRED',
    'ADS_UF_LOCKOUT',
    'ADS_UF_PASSWD_NOTREQD',
    'ADS_UF_PASSWD_CANT_CHANGE',
    'ADS_UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED',
    'ADS_UF_TEMP_DUPLICATE_ACCOUNT',
    'ADS_UF_NORMAL_ACCOUNT',
    'ADS_UF_INTERDOMAIN_TRUST_ACCOUNT',
    'ADS_UF_WORKSTATION_TRUST_ACCOUNT',
    'ADS_UF_SERVER_TRUST_ACCOUNT',
    'ADS_UF_DONT_EXPIRE_PASSWD',
    'ADS_UF_MNS_LOGON_ACCOUNT',
    'ADS_UF_SMARTCARD_REQUIRED',
    'ADS_UF_TRUSTED_FOR_DELEGATION',
    'ADS_UF_NOT_DELEGATED',
    'ADS_UF_USE_DES_KEY_ONLY',
    'ADS_UF_DONT_REQUIRE_PREAUTH',
    'ADS_UF_PASSWORD_EXPIRED',
    'ADS_UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION'
  ],
  'ADS_SECURITY_INFO_ENUM' => [
    'ADS_SECURITY_INFO_OWNER',
    'ADS_SECURITY_INFO_GROUP',
    'ADS_SECURITY_INFO_DACL',
    'ADS_SECURITY_INFO_SACL'
  ],
  'ADS_PASSWORD_ENCODING_ENUM' => [
    'ADS_PASSWORD_ENCODE_REQUIRE_SSL',
    'ADS_PASSWORD_ENCODE_CLEAR'
  ],
);

{
  my %seen;

  push @{$EXPORT_TAGS{all}},
    grep {!$seen{$_}++} @{$EXPORT_TAGS{$_}} foreach keys %EXPORT_TAGS;
}

qq'Never look a gift horse in the mouth, especially in your frozen lasagne';

__END__

=pod

=head1 NAME

Win32::ADSIEnumerations - constants for the Active Directory Service Interfaces (ADSI) enumerations

=head1 VERSION

version 0.02

=head1 SYNOPSIS

  use Win32::ADSIEnumerations qw[:all]; # import *all* the enumeration symbols

=head1 DESCRIPTION

This module provides all the Active Directory Service Interfaces (ADSI) enumerations as importable symbols.

=head1 CATEGORIES

Each of the following categories of enumerations may be imported individually using a ':' prefix.

=over

=item C<ADS_ACEFLAG_ENUM>

Specifies how security propagates for inherited access-control entries (ACEs) and types of auditing for a system ACE.

=item C<ADS_ACETYPE_ENUM>

Specifies the ACE type.

=item C<ADS_AUTHENTICATION_ENUM>

Specifies the security level used in authenticating a client.

=item C<ADS_CHASE_REFERRALS_ENUM>

Specifies the behavior of referral chasing.

=item C<ADS_DEREFENUM>

Specifies the behavior of alias dereferencing.

=item C<ADS_DISPLAY_ENUM>

Specifies how a path is displayed.

=item C<ADS_ESCAPE_MODE_ENUM>

Specifies whether special characters are escaped, unescaped, or untouched.

=item C<ADS_FLAGTYPE_ENUM>

Specifies the presence of the ObjectType or InheritedObjectType fields in an ACE.

=item C<ADS_FORMAT_ENUM>

Specifies the type of values in a pathname object.

=item C<ADS_GROUP_TYPE_ENUM>

Specifies the group type of the member.

=item C<ADS_NAME_INITTYPE_ENUM>

Specifies the type of initialization to be performed on a name translate object.

=item C<ADS_NAME_TYPE_ENUM>

Specifies the format used to represent distinguished names.

=item C<ADS_OPTION_ENUM>

Specifies the available options that the IADsObjectOptions interface uses for manipulating directory objects.

=item C<ADS_PASSWORD_ENCODING_ENUM>

Used to identify the type of password encoding used with the ADS_OPTION_PASSWORD_METHOD option in the IADsObjectOptions::GetOption and IADsObjectOptions::SetOption methods.

=item C<ADS_PATHTYPE_ENUM>

Specifies the type of object on which the security descriptor is modified.

=item C<ADS_PREFERENCES_ENUM>

Specifies the query preferences of the OLE DB for ADSI.

=item C<ADS_PROPERTY_OPERATION_ENUM>

Specifies the ways to update property values in the property cache.

=item C<ADS_RIGHTS_ENUM>

Specifies the access rights to a directory service object.

=item C<ADS_SCOPEENUM>

Specifies the scope of a directory search.

=item C<ADS_SD_CONTROL_ENUM>

Specifies that an access-control list (ACL) is to be protected when new permissions are recursively applied to a directory tree.

=item C<ADS_SD_FORMAT_ENUM>

Specifies the format for converting the security descriptor.

=item C<ADS_SD_REVISION_ENUM>

Specifies the revision number of an ACE or ACL.

=item C<ADS_SEARCHPREF_ENUM>

Specifies preferences of the search.

=item C<ADS_SECURITY_INFO_ENUM>

Specifies the options for examining security data.

=item C<ADS_SETTYPE_ENUM>

Specifies the path format in IADsPathname::Set.

=item C<ADS_STATUSENUM>

Specifies the status of search preferences.

=item C<ADS_SYSTEMFLAG_ENUM>

Specifies the types of attributes represented by an attributeSchema object.

=item C<ADS_USER_FLAG_ENUM>

Specifies flags used for manipulating user properties.

=item C<ADSI_DIALECT_ENUM>

Specifies available ADSI query dialects.

=item C<ADSTYPEENUM>

Specifies data types used to interpret an ADSI extended syntax string.

=back

=head1 ENUMERATIONS

All the following enumerations are available:

  ADS_ACEFLAG_INHERIT_ACE
  ADS_ACEFLAG_NO_PROPAGATE_INHERIT_ACE
  ADS_ACEFLAG_INHERIT_ONLY_ACE
  ADS_ACEFLAG_INHERITED_ACE
  ADS_ACEFLAG_VALID_INHERIT_FLAGS
  ADS_ACEFLAG_SUCCESSFUL_ACCESS
  ADS_ACEFLAG_FAILED_ACCESS
  ADS_ACETYPE_ACCESS_ALLOWED
  ADS_ACETYPE_ACCESS_DENIED
  ADS_ACETYPE_SYSTEM_AUDIT
  ADS_ACETYPE_ACCESS_ALLOWED_OBJECT
  ADS_ACETYPE_ACCESS_DENIED_OBJECT
  ADS_ACETYPE_SYSTEM_AUDIT_OBJECT
  ADS_ACETYPE_SYSTEM_ALARM_OBJECT
  ADS_ACETYPE_ACCESS_ALLOWED_CALLBACK
  ADS_ACETYPE_ACCESS_DENIED_CALLBACK
  ADS_ACETYPE_ACCESS_ALLOWED_CALLBACK_OBJECT
  ADS_ACETYPE_ACCESS_DENIED_CALLBACK_OBJECT
  ADS_ACETYPE_SYSTEM_AUDIT_CALLBACK
  ADS_ACETYPE_SYSTEM_ALARM_CALLBACK
  ADS_ACETYPE_SYSTEM_AUDIT_CALLBACK_OBJECT
  ADS_ACETYPE_SYSTEM_ALARM_CALLBACK_OBJECT
  ADS_SECURE_AUTHENTICATION
  ADS_USE_ENCRYPTION
  ADS_USE_SSL
  ADS_READONLY_SERVER
  ADS_PROMPT_CREDENTIALS
  ADS_NO_AUTHENTICATION
  ADS_FAST_BIND
  ADS_USE_SIGNING
  ADS_USE_SEALING
  ADS_USE_DELEGATION
  ADS_SERVER_BIND
  ADS_NO_REFERRAL_CHASING
  ADS_AUTH_RESERVED
  ADS_CHASE_REFERRALS_NEVER
  ADS_CHASE_REFERRALS_SUBORDINATE
  ADS_CHASE_REFERRALS_EXTERNAL
  ADS_CHASE_REFERRALS_ALWAYS
  ADS_DEREF_NEVER
  ADS_DEREF_SEARCHING
  ADS_DEREF_FINDING
  ADS_DEREF_ALWAYS
  ADS_DISPLAY_FULL
  ADS_DISPLAY_VALUE_ONLY
  ADS_ESCAPEDMODE_DEFAULT
  ADS_ESCAPEDMODE_ON
  ADS_ESCAPEDMODE_OFF
  ADS_ESCAPEDMODE_OFF_EX
  ADS_FLAG_OBJECT_TYPE_PRESENT
  ADS_FLAG_INHERITED_OBJECT_TYPE_PRESENT
  ADS_FORMAT_WINDOWS
  ADS_FORMAT_WINDOWS_NO_SERVER
  ADS_FORMAT_WINDOWS_DN
  ADS_FORMAT_WINDOWS_PARENT
  ADS_FORMAT_X500
  ADS_FORMAT_X500_NO_SERVER
  ADS_FORMAT_X500_DN
  ADS_FORMAT_X500_PARENT
  ADS_FORMAT_SERVER
  ADS_FORMAT_PROVIDER
  ADS_FORMAT_LEAF
  ADS_GROUP_TYPE_GLOBAL_GROUP
  ADS_GROUP_TYPE_DOMAIN_LOCAL_GROUP
  ADS_GROUP_TYPE_LOCAL_GROUP
  ADS_GROUP_TYPE_UNIVERSAL_GROUP
  ADS_GROUP_TYPE_SECURITY_ENABLED
  ADS_NAME_INITTYPE_DOMAIN
  ADS_NAME_INITTYPE_SERVER
  ADS_NAME_INITTYPE_GC
  ADS_NAME_TYPE_1779
  ADS_NAME_TYPE_CANONICAL
  ADS_NAME_TYPE_NT4
  ADS_NAME_TYPE_DISPLAY
  ADS_NAME_TYPE_DOMAIN_SIMPLE
  ADS_NAME_TYPE_ENTERPRISE_SIMPLE
  ADS_NAME_TYPE_GUID
  ADS_NAME_TYPE_UNKNOWN
  ADS_NAME_TYPE_USER_PRINCIPAL_NAME
  ADS_NAME_TYPE_CANONICAL_EX
  ADS_NAME_TYPE_SERVICE_PRINCIPAL_NAME
  ADS_NAME_TYPE_SID_OR_SID_HISTORY_NAME
  ADS_OPTION_SERVERNAME
  ADS_OPTION_REFERRALS
  ADS_OPTION_PAGE_SIZE
  ADS_OPTION_SECURITY_MASK
  ADS_OPTION_MUTUAL_AUTH_STATUS
  ADS_OPTION_QUOTA
  ADS_OPTION_PASSWORD_PORTNUMBER
  ADS_OPTION_PASSWORD_METHOD
  ADS_OPTION_ACCUMULATIVE_MODIFICATION
  ADS_OPTION_SKIP_SID_LOOKUP
  ADS_PASSWORD_ENCODE_REQUIRE_SSL
  ADS_PASSWORD_ENCODE_CLEAR
  ADS_PATH_FILE
  ADS_PATH_FILESHARE
  ADS_PATH_REGISTRY
  ADSIPROP_ASYNCHRONOUS
  ADSIPROP_DEREF_ALIASES
  ADSIPROP_SIZE_LIMIT
  ADSIPROP_TIME_LIMIT
  ADSIPROP_ATTRIBTYPES_ONLY
  ADSIPROP_SEARCH_SCOPE
  ADSIPROP_TIMEOUT
  ADSIPROP_PAGESIZE
  ADSIPROP_PAGED_TIME_LIMIT
  ADSIPROP_CHASE_REFERRALS
  ADSIPROP_SORT_ON
  ADSIPROP_CACHE_RESULTS
  ADSIPROP_ADSIFLAG
  ADS_PROPERTY_CLEAR
  ADS_PROPERTY_UPDATE
  ADS_PROPERTY_APPEND
  ADS_PROPERTY_DELETE
  ADS_RIGHT_DELETE
  ADS_RIGHT_READ_CONTROL
  ADS_RIGHT_WRITE_DAC
  ADS_RIGHT_WRITE_OWNER
  ADS_RIGHT_SYNCHRONIZE
  ADS_RIGHT_ACCESS_SYSTEM_SECURITY
  ADS_RIGHT_GENERIC_READ
  ADS_RIGHT_GENERIC_WRITE
  ADS_RIGHT_GENERIC_EXECUTE
  ADS_RIGHT_GENERIC_ALL
  ADS_RIGHT_DS_CREATE_CHILD
  ADS_RIGHT_DS_DELETE_CHILD
  ADS_RIGHT_ACTRL_DS_LIST
  ADS_RIGHT_DS_SELF
  ADS_RIGHT_DS_READ_PROP
  ADS_RIGHT_DS_WRITE_PROP
  ADS_RIGHT_DS_DELETE_TREE
  ADS_RIGHT_DS_LIST_OBJECT
  ADS_RIGHT_DS_CONTROL_ACCESS
  ADS_SCOPE_BASE
  ADS_SCOPE_ONELEVEL
  ADS_SCOPE_SUBTREE
  ADS_SD_CONTROL_SE_OWNER_DEFAULTED
  ADS_SD_CONTROL_SE_GROUP_DEFAULTED
  ADS_SD_CONTROL_SE_DACL_PRESENT
  ADS_SD_CONTROL_SE_DACL_DEFAULTED
  ADS_SD_CONTROL_SE_SACL_PRESENT
  ADS_SD_CONTROL_SE_SACL_DEFAULTED
  ADS_SD_CONTROL_SE_DACL_AUTO_INHERIT_REQ
  ADS_SD_CONTROL_SE_SACL_AUTO_INHERIT_REQ
  ADS_SD_CONTROL_SE_DACL_AUTO_INHERITED
  ADS_SD_CONTROL_SE_SACL_AUTO_INHERITED
  ADS_SD_CONTROL_SE_DACL_PROTECTED
  ADS_SD_CONTROL_SE_SACL_PROTECTED
  ADS_SD_CONTROL_SE_SELF_RELATIVE
  ADS_SD_FORMAT_IID
  ADS_SD_FORMAT_RAW
  ADS_SD_FORMAT_HEXSTRING
  ADS_SD_REVISION_DS
  ADS_SEARCHPREF_ASYNCHRONOUS
  ADS_SEARCHPREF_DEREF_ALIASES
  ADS_SEARCHPREF_SIZE_LIMIT
  ADS_SEARCHPREF_TIME_LIMIT
  ADS_SEARCHPREF_ATTRIBTYPES_ONLY
  ADS_SEARCHPREF_SEARCH_SCOPE
  ADS_SEARCHPREF_TIMEOUT
  ADS_SEARCHPREF_PAGESIZE
  ADS_SEARCHPREF_PAGED_TIME_LIMIT
  ADS_SEARCHPREF_CHASE_REFERRALS
  ADS_SEARCHPREF_SORT_ON
  ADS_SEARCHPREF_CACHE_RESULTS
  ADS_SEARCHPREF_DIRSYNC
  ADS_SEARCHPREF_TOMBSTONE
  ADS_SEARCHPREF_VLV
  ADS_SEARCHPREF_ATTRIBUTE_QUERY
  ADS_SEARCHPREF_SECURITY_MASK
  ADS_SEARCHPREF_DIRSYNC_FLAG
  ADS_SEARCHPREF_EXTENDED_DN
  ADS_SECURITY_INFO_OWNER
  ADS_SECURITY_INFO_GROUP
  ADS_SECURITY_INFO_DACL
  ADS_SECURITY_INFO_SACL
  ADS_SETTYPE_FULL
  ADS_SETTYPE_PROVIDER
  ADS_SETTYPE_SERVER
  ADS_SETTYPE_DN
  ADS_STATUS_S_OK
  ADS_STATUS_INVALID_SEARCHPREF
  ADS_STATUS_INVALID_SEARCHPREFVALUE
  ADS_SYSTEMFLAG_DISALLOW_DELETE
  ADS_SYSTEMFLAG_CONFIG_ALLOW_RENAME
  ADS_SYSTEMFLAG_CONFIG_ALLOW_MOVE
  ADS_SYSTEMFLAG_CONFIG_ALLOW_LIMITED_MOVE
  ADS_SYSTEMFLAG_DOMAIN_DISALLOW_RENAME
  ADS_SYSTEMFLAG_DOMAIN_DISALLOW_MOVE
  ADS_SYSTEMFLAG_CR_NTDS_NC
  ADS_SYSTEMFLAG_CR_NTDS_DOMAIN
  ADS_SYSTEMFLAG_ATTR_NOT_REPLICATED
  ADS_SYSTEMFLAG_ATTR_IS_CONSTRUCTED
  ADS_UF_SCRIPT
  ADS_UF_ACCOUNTDISABLE
  ADS_UF_HOMEDIR_REQUIRED
  ADS_UF_LOCKOUT
  ADS_UF_PASSWD_NOTREQD
  ADS_UF_PASSWD_CANT_CHANGE
  ADS_UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED
  ADS_UF_TEMP_DUPLICATE_ACCOUNT
  ADS_UF_NORMAL_ACCOUNT
  ADS_UF_INTERDOMAIN_TRUST_ACCOUNT
  ADS_UF_WORKSTATION_TRUST_ACCOUNT
  ADS_UF_SERVER_TRUST_ACCOUNT
  ADS_UF_DONT_EXPIRE_PASSWD
  ADS_UF_MNS_LOGON_ACCOUNT
  ADS_UF_SMARTCARD_REQUIRED
  ADS_UF_TRUSTED_FOR_DELEGATION
  ADS_UF_NOT_DELEGATED
  ADS_UF_USE_DES_KEY_ONLY
  ADS_UF_DONT_REQUIRE_PREAUTH
  ADS_UF_PASSWORD_EXPIRED
  ADS_UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION
  ADSI_DIALECT_LDAP
  ADSI_DIALECT_SQL
  ADSTYPE_INVALID
  ADSTYPE_DN_STRING
  ADSTYPE_CASE_EXACT_STRING
  ADSTYPE_CASE_IGNORE_STRING
  ADSTYPE_PRINTABLE_STRING
  ADSTYPE_NUMERIC_STRING
  ADSTYPE_BOOLEAN
  ADSTYPE_INTEGER
  ADSTYPE_OCTET_STRING
  ADSTYPE_UTC_TIME
  ADSTYPE_LARGE_INTEGER
  ADSTYPE_PROV_SPECIFIC
  ADSTYPE_OBJECT_CLASS
  ADSTYPE_CASEIGNORE_LIST
  ADSTYPE_OCTET_LIST
  ADSTYPE_PATH
  ADSTYPE_POSTALADDRESS
  ADSTYPE_TIMESTAMP
  ADSTYPE_BACKLINK
  ADSTYPE_TYPEDNAME
  ADSTYPE_HOLD
  ADSTYPE_NETADDRESS
  ADSTYPE_REPLICAPOINTER
  ADSTYPE_FAXNUMBER
  ADSTYPE_EMAIL
  ADSTYPE_NT_SECURITY_DESCRIPTOR
  ADSTYPE_UNKNOWN
  ADSTYPE_DN_WITH_BINARY
  ADSTYPE_DN_WITH_STRING

=head1 AUTHOR

Chris Williams <chris@bingosnet.co.uk>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by Chris Williams.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
